/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.TeiidException;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.query.QueryPlugin;
import org.teiid.translator.ExecutionFactory;

public class ConnectorManagerRepository
implements Serializable {
    private static final long serialVersionUID = -1611063218178314458L;
    private Map<String, ConnectorManager> repo = new ConcurrentHashMap<String, ConnectorManager>();
    private boolean shared;
    private ExecutionFactoryProvider provider;

    public ConnectorManagerRepository() {
    }

    protected ConnectorManagerRepository(boolean b) {
        this.shared = b;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void addConnectorManager(String connectorName, ConnectorManager mgr) {
        this.repo.put(connectorName, mgr);
    }

    public ConnectorManager getConnectorManager(String connectorName) {
        return this.repo.get(connectorName);
    }

    public Map<String, ConnectorManager> getConnectorManagers() {
        return this.repo;
    }

    public ConnectorManager removeConnectorManager(String connectorName) {
        return this.repo.remove(connectorName);
    }

    public void createConnectorManagers(VDBMetaData deployment, ExecutionFactoryProvider provider) throws ConnectorManagerException {
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            List<String> sourceNames = model.getSourceNames();
            if (sourceNames.size() != new HashSet<String>(sourceNames).size()) {
                throw new ConnectorManagerException(QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31101, model.getName(), deployment.getName(), deployment.getVersion()));
            }
            if (sourceNames.size() > 1 && !model.isSupportsMultiSourceBindings()) {
                throw new ConnectorManagerException(QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31102, model.getName(), deployment.getName(), deployment.getVersion()));
            }
            for (SourceMappingMetadata source : model.getSourceMappings()) {
                this.createConnectorManager(deployment, provider, source, false);
            }
        }
    }

    public void createConnectorManager(VDBMetaData deployment, ExecutionFactoryProvider provider, SourceMappingMetadata source, boolean replace) throws ConnectorManagerException {
        ConnectorManager cm = this.getConnectorManager(source.getName());
        String name = source.getTranslatorName();
        String connection = source.getConnectionJndiName();
        ExecutionFactory<Object, Object> ef = null;
        if (cm != null) {
            if (!cm.getTranslatorName().equals(name) || !EquivalenceUtil.areEqual(cm.getConnectionName(), connection)) {
                if (!replace) {
                    throw new ConnectorManagerException(QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31103, source, deployment.getName(), deployment.getVersion()));
                }
                if (cm.getTranslatorName().equals(name)) {
                    ef = cm.getExecutionFactory();
                }
            } else {
                return;
            }
        }
        if (ef == null && (ef = provider.getExecutionFactory(name)) == null) {
            throw new ConnectorManagerException(QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31146, deployment.getName(), deployment.getVersion(), name));
        }
        cm = this.createConnectorManager(name, connection, ef);
        this.addConnectorManager(source.getName(), cm);
    }

    protected ConnectorManager createConnectorManager(String name, String connection, ExecutionFactory<Object, Object> ef) {
        return new ConnectorManager(name, connection, ef);
    }

    public void setProvider(ExecutionFactoryProvider provider) {
        this.provider = provider;
    }

    public ExecutionFactoryProvider getProvider() {
        return this.provider;
    }

    public static interface ExecutionFactoryProvider {
        public ExecutionFactory<Object, Object> getExecutionFactory(String var1) throws ConnectorManagerException;
    }

    public static class ConnectorManagerException
    extends TeiidException {
        public ConnectorManagerException(String msg) {
            super(msg);
        }

        public ConnectorManagerException(Throwable t) {
            super(t);
        }
    }
}

