/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.JDBCPlugin;

public class SocketUtil {
    private static Logger logger = Logger.getLogger(SocketUtil.class.getName());
    static final String TRUSTSTORE_PASSWORD = "org.teiid.ssl.trustStorePassword";
    public static final String TRUSTSTORE_FILENAME = "org.teiid.ssl.trustStore";
    static final String KEYSTORE_ALGORITHM = "org.teiid.ssl.algorithm";
    static final String PROTOCOL = "org.teiid.ssl.protocol";
    static final String KEYSTORE_TYPE = "org.teiid.ssl.keyStoreType";
    static final String KEYSTORE_PASSWORD = "org.teiid.ssl.keyStorePassword";
    static final String KEYSTORE_FILENAME = "org.teiid.ssl.keyStore";
    public static final String ALLOW_ANON = "org.teiid.ssl.allowAnon";
    static final String KEYSTORE_ALIAS = "org.teiid.ssl.keyAlias";
    static final String KEY_PASSWORD = "org.teiid.ssl.keyPassword";
    static final String TRUST_ALL = "org.teiid.ssl.trustAll";
    static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String ANON_CIPHER_SUITE = "TLS_DH_anon_WITH_AES_128_CBC_SHA";
    public static final String DEFAULT_PROTOCOL = "TLSv1";
    private static final X509TrustManager[] TRUST_ALL_MANAGER = new X509TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }};

    public static SSLSocketFactory getSSLSocketFactory(Properties props) throws IOException, GeneralSecurityException {
        String keystore = props.getProperty(KEYSTORE_FILENAME);
        String keystorePassword = props.getProperty(KEYSTORE_PASSWORD);
        String keystoreType = props.getProperty(KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
        String keystoreProtocol = props.getProperty(PROTOCOL, DEFAULT_PROTOCOL);
        String keystoreAlgorithm = props.getProperty(KEYSTORE_ALGORITHM);
        String truststore = props.getProperty(TRUSTSTORE_FILENAME, keystore);
        String truststorePassword = props.getProperty(TRUSTSTORE_PASSWORD, keystorePassword);
        String keyAlias = props.getProperty(KEYSTORE_ALIAS);
        String keyPassword = props.getProperty(KEY_PASSWORD);
        boolean anon = PropertiesUtils.getBooleanProperty(props, ALLOW_ANON, true);
        boolean trustAll = PropertiesUtils.getBooleanProperty(props, TRUST_ALL, false);
        SSLContext result = null;
        result = keystore != null || truststore != null || trustAll ? SocketUtil.getSSLContext(keystore, keystorePassword, truststore, truststorePassword, keystoreAlgorithm, keystoreType, keystoreProtocol, keyAlias, keyPassword, trustAll) : SSLContext.getDefault();
        return new SSLSocketFactory(result, anon);
    }

    public static boolean addCipherSuite(SSLSocket engine, String cipherSuite) {
        if (!Arrays.asList(engine.getSupportedCipherSuites()).contains(cipherSuite)) {
            return false;
        }
        String[] suites = engine.getEnabledCipherSuites();
        String[] newSuites = new String[suites.length + 1];
        System.arraycopy(suites, 0, newSuites, 0, suites.length);
        newSuites[suites.length] = cipherSuite;
        engine.setEnabledCipherSuites(newSuites);
        return true;
    }

    public static SSLContext getAnonSSLContext() throws IOException, GeneralSecurityException {
        return SocketUtil.getSSLContext(null, null, null, null, null, null, DEFAULT_PROTOCOL, null, null, false);
    }

    public static SSLContext getSSLContext(String keystore, String password, String truststore, String truststorePassword, String algorithm, String keystoreType, String protocol, String keyAlias, String keyPassword, boolean trustAll) throws IOException, GeneralSecurityException {
        KeyStore ks;
        KeyStore ks2;
        if (algorithm == null) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        KeyManager[] keyManagers = null;
        if (keystore != null && (ks2 = SocketUtil.loadKeyStore(keystore, password, keystoreType)) != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            if (keyPassword == null) {
                keyPassword = password;
            }
            kmf.init(ks2, keyPassword != null ? keyPassword.toCharArray() : null);
            keyManagers = kmf.getKeyManagers();
            if (keyAlias != null) {
                if (!ks2.isKeyEntry(keyAlias)) {
                    throw new GeneralSecurityException(JDBCPlugin.Util.getString("alias_no_key_entry", keyAlias));
                }
                if (DEFAULT_KEYSTORE_TYPE.equals(keystoreType)) {
                    keyAlias = keyAlias.toLowerCase(Locale.ENGLISH);
                }
                for (int i = 0; i < keyManagers.length; ++i) {
                    if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                    keyManagers[i] = new AliasAwareKeyManager((X509KeyManager)keyManagers[i], keyAlias);
                }
            }
        }
        TrustManager[] trustManagers = null;
        if (trustAll) {
            trustManagers = TRUST_ALL_MANAGER;
        } else if (truststore != null && (ks = SocketUtil.loadKeyStore(truststore, truststorePassword, keystoreType)) != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(ks);
            trustManagers = tmf.getTrustManagers();
        }
        SSLContext sslc = SSLContext.getInstance(protocol);
        sslc.init(keyManagers, trustManagers, null);
        return sslc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String name, String password, String type) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        InputStream stream = SocketUtil.class.getClassLoader().getResourceAsStream(name);
        if (stream == null) {
            try {
                stream = new FileInputStream(name);
            }
            catch (FileNotFoundException e) {
                IOException exception = new IOException(JDBCPlugin.Util.getString("SocketHelper.keystore_not_found", name));
                exception.initCause(e);
                throw exception;
            }
        }
        KeyStore ks = KeyStore.getInstance(type);
        try {
            ks.load(stream, password != null ? password.toCharArray() : null);
        }
        finally {
            stream.close();
        }
        return ks;
    }

    static class AliasAwareKeyManager
    extends X509ExtendedKeyManager {
        private X509KeyManager delegate;
        private String keyAlias;

        public AliasAwareKeyManager(X509KeyManager delegate, String alias) {
            this.delegate = delegate;
            this.keyAlias = alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.keyAlias;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.keyAlias;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.delegate.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.delegate.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.delegate.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.delegate.getServerAliases(keyType, issuers);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.keyAlias;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return this.keyAlias;
        }
    }

    public static class SSLSocketFactory {
        private boolean isAnon;
        private boolean warned;
        private javax.net.ssl.SSLSocketFactory factory;

        public SSLSocketFactory(SSLContext context, boolean isAnon) {
            this.factory = context.getSocketFactory();
            this.isAnon = isAnon;
        }

        public synchronized Socket getSocket() throws IOException {
            SSLSocket result = (SSLSocket)this.factory.createSocket();
            result.setUseClientMode(true);
            if (this.isAnon && !SocketUtil.addCipherSuite(result, SocketUtil.ANON_CIPHER_SUITE) && !this.warned) {
                this.warned = true;
                logger.warning(JDBCPlugin.Util.getString("SocketUtil.anon_not_available"));
            }
            return result;
        }
    }
}

