/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.Map;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.util.CommandContext;

public class SystemFunctionMethods {
    private static final int MAX_VARIABLES = 512;

    @TeiidFunction(category="System", nullOnNull=true, determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC)
    public static Object teiid_session_get(CommandContext context, String key) {
        return context.getSessionVariable(key);
    }

    @TeiidFunction(category="System", determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC)
    public static Object teiid_session_set(CommandContext context, String key, Object value) throws FunctionExecutionException {
        SessionMetadata session = context.getSession();
        Map<String, Object> variables = session.getSessionVariables();
        if (variables.size() > 512 && !variables.containsKey(key)) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31136, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31136, 512));
        }
        return context.setSessionVariable(key, value);
    }
}

