/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.id.IDGenerator;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.CommandPlanner;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.processor.BatchedUpdatePlan;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.BatchedUpdateNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.util.CommandContext;

public class BatchedUpdatePlanner
implements CommandPlanner {
    @Override
    public ProcessorPlan optimize(Command command, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        BatchedUpdateCommand batchedUpdateCommand = (BatchedUpdateCommand)command;
        ArrayList<ProcessorPlan> childPlans = new ArrayList<ProcessorPlan>(batchedUpdateCommand.getUpdateCommands().size());
        List<Command> updateCommands = batchedUpdateCommand.getUpdateCommands();
        int numCommands = updateCommands.size();
        List<VariableContext> allContexts = batchedUpdateCommand.getVariableContexts();
        ArrayList<VariableContext> planContexts = null;
        if (allContexts != null) {
            planContexts = new ArrayList<VariableContext>(allContexts.size());
        }
        for (int commandIndex = 0; commandIndex < numCommands; ++commandIndex) {
            Object batchModelID;
            String modelName;
            SourceCapabilities caps;
            Command updateCommand = updateCommands.get(commandIndex);
            boolean commandWasBatched = false;
            if (BatchedUpdatePlanner.isEligibleForBatching(updateCommand, metadata) && (caps = capFinder.findCapabilities(modelName = metadata.getFullName(batchModelID = metadata.getModelID(BatchedUpdatePlanner.getUpdatedGroup(updateCommand).getMetadataID())))).supportsCapability(SourceCapabilities.Capability.BATCHED_UPDATES)) {
                Command batchingCandidate;
                ArrayList<Command> batch = new ArrayList<Command>();
                ArrayList<VariableContext> contexts = new ArrayList<VariableContext>();
                ArrayList<Boolean> shouldEvaluate = new ArrayList<Boolean>();
                batch.add(updateCommand);
                if (allContexts != null) {
                    contexts.add(allContexts.get(commandIndex));
                    shouldEvaluate.add(Boolean.TRUE);
                } else {
                    shouldEvaluate.add(EvaluatableVisitor.needsProcessingEvaluation(updateCommand));
                }
                for (int batchIndex = commandIndex + 1; batchIndex < numCommands && BatchedUpdatePlanner.canBeAddedToBatch(batchingCandidate = updateCommands.get(batchIndex), batchModelID, metadata, capFinder); ++batchIndex) {
                    batch.add(batchingCandidate);
                    if (allContexts != null) {
                        contexts.add(allContexts.get(batchIndex));
                        shouldEvaluate.add(Boolean.TRUE);
                        continue;
                    }
                    shouldEvaluate.add(EvaluatableVisitor.needsProcessingEvaluation(batchingCandidate));
                }
                if (batch.size() > 1) {
                    ProjectNode projectNode = new ProjectNode(idGenerator.nextInt());
                    BatchedUpdateNode batchNode = new BatchedUpdateNode(idGenerator.nextInt(), batch, contexts, shouldEvaluate, modelName);
                    List symbols = batchedUpdateCommand.getProjectedSymbols();
                    projectNode.setSelectSymbols(symbols);
                    projectNode.setElements(symbols);
                    batchNode.setElements(symbols);
                    projectNode.addChild(batchNode);
                    childPlans.add(new RelationalPlan(projectNode));
                    if (planContexts != null) {
                        planContexts.add(new VariableContext());
                    }
                    commandIndex += batch.size() - 1;
                    commandWasBatched = true;
                }
            }
            if (commandWasBatched) continue;
            Command cmd = batchedUpdateCommand.getUpdateCommands().get(commandIndex);
            ProcessorPlan plan = cmd.getProcessorPlan();
            if (plan == null) {
                plan = QueryOptimizer.optimizePlan(cmd, metadata, idGenerator, capFinder, analysisRecord, context);
            }
            childPlans.add(plan);
            if (allContexts == null) continue;
            planContexts.add(allContexts.get(commandIndex));
        }
        return new BatchedUpdatePlan(childPlans, batchedUpdateCommand.getUpdateCommands().size(), planContexts, batchedUpdateCommand.isSingleResult());
    }

    public static GroupSymbol getUpdatedGroup(Command command) {
        int type = command.getType();
        if (type == 2) {
            return ((Insert)command).getGroup();
        }
        if (type == 3) {
            return ((Update)command).getGroup();
        }
        if (type == 4) {
            return ((Delete)command).getGroup();
        }
        throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30244, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30244, command));
    }

    public static boolean isEligibleForBatching(Command command, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        return !metadata.isVirtualGroup(BatchedUpdatePlanner.getUpdatedGroup(command).getMetadataID());
    }

    private static boolean canBeAddedToBatch(Command command, Object batchModelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (BatchedUpdatePlanner.isEligibleForBatching(command, metadata)) {
            Object modelID = metadata.getModelID(BatchedUpdatePlanner.getUpdatedGroup(command).getMetadataID());
            return CapabilitiesUtil.isSameConnector(modelID, batchModelID, metadata, capFinder);
        }
        return false;
    }
}

