/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class GroupBy
implements LanguageObject {
    private List<Expression> symbols;
    private boolean rollup;

    public GroupBy() {
        this.symbols = new ArrayList<Expression>();
    }

    public GroupBy(List<? extends Expression> symbols) {
        this.symbols = new ArrayList<Expression>(symbols);
    }

    public int getCount() {
        return this.symbols.size();
    }

    public List<Expression> getSymbols() {
        return this.symbols;
    }

    public void addSymbol(Expression symbol) {
        if (symbol != null) {
            this.symbols.add(symbol);
        }
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        GroupBy clone = new GroupBy(LanguageObject.Util.deepClone(this.symbols, Expression.class));
        clone.rollup = this.rollup;
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GroupBy)) {
            return false;
        }
        GroupBy other = (GroupBy)obj;
        return EquivalenceUtil.areEqual(this.getSymbols(), other.getSymbols()) && this.rollup == other.rollup;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(this.rollup ? 1 : 0, this.getSymbols());
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean isRollup() {
        return this.rollup;
    }

    public void setRollup(boolean rollup) {
        this.rollup = rollup;
    }
}

