/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class DerivedColumn
implements LanguageObject {
    private String alias;
    private Expression expression;
    private boolean propagateName = true;

    public DerivedColumn(String name, Expression expression) {
        this.alias = name;
        this.expression = expression;
    }

    public boolean isPropagateName() {
        return this.propagateName;
    }

    public void setPropagateName(boolean propagateName) {
        this.propagateName = propagateName;
    }

    public String getAlias() {
        return this.alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setAlias(String name) {
        this.alias = name;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(0, this.alias, this.expression);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DerivedColumn)) {
            return false;
        }
        DerivedColumn other = (DerivedColumn)obj;
        return EquivalenceUtil.areEqual(this.alias, other.alias) && this.expression.equals(other.expression);
    }

    @Override
    public DerivedColumn clone() {
        DerivedColumn clone = new DerivedColumn(this.alias, (Expression)this.expression.clone());
        clone.propagateName = this.propagateName;
        return clone;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

