/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.teiid.core.util.Assertion;

public class MultiArrayOutputStream
extends OutputStream {
    private byte bufferIndex;
    private int index;
    private int count;
    private byte[][] bufs = new byte[15][];

    public MultiArrayOutputStream(int initialSize) {
        this.bufs[0] = new byte[initialSize];
    }

    public void reset(int newIndex) {
        Assertion.assertTrue(newIndex < this.bufs[0].length);
        while (this.bufferIndex > 0) {
            byte by = this.bufferIndex;
            this.bufferIndex = (byte)(by - 1);
            this.bufs[by] = null;
        }
        this.count = this.index = newIndex;
    }

    @Override
    public void write(int b) throws IOException {
        int newIndex = this.index + 1;
        byte[] buf = this.bufs[this.bufferIndex];
        if (newIndex > buf.length) {
            this.bufferIndex = (byte)(this.bufferIndex + 1);
            this.bufs[this.bufferIndex] = new byte[buf.length << 1];
            buf = this.bufs[this.bufferIndex];
            buf[0] = (byte)b;
            this.index = 1;
        } else {
            buf[this.index] = (byte)b;
            this.index = newIndex;
        }
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int newIndex = this.index + len;
        byte[] buf = this.bufs[this.bufferIndex];
        if (newIndex > buf.length) {
            int copyLen = Math.min(buf.length - this.index, len);
            if (copyLen > 0) {
                System.arraycopy(b, off, buf, this.index, copyLen);
            }
            int to = off + len;
            int nextIndex = len - copyLen;
            int diff = (buf.length << 1) - nextIndex;
            if (diff > 0) {
                to += diff;
            }
            this.bufferIndex = (byte)(this.bufferIndex + 1);
            this.bufs[this.bufferIndex] = Arrays.copyOfRange(b, off + copyLen, to);
            this.index = nextIndex;
        } else {
            System.arraycopy(b, off, buf, this.index, len);
            this.index = newIndex;
        }
        this.count += len;
    }

    public void writeTo(DataOutput out) throws IOException {
        for (byte i = 0; i <= this.bufferIndex; i = (byte)(i + 1)) {
            byte[] b = this.bufs[i];
            out.write(b, 0, this.bufferIndex == i ? this.index : b.length);
        }
    }

    public int getCount() {
        return this.count;
    }

    public byte[][] getBuffers() {
        return this.bufs;
    }

    public int getIndex() {
        return this.index;
    }
}

