/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language;

import java.util.List;
import org.teiid.language.Argument;
import org.teiid.language.BaseLanguageObject;
import org.teiid.language.Command;
import org.teiid.language.MetadataReference;
import org.teiid.language.visitor.LanguageObjectVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;

public class Call
extends BaseLanguageObject
implements Command,
MetadataReference<Procedure> {
    private String name;
    private List<Argument> arguments;
    private Procedure metadataObject;
    private Class<?> returnType;

    public Call(String name, List<Argument> parameters, Procedure metadataObject) {
        this.name = name;
        this.arguments = parameters;
        this.metadataObject = metadataObject;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public String getProcedureName() {
        return this.name;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public void acceptVisitor(LanguageObjectVisitor visitor) {
        visitor.visit(this);
    }

    public void setProcedureName(String name) {
        this.name = name;
    }

    public void setArguments(List<Argument> parameters) {
        this.arguments = parameters;
    }

    @Override
    public Procedure getMetadataObject() {
        return this.metadataObject;
    }

    public ProcedureParameter getReturnParameter() {
        for (ProcedureParameter param : this.metadataObject.getParameters()) {
            if (param.getType() != ProcedureParameter.Type.ReturnValue) continue;
            return param;
        }
        return null;
    }

    public Class<?>[] getResultSetColumnTypes() {
        ColumnSet<Procedure> resultSet = this.metadataObject.getResultSet();
        if (resultSet == null) {
            return new Class[0];
        }
        List<Column> columnMetadata = resultSet.getColumns();
        int size = columnMetadata.size();
        Class[] coulmnDTs = new Class[size];
        for (int i = 0; i < size; ++i) {
            coulmnDTs[i] = columnMetadata.get(i).getJavaType();
        }
        return coulmnDTs;
    }
}

