/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.report.ActivityReport;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.TranslatorException;

public class MetadataValidator {
    private Map<String, Datatype> typeMap;
    private QueryParser parser;

    public MetadataValidator(Map<String, Datatype> typeMap, QueryParser parser) {
        this.typeMap = typeMap;
        this.parser = parser;
    }

    public MetadataValidator() {
        this.typeMap = SystemMetadata.getInstance().getRuntimeTypeMap();
        this.parser = QueryParser.getQueryParser();
    }

    public ValidatorReport validate(VDBMetaData vdb, MetadataStore store) {
        ValidatorReport report = new ValidatorReport();
        if (store != null && !store.getSchemaList().isEmpty()) {
            new SourceModelArtifacts().execute(vdb, store, report, this);
            new CrossSchemaResolver().execute(vdb, store, report, this);
            new ResolveQueryPlans().execute(vdb, store, report, this);
            new MinimalMetadata().execute(vdb, store, report, this);
        }
        return report;
    }

    public void log(ValidatorReport report, ModelMetaData model, String msg) {
        this.log(report, model, ModelMetaData.Message.Severity.ERROR, msg);
    }

    public void log(ValidatorReport report, ModelMetaData model, ModelMetaData.Message.Severity severity, String msg) {
        model.addRuntimeMessage(severity, msg);
        int messageLevel = 3;
        if (severity == ModelMetaData.Message.Severity.ERROR) {
            report.handleValidationError(msg);
        } else {
            messageLevel = 4;
            report.handleValidationWarning(msg);
        }
        LogManager.log(messageLevel, "org.teiid.PLANNER.RESOLVER", msg);
    }

    private void validate(VDBMetaData vdb, ModelMetaData model, AbstractMetadataRecord record, ValidatorReport report, QueryMetadataInterface metadata, MetadataFactory mf) {
        ActivityReport resolverReport = null;
        try {
            if (record instanceof Procedure) {
                Procedure p = (Procedure)record;
                Command command = this.parser.parseProcedure(p.getQueryPlan(), false);
                QueryResolver.resolveCommand(command, new GroupSymbol(p.getFullName()), 6, metadata, false);
                resolverReport = Validator.validate(command, metadata);
            } else if (record instanceof Table) {
                Table t = (Table)record;
                GroupSymbol symbol = new GroupSymbol(t.getFullName());
                ResolverUtil.resolveGroup(symbol, metadata);
                if (t.isVirtual() && (t.getColumns() == null || t.getColumns().isEmpty())) {
                    QueryCommand command = (QueryCommand)QueryParser.getQueryParser().parseCommand(t.getSelectTransformation());
                    QueryResolver.resolveCommand(command, metadata);
                    resolverReport = Validator.validate(command, metadata);
                    if (!resolverReport.hasItems()) {
                        List<Expression> symbols = command.getProjectedSymbols();
                        for (Expression column : symbols) {
                            try {
                                this.addColumn(Symbol.getShortName(column), column.getType(), t, mf);
                            }
                            catch (TranslatorException e) {
                                this.log(report, model, e.getMessage());
                            }
                        }
                    }
                }
                boolean addCacheHint = false;
                if (t.isMaterialized() && t.getMaterializedTable() == null) {
                    List<KeyRecord> fbis = t.getFunctionBasedIndexes();
                    List<GroupSymbol> groups = Arrays.asList(symbol);
                    if (fbis != null && !fbis.isEmpty()) {
                        for (KeyRecord fbi : fbis) {
                            for (int j = 0; j < fbi.getColumns().size(); ++j) {
                                Column c = fbi.getColumns().get(j);
                                if (c.getParent() != fbi) continue;
                                String exprString = c.getNameInSource();
                                try {
                                    Expression ex = QueryParser.getQueryParser().parseExpression(exprString);
                                    ResolverVisitor.resolveLanguageObject(ex, groups, metadata);
                                    if (!ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ex).isEmpty()) {
                                        this.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31114, exprString, fbi.getFullName()));
                                    }
                                    EvaluatableVisitor ev = new EvaluatableVisitor();
                                    PreOrPostOrderNavigator.doVisit(ex, ev, true);
                                    if (ev.getDeterminismLevel().compareTo(FunctionMethod.Determinism.VDB_DETERMINISTIC) >= 0) continue;
                                    this.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31115, exprString, fbi.getFullName()));
                                    continue;
                                }
                                catch (QueryResolverException e) {
                                    this.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31116, exprString, fbi.getFullName(), e.getMessage()));
                                }
                            }
                        }
                    }
                } else {
                    addCacheHint = true;
                }
                QueryNode node = QueryResolver.resolveView(symbol, new QueryNode(t.getSelectTransformation()), "SELECT", metadata);
                CacheHint cacheHint = node.getCommand().getCacheHint();
                Long ttl = -1L;
                if (cacheHint != null && cacheHint.getTtl() != null && addCacheHint) {
                    ttl = cacheHint.getTtl();
                    t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", String.valueOf(ttl));
                }
            }
            if (resolverReport != null && resolverReport.hasItems()) {
                for (ValidatorFailure v : resolverReport.getItems()) {
                    this.log(report, model, v.getStatus() == ValidatorFailure.Status.ERROR ? ModelMetaData.Message.Severity.ERROR : ModelMetaData.Message.Severity.WARNING, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31080, record.getFullName(), v.getMessage()));
                }
            }
        }
        catch (TeiidException e) {
            this.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31080, record.getFullName(), e.getMessage()));
        }
    }

    private Column addColumn(String name, Class<?> type, Table table, MetadataFactory mf) throws TranslatorException {
        if (type == null) {
            throw new TranslatorException(QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31086, name, table.getFullName()));
        }
        Column column = mf.addColumn(name, DataTypeManager.getDataTypeName(type), table);
        column.setUpdatable(table.supportsUpdate());
        return column;
    }

    static class CrossSchemaResolver
    implements MetadataRule {
        CrossSchemaResolver() {
        }

        private boolean keyMatches(List<String> names, KeyRecord record) {
            if (names.size() != record.getColumns().size()) {
                return false;
            }
            TreeSet<String> keyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Column c : record.getColumns()) {
                keyNames.add(c.getName());
            }
            for (int i = 0; i < names.size(); ++i) {
                if (keyNames.contains(names.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (t.isVirtual() && t.isMaterialized() && t.getMaterializedTable() != null && t.getMaterializedTable().getParent() == null) {
                        String matTableName = t.getMaterializedTable().getName();
                        int index = matTableName.indexOf(46);
                        if (index == -1) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31088, matTableName, t.getFullName()));
                        } else {
                            String schemaName = matTableName.substring(0, index);
                            Schema matSchema = store.getSchema(schemaName);
                            if (matSchema == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31089, schemaName, matTableName, t.getFullName()));
                            } else {
                                Table matTable = matSchema.getTable(matTableName.substring(index + 1));
                                if (matTable == null) {
                                    metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31090, matTableName.substring(index + 1), schemaName, t.getFullName()));
                                } else {
                                    t.setMaterializedTable(matTable);
                                }
                            }
                        }
                    }
                    for (KeyRecord record : t.getAllKeys()) {
                        if (record.getColumns() != null && !record.getColumns().isEmpty()) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31149, t.getFullName(), record.getName()));
                    }
                    List<ForeignKey> fks = t.getForeignKeys();
                    if (fks == null || fks.isEmpty()) continue;
                    for (ForeignKey fk : fks) {
                        if (fk.getReferenceKey() != null) {
                            fk.setReferenceKey(fk.getReferenceKey());
                            continue;
                        }
                        String referenceTableName = fk.getReferenceTableName();
                        if (referenceTableName == null) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31091, t.getFullName()));
                            continue;
                        }
                        String referenceSchemaName = schema.getName();
                        Table referenceTable = schema.getTable(referenceTableName);
                        int index = referenceTableName.indexOf(46);
                        if (referenceTable == null) {
                            if (index != -1) {
                                referenceSchemaName = referenceTableName.substring(0, index);
                                Schema referenceSchema = store.getSchema(referenceSchemaName);
                                if (referenceSchema == null) {
                                    metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31093, referenceSchemaName, t.getFullName()));
                                    continue;
                                }
                                referenceTable = referenceSchema.getTable(referenceTableName.substring(index + 1));
                            }
                            if (referenceTable == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31092, t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName));
                                continue;
                            }
                        }
                        KeyRecord uniqueKey = null;
                        List<String> referenceColumns = fk.getReferenceColumns();
                        if (referenceColumns == null || referenceColumns.isEmpty()) {
                            if (referenceTable.getPrimaryKey() == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31094, t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName));
                            } else {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                        } else {
                            for (KeyRecord record : referenceTable.getUniqueKeys()) {
                                if (!this.keyMatches(referenceColumns, record)) continue;
                                uniqueKey = record;
                                break;
                            }
                            if (uniqueKey == null && referenceTable.getPrimaryKey() != null && this.keyMatches(referenceColumns, referenceTable.getPrimaryKey())) {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                        }
                        if (uniqueKey == null) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31095, t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName, referenceColumns));
                            continue;
                        }
                        fk.setReferenceKey(uniqueKey);
                    }
                }
            }
        }
    }

    static class ResolveQueryPlans
    implements MetadataRule {
        ResolveQueryPlans() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            QueryMetadataInterface metadata = vdb.getAttachment(QueryMetadataInterface.class);
            metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                MetadataFactory mf = new MetadataFactory(vdb.getName(), vdb.getVersion(), metadataValidator.typeMap, model){

                    @Override
                    protected void setUUID(AbstractMetadataRecord record) {
                        if (this.count >= 0) {
                            this.count = Integer.MIN_VALUE;
                        }
                        super.setUUID(record);
                    }
                };
                mf.setBuiltinDataTypes(store.getDatatypes());
                for (AbstractMetadataRecord record : schema.getResolvingOrder()) {
                    Procedure p;
                    if (record instanceof Table) {
                        Table t = (Table)record;
                        if (t.getTableType() == Table.Type.Document || t.getTableType() == Table.Type.XmlMappingClass || t.getTableType() == Table.Type.XmlStagingTable || !t.isVirtual() || t.getTableType() == Table.Type.TemporaryTable) continue;
                        if (t.getSelectTransformation() == null) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31079, t.getFullName(), model.getName()));
                            continue;
                        }
                        metadataValidator.validate(vdb, model, t, report, metadata, mf);
                        continue;
                    }
                    if (!(record instanceof Procedure) || !(p = (Procedure)record).isVirtual() || p.isFunction()) continue;
                    if (p.getQueryPlan() == null) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31081, p.getFullName(), model.getName()));
                        continue;
                    }
                    metadataValidator.validate(vdb, model, p, report, metadata, mf);
                }
            }
        }
    }

    static class SourceModelArtifacts
    implements MetadataRule {
        SourceModelArtifacts() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (!t.isPhysical() || model.isSource()) continue;
                    metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31075, t.getFullName(), model.getName()));
                }
                HashSet<String> names = new HashSet<String>();
                for (Procedure p : schema.getProcedures().values()) {
                    boolean hasReturn = false;
                    names.clear();
                    for (ProcedureParameter param : p.getParameters()) {
                        if (param.isVarArg() && param != p.getParameters().get(p.getParameters().size() - 1)) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31112, p.getFullName()));
                        }
                        if (param.getType() == ProcedureParameter.Type.ReturnValue) {
                            if (hasReturn) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31107, p.getFullName()));
                            }
                            hasReturn = true;
                        }
                        if (names.add(param.getName())) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31106, p.getFullName(), param.getFullName()));
                    }
                    if (p.isVirtual() || model.isSource()) continue;
                    metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31077, p.getFullName(), model.getName()));
                }
                for (FunctionMethod func : schema.getFunctions().values()) {
                    for (FunctionParameter param : func.getInputParameters()) {
                        if (!param.isVarArg() || param == func.getInputParameters().get(func.getInputParameterCount() - 1)) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31112, func.getFullName()));
                    }
                    if (!func.getPushdown().equals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN) || model.isSource()) continue;
                    metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31078, func.getFullName(), model.getName()));
                }
            }
        }
    }

    static class MinimalMetadata
    implements MetadataRule {
        MinimalMetadata() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                if (schema.getTables().isEmpty() && schema.getProcedures().isEmpty() && schema.getFunctions().isEmpty()) {
                    metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31070, model.getName()));
                }
                for (Table t : schema.getTables().values()) {
                    if (t.getColumns() == null || t.getColumns().size() == 0) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31071, t.getFullName()));
                    }
                    TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    this.validateConstraintNames(metadataValidator, report, model, t.getAllKeys(), names);
                    this.validateConstraintNames(metadataValidator, report, model, t.getFunctionBasedIndexes(), names);
                }
                if (schema.getFunctions().isEmpty()) continue;
                ActivityReport funcReport = new ActivityReport("Translator metadata load " + model.getName());
                FunctionMetadataValidator.validateFunctionMethods(schema.getFunctions().values(), report);
                if (!report.hasItems()) continue;
                metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31073, funcReport));
            }
        }

        private void validateConstraintNames(MetadataValidator metadataValidator, ValidatorReport report, ModelMetaData model, Collection<KeyRecord> keys, Set<String> names) {
            for (KeyRecord record : keys) {
                if (record.getName() == null || names.add(record.getName())) continue;
                metadataValidator.log(report, model, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31152, record.getFullName()));
            }
        }
    }

    static interface MetadataRule {
        public void execute(VDBMetaData var1, MetadataStore var2, ValidatorReport var3, MetadataValidator var4);
    }
}

