/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

public class TextTableNode
extends SubqueryAwareRelationalNode {
    private TextTable table;
    private int skip = 0;
    private int header = -1;
    private boolean noQuote;
    private char quote;
    private char delimiter;
    private int lineWidth;
    private int[] projectionIndexes;
    private Map<String, List<String>> parentLines;
    private BufferedReader reader;
    private int textLine = 0;
    private Map<String, Integer> nameIndexes;
    private String systemId;
    private int rowNumber;
    private boolean cr;
    private boolean eof;
    private boolean running;
    private TeiidProcessingException asynchException;
    private int limit = -1;

    public TextTableNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.projectionIndexes != null) {
            return;
        }
        if (this.table.getSkip() != null) {
            this.skip = this.table.getSkip();
        }
        if (this.table.getHeader() != null) {
            this.skip = Math.max(this.table.getHeader(), this.skip);
            this.header = this.table.getHeader() - 1;
        }
        if (this.table.isFixedWidth()) {
            for (TextTable.TextColumn col : this.table.getColumns()) {
                this.lineWidth += col.getWidth().intValue();
            }
        } else {
            this.delimiter = this.table.getDelimiter() == null ? (char)44 : this.table.getDelimiter().charValue();
            if (this.table.getQuote() == null) {
                this.quote = (char)34;
            } else {
                this.noQuote = this.table.isEscape();
                this.quote = this.table.getQuote().charValue();
            }
            for (TextTable.TextColumn column : this.table.getColumns()) {
                if (column.getSelector() == null) continue;
                if (this.parentLines == null) {
                    this.parentLines = new HashMap<String, List<String>>();
                }
                this.parentLines.put(column.getSelector(), null);
            }
            this.lineWidth = this.table.getColumns().size() * DataTypeManager.MAX_STRING_LENGTH;
        }
        Map<Expression, Integer> elementMap = TextTableNode.createLookupMap(this.table.getProjectedSymbols());
        this.projectionIndexes = TextTableNode.getProjectionIndexes(elementMap, this.getElements());
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.reader = null;
        }
        this.nameIndexes = null;
        this.textLine = 0;
        this.rowNumber = 0;
        this.cr = false;
        this.eof = false;
        if (this.parentLines != null) {
            for (Map.Entry<String, List<String>> entry : this.parentLines.entrySet()) {
                entry.setValue(null);
            }
        }
        this.running = false;
        this.asynchException = null;
        this.limit = -1;
    }

    public void setTable(TextTable table) {
        this.table = table;
    }

    @Override
    public TextTableNode clone() {
        TextTableNode clone = new TextTableNode(this.getID());
        this.copyTo(clone);
        clone.setTable(this.table);
        return clone;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        LimitNode parent;
        super.open();
        if (this.getParent() instanceof LimitNode && (parent = (LimitNode)this.getParent()).getLimit() > 0) {
            this.limit = parent.getLimit() + parent.getOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.reader == null) {
            this.initReader();
        }
        if (this.reader == null) {
            this.terminateBatches();
            return this.pullBatch();
        }
        if (this.isLastBatch()) {
            return this.pullBatch();
        }
        if (this.isBatchFull()) {
            TupleBatch result = this.pullBatch();
            this.processAsynch();
            return result;
        }
        if (this.asynchException != null) {
            throw this.asynchException;
        }
        this.processAsynch();
        if (this.getContext().getWorkItem() == null) {
            TextTableNode textTableNode = this;
            synchronized (textTableNode) {
                while (this.running) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new TeiidRuntimeException(e);
                    }
                }
            }
        }
        throw BlockedException.block("Blocking on results from file processing.");
    }

    private void processAsynch() {
        if (!this.running) {
            this.running = true;
            this.getContext().getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TextTableNode.this.process();
                    }
                    catch (TeiidProcessingException e) {
                        TextTableNode.this.asynchException = e;
                    }
                    finally {
                        TextTableNode.this.running = false;
                        RequestWorkItem workItem = TextTableNode.this.getContext().getWorkItem();
                        if (workItem != null) {
                            workItem.moreWork();
                        } else {
                            TextTableNode textTableNode = TextTableNode.this;
                            synchronized (textTableNode) {
                                TextTableNode.this.notifyAll();
                            }
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws TeiidProcessingException {
        while (true) {
            TextTableNode textTableNode = this;
            synchronized (textTableNode) {
                if (this.isBatchFull()) {
                    return;
                }
                StringBuilder line = this.readLine(this.lineWidth, this.table.isFixedWidth());
                if (line == null) {
                    this.terminateBatches();
                    break;
                }
                String parentSelector = null;
                if (this.table.getSelector() != null) {
                    if (line.length() < this.table.getSelector().length()) {
                        continue;
                    }
                    if (!line.substring(0, this.table.getSelector().length()).equals(this.table.getSelector())) {
                        if (this.parentLines == null) {
                            continue;
                        }
                        parentSelector = line.substring(0, this.table.getSelector().length());
                        if (!this.parentLines.containsKey(parentSelector)) {
                            continue;
                        }
                    }
                }
                List<String> vals = this.parseLine(line);
                if (parentSelector != null) {
                    this.parentLines.put(parentSelector, vals);
                    continue;
                }
                if (this.table.getSelector() != null && !this.table.getSelector().equals(vals.get(0))) {
                    continue;
                }
                ++this.rowNumber;
                ArrayList<Object> tuple = new ArrayList<Object>(this.projectionIndexes.length);
                for (int output : this.projectionIndexes) {
                    TextTable.TextColumn col = this.table.getColumns().get(output);
                    String val = null;
                    int index = output;
                    if (col.isOrdinal()) {
                        tuple.add(this.rowNumber);
                        continue;
                    }
                    if (col.getSelector() != null) {
                        vals = this.parentLines.get(col.getSelector());
                        index = col.getPosition() - 1;
                    } else if (this.nameIndexes != null) {
                        index = this.nameIndexes.get(col.getName());
                    }
                    if (vals == null || index >= vals.size()) {
                        tuple.add(null);
                        continue;
                    }
                    val = vals.get(index);
                    try {
                        tuple.add(DataTypeManager.transformValue(val, this.table.getColumns().get(output).getSymbol().getType()));
                    }
                    catch (TransformationException e) {
                        throw new TeiidProcessingException(QueryPlugin.Event.TEIID30176, e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30176, col.getName(), this.textLine, this.systemId));
                    }
                }
                this.addBatchRow(tuple);
                if (this.rowNumber == this.limit) {
                    this.terminateBatches();
                    break;
                }
            }
        }
    }

    private StringBuilder readLine(int maxLength, boolean exact) throws TeiidProcessingException {
        if (this.eof) {
            return null;
        }
        StringBuilder sb = new StringBuilder(exact ? maxLength : maxLength >> 4);
        while (true) {
            char c;
            if ((c = this.readChar()) == '\n') {
                if (sb.length() == 0) {
                    if (this.eof) {
                        return null;
                    }
                    if (this.table.isUsingRowDelimiter()) continue;
                }
                if (this.table.isUsingRowDelimiter()) {
                    return sb;
                }
            }
            sb.append(c);
            if (exact && sb.length() == maxLength && !this.table.isUsingRowDelimiter()) {
                return sb;
            }
            if (sb.length() > maxLength) break;
        }
        if (exact) {
            sb.deleteCharAt(sb.length() - 1);
            while (this.readChar() != '\n') {
            }
            return sb;
        }
        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30178, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30178, this.textLine + 1, this.systemId, maxLength));
    }

    private char readChar() throws TeiidProcessingException {
        try {
            int c = this.reader.read();
            if (this.cr) {
                if (c == 10) {
                    c = this.reader.read();
                }
                this.cr = false;
            }
            switch (c) {
                case 13: {
                    this.cr = true;
                    ++this.textLine;
                    return '\n';
                }
                case -1: {
                    this.eof = true;
                    ++this.textLine;
                    return '\n';
                }
                case 10: {
                    ++this.textLine;
                    return '\n';
                }
            }
            return (char)c;
        }
        catch (IOException e) {
            throw new TeiidProcessingException(QueryPlugin.Event.TEIID30179, e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30179, this.systemId));
        }
    }

    private void initReader() throws ExpressionEvaluationException, BlockedException, TeiidComponentException, TeiidProcessingException {
        this.setReferenceValues(this.table);
        ClobType file = (ClobType)this.getEvaluator(Collections.emptyMap()).evaluate(this.table.getFile(), null);
        if (file == null) {
            return;
        }
        try {
            Reader r;
            this.systemId = "Unknown";
            if (file.getReference() instanceof ClobImpl) {
                this.systemId = ((ClobImpl)file.getReference()).getStreamFactory().getSystemId();
                if (this.systemId == null) {
                    this.systemId = "Unknown";
                }
            }
            this.reader = !((r = file.getCharacterStream()) instanceof BufferedReader) ? new BufferedReader(r) : (BufferedReader)r;
        }
        catch (SQLException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30180, (Throwable)e);
        }
        if (this.skip <= 0) {
            return;
        }
        while (this.textLine < this.skip) {
            boolean isHeader;
            boolean bl = isHeader = this.textLine == this.header;
            if (isHeader) {
                StringBuilder line = this.readLine(DataTypeManager.MAX_STRING_LENGTH * 16, false);
                if (line == null) {
                    this.reset();
                    return;
                }
                this.processHeader(this.parseLine(line));
                continue;
            }
            while (this.readChar() != '\n') {
            }
        }
    }

    private void processHeader(List<String> line) throws TeiidProcessingException {
        this.nameIndexes = new HashMap<String, Integer>();
        this.lineWidth = DataTypeManager.MAX_STRING_LENGTH * line.size();
        for (String string : line) {
            if (string == null) continue;
            this.nameIndexes.put(string.toUpperCase(), this.nameIndexes.size());
        }
        for (TextTable.TextColumn col : this.table.getColumns()) {
            if (col.isOrdinal()) continue;
            Integer index = this.nameIndexes.get(col.getName().toUpperCase());
            if (index == null) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30181, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30181, col.getName(), this.systemId));
            }
            this.nameIndexes.put(col.getName(), index);
        }
    }

    private List<String> parseLine(StringBuilder line) throws TeiidProcessingException {
        if (this.table.isFixedWidth()) {
            return this.parseFixedWidth(line);
        }
        return this.parseDelimitedLine(line);
    }

    private List<String> parseDelimitedLine(StringBuilder line) throws TeiidProcessingException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        boolean wasQualified = false;
        boolean qualified = false;
        while (true) {
            if (line == null) {
                if (escaped) {
                    if (this.cr) {
                        builder.append('\r');
                    }
                    builder.append('\n');
                    escaped = false;
                    line = this.readLine(this.lineWidth, false);
                    continue;
                }
                if (!qualified) {
                    this.addValue(result, wasQualified, builder.toString());
                    return result;
                }
                line = this.readLine(this.lineWidth, false);
                if (line == null) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30182, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30182, this.systemId));
                }
            }
            for (int i = 0; i < line.length(); ++i) {
                char chr = line.charAt(i);
                if (chr == this.delimiter) {
                    if (escaped || qualified) {
                        builder.append(chr);
                        escaped = false;
                        continue;
                    }
                    this.addValue(result, wasQualified, builder.toString());
                    wasQualified = false;
                    builder = new StringBuilder();
                    continue;
                }
                if (chr == this.quote) {
                    if (this.noQuote) {
                        if (escaped) {
                            builder.append(this.quote);
                        }
                        escaped = !escaped;
                        continue;
                    }
                    if (qualified) {
                        qualified = false;
                        continue;
                    }
                    if (wasQualified) {
                        qualified = true;
                        builder.append(chr);
                        continue;
                    }
                    if (builder.toString().trim().length() != 0) {
                        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30183, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30183, this.textLine, this.systemId));
                    }
                    qualified = true;
                    builder = new StringBuilder();
                    wasQualified = true;
                    continue;
                }
                if (escaped) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30184, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30184, Character.valueOf(chr), this.textLine, this.systemId));
                }
                if (wasQualified && !qualified) {
                    if (Character.isWhitespace(chr)) continue;
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30183, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30183, this.textLine, this.systemId));
                }
                builder.append(chr);
            }
            line = null;
        }
    }

    private void addValue(ArrayList<String> result, boolean wasQualified, String val) {
        if (!wasQualified && (val = val.trim()).length() == 0) {
            val = null;
        }
        result.add(val);
    }

    private List<String> parseFixedWidth(StringBuilder line) {
        ArrayList<String> result = new ArrayList<String>();
        int beginIndex = 0;
        for (TextTable.TextColumn col : this.table.getColumns()) {
            if (beginIndex >= line.length()) {
                result.add(null);
                continue;
            }
            String val = new String(line.substring(beginIndex, Math.min(line.length(), beginIndex + col.getWidth())));
            this.addValue(result, col.isNoTrim(), val);
            beginIndex += col.getWidth().intValue();
        }
        return result;
    }

    @Override
    protected Collection<? extends LanguageObject> getObjects() {
        return Arrays.asList(this.table.getFile());
    }
}

