/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.teiid.client.SourceWarning;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.FutureWork;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.events.EventDistributor;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;

public class DataTierTupleSource
implements TupleSource,
DQPCore.CompletionListener<AtomicResultsMessage> {
    private final AtomicRequestMessage aqr;
    private final RequestWorkItem workItem;
    private final ConnectorWork cwi;
    private final DataTierManagerImpl dtm;
    private int limit = -1;
    private int index;
    private int rowsProcessed;
    private AtomicResultsMessage arm;
    private AtomicBoolean closed = new AtomicBoolean();
    private volatile boolean canceled;
    private volatile boolean cancelAsynch;
    private boolean executed;
    private volatile boolean done;
    private boolean explicitClose;
    private volatile FutureWork<AtomicResultsMessage> futureResult;
    private volatile boolean running;
    boolean errored;
    CacheDirective.Scope scope;
    private long waitUntil;
    private Future<Void> scheduledFuture;

    public DataTierTupleSource(AtomicRequestMessage aqr, RequestWorkItem workItem, ConnectorWork cwi, DataTierManagerImpl dtm, int limit) {
        this.aqr = aqr;
        this.workItem = workItem;
        this.cwi = cwi;
        this.dtm = dtm;
        this.limit = limit;
        Assertion.isNull((Object)workItem.getConnectorRequest(aqr.getAtomicRequestID()));
        workItem.addConnectorRequest(aqr.getAtomicRequestID(), this);
    }

    void addWork() {
        this.futureResult = this.workItem.addWork(new Callable<AtomicResultsMessage>(){

            @Override
            public AtomicResultsMessage call() throws Exception {
                return DataTierTupleSource.this.getResults();
            }
        }, this, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
        if (this.waitUntil > 0L && this.waitUntil > System.currentTimeMillis()) {
            if (!this.cwi.isDataAvailable()) {
                throw BlockedException.block(this.aqr.getAtomicRequestID(), "Blocking until", this.waitUntil);
            }
            this.waitUntil = 0L;
        }
        while (true) {
            if (this.arm == null) {
                AtomicResultsMessage results;
                boolean partial;
                block17: {
                    if (this.isDone()) {
                        return null;
                    }
                    partial = false;
                    results = null;
                    boolean noResults = false;
                    try {
                        long ts;
                        results = this.futureResult != null || !this.aqr.isSerial() ? this.asynchGet() : this.getResults();
                        if (this.index != 0 || !this.dtm.detectChangeEvents()) break block17;
                        Command command = this.aqr.getCommand();
                        int commandIndex = 0;
                        if (RelationalNodeUtil.isUpdate(command)) {
                            ts = System.currentTimeMillis();
                            this.checkForUpdates(results, command, this.dtm.getEventDistributor(), commandIndex, ts);
                            break block17;
                        }
                        if (!(command instanceof BatchedUpdateCommand)) break block17;
                        ts = System.currentTimeMillis();
                        BatchedUpdateCommand bac = (BatchedUpdateCommand)command;
                        for (Command uc : bac.getUpdateCommands()) {
                            this.checkForUpdates(results, uc, this.dtm.getEventDistributor(), commandIndex++, ts);
                        }
                    }
                    catch (TranslatorException e) {
                        this.errored = true;
                        results = this.exceptionOccurred(e);
                        partial = true;
                    }
                    catch (BlockedException e) {
                        noResults = true;
                        throw e;
                    }
                    catch (DataNotAvailableException e) {
                        noResults = true;
                        this.handleDataNotAvailable(e);
                        continue;
                    }
                    finally {
                        if (noResults || results != null) continue;
                        this.errored = true;
                        continue;
                    }
                }
                this.receiveResults(results, partial);
            }
            if (this.index < this.arm.getResults().length) {
                if (this.limit-- == 0) {
                    this.done = true;
                    this.arm = null;
                    return null;
                }
                return this.arm.getResults()[this.index++];
            }
            this.arm = null;
            if (this.isDone()) break;
        }
        return null;
    }

    private void handleDataNotAvailable(DataNotAvailableException e) throws BlockedException {
        if (e.getWaitUntil() != null) {
            long timeDiff = e.getWaitUntil().getTime() - System.currentTimeMillis();
            if (timeDiff <= 0L) {
                return;
            }
            if (e.isStrict()) {
                this.waitUntil = e.getWaitUntil().getTime();
            }
            this.scheduleMoreWork(timeDiff);
        } else if (e.getRetryDelay() >= 0L) {
            if (e.isStrict()) {
                this.waitUntil = System.currentTimeMillis() + e.getRetryDelay();
            }
            this.scheduleMoreWork(e.getRetryDelay());
        } else {
            if (this.cwi.isDataAvailable()) {
                return;
            }
            if (e.isStrict()) {
                this.waitUntil = Long.MAX_VALUE;
            }
        }
        throw BlockedException.block(this.aqr.getAtomicRequestID(), "Blocking on DataNotAvailableException", this.aqr.getAtomicRequestID());
    }

    private void scheduleMoreWork(long timeDiff) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.scheduledFuture = this.workItem.scheduleWork(timeDiff);
    }

    private void checkForUpdates(AtomicResultsMessage results, Command command, EventDistributor distributor, int commandIndex, long ts) {
        if (!RelationalNodeUtil.isUpdate(command) || !(command instanceof ProcedureContainer)) {
            return;
        }
        ProcedureContainer pc = (ProcedureContainer)command;
        GroupSymbol gs = pc.getGroup();
        Integer zero = 0;
        if (results.getResults().length <= commandIndex || zero.equals(results.getResults()[commandIndex].get(0))) {
            return;
        }
        Object metadataId = gs.getMetadataID();
        if (metadataId == null) {
            return;
        }
        if (!(metadataId instanceof Table)) {
            TempMetadataID tid;
            if (metadataId instanceof TempMetadataID && (tid = (TempMetadataID)metadataId).getTableData().getModel() != null) {
                tid.getTableData().dataModified((Integer)results.getResults()[commandIndex].get(0));
            }
            return;
        }
        Table t = (Table)metadataId;
        t.setLastDataModification(ts);
        if (distributor != null) {
            distributor.dataModification(this.workItem.getDqpWorkContext().getVdbName(), this.workItem.getDqpWorkContext().getVdbVersion(), ((Schema)t.getParent()).getName(), new String[]{t.getName()});
        }
    }

    private AtomicResultsMessage asynchGet() throws BlockedException, TeiidProcessingException, TeiidComponentException, TranslatorException {
        if (this.futureResult == null) {
            this.addWork();
        }
        if (!this.futureResult.isDone()) {
            throw BlockedException.block(this.aqr.getAtomicRequestID(), "Blocking on source query", this.aqr.getAtomicRequestID());
        }
        FutureWork<AtomicResultsMessage> currentResults = this.futureResult;
        this.futureResult = null;
        AtomicResultsMessage results = null;
        try {
            results = (AtomicResultsMessage)currentResults.get();
            if (results.getFinalRow() < 0) {
                this.addWork();
            }
        }
        catch (CancellationException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30503, (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)e.getCause();
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            if (e.getCause() instanceof TranslatorException) {
                throw (TranslatorException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        return results;
    }

    AtomicResultsMessage getResults() throws BlockedException, TeiidComponentException, TranslatorException {
        AtomicResultsMessage results = null;
        if (this.cancelAsynch) {
            return null;
        }
        this.running = true;
        if (!this.executed) {
            this.cwi.execute();
            this.executed = true;
        }
        results = this.cwi.more();
        return results;
    }

    public boolean isQueued() {
        FutureWork<AtomicResultsMessage> future = this.futureResult;
        return !this.running && future != null && !future.isDone();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void fullyCloseSource() {
        this.cancelAsynch = true;
        if (this.closed.compareAndSet(false, true)) {
            this.workItem.closeAtomicRequest(this.aqr.getAtomicRequestID());
            if (this.aqr.isSerial() || this.futureResult == null) {
                this.cwi.close();
            } else {
                this.futureResult.addCompletionListener(new DQPCore.CompletionListener<AtomicResultsMessage>(){

                    @Override
                    public void onCompletion(FutureWork<AtomicResultsMessage> future) {
                        DataTierTupleSource.this.cwi.close();
                    }
                });
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancelRequest() {
        this.canceled = true;
        this.cwi.cancel();
        this.cancelFutures();
    }

    @Override
    public void closeSource() {
        this.cancelFutures();
        this.cancelAsynch = true;
        if (!this.explicitClose) {
            this.fullyCloseSource();
        }
    }

    private void cancelFutures() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        if (this.futureResult != null) {
            this.futureResult.cancel(false);
        }
    }

    AtomicResultsMessage exceptionOccurred(TranslatorException exception) throws TeiidComponentException, TeiidProcessingException {
        if (this.workItem.requestMsg.supportsPartialResults()) {
            AtomicResultsMessage emptyResults = new AtomicResultsMessage(new List[0]);
            emptyResults.setWarnings(Arrays.asList(new Exception[]{exception}));
            emptyResults.setFinalRow(this.rowsProcessed);
            return emptyResults;
        }
        this.fullyCloseSource();
        if (exception.getCause() instanceof TeiidComponentException) {
            throw (TeiidComponentException)exception.getCause();
        }
        if (exception.getCause() instanceof TeiidProcessingException) {
            throw (TeiidProcessingException)exception.getCause();
        }
        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30504, (Throwable)exception, this.getConnectorName() + ": " + exception.getMessage());
    }

    void receiveResults(AtomicResultsMessage response, boolean partial) {
        this.arm = response;
        this.scope = response.getScope();
        this.explicitClose |= !this.arm.supportsImplicitClose();
        this.rowsProcessed += response.getResults().length;
        this.index = 0;
        if (response.getWarnings() != null) {
            for (Exception warning : response.getWarnings()) {
                SourceWarning sourceFailure = new SourceWarning(this.aqr.getModelName(), this.aqr.getConnectorName(), (Throwable)warning, partial);
                this.aqr.getCommandContext().addWarning((Exception)sourceFailure);
            }
        }
        if (response.getFinalRow() >= 0) {
            this.done = true;
        }
    }

    public AtomicRequestMessage getAtomicRequestMessage() {
        return this.aqr;
    }

    public String getConnectorName() {
        return this.aqr.getConnectorName();
    }

    public boolean isTransactional() {
        return this.aqr.isTransactional();
    }

    @Override
    public void onCompletion(FutureWork<AtomicResultsMessage> future) {
        this.running = false;
        if (!this.cancelAsynch) {
            this.workItem.moreWork();
        }
    }

    public boolean isExplicitClose() {
        return this.explicitClose;
    }

    public Future<Void> getScheduledFuture() {
        return this.scheduledFuture;
    }
}

