/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.jboss.vfs.VirtualFile;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.metadata.VDBResource;

public class VDBResources {
    public static final String DEPLOYMENT_FILE = "vdb.xml";
    public static final String VDB_ARCHIVE_EXTENSION = ".vdb";
    public static final String INDEX_EXT = ".INDEX";
    public static final String SEARCH_INDEX_EXT = ".SEARCH_INDEX";
    public static final String MODEL_EXT = ".xmi";
    private LinkedHashMap<String, Resource> vdbEntries;

    public VDBResources(VirtualFile root, VDBMetaData vdb) throws IOException {
        LinkedHashMap<String, Resource> visibilityMap = new LinkedHashMap<String, Resource>();
        for (VirtualFile f : root.getChildrenRecursively()) {
            if (!f.isFile()) continue;
            String path = f.getPathName().substring(root.getPathName().length());
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            visibilityMap.put(path, new Resource(f));
        }
        this.vdbEntries = visibilityMap;
    }

    public LinkedHashMap<String, Resource> getEntriesPlusVisibilities() {
        return this.vdbEntries;
    }

    public static class Resource
    implements VDBResource {
        VirtualFile file;
        boolean visible;

        public Resource(VirtualFile file) {
            this.file = file;
        }

        public InputStream openStream() throws IOException {
            return this.file.openStream();
        }

        public long getSize() {
            return this.file.getSize();
        }

        public String getName() {
            return this.file.getName();
        }

        public VirtualFile getFile() {
            return this.file;
        }
    }
}

