/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.Expression;

public class ObjectTable
extends TableFunctionReference {
    public static final String DEFAULT_LANGUAGE = "teiid_script";
    private List<ObjectColumn> columns = new ArrayList<ObjectColumn>();
    private String rowScript;
    private List<DerivedColumn> passing = new ArrayList<DerivedColumn>();
    private String scriptingLanguage;
    private CompiledScript compiledScript;
    private ScriptEngine scriptEngine;

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    public String getScriptingLanguage() {
        return this.scriptingLanguage;
    }

    public void setScriptingLanguage(String scriptingLanguage) {
        this.scriptingLanguage = scriptingLanguage;
    }

    public List<DerivedColumn> getPassing() {
        return this.passing;
    }

    public void setPassing(List<DerivedColumn> passing) {
        this.passing = passing;
    }

    public String getRowScript() {
        return this.rowScript;
    }

    public void setRowScript(String query) {
        this.rowScript = query;
    }

    public List<ObjectColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ObjectColumn> columns) {
        this.columns = columns;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected ObjectTable cloneDirect() {
        ObjectTable clone = new ObjectTable();
        this.copy(clone);
        for (ObjectColumn column : this.columns) {
            clone.getColumns().add(column.clone());
        }
        if (this.passing != null) {
            for (DerivedColumn col : this.passing) {
                clone.passing.add(col.clone());
            }
        }
        clone.rowScript = this.rowScript;
        clone.compiledScript = this.compiledScript;
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof ObjectTable)) {
            return false;
        }
        ObjectTable other = (ObjectTable)obj;
        return this.columns.equals(other.columns) && this.rowScript.equals(other.rowScript) && this.passing.equals(other.passing);
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public static class ObjectColumn
    extends TableFunctionReference.ProjectedColumn {
        private String path;
        private Expression defaultExpression;
        private CompiledScript compiledScript;

        public ObjectColumn(String name, String type, String path, Expression defaultExpression) {
            super(name, type);
            this.path = path;
            this.defaultExpression = defaultExpression;
        }

        protected ObjectColumn() {
        }

        public Expression getDefaultExpression() {
            return this.defaultExpression;
        }

        public void setDefaultExpression(Expression defaultExpression) {
            this.defaultExpression = defaultExpression;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public CompiledScript getCompiledScript() {
            return this.compiledScript;
        }

        public void setCompiledScript(CompiledScript compiledScript) {
            this.compiledScript = compiledScript;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj) || !(obj instanceof ObjectColumn)) {
                return false;
            }
            ObjectColumn other = (ObjectColumn)obj;
            return EquivalenceUtil.areEqual((Object)this.path, (Object)other.path) && EquivalenceUtil.areEqual((Object)this.defaultExpression, (Object)other.defaultExpression);
        }

        public ObjectColumn clone() {
            ObjectColumn clone = new ObjectColumn();
            super.copyTo(clone);
            clone.path = this.path;
            if (this.defaultExpression != null) {
                clone.defaultExpression = (Expression)this.defaultExpression.clone();
            }
            clone.compiledScript = this.compiledScript;
            return clone;
        }
    }
}

