/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.types.ArrayImpl;
import org.teiid.language.Like;
import org.teiid.language.SortSpecification;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.tempdata.SearchableTable;

public class BaseIndexInfo<T extends SearchableTable> {
    List<Object> lower = null;
    List<Object> upper = null;
    ArrayList<List<Object>> valueSet = new ArrayList();
    T table;
    Boolean ordering;
    boolean covering;
    CompoundCriteria nonCoveredCriteria = null;
    CompoundCriteria coveredCriteria = null;
    public BaseIndexInfo<?> next;

    public BaseIndexInfo(T table, List<? extends Expression> projectedCols, Criteria condition, OrderBy orderBy, boolean primary) {
        this.table = table;
        if (primary || this.table.getColumnMap().keySet().containsAll(projectedCols)) {
            this.covering = true;
        }
        if (table.getPkLength() > 0) {
            this.processCriteria(condition, primary);
            if (orderBy != null) {
                this.ordering = this.useIndexForOrderBy(orderBy);
            }
        }
    }

    private void processCriteria(Criteria condition, boolean primary) {
        List<Criteria> crits = Criteria.separateCriteriaByAnd(condition);
        if (!primary) {
            Iterator<Criteria> critIter = crits.iterator();
            while (critIter.hasNext()) {
                Criteria criteria = critIter.next();
                if (this.table.getColumnMap().keySet().containsAll(ElementCollectorVisitor.getElements((LanguageObject)criteria, false))) {
                    if (this.coveredCriteria == null) {
                        this.coveredCriteria = new CompoundCriteria();
                    }
                    this.coveredCriteria.addCriteria(criteria);
                    continue;
                }
                this.covering = false;
                if (this.nonCoveredCriteria == null) {
                    this.nonCoveredCriteria = new CompoundCriteria();
                }
                this.nonCoveredCriteria.addCriteria(criteria);
                critIter.remove();
            }
        }
        for (int i = 0; i < this.table.getPkLength(); ++i) {
            Iterator<Criteria> critIter = crits.iterator();
            while (critIter.hasNext()) {
                SetCriteria setCriteria;
                Object matchResult;
                Criteria criteria = critIter.next();
                if (criteria instanceof CompareCriteria) {
                    CompareCriteria cc = (CompareCriteria)criteria;
                    matchResult = this.table.matchesPkColumn(i, cc.getLeftExpression());
                    if (Boolean.FALSE.equals(matchResult)) continue;
                    if (cc.getOperator() != 1 && !this.table.supportsOrdering(i, cc.getLeftExpression())) {
                        critIter.remove();
                        continue;
                    }
                    this.addCondition(i, matchResult, (Constant)cc.getRightExpression(), cc.getOperator());
                    critIter.remove();
                    continue;
                }
                if (criteria instanceof IsNullCriteria) {
                    IsNullCriteria inc = (IsNullCriteria)criteria;
                    matchResult = this.table.matchesPkColumn(i, inc.getExpression());
                    if (Boolean.FALSE.equals(matchResult)) continue;
                    this.addCondition(i, matchResult, new Constant(null), 1);
                    critIter.remove();
                    continue;
                }
                if (criteria instanceof MatchCriteria) {
                    int j;
                    MatchCriteria matchCriteria = (MatchCriteria)criteria;
                    matchResult = this.table.matchesPkColumn(i, matchCriteria.getLeftExpression());
                    if (Boolean.FALSE.equals(matchResult)) continue;
                    Constant value = (Constant)matchCriteria.getRightExpression();
                    String pattern = (String)value.getValue();
                    boolean escaped = false;
                    char escapeChar = matchCriteria.getEscapeChar();
                    if (matchCriteria.getMode() == Like.MatchMode.REGEX) {
                        escapeChar = '\\';
                    }
                    StringBuilder prefix = new StringBuilder();
                    if (pattern.length() > 0 && matchCriteria.getMode() == Like.MatchMode.REGEX && pattern.charAt(0) != '^') continue;
                    int n = j = matchCriteria.getMode() == Like.MatchMode.REGEX ? 1 : 0;
                    while (j < pattern.length()) {
                        char character = pattern.charAt(j);
                        if (character == escapeChar && character != '\u0000') {
                            if (escaped) {
                                prefix.append(character);
                                escaped = false;
                            } else {
                                escaped = true;
                            }
                        } else {
                            if (!escaped) {
                                if (matchCriteria.getMode() == Like.MatchMode.LIKE) {
                                    if (character == '%' || character == '_') {
                                        break;
                                    }
                                } else {
                                    int index = Arrays.binarySearch(Evaluator.REGEX_RESERVED, character);
                                    if (index >= 0 && pattern.length() > 0) {
                                        this.getRegexPrefix(pattern, escapeChar, prefix, j, character);
                                        break;
                                    }
                                }
                            } else {
                                escaped = false;
                            }
                            prefix.append(character);
                        }
                        ++j;
                    }
                    if (prefix.length() > 0) {
                        this.addCondition(i, matchResult, new Constant(prefix.toString()), 6);
                        if (matchCriteria.getLeftExpression() instanceof Function && this.table.supportsOrdering(i, matchCriteria.getLeftExpression())) {
                            this.addCondition(i, matchResult, new Constant(prefix.substring(0, prefix.length() - 1) + (char)(Character.toLowerCase(prefix.charAt(prefix.length() - 1)) + '\u0001')), 5);
                            continue;
                        }
                        this.addCondition(i, matchResult, new Constant(prefix.substring(0, prefix.length() - 1) + (char)(prefix.charAt(prefix.length() - 1) + '\u0001')), 5);
                        continue;
                    }
                    critIter.remove();
                    continue;
                }
                if (!(criteria instanceof SetCriteria) || Boolean.FALSE.equals(matchResult = this.table.matchesPkColumn(i, (setCriteria = (SetCriteria)criteria).getExpression()))) continue;
                Collection values = setCriteria.getValues();
                this.addSet(i, matchResult, values);
                critIter.remove();
            }
        }
    }

    private void getRegexPrefix(String pattern, char escapeChar, StringBuilder prefix, int j, char character) {
        boolean escaped = false;
        int level = 0;
        for (int k = j; k < pattern.length(); ++k) {
            character = pattern.charAt(k);
            if (character == escapeChar && character != '\u0000') {
                escaped = !escaped;
                continue;
            }
            if (escaped) continue;
            if (character == '(') {
                ++level;
                continue;
            }
            if (character == ')') {
                --level;
                continue;
            }
            if (character != '|' || level != 0) continue;
            prefix.setLength(0);
            return;
        }
        if (character == '{' || character == '?' || character == '*') {
            prefix.setLength(prefix.length() - 1);
        }
    }

    void addCondition(int i, Object match, Constant value, int comparisionMode) {
        Object value2 = value.getValue();
        switch (comparisionMode) {
            case 1: {
                if (i == 0) {
                    this.valueSet.clear();
                    this.valueSet.add(new ArrayList(this.table.getPkLength()));
                }
                if (this.valueSet.size() != 1) break;
                List<Object> toSearch = this.valueSet.get(0);
                this.buildSearchRow(i, match, value2, toSearch);
                this.lower = null;
                this.upper = null;
                break;
            }
            case 4: 
            case 6: {
                if (!this.valueSet.isEmpty()) break;
                if (i == 0) {
                    this.lower = new ArrayList<Object>(this.table.getPkLength());
                }
                if (this.lower == null) break;
                this.buildSearchRow(i, match, value2, this.lower);
                break;
            }
            case 3: 
            case 5: {
                if (!this.valueSet.isEmpty()) break;
                if (i == 0) {
                    this.upper = new ArrayList<Object>(this.table.getPkLength());
                }
                if (this.upper == null) break;
                this.buildSearchRow(i, match, value2, this.upper);
            }
        }
    }

    private void buildSearchRow(int i, Object match, Object value2, List<Object> toSearch) {
        if (toSearch.size() != i) {
            return;
        }
        if (value2 instanceof ArrayImpl && match instanceof int[]) {
            int index;
            int[] indexes = (int[])match;
            ArrayImpl array = (ArrayImpl)value2;
            Object[] arrayVals = array.getValues();
            for (int j = 0; j < indexes.length && (index = indexes[j]) != -1; ++j) {
                toSearch.add(arrayVals[index]);
            }
        } else {
            toSearch.add(value2);
        }
    }

    void addSet(int i, Object match, Collection<Constant> values) {
        if (!this.valueSet.isEmpty()) {
            return;
        }
        if (i == 0) {
            for (Constant constant : values) {
                ArrayList<Object> value = new ArrayList<Object>(this.table.getPkLength());
                Object value2 = constant.getValue();
                this.buildSearchRow(i, match, value2, value);
                this.valueSet.add(value);
            }
            this.lower = null;
            this.upper = null;
        }
    }

    private Boolean useIndexForOrderBy(OrderBy orderBy) {
        Boolean direction = null;
        int size = orderBy.getOrderByItems().size();
        if (size > this.table.getPkLength()) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            OrderByItem item = orderBy.getOrderByItems().get(i);
            if (!Boolean.TRUE.equals(this.table.matchesPkColumn(i, item.getSymbol())) || !this.table.supportsOrdering(i, item.getSymbol())) {
                return null;
            }
            if (item.getNullOrdering() != null && (item.isAscending() && item.getNullOrdering() == SortSpecification.NullOrdering.LAST || !item.isAscending() && item.getNullOrdering() == SortSpecification.NullOrdering.FIRST)) {
                return null;
            }
            if (item.isAscending()) {
                if (direction == null) {
                    direction = true;
                    continue;
                }
                if (direction.booleanValue()) continue;
                return null;
            }
            if (direction == null) {
                direction = false;
                continue;
            }
            if (!direction.booleanValue()) continue;
            return null;
        }
        return direction;
    }

    public List<Object> getLower() {
        return this.lower;
    }

    public List<Object> getUpper() {
        return this.upper;
    }

    public ArrayList<List<Object>> getValueSet() {
        return this.valueSet;
    }

    public void sortValueSet(boolean direction) {
        int size = this.getValueSet().get(0).size();
        int[] sortOn = new int[size];
        for (int i = 0; i < sortOn.length; ++i) {
            sortOn[i] = i;
        }
        Collections.sort(this.getValueSet(), new ListNestedSortComparator(sortOn, direction));
    }

    public Criteria getCoveredCriteria() {
        return this.coveredCriteria;
    }

    public Criteria getNonCoveredCriteria() {
        return this.nonCoveredCriteria;
    }
}

