/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.teiid.client.BatchSerializer;
import org.teiid.client.ResizingArrayList;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.common.buffer.AutoCleanupUtil;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.CacheEntry;
import org.teiid.common.buffer.CacheKey;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.LobManager;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.Serializer;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.impl.LrfuEvictionQueue;
import org.teiid.common.buffer.impl.SizeUtility;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.ReplicatedObject;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;
import org.teiid.query.util.Options;

public class BufferManagerImpl
implements BufferManager,
ReplicatedObject<String> {
    private static final int SYSTEM_OVERHEAD_MEGS = 150;
    private static final int MAX_READ_AGE = 524288;
    private static final long BATCH_OVERHEAD = 128L;
    static final int CONCURRENCY_LEVEL = 32;
    private static final int TARGET_BYTES_PER_ROW = 2048;
    private static ReferenceQueue<CacheEntry> SOFT_QUEUE = new ReferenceQueue();
    private int processorBatchSize = 256;
    private int maxProcessingBytes = 0x200000;
    private Integer maxProcessingBytesOrig;
    long maxReserveBytes = 0x10000000L;
    AtomicLong reserveBatchBytes = new AtomicLong();
    AtomicLong overheadBytes = new AtomicLong();
    private int maxActivePlans = 20;
    private boolean useWeakReferences = true;
    private boolean inlineLobs = true;
    private int targetBytesPerRow = 2048;
    private int maxSoftReferences;
    private int nominalProcessingMemoryMax = this.maxProcessingBytes;
    private ReentrantLock lock = new ReentrantLock();
    private Condition batchesFreed = this.lock.newCondition();
    AtomicLong activeBatchBytes = new AtomicLong();
    private AtomicLong readAttempts = new AtomicLong();
    LrfuEvictionQueue<CacheEntry> evictionQueue = new LrfuEvictionQueue(this.readAttempts);
    LrfuEvictionQueue<CacheEntry> initialEvictionQueue = new LrfuEvictionQueue(this.readAttempts);
    ConcurrentHashMap<Long, CacheEntry> memoryEntries = new ConcurrentHashMap(16, 0.75f, 32);
    private DataTypeManager.WeakReferenceHashedValueCache<CacheEntry> weakReferenceCache;
    private Map<Long, BatchSoftReference> softCache = Collections.synchronizedMap(new LinkedHashMap<Long, BatchSoftReference>(16, 0.75f, false){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, BatchSoftReference> eldest) {
            if (this.size() > BufferManagerImpl.this.maxSoftReferences) {
                BatchSoftReference bsr = eldest.getValue();
                BufferManagerImpl.this.clearSoftReference(bsr);
                return true;
            }
            return false;
        }
    });
    private Cache cache;
    private Map<String, TupleReference> tupleBufferMap = new ConcurrentHashMap<String, TupleReference>();
    private ReferenceQueue<TupleBuffer> tupleBufferQueue = new ReferenceQueue();
    private AtomicLong tsId = new AtomicLong();
    private AtomicLong batchAdded = new AtomicLong();
    private AtomicLong readCount = new AtomicLong();
    private AtomicLong writeCount = new AtomicLong();
    private AtomicLong referenceHit = new AtomicLong();
    private static final Timer timer = new Timer("BufferManager Cleaner", true);
    private Cleaner cleaner;
    private AtomicBoolean cleaning = new AtomicBoolean();
    AtomicInteger removed = new AtomicInteger();
    private Options options;

    public BufferManagerImpl() {
        this.cleaner = new Cleaner(this);
        timer.schedule((TimerTask)this.cleaner, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSoftReference(BatchSoftReference bsr) {
        BatchSoftReference batchSoftReference = bsr;
        synchronized (batchSoftReference) {
            this.overheadBytes.addAndGet(-bsr.sizeEstimate);
            bsr.sizeEstimate = 0;
        }
        bsr.clear();
    }

    void removeFromCache(Long gid, Long batch) {
        if (this.cache.remove(gid, batch)) {
            this.overheadBytes.addAndGet(-128L);
        }
    }

    public long getBatchesAdded() {
        return this.batchAdded.get();
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    public long getReadAttempts() {
        return this.readAttempts.get();
    }

    @Override
    public int getMaxProcessingSize() {
        return this.maxProcessingBytes;
    }

    public long getReserveBatchBytes() {
        return this.reserveBatchBytes.get();
    }

    @Override
    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    public void setTargetBytesPerRow(int targetBytesPerRow) {
        this.targetBytesPerRow = targetBytesPerRow;
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.processorBatchSize = processorBatchSize;
    }

    @Override
    public TupleBuffer createTupleBuffer(List elements, String groupName, BufferManager.TupleSourceType tupleSourceType) {
        Long newID = this.tsId.getAndIncrement();
        int[] lobIndexes = LobManager.getLobIndexes(elements);
        Object[] types = BufferManagerImpl.getTypeClasses(elements);
        BatchManagerImpl batchManager = this.createBatchManager(newID, (Class<?>[])types);
        LobManager lobManager = null;
        if (lobIndexes != null) {
            FileStore lobStore = this.createFileStore(newID + "_lobs");
            lobManager = new LobManager(lobIndexes, lobStore);
            batchManager.setLobManager(lobManager);
        }
        TupleBuffer tupleBuffer = new TupleBuffer(batchManager, String.valueOf(newID), elements, lobManager, this.getProcessorBatchSize(elements));
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Creating TupleBuffer:", newID, elements, Arrays.toString(types), "batch size", tupleBuffer.getBatchSize(), "of type", tupleSourceType});
        }
        tupleBuffer.setInlineLobs(this.inlineLobs);
        return tupleBuffer;
    }

    @Override
    public STree createSTree(List<? extends Expression> elements, String groupName, int keyLength) {
        Long newID = this.tsId.getAndIncrement();
        int[] lobIndexes = LobManager.getLobIndexes(elements);
        Class<?>[] types = BufferManagerImpl.getTypeClasses(elements);
        BatchManagerImpl bm = this.createBatchManager(newID, types);
        LobManager lobManager = null;
        if (lobIndexes != null) {
            lobManager = new LobManager(lobIndexes, null);
            bm.setLobManager(lobManager);
        }
        BatchManagerImpl keyManager = this.createBatchManager(this.tsId.getAndIncrement(), Arrays.copyOf(types, keyLength));
        int[] compareIndexes = new int[keyLength];
        for (int i = 1; i < compareIndexes.length; ++i) {
            compareIndexes[i] = i;
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)"Creating STree:", (Object)newID);
        }
        return new STree(keyManager, bm, new ListNestedSortComparator(compareIndexes).defaultNullOrder(this.getOptions().getDefaultNullOrder()), this.getProcessorBatchSize(elements.subList(0, keyLength)), this.getProcessorBatchSize(elements), keyLength, lobManager);
    }

    private static Class<?>[] getTypeClasses(List<? extends Expression> elements) {
        Class[] types = new Class[elements.size()];
        ListIterator<? extends Expression> i = elements.listIterator();
        while (i.hasNext()) {
            Expression expr = i.next();
            Class<?> type = expr.getType();
            Assertion.isNotNull(type);
            types[i.previousIndex()] = type;
        }
        return types;
    }

    private BatchManagerImpl createBatchManager(Long newID, Class<?>[] types) {
        return new BatchManagerImpl(newID, types);
    }

    @Override
    public FileStore createFileStore(String name) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object)"Creating FileStore:", (Object)name);
        }
        return this.cache.createFileStore(name);
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public void setMaxActivePlans(int maxActivePlans) {
        this.maxActivePlans = maxActivePlans;
    }

    public void setMaxProcessingKB(int maxProcessingKB) {
        this.maxProcessingBytes = maxProcessingKB > -1 ? maxProcessingKB << 10 : -1;
    }

    public void setMaxReserveKB(int maxReserveBatchKB) {
        if (maxReserveBatchKB > -1) {
            long maxReserve;
            this.maxReserveBytes = maxReserve = (long)maxReserveBatchKB << 10;
            this.reserveBatchBytes.set(maxReserve);
        } else {
            this.maxReserveBytes = -1L;
        }
    }

    @Override
    public void initialize() throws TeiidComponentException {
        long maxMemory = Runtime.getRuntime().maxMemory();
        maxMemory = Math.max(0L, maxMemory - 0x9600000L);
        if (this.getMaxReserveKB() < 0) {
            this.maxReserveBytes = 0L;
            int one_gig = 0x40000000;
            if (maxMemory > (long)one_gig) {
                this.maxReserveBytes = (long)Math.max(0.0, (double)(maxMemory - (long)one_gig) * 0.5);
            }
            this.maxReserveBytes = (long)((double)this.maxReserveBytes + Math.max(0.0, (double)Math.min((long)one_gig, maxMemory) * 0.4));
        }
        this.reserveBatchBytes.set(this.maxReserveBytes);
        if (this.maxProcessingBytesOrig == null) {
            this.maxProcessingBytesOrig = this.maxProcessingBytes;
        }
        if (this.maxProcessingBytesOrig < 0) {
            this.maxProcessingBytes = (int)Math.min(Math.max((double)((long)(this.processorBatchSize * this.targetBytesPerRow) * 16L), 0.07 * (double)maxMemory / Math.pow(this.maxActivePlans, 0.8)), 2.147483647E9);
        }
        long memoryBatches = maxMemory / (long)(this.processorBatchSize * this.targetBytesPerRow);
        int logSize = 67 - Long.numberOfLeadingZeros(memoryBatches);
        if (this.useWeakReferences) {
            this.weakReferenceCache = new DataTypeManager.WeakReferenceHashedValueCache(Math.min(30, logSize));
        }
        this.maxSoftReferences = 1 << Math.min(30, logSize);
        this.nominalProcessingMemoryMax = (int)Math.max(Math.min(this.maxReserveBytes, (long)(2 * this.maxProcessingBytes)), Math.min(Integer.MAX_VALUE, 2L * this.maxReserveBytes / (long)this.maxActivePlans));
    }

    void setNominalProcessingMemoryMax(int nominalProcessingMemoryMax) {
        this.nominalProcessingMemoryMax = nominalProcessingMemoryMax;
    }

    @Override
    public void releaseOrphanedBuffers(long count) {
        this.releaseBuffers(count, false);
    }

    @Override
    public void releaseBuffers(int count) {
        this.releaseBuffers(count, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuffers(long count, boolean updateContext) {
        if (count < 1L) {
            return;
        }
        if (updateContext) {
            CommandContext context;
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object)"Releasing buffer space", (Object)count);
            }
            if ((context = CommandContext.getThreadLocalContext()) != null) {
                context.addAndGetReservedBuffers((int)(-count));
            }
        } else if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)4)) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object)"Releasing orphaned buffer space", (Object)count);
        }
        this.lock.lock();
        try {
            this.reserveBatchBytes.addAndGet(count);
            this.batchesFreed.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reserveBuffers(int count, BufferManager.BufferReserveMode mode) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object)"Reserving buffer space", (Object)count, (Object)((Object)mode));
        }
        CommandContext context = CommandContext.getThreadLocalContext();
        int existing = 0;
        if (context != null) {
            existing = (int)Math.min(Integer.MAX_VALUE, context.addAndGetReservedBuffers(0));
        }
        int result = count;
        if (mode == BufferManager.BufferReserveMode.FORCE) {
            this.reserve(count, context);
        } else {
            this.lock.lock();
            try {
                count = Math.min(count, this.nominalProcessingMemoryMax - existing);
                result = this.noWaitReserve(count, false, context);
            }
            finally {
                this.lock.unlock();
            }
        }
        this.persistBatchReferences(result);
        return result;
    }

    private void reserve(int count, CommandContext context) {
        this.reserveBatchBytes.addAndGet(-count);
        if (context != null) {
            context.addAndGetReservedBuffers(count);
        }
    }

    @Override
    public int reserveBuffersBlocking(int count, long[] val, boolean force) throws BlockedException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object)"Reserving buffer space", (Object)count, (Object)force);
        }
        assert (count >= 0);
        if (count == 0) {
            return 0;
        }
        int result = 0;
        int count_orig = count;
        CommandContext context = CommandContext.getThreadLocalContext();
        long reserved = 0L;
        if (context != null) {
            reserved = context.addAndGetReservedBuffers(0);
        }
        if (count_orig != (count = Math.min(count, (int)Math.min(Integer.MAX_VALUE, (long)this.nominalProcessingMemoryMax - reserved))) && !force) {
            return 0;
        }
        result = this.noWaitReserve(count, true, context);
        if (result == 0) {
            long l = val[0];
            val[0] = l + 1L;
            if (l == 0L) {
                val[1] = System.currentTimeMillis();
            }
            if (val[1] > 1L) {
                long last = val[1];
                val[1] = System.currentTimeMillis();
                try {
                    this.lock.lock();
                    if (val[1] - last < 10L) {
                        this.batchesFreed.await(20L, TimeUnit.MILLISECONDS);
                    }
                    if (val[0] << (force ? 16 : 18) > (long)count) {
                        if (!force) {
                            int n = 0;
                            return n;
                        }
                        this.reserve(count_orig, context);
                        result = count_orig;
                    } else {
                        int min = 0;
                        min = force ? 2 * count / 3 : 4 * count / 5;
                        if (this.reserveBatchBytes.get() > (long)min) {
                            this.reserve(count_orig, context);
                            result = count_orig;
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (result == 0) {
                RequestWorkItem workItem;
                if (context != null && (workItem = context.getWorkItem()) != null) {
                    workItem.moreWork();
                }
                throw BlockedException.BLOCKED_ON_MEMORY_EXCEPTION;
            }
        }
        if (force && result < count_orig) {
            this.reserve(count_orig - result, context);
            result = count_orig;
        }
        val[0] = 0L;
        this.persistBatchReferences(result);
        return result;
    }

    private int noWaitReserve(int count, boolean allOrNothing, CommandContext context) {
        boolean success = false;
        for (int i = 0; !success && i < 2; ++i) {
            long reserveBatch = this.reserveBatchBytes.get();
            long overhead = this.overheadBytes.get();
            long current = reserveBatch - overhead;
            if (allOrNothing) {
                if ((long)count > current) {
                    return 0;
                }
            } else if ((long)count > current) {
                count = (int)Math.max(0L, current);
            }
            if (count == 0) {
                return 0;
            }
            if (!this.reserveBatchBytes.compareAndSet(reserveBatch, reserveBatch - (long)count)) continue;
            success = true;
        }
        if (!success) {
            this.reserveBatchBytes.addAndGet(-count);
        }
        if (context != null) {
            context.addAndGetReservedBuffers(count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBatchReferences(int max) {
        long reserveBatch;
        if (max <= 0) {
            return;
        }
        long activeBatch = this.activeBatchBytes.get() + this.overheadBytes.get();
        long memoryCount = activeBatch + this.maxReserveBytes - (reserveBatch = this.reserveBatchBytes.get());
        if (memoryCount <= this.maxReserveBytes) {
            if (DataTypeManager.USE_VALUE_CACHE && DataTypeManager.isValueCacheEnabled() && memoryCount < this.maxReserveBytes / 8L) {
                DataTypeManager.setValueCacheEnabled((boolean)false);
            }
            return;
        }
        if (DataTypeManager.USE_VALUE_CACHE) {
            DataTypeManager.setValueCacheEnabled((boolean)true);
        }
        if (this.cleaning.compareAndSet(false, true)) {
            Cleaner cleaner = this.cleaner;
            synchronized (cleaner) {
                this.cleaner.notify();
            }
        }
        long maxToFree = Math.min((long)max, memoryCount - this.maxReserveBytes);
        LrfuEvictionQueue<CacheEntry> first = this.initialEvictionQueue;
        LrfuEvictionQueue<CacheEntry> second = this.evictionQueue;
        if (this.evictionQueue.getSize() > 2 * this.initialEvictionQueue.getSize()) {
            first = this.evictionQueue;
            second = this.initialEvictionQueue;
        }
        if ((maxToFree -= this.doEvictions(maxToFree, false, first)) > 0L && (maxToFree = Math.min(maxToFree, this.activeBatchBytes.get() + this.overheadBytes.get() - this.reserveBatchBytes.get())) > 0L) {
            this.doEvictions(maxToFree, false, second);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long doEvictions(long maxToFree, boolean ageOut, LrfuEvictionQueue<CacheEntry> queue) {
        CacheEntry ce;
        if (queue == this.evictionQueue) {
            maxToFree = Math.min(maxToFree, (long)this.maxProcessingBytes);
        }
        long freed = 0L;
        while (freed <= maxToFree && (ageOut || queue == this.evictionQueue && this.activeBatchBytes.get() + this.overheadBytes.get() + this.maxReserveBytes / 2L > this.reserveBatchBytes.get() || queue != this.evictionQueue && this.activeBatchBytes.get() + this.overheadBytes.get() + 3L * this.maxReserveBytes / 4L > this.reserveBatchBytes.get()) && (ce = queue.firstEntry(!ageOut)) != null) {
            CacheEntry cacheEntry = ce;
            synchronized (cacheEntry) {
                if (!this.memoryEntries.containsKey(ce.getId())) {
                    if (!ageOut) {
                        queue.remove(ce);
                    }
                    continue;
                }
            }
            if (ageOut) {
                long lastAccess = ce.getKey().getLastAccess();
                long currentTime = this.readAttempts.get();
                long age = currentTime - lastAccess;
                if (age < 524288L) {
                    ageOut = false;
                    continue;
                }
                queue.remove(ce);
            }
            boolean evicted = true;
            try {
                evicted = this.evict(ce);
            }
            catch (Throwable e) {
                LogManager.logError((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30017, new Object[]{ce.getId()}));
            }
            finally {
                if (!evicted) continue;
                CacheEntry cacheEntry2 = ce;
                synchronized (cacheEntry2) {
                    if (this.memoryEntries.remove(ce.getId()) != null) {
                        freed += (long)ce.getSizeEstimate();
                        this.activeBatchBytes.addAndGet(-ce.getSizeEstimate());
                        queue.remove(ce);
                    }
                }
            }
        }
        return freed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean evict(CacheEntry ce) throws Exception {
        Serializer<?> s = ce.getSerializer();
        if (s == null) {
            return true;
        }
        boolean persist = false;
        CacheEntry cacheEntry = ce;
        synchronized (cacheEntry) {
            if (!ce.isPersistent()) {
                assert (!this.initialEvictionQueue.remove(ce));
                persist = true;
                ce.setPersistent(true);
            }
        }
        if (persist) {
            long count = this.writeCount.incrementAndGet();
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{s.getId(), ce.getId(), "writing batch to storage, total writes: ", count});
            }
        }
        boolean result = this.cache.add(ce, s);
        if (s.useSoftCache()) {
            this.createSoftReference(ce);
        } else if (this.useWeakReferences) {
            this.weakReferenceCache.getValue((Object)ce);
        }
        return result;
    }

    private void createSoftReference(CacheEntry ce) {
        int sizeEstimate = ce.getSizeEstimate() / 2;
        BatchSoftReference ref = new BatchSoftReference(ce, SOFT_QUEUE, sizeEstimate);
        this.softCache.put(ce.getId(), ref);
        this.overheadBytes.addAndGet(sizeEstimate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheEntry fastGet(Long batch, Boolean prefersMemory, boolean retain) {
        BatchSoftReference bsr;
        CacheEntry ce = null;
        ce = retain ? this.memoryEntries.get(batch) : this.memoryEntries.remove(batch);
        if (ce != null) {
            CacheEntry cacheEntry = ce;
            synchronized (cacheEntry) {
                if (retain) {
                    if (this.memoryEntries.containsKey(batch)) {
                        if (ce.isPersistent()) {
                            assert (!this.initialEvictionQueue.remove(ce));
                            this.evictionQueue.touch(ce);
                        } else {
                            this.initialEvictionQueue.touch(ce);
                        }
                    }
                } else {
                    this.evictionQueue.remove(ce);
                    if (!ce.isPersistent()) {
                        this.initialEvictionQueue.remove(ce);
                    }
                }
            }
            if (!retain) {
                this.remove(ce, true);
            }
            return ce;
        }
        if ((prefersMemory == null || prefersMemory.booleanValue()) && (bsr = this.softCache.remove(batch)) != null && (ce = (CacheEntry)bsr.get()) != null) {
            this.clearSoftReference(bsr);
        }
        if (!(ce != null || prefersMemory != null && prefersMemory.booleanValue() || !this.useWeakReferences || (ce = (CacheEntry)this.weakReferenceCache.getByHash((Object)batch)) != null && ce.getId().equals(batch))) {
            return null;
        }
        if (ce != null && ce.getObject() != null) {
            this.referenceHit.getAndIncrement();
            if (retain) {
                this.addMemoryEntry(ce, false);
            } else {
                this.remove(ce, false);
            }
            return ce;
        }
        return null;
    }

    CacheEntry remove(Long gid, Long batch, boolean prefersMemory) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object)"Removing batch from BufferManager", (Object)gid, (Object)batch);
        }
        this.cleanSoftReferences();
        CacheEntry ce = this.fastGet(batch, prefersMemory, false);
        if (ce == null) {
            this.removeFromCache(gid, batch);
        } else {
            ce.nullOut();
        }
        return ce;
    }

    private void remove(CacheEntry ce, boolean inMemory) {
        Serializer<?> s;
        if (inMemory) {
            this.activeBatchBytes.addAndGet(-ce.getSizeEstimate());
        }
        if ((s = ce.getSerializer()) != null) {
            this.removeFromCache(s.getId(), ce.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMemoryEntry(CacheEntry ce, boolean initial) {
        this.persistBatchReferences(ce.getSizeEstimate());
        CacheEntry cacheEntry = ce;
        synchronized (cacheEntry) {
            boolean added;
            boolean bl = added = this.memoryEntries.put(ce.getId(), ce) == null;
            if (initial) {
                assert (added);
                this.initialEvictionQueue.add(ce);
            } else {
                assert (ce.isPersistent());
                this.evictionQueue.touch(ce);
            }
        }
        this.activeBatchBytes.getAndAdd(ce.getSizeEstimate());
    }

    void removeCacheGroup(Long id, Boolean prefersMemory) {
        this.cleanSoftReferences();
        if (this.cache == null) {
            return;
        }
        Collection<Long> vals = this.cache.removeCacheGroup(id);
        long overhead = (long)vals.size() * 128L;
        this.overheadBytes.addAndGet(-overhead);
        if (!vals.isEmpty()) {
            for (Long val : vals) {
                this.fastGet(val, prefersMemory, false);
            }
        }
    }

    void cleanSoftReferences() {
        BatchSoftReference ref;
        for (int i = 0; i < 10 && (ref = (BatchSoftReference)SOFT_QUEUE.poll()) != null; ++i) {
            this.softCache.remove(ref.key);
            this.clearSoftReference(ref);
        }
    }

    @Override
    public int getProcessorBatchSize(List<? extends Expression> schema) {
        return this.getSizeEstimates(schema)[0];
    }

    private int[] getSizeEstimates(List<? extends Expression> elements) {
        int total = 0;
        boolean isValueCacheEnabled = DataTypeManager.isValueCacheEnabled();
        for (int i = elements.size() - 1; i >= 0; --i) {
            Class<?> type = elements.get(i).getType();
            total += SizeUtility.getSize(isValueCacheEnabled, type);
        }
        int totalCopy = total += 8 * elements.size() + 36;
        boolean less = totalCopy < this.targetBytesPerRow;
        int rowCount = this.processorBatchSize;
        for (int i = 0; i < 3; ++i) {
            totalCopy = less ? (totalCopy <<= 1) : (totalCopy >>= 2);
            if (less && totalCopy > this.targetBytesPerRow || !less && totalCopy < this.targetBytesPerRow) break;
            if (less) {
                rowCount <<= 1;
                continue;
            }
            rowCount >>= 1;
        }
        rowCount = Math.max(1, rowCount);
        return new int[]{rowCount, Math.max(1, total *= rowCount)};
    }

    @Override
    public int getSchemaSize(List<? extends Expression> elements) {
        return this.getSizeEstimates(elements)[1];
    }

    public void shutdown() {
        this.cache.shutdown();
        this.cache = null;
        this.memoryEntries.clear();
        this.evictionQueue.getEvictionQueue().clear();
        this.initialEvictionQueue.getEvictionQueue().clear();
        this.cleaner.cancel();
    }

    @Override
    public void addTupleBuffer(TupleBuffer tb) {
        this.cleanDefunctTupleBuffers();
        this.tupleBufferMap.put(tb.getId(), new TupleReference(tb, this.tupleBufferQueue));
    }

    @Override
    public void distributeTupleBuffer(String uuid, TupleBuffer tb) {
        tb.setId(uuid);
        this.addTupleBuffer(tb);
    }

    @Override
    public TupleBuffer getTupleBuffer(String id) {
        this.cleanDefunctTupleBuffers();
        Reference r = this.tupleBufferMap.get(id);
        if (r != null) {
            return (TupleBuffer)r.get();
        }
        return null;
    }

    private void cleanDefunctTupleBuffers() {
        Reference<TupleBuffer> r;
        while ((r = this.tupleBufferQueue.poll()) != null) {
            this.tupleBufferMap.remove(((TupleReference)r).id);
        }
    }

    public void setUseWeakReferences(boolean useWeakReferences) {
        this.useWeakReferences = useWeakReferences;
    }

    @Override
    public void getState(OutputStream ostream) {
    }

    @Override
    public void getState(String state_id, OutputStream ostream) {
        TupleBuffer buffer = this.getTupleBuffer(state_id);
        if (buffer != null) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(ostream);
                this.getTupleBufferState(out, buffer);
                out.flush();
            }
            catch (TeiidComponentException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30054, (Throwable)e);
            }
            catch (IOException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30055, (Throwable)e);
            }
        }
    }

    private void getTupleBufferState(ObjectOutputStream out, TupleBuffer buffer) throws TeiidComponentException, IOException {
        out.writeLong(buffer.getRowCount());
        out.writeInt(buffer.getBatchSize());
        out.writeObject(buffer.getTypes());
        int row = 1;
        while ((long)row <= buffer.getRowCount()) {
            TupleBatch b = buffer.getBatch(row);
            BatchSerializer.writeBatch((ObjectOutput)out, (String[])buffer.getTypes(), b.getTuples());
            row += buffer.getBatchSize();
        }
    }

    @Override
    public void setState(InputStream istream) {
    }

    @Override
    public void setState(String state_id, InputStream istream) {
        TupleBuffer buffer = this.getTupleBuffer(state_id);
        if (buffer == null) {
            try {
                ObjectInputStream in = new ObjectInputStream(istream);
                this.setTupleBufferState(state_id, in);
            }
            catch (IOException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30056, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30057, (Throwable)e);
            }
            catch (TeiidComponentException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30058, (Throwable)e);
            }
        }
    }

    private void setTupleBufferState(String state_id, ObjectInputStream in) throws IOException, ClassNotFoundException, TeiidComponentException {
        long rowCount = in.readLong();
        int batchSize = in.readInt();
        String[] types = (String[])in.readObject();
        ArrayList<ElementSymbol> schema = new ArrayList<ElementSymbol>(types.length);
        for (int i = 0; i < types.length; ++i) {
            ElementSymbol es = new ElementSymbol("x");
            es.setType(DataTypeManager.getDataTypeClass((String)types[i]));
            schema.add(es);
        }
        TupleBuffer buffer = this.createTupleBuffer(schema, "cached", BufferManager.TupleSourceType.FINAL);
        buffer.setBatchSize(batchSize);
        buffer.setId(state_id);
        int row = 1;
        while ((long)row <= rowCount) {
            List batch = BatchSerializer.readBatch((ObjectInput)in, (String[])types);
            for (int i = 0; i < batch.size(); ++i) {
                buffer.addTuple((List)batch.get(i));
            }
            row += batchSize;
        }
        if (buffer.getRowCount() != rowCount) {
            buffer.remove();
            throw new IOException(QueryPlugin.Util.getString("not_found_cache"));
        }
        buffer.close();
        this.addTupleBuffer(buffer);
    }

    @Override
    public void setAddress(Serializable address) {
    }

    @Override
    public void droppedMembers(Collection<Serializable> addresses) {
    }

    public void setInlineLobs(boolean inlineLobs) {
        this.inlineLobs = inlineLobs;
    }

    public int getMaxReserveKB() {
        return (int)(this.maxReserveBytes >> 10);
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public int getMemoryCacheEntries() {
        return this.memoryEntries.size();
    }

    public long getActiveBatchBytes() {
        return this.activeBatchBytes.get();
    }

    @Override
    public boolean hasState(String stateId) {
        return this.getTupleBuffer(stateId) != null;
    }

    public long getReferenceHits() {
        return this.referenceHit.get();
    }

    @Override
    public void persistLob(Streamable<?> lob, FileStore store, byte[] bytes) throws TeiidComponentException {
        LobManager.persistLob(lob, store, bytes, this.inlineLobs, DataTypeManager.MAX_LOB_MEMORY_BYTES);
    }

    public void invalidCacheGroup(Long gid) {
        this.removeCacheGroup(gid, null);
    }

    @Override
    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    static class TupleReference
    extends WeakReference<TupleBuffer> {
        String id;

        public TupleReference(TupleBuffer referent, ReferenceQueue<? super TupleBuffer> q) {
            super(referent, q);
            this.id = referent.getId();
        }
    }

    private static class BatchSoftReference
    extends SoftReference<CacheEntry> {
        private int sizeEstimate;
        private Long key;

        public BatchSoftReference(CacheEntry referent, ReferenceQueue<? super CacheEntry> q, int sizeEstimate) {
            super(referent, q);
            this.sizeEstimate = sizeEstimate;
            this.key = referent.getId();
        }
    }

    final class BatchManagerImpl
    implements BatchManager,
    Serializer<List<? extends List<?>>> {
        final Long id;
        SizeUtility sizeUtility;
        private WeakReference<BatchManagerImpl> ref = new WeakReference<BatchManagerImpl>(this);
        private PhantomReference<Object> cleanup;
        AtomicBoolean prefersMemory = new AtomicBoolean();
        String[] types;
        private LobManager lobManager;
        private long totalSize;
        private long rowsSampled;

        private BatchManagerImpl(Long newID, Class<?>[] types) {
            this.id = newID;
            this.sizeUtility = new SizeUtility(types);
            this.types = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                this.types[i] = DataTypeManager.getDataTypeName(types[i]);
            }
        }

        @Override
        public Long getId() {
            return this.id;
        }

        public void setLobManager(LobManager lobManager) {
            this.lobManager = lobManager;
        }

        @Override
        public String[] getTypes() {
            return this.types;
        }

        @Override
        public boolean prefersMemory() {
            return this.prefersMemory.get();
        }

        @Override
        public void setPrefersMemory(boolean prefers) {
            this.prefersMemory.set(prefers);
        }

        @Override
        public boolean useSoftCache() {
            return this.prefersMemory.get();
        }

        @Override
        public Reference<? extends BatchManager> getBatchManagerReference() {
            return this.ref;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long createManagedBatch(List<? extends List<?>> batch, Long previous, boolean removeOld) throws TeiidComponentException {
            if (this.cleanup == null) {
                BufferManagerImpl.this.cache.createCacheGroup(this.id);
                this.cleanup = AutoCleanupUtil.setCleanupReference(this, new Remover(this.id, this.prefersMemory));
            }
            CacheEntry old = null;
            int sizeEstimate = 0;
            boolean updateEstimates = true;
            if (previous != null) {
                old = BufferManagerImpl.this.fastGet(previous, this.prefersMemory.get(), true);
                if (removeOld && old != null) {
                    CacheEntry cacheEntry = old;
                    synchronized (cacheEntry) {
                        int oldRowCount = ((List)old.getObject()).size();
                        if (!old.isPersistent() && batch.size() > oldRowCount >> 2 && batch.size() < oldRowCount << 1) {
                            old.setObject(batch);
                            return previous;
                        }
                        this.totalSize -= (long)old.getSizeEstimate();
                        this.rowsSampled -= (long)oldRowCount;
                        updateEstimates = true;
                    }
                    BufferManagerImpl.this.remove(old, this.prefersMemory.get());
                }
            } else {
                updateEstimates = true;
            }
            sizeEstimate = this.getSizeEstimate(batch);
            if (updateEstimates) {
                this.totalSize += (long)sizeEstimate;
                this.rowsSampled += (long)batch.size();
            }
            Long oid = BufferManagerImpl.this.batchAdded.getAndIncrement();
            CacheKey key = new CacheKey(oid, BufferManagerImpl.this.readAttempts.get(), old != null ? old.getKey().getOrderingValue() : 0L);
            CacheEntry ce = new CacheEntry(key, sizeEstimate, batch, this.ref, false);
            if (!BufferManagerImpl.this.cache.addToCacheGroup(this.id, ce.getId())) {
                this.remove();
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID31138, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31138, new Object[]{this.id}));
            }
            BufferManagerImpl.this.overheadBytes.addAndGet(128L);
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Add batch to BufferManager", this.id, ce.getId(), "with size estimate", ce.getSizeEstimate()});
            }
            BufferManagerImpl.this.addMemoryEntry(ce, true);
            return oid;
        }

        @Override
        public List<? extends List<?>> deserialize(ObjectInput ois) throws IOException, ClassNotFoundException {
            List batch = BatchSerializer.readBatch((ObjectInput)ois, (String[])this.types);
            if (this.lobManager != null) {
                for (int i = batch.size() - 1; i >= 0; --i) {
                    try {
                        this.lobManager.updateReferences((List)batch.get(i), LobManager.ReferenceMode.ATTACH);
                        continue;
                    }
                    catch (TeiidComponentException e) {
                        throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30052, (Throwable)e);
                    }
                }
            }
            return batch;
        }

        @Override
        public void serialize(List<? extends List<?>> obj, ObjectOutput oos) throws IOException {
            ResizingArrayList list = null;
            if (obj instanceof ResizingArrayList) {
                list = (ResizingArrayList)obj;
            }
            try {
                BatchSerializer.writeBatch((ObjectOutput)oos, (String[])this.types, obj);
            }
            catch (RuntimeException e) {
                if (ExceptionUtil.getExceptionOfType((Throwable)e, ClassCastException.class) != null) {
                    throw e;
                }
                if (list == null) {
                    throw e;
                }
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)e, (Object)"Possible Concurrent Modification", (Object)this.id);
            }
        }

        public int getSizeEstimate(List<? extends List<?>> obj) {
            return (int)Math.max(1L, this.sizeUtility.getBatchSize(DataTypeManager.isValueCacheEnabled(), obj));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<List<?>> getBatch(Long batch, boolean retain) throws TeiidComponentException {
            CacheEntry ce;
            BufferManagerImpl.this.cleanSoftReferences();
            long reads = BufferManagerImpl.this.readAttempts.incrementAndGet();
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.id, "getting batch", batch, "total reads", reads, "reference hits", BufferManagerImpl.this.referenceHit.get()});
            }
            if ((ce = BufferManagerImpl.this.fastGet(batch, this.prefersMemory.get(), retain)) != null) {
                return (List)(!retain ? ce.nullOut() : ce.getObject());
            }
            Object o = BufferManagerImpl.this.cache.lockForLoad(batch, this);
            try {
                ce = BufferManagerImpl.this.fastGet(batch, this.prefersMemory.get(), retain);
                if (ce != null) {
                    List list = (List)(!retain ? ce.nullOut() : ce.getObject());
                    return list;
                }
                long count = BufferManagerImpl.this.readCount.incrementAndGet();
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.id, "reading batch", batch, "from storage, total reads:", count});
                }
                if ((ce = BufferManagerImpl.this.cache.get(o, batch, this.ref)) == null) {
                    throw new AssertionError((Object)("Batch not found in storage " + batch));
                }
                if (!retain) {
                    BufferManagerImpl.this.removeFromCache(this.id, batch);
                    BufferManagerImpl.this.persistBatchReferences(ce.getSizeEstimate());
                } else {
                    BufferManagerImpl.this.addMemoryEntry(ce, false);
                }
            }
            finally {
                BufferManagerImpl.this.cache.unlockForLoad(o);
            }
            return (List)ce.getObject();
        }

        @Override
        public void remove(Long batch) {
            BufferManagerImpl.this.remove(this.id, batch, this.prefersMemory.get());
        }

        @Override
        public void remove() {
            if (this.cleanup != null) {
                BufferManagerImpl.this.removeCacheGroup(this.id, this.prefersMemory.get());
                AutoCleanupUtil.removeCleanupReference(this.cleanup);
                this.cleanup = null;
            }
        }

        public String toString() {
            return this.id.toString();
        }

        @Override
        public int getRowSizeEstimate() {
            if (this.rowsSampled == 0L) {
                return 0;
            }
            return (int)(this.totalSize / this.rowsSampled);
        }
    }

    private final class Remover
    implements AutoCleanupUtil.Removable {
        private Long id;
        private AtomicBoolean prefersMemory;

        public Remover(Long id, AtomicBoolean prefersMemory) {
            this.id = id;
            this.prefersMemory = prefersMemory;
        }

        @Override
        public void remove() {
            BufferManagerImpl.this.removeCacheGroup(this.id, this.prefersMemory.get());
        }
    }

    private static final class Cleaner
    extends TimerTask {
        WeakReference<BufferManagerImpl> bufferRef;

        public Cleaner(BufferManagerImpl bufferManagerImpl) {
            this.bufferRef = new WeakReference<BufferManagerImpl>(bufferManagerImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                BufferManagerImpl impl;
                if ((impl = (BufferManagerImpl)this.bufferRef.get()) == null) {
                    this.cancel();
                    return;
                }
                AutoCleanupUtil.doCleanup(false);
                impl.cleaning.set(true);
                try {
                    long evicted = impl.doEvictions(impl.maxProcessingBytes, true, impl.initialEvictionQueue);
                    if (evicted != 0L && LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                        LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Asynch eviction run", evicted, impl.reserveBatchBytes.get(), impl.maxReserveBytes, impl.activeBatchBytes.get()});
                    }
                }
                catch (Throwable t) {
                    LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)t, (Object)"Exception during cleaning run");
                }
                Cleaner cleaner = this;
                synchronized (cleaner) {
                    impl.cleaning.set(false);
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
    }
}

