/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */

package org.teiid.query.function.aggregate;

import java.util.Arrays;
import java.util.List;

import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.util.CommandContext;

/**
 * Just a simple COUNT() implementation that counts every non-null row it sees.
 */
public class Count extends AggregateFunction {

    private int count = 0;

    public void reset() {
        count = 0;
    }
    
    @Override
    public void addInputDirect(List<?> tuple, CommandContext commandContext)
    		throws TeiidComponentException, TeiidProcessingException {
    	if (count == Integer.MAX_VALUE) {
    		throw new TeiidProcessingException(QueryPlugin.Event.TEIID31174, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID31174));
    	}
        count++;
    }

    /**
     * @see org.teiid.query.function.aggregate.AggregateFunction#getResult(CommandContext)
     */
    public Object getResult(CommandContext commandContext) {
        return Integer.valueOf(count);
    }
    
    @Override
    public void getState(List<Object> state) {
    	state.add(count);
    }
    
    @Override
    public int setState(List<?> state, int index) {
    	count = (Integer) state.get(index);
    	return index++;
    }
    
    @Override
    public List<? extends Class<?>> getStateTypes() {
    	return Arrays.asList(Integer.class);
    }

}
