/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.vdb.runtime;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.util.HashCodeUtil;

public class VDBKey
implements Serializable,
Comparable<VDBKey> {
    private static final Integer[] EMPTY_PARTS = new Integer[3];
    private static final long serialVersionUID = -7249750823144856081L;
    private String name;
    private String baseName;
    private Integer[] versionParts;
    private int version;
    private int hashCode;
    private boolean fullySpecified = true;
    private boolean atMost;
    public static Pattern NAME_PATTERN = Pattern.compile("([^.]*)\\.v(?:(0|(?:[1-9]\\d{0,8})))(?:\\.(0|(?:[1-9]\\d{0,8})))?(?:\\.(0|(?:[1-9]\\d{0,8})))?(\\.)?$");

    public VDBKey(String name, int version) {
        this.name = name;
        Matcher m = NAME_PATTERN.matcher(name);
        if (!m.matches()) {
            this.baseName = name;
            this.versionParts = EMPTY_PARTS;
            this.fullySpecified = true;
        } else {
            this.baseName = m.group(1);
            this.versionParts = new Integer[3];
            this.getPart(m, 0);
            this.getPart(m, 1);
            this.getPart(m, 2);
            this.atMost = name.endsWith(".");
        }
        this.version = version;
    }

    private void getPart(Matcher m, int part) {
        String val = m.group(part + 2);
        if (val != null) {
            this.versionParts[part] = Integer.parseInt(val);
        } else {
            this.fullySpecified = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = HashCodeUtil.hashCode((int)HashCodeUtil.expHashCode((CharSequence)this.name, (boolean)false), (int)this.version);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VDBKey)) {
            return false;
        }
        VDBKey other = (VDBKey)obj;
        return this.version == other.version && other.name.equalsIgnoreCase(this.name);
    }

    public String toString() {
        if (this.version == 1) {
            return this.name;
        }
        return this.name + " " + this.version;
    }

    @Override
    public int compareTo(VDBKey o) {
        int compare = String.CASE_INSENSITIVE_ORDER.compare(this.baseName, o.baseName);
        if (compare != 0) {
            return compare;
        }
        for (int i = 0; i < this.versionParts.length; ++i) {
            compare = Integer.compare(this.versionParts[i] == null ? 0 : this.versionParts[i], o.versionParts[i] == null ? 0 : o.versionParts[i]);
            if (compare == 0) continue;
            return compare;
        }
        compare = Integer.compare(this.versionParts.length, o.versionParts.length);
        if (compare != 0) {
            return compare;
        }
        compare = Integer.compare(this.version, o.version);
        if (compare != 0) {
            return compare;
        }
        return 0;
    }

    public boolean isSemantic() {
        return this.versionParts != EMPTY_PARTS;
    }

    public boolean isFullySpecified() {
        return this.fullySpecified;
    }

    public boolean isAtMost() {
        return this.atMost;
    }

    public boolean acceptsVerion(VDBKey key) {
        for (int i = 0; i < this.versionParts.length && this.versionParts[i] != null; ++i) {
            if (this.versionParts[i] == (key.versionParts[i] == null ? 0 : key.versionParts[i])) continue;
            return false;
        }
        return this.version <= key.version;
    }
}

