/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class ExceptionExpression
implements Expression,
LanguageObject {
    private Expression message;
    private Expression sqlState;
    private Expression errorCode;
    private Expression parent;

    @Override
    public Class<?> getType() {
        return DataTypeManager.DefaultDataClasses.OBJECT;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExceptionExpression)) {
            return false;
        }
        ExceptionExpression other = (ExceptionExpression)obj;
        return EquivalenceUtil.areEqual((Object)this.message, (Object)other.message) && EquivalenceUtil.areEqual((Object)this.sqlState, (Object)other.sqlState) && EquivalenceUtil.areEqual((Object)this.errorCode, (Object)other.errorCode) && EquivalenceUtil.areEqual((Object)this.parent, (Object)other.parent);
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.message, this.sqlState, this.errorCode});
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    @Override
    public ExceptionExpression clone() {
        ExceptionExpression clone = new ExceptionExpression();
        if (this.message != null) {
            clone.message = (Expression)this.message.clone();
        }
        if (this.sqlState != null) {
            clone.sqlState = (Expression)this.sqlState.clone();
        }
        if (this.errorCode != null) {
            clone.errorCode = (Expression)this.errorCode.clone();
        }
        if (this.parent != null) {
            clone.parent = (Expression)this.parent.clone();
        }
        return clone;
    }

    public Expression getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Expression errCode) {
        this.errorCode = errCode;
    }

    public Expression getSqlState() {
        return this.sqlState;
    }

    public void setSqlState(Expression sqlState) {
        this.sqlState = sqlState;
    }

    public Expression getMessage() {
        return this.message;
    }

    public void setMessage(Expression message) {
        this.message = message;
    }

    public Expression getParent() {
        return this.parent;
    }

    public void setParent(Expression parent) {
        this.parent = parent;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public String getDefaultSQLState() {
        return "50001";
    }
}

