/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.common.buffer.SPage;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;

public class TupleBrowser
implements TupleSource {
    private final STree tree;
    private TupleSource valueSet;
    private SPage page;
    private int index;
    private SPage bound;
    private int boundIndex = -1;
    private List<List<?>> values;
    private boolean updated;
    private boolean direction;
    private boolean inPartial;
    private List<Object> cachedBound;
    private ArrayList<SPage.SearchResult> places = new ArrayList();

    public TupleBrowser(STree sTree, TupleSource valueSet, boolean direction) {
        this.tree = sTree;
        this.direction = direction;
        this.valueSet = valueSet;
    }

    public TupleBrowser(STree sTree, List<Object> lowerBound, List<Object> upperBound, boolean direction) throws TeiidComponentException {
        this.tree = sTree;
        this.direction = direction;
        this.init(lowerBound, upperBound, false);
    }

    private void init(List<Object> lowerBound, List<?> upperBound, boolean isPartialKey) throws TeiidComponentException {
        if (lowerBound != null) {
            lowerBound.addAll(Collections.nCopies(this.tree.getKeyLength() - lowerBound.size(), null));
            this.setPage(lowerBound);
        } else {
            this.page = this.tree.header[0];
        }
        boolean valid = true;
        if (upperBound != null) {
            if (!isPartialKey && lowerBound != null && this.tree.comparator.compare(upperBound, lowerBound) < 0) {
                valid = false;
            }
            this.tree.find(upperBound, this.getPlaces());
            SPage.SearchResult upper = this.places.get(this.places.size() - 1);
            this.bound = upper.page;
            this.boundIndex = upper.index;
            if (this.boundIndex < 0) {
                this.boundIndex = Math.min(upper.values.size(), -this.boundIndex - 1) - 1;
            }
            if (!this.direction) {
                this.values = upper.values;
            }
            if (lowerBound != null && this.page == this.bound) {
                valid = this.index <= this.boundIndex;
            }
        } else {
            while (this.bound == null || this.bound.children != null) {
                this.bound = this.tree.findChildTail(this.bound);
            }
            if (!this.direction) {
                if (this.page != this.bound || this.values == null) {
                    this.values = this.bound.getValues();
                }
                this.boundIndex = this.values.size() - 1;
            }
        }
        if (!this.direction) {
            SPage swap = this.page;
            this.page = this.bound;
            this.bound = swap;
            int upperIndex = this.boundIndex;
            this.boundIndex = this.index;
            this.index = upperIndex;
        }
        if (!valid) {
            this.page = null;
        }
    }

    private boolean setPage(List<?> lowerBound) throws TeiidComponentException {
        this.tree.find(lowerBound, this.getPlaces());
        SPage.SearchResult sr = this.places.get(this.places.size() - 1);
        this.page = sr.page;
        this.index = sr.index;
        boolean result = true;
        if (this.index < 0) {
            result = false;
            this.index = -this.index - 1;
        }
        this.values = sr.values;
        return result;
    }

    private ArrayList<SPage.SearchResult> getPlaces() {
        this.places.clear();
        return this.places;
    }

    @Override
    public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
        while (true) {
            if (!this.inPartial && this.valueSet != null) {
                List<?> newValue = this.valueSet.nextTuple();
                if (newValue == null) {
                    this.resetState();
                    return null;
                }
                if (newValue.size() < this.tree.getKeyLength()) {
                    if (this.cachedBound == null) {
                        this.cachedBound = new ArrayList<Object>(this.tree.getKeyLength());
                    }
                    this.cachedBound.clear();
                    this.cachedBound.addAll(newValue);
                    this.init(this.cachedBound, newValue, true);
                    this.inPartial = true;
                    continue;
                }
                if (this.values != null) {
                    int possibleIndex = Collections.binarySearch(this.values, newValue, this.tree.comparator);
                    if (possibleIndex >= 0) {
                        this.index = possibleIndex;
                        return this.values.get(possibleIndex);
                    }
                    if (this.direction && possibleIndex == -this.values.size() - 1) {
                        if (this.page.next == null) {
                            this.resetState();
                            return null;
                        }
                    } else {
                        if (this.direction || possibleIndex != -1) continue;
                        if (this.page.prev == null) {
                            this.resetState();
                            return null;
                        }
                    }
                }
                this.resetState();
                if (!this.setPage(newValue)) continue;
                return this.values.get(this.index);
            }
            if (this.page == null) {
                if (this.inPartial) {
                    this.inPartial = false;
                    continue;
                }
                return null;
            }
            if (this.values == null) {
                this.values = this.page.getValues();
                this.index = this.direction ? 0 : this.values.size() - 1;
            }
            if (this.index >= 0 && this.index < this.values.size()) {
                List<?> result = this.values.get(this.index);
                if (this.page == this.bound && this.index == this.boundIndex) {
                    this.resetState();
                    this.page = null;
                } else {
                    this.index += this.getOffset();
                }
                return result;
            }
            this.resetState();
            if (this.direction) {
                this.page = this.page.next;
                continue;
            }
            this.page = this.page.prev;
        }
    }

    public void reset(TupleSource ts) throws TeiidComponentException {
        this.valueSet = ts;
        this.resetState();
    }

    private void resetState() throws TeiidComponentException {
        if (this.updated) {
            this.page.setValues(this.values);
        }
        this.updated = false;
        this.values = null;
    }

    private int getOffset() {
        if (!this.inPartial && this.valueSet != null) {
            return 0;
        }
        return this.direction ? 1 : -1;
    }

    public void update(List<?> tuple) throws TeiidComponentException {
        this.values.set(this.index - this.getOffset(), tuple);
        this.updated = true;
    }

    public void removed() throws TeiidComponentException {
        this.index -= this.getOffset();
        if (this.page != null && this.page.managedBatch == null && this.page.values == null) {
            List<?> lowerBound = this.values.get(this.index);
            this.values = null;
            this.setPage(lowerBound);
        }
    }

    @Override
    public void closeSource() {
    }
}

