/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.report.ActivityReport;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.ValidationVisitor;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.TranslatorException;

public class MetadataValidator {
    private Map<String, Datatype> typeMap;
    private QueryParser parser;

    public MetadataValidator(Map<String, Datatype> typeMap, QueryParser parser) {
        this.typeMap = typeMap;
        this.parser = parser;
    }

    public MetadataValidator() {
        this.typeMap = SystemMetadata.getInstance().getRuntimeTypeMap();
        this.parser = QueryParser.getQueryParser();
    }

    public ValidatorReport validate(VDBMetaData vdb, MetadataStore store) {
        ValidatorReport report = new ValidatorReport();
        if (store != null && !store.getSchemaList().isEmpty()) {
            new SourceModelArtifacts().execute(vdb, store, report, this);
            new CrossSchemaResolver().execute(vdb, store, report, this);
            new ResolveQueryPlans().execute(vdb, store, report, this);
            new MinimalMetadata().execute(vdb, store, report, this);
            new MatViewPropertiesValidator().execute(vdb, store, report, this);
        }
        return report;
    }

    public void log(ValidatorReport report, ModelMetaData model, String msg) {
        this.log(report, model, ModelMetaData.Message.Severity.ERROR, msg);
    }

    public void log(ValidatorReport report, ModelMetaData model, ModelMetaData.Message.Severity severity, String msg) {
        model.addRuntimeMessage(severity, msg);
        int messageLevel = 3;
        if (severity == ModelMetaData.Message.Severity.ERROR) {
            report.handleValidationError(msg);
        } else {
            messageLevel = 4;
        }
        LogManager.log((int)messageLevel, (String)"org.teiid.PLANNER.RESOLVER", (Object)msg);
    }

    private void validate(VDBMetaData vdb, ModelMetaData model, AbstractMetadataRecord record, ValidatorReport report, QueryMetadataInterface metadata, MetadataFactory mf) {
        ValidatorReport resolverReport = null;
        try {
            if (record instanceof Procedure) {
                Procedure p = (Procedure)record;
                Command command = this.parser.parseProcedure(p.getQueryPlan(), false);
                QueryResolver.resolveCommand(command, new GroupSymbol(p.getFullName()), 6, metadata, false);
                resolverReport = Validator.validate(command, metadata);
                MetadataValidator.determineDependencies((AbstractMetadataRecord)p, command);
            } else if (record instanceof Table) {
                Table t = (Table)record;
                GroupSymbol symbol = new GroupSymbol(t.getFullName());
                ResolverUtil.resolveGroup(symbol, metadata);
                String selectTransformation = t.getSelectTransformation();
                if (t.isVirtual()) {
                    QueryCommand command = (QueryCommand)QueryParser.getQueryParser().parseCommand(selectTransformation);
                    QueryResolver.resolveCommand(command, metadata);
                    resolverReport = Validator.validate(command, metadata);
                    if (!resolverReport.hasItems() && (t.getColumns() == null || t.getColumns().isEmpty())) {
                        List<Expression> symbols = command.getProjectedSymbols();
                        for (Expression expression : symbols) {
                            try {
                                this.addColumn(Symbol.getShortName(expression), expression.getType(), t, mf);
                            }
                            catch (TranslatorException e) {
                                this.log(report, model, e.getMessage());
                            }
                        }
                    }
                    if (t.getColumns() != null && !t.getColumns().isEmpty()) {
                        MetadataValidator.determineDependencies((AbstractMetadataRecord)t, command);
                        if (t.getInsertPlan() != null && t.isInsertPlanEnabled()) {
                            this.validateUpdatePlan(model, report, metadata, t, t.getInsertPlan(), 2);
                        }
                        if (t.getUpdatePlan() != null && t.isUpdatePlanEnabled()) {
                            this.validateUpdatePlan(model, report, metadata, t, t.getUpdatePlan(), 3);
                        }
                        if (t.getDeletePlan() != null && t.isDeletePlanEnabled()) {
                            this.validateUpdatePlan(model, report, metadata, t, t.getDeletePlan(), 4);
                        }
                    }
                }
                boolean addCacheHint = false;
                if (t.isMaterialized() && t.getMaterializedTable() == null) {
                    List fbis = t.getFunctionBasedIndexes();
                    List<GroupSymbol> groups = Arrays.asList(symbol);
                    if (fbis != null && !fbis.isEmpty()) {
                        for (KeyRecord fbi : fbis) {
                            for (int j = 0; j < fbi.getColumns().size(); ++j) {
                                Column c = (Column)fbi.getColumns().get(j);
                                if (c.getParent() != fbi) continue;
                                String exprString = c.getNameInSource();
                                try {
                                    Expression ex = QueryParser.getQueryParser().parseExpression(exprString);
                                    ResolverVisitor.resolveLanguageObject(ex, groups, metadata);
                                    if (!ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ex).isEmpty()) {
                                        this.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31114, new Object[]{exprString, fbi.getFullName()}));
                                    }
                                    EvaluatableVisitor ev = new EvaluatableVisitor();
                                    PreOrPostOrderNavigator.doVisit(ex, ev, true);
                                    if (ev.getDeterminismLevel().compareTo((Enum)FunctionMethod.Determinism.VDB_DETERMINISTIC) >= 0) continue;
                                    this.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31115, new Object[]{exprString, fbi.getFullName()}));
                                    continue;
                                }
                                catch (QueryResolverException e) {
                                    this.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31116, new Object[]{exprString, fbi.getFullName(), e.getMessage()}));
                                }
                            }
                        }
                    }
                } else {
                    addCacheHint = true;
                }
                QueryNode node = QueryResolver.resolveView(symbol, new QueryNode(selectTransformation), "SELECT", metadata, true);
                CacheHint cacheHint = node.getCommand().getCacheHint();
                Long l = -1L;
                if (cacheHint != null && cacheHint.getTtl() != null && addCacheHint && t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", false) == null) {
                    Long l2 = cacheHint.getTtl();
                    t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", String.valueOf(l2));
                }
            }
            this.processReport(model, record, report, resolverReport);
        }
        catch (TeiidException e) {
            this.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31080, new Object[]{record.getFullName(), e.getMessage()}));
        }
    }

    public static void determineDependencies(AbstractMetadataRecord p, Command command) {
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews(command, true);
        LinkedHashSet<AbstractMetadataRecord> values = new LinkedHashSet<AbstractMetadataRecord>();
        for (GroupSymbol group : groups) {
            Object mid = group.getMetadataID();
            if (mid instanceof TempMetadataAdapter) {
                mid = ((TempMetadataID)mid).getOriginalMetadataID();
            }
            if (!(mid instanceof AbstractMetadataRecord)) continue;
            values.add((AbstractMetadataRecord)mid);
        }
        Collection<ElementSymbol> elems = ElementCollectorVisitor.getElements(command, true, true);
        for (ElementSymbol elem : elems) {
            Object mid = elem.getMetadataID();
            if (mid instanceof TempMetadataAdapter) {
                mid = ((TempMetadataID)mid).getOriginalMetadataID();
            }
            if (!(mid instanceof AbstractMetadataRecord)) continue;
            values.add((AbstractMetadataRecord)mid);
        }
        p.setIncomingObjects(new ArrayList(values));
    }

    private static Table findTableByName(MetadataStore store, String name) {
        Table table = null;
        int index = name.indexOf(46);
        if (index == -1) {
            Schema schema;
            Iterator iterator = store.getSchemaList().iterator();
            while (iterator.hasNext() && (table = (schema = (Schema)iterator.next()).getTable(name)) == null) {
            }
        } else {
            String schemaName = name.substring(0, index);
            Schema schema = store.getSchema(schemaName);
            if (schema != null) {
                table = schema.getTable(name.substring(index + 1));
            }
        }
        return table;
    }

    private void validateUpdatePlan(ModelMetaData model, ValidatorReport report, QueryMetadataInterface metadata, Table t, String plan, int type) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Command command = QueryParser.getQueryParser().parseProcedure(plan, true);
        QueryResolver.resolveCommand(command, new GroupSymbol(t.getFullName()), type, metadata, false);
        ValidatorReport resolverReport = Validator.validate(command, metadata);
        this.processReport(model, (AbstractMetadataRecord)t, report, resolverReport);
    }

    private void processReport(ModelMetaData model, AbstractMetadataRecord record, ValidatorReport report, ValidatorReport resolverReport) {
        if (resolverReport != null && resolverReport.hasItems()) {
            for (ValidatorFailure v : resolverReport.getItems()) {
                this.log(report, model, v.getStatus() == ValidatorFailure.Status.ERROR ? ModelMetaData.Message.Severity.ERROR : ModelMetaData.Message.Severity.WARNING, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31080, new Object[]{record.getFullName(), v.getMessage()}));
            }
        }
    }

    private Column addColumn(String name, Class<?> type, Table table, MetadataFactory mf) throws TranslatorException {
        if (type == null) {
            throw new TranslatorException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31086, new Object[]{name, table.getFullName()}));
        }
        Column column = mf.addColumn(name, DataTypeManager.getDataTypeName(type), (ColumnSet)table);
        column.setUpdatable(table.supportsUpdate());
        return column;
    }

    static class CrossSchemaResolver
    implements MetadataRule {
        CrossSchemaResolver() {
        }

        private boolean keyMatches(List<String> names, KeyRecord record) {
            if (names.size() != record.getColumns().size()) {
                return false;
            }
            TreeSet<String> keyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Column c : record.getColumns()) {
                keyNames.add(c.getName());
            }
            for (int i = 0; i < names.size(); ++i) {
                if (keyNames.contains(names.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (t.isVirtual() && t.isMaterialized() && t.getMaterializedTable() != null) {
                        String matTableName = t.getMaterializedTable().getFullName();
                        int index = matTableName.indexOf(46);
                        if (index == -1) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31088, new Object[]{matTableName, t.getFullName()}));
                        } else {
                            String schemaName = matTableName.substring(0, index);
                            Schema matSchema = store.getSchema(schemaName);
                            if (matSchema == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31089, new Object[]{schemaName, matTableName, t.getFullName()}));
                            } else {
                                Table matTable = matSchema.getTable(matTableName.substring(index + 1));
                                if (matTable == null) {
                                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31090, new Object[]{matTableName.substring(index + 1), schemaName, t.getFullName()}));
                                } else {
                                    t.setMaterializedTable(matTable);
                                }
                            }
                        }
                        String stageTable = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATERIALIZED_STAGE_TABLE", false);
                        if (stageTable != null) {
                            Table materializedStageTable = MetadataValidator.findTableByName(store, stageTable);
                            if (materializedStageTable == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31192, new Object[]{t.getFullName(), "{http://www.teiid.org/ext/relational/2012}MATERIALIZED_STAGE_TABLE", stageTable}));
                            } else {
                                t.setMaterializedStageTable(materializedStageTable);
                            }
                        }
                    }
                    for (KeyRecord record : t.getAllKeys()) {
                        if (record.getColumns() != null && !record.getColumns().isEmpty()) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31149, new Object[]{t.getFullName(), record.getName()}));
                    }
                    List fks = t.getForeignKeys();
                    if (fks == null || fks.isEmpty()) continue;
                    for (ForeignKey fk : fks) {
                        String referenceTableName = fk.getReferenceTableName();
                        Table referenceTable = null;
                        if (fk.getReferenceKey() == null) {
                            if (referenceTableName == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31091, new Object[]{t.getFullName()}));
                                continue;
                            }
                            referenceTable = schema.getTable(referenceTableName);
                        } else {
                            referenceTableName = ((Table)fk.getReferenceKey().getParent()).getFullName();
                        }
                        String referenceSchemaName = schema.getName();
                        int index = referenceTableName.indexOf(46);
                        if (referenceTable == null) {
                            if (index != -1) {
                                referenceSchemaName = referenceTableName.substring(0, index);
                                Schema referenceSchema = store.getSchema(referenceSchemaName);
                                if (referenceSchema == null) {
                                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31093, new Object[]{referenceSchemaName, t.getFullName()}));
                                    continue;
                                }
                                referenceTable = referenceSchema.getTable(referenceTableName.substring(index + 1));
                            }
                            if (referenceTable == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31092, new Object[]{t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName}));
                                continue;
                            }
                        }
                        KeyRecord uniqueKey = null;
                        ArrayList<String> referenceColumns = fk.getReferenceColumns();
                        if (fk.getReferenceKey() != null) {
                            List cols = fk.getReferenceKey().getColumns();
                            referenceColumns = new ArrayList<String>();
                            for (Column col : cols) {
                                referenceColumns.add(col.getName());
                            }
                        }
                        if (referenceColumns == null || referenceColumns.isEmpty()) {
                            if (referenceTable.getPrimaryKey() == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31094, new Object[]{t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName}));
                            } else {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                        } else {
                            for (KeyRecord record : referenceTable.getUniqueKeys()) {
                                if (!this.keyMatches(referenceColumns, record)) continue;
                                uniqueKey = record;
                                break;
                            }
                            if (uniqueKey == null && referenceTable.getPrimaryKey() != null && this.keyMatches(referenceColumns, referenceTable.getPrimaryKey())) {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                        }
                        if (uniqueKey == null) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31095, new Object[]{t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName, referenceColumns}));
                            continue;
                        }
                        fk.setReferenceKey(uniqueKey);
                    }
                }
            }
        }
    }

    static class MatViewPropertiesValidator
    implements MetadataRule {
        MatViewPropertiesValidator() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    String manage;
                    if (!t.isVirtual() || !t.isMaterialized() || t.getMaterializedTable() == null) continue;
                    Table matTable = t.getMaterializedTable();
                    Table stageTable = t.getMaterializedStageTable();
                    String beforeScript = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_BEFORE_LOAD_SCRIPT", false);
                    String afterScript = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_AFTER_LOAD_SCRIPT", false);
                    if (beforeScript == null || afterScript == null) {
                        metadataValidator.log(report, model, ModelMetaData.Message.Severity.WARNING, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31155, new Object[]{t.getFullName()}));
                    }
                    this.verifyTableColumns(model, report, metadataValidator, t, matTable);
                    if (stageTable != null) {
                        this.verifyTableColumns(model, report, metadataValidator, t, stageTable);
                    }
                    String status = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE", false);
                    String loadScript = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_LOAD_SCRIPT", false);
                    if (status == null || stageTable == null && loadScript == null) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31154, new Object[]{t.getFullName()}));
                        continue;
                    }
                    Table statusTable = MetadataValidator.findTableByName(store, status);
                    if (statusTable == null) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31197, new Object[]{t.getFullName(), status}));
                        continue;
                    }
                    TreeMap<String, Class> statusTypeMap = new TreeMap<String, Class>(String.CASE_INSENSITIVE_ORDER);
                    statusTypeMap.put("VDBNAME", DataTypeManager.DefaultDataClasses.STRING);
                    statusTypeMap.put("VDBVERSION", DataTypeManager.DefaultDataClasses.STRING);
                    statusTypeMap.put("SCHEMANAME", DataTypeManager.DefaultDataClasses.STRING);
                    statusTypeMap.put("NAME", DataTypeManager.DefaultDataClasses.STRING);
                    statusTypeMap.put("TARGETSCHEMANAME", DataTypeManager.DefaultDataClasses.STRING);
                    statusTypeMap.put("TARGETNAME", DataTypeManager.DefaultDataClasses.STRING);
                    statusTypeMap.put("VALID", DataTypeManager.DefaultDataClasses.BOOLEAN);
                    statusTypeMap.put("LOADSTATE", DataTypeManager.DefaultDataClasses.STRING);
                    statusTypeMap.put("CARDINALITY", DataTypeManager.DefaultDataClasses.LONG);
                    statusTypeMap.put("UPDATED", DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    statusTypeMap.put("LOADNUMBER", DataTypeManager.DefaultDataClasses.LONG);
                    List statusColumns = statusTable.getColumns();
                    for (int i = 0; i < statusColumns.size(); ++i) {
                        Class type;
                        String name = ((Column)statusColumns.get(i)).getName();
                        Class expectedType = (Class)statusTypeMap.remove(name);
                        if (expectedType == null || (type = ((Column)statusColumns.get(i)).getJavaType()) == expectedType) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31195, new Object[]{t.getName(), statusTable.getFullName(), name, type, expectedType}));
                    }
                    if (!statusTypeMap.isEmpty()) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31196, new Object[]{t.getName(), statusTable.getFullName(), statusTypeMap.keySet()}));
                    }
                    if (Boolean.valueOf(manage = t.getProperty("{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", false)).booleanValue()) {
                        this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}ON_VDB_START_SCRIPT", false), "ON_VDB_START_SCRIPT");
                        this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}ON_VDB_DROP_SCRIPT", false), "ON_VDB_DROP_SCRIPT");
                    }
                    this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_BEFORE_LOAD_SCRIPT", false), "MATVIEW_BEFORE_LOAD_SCRIPT");
                    this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_LOAD_SCRIPT", false), "MATVIEW_LOAD_SCRIPT");
                    this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_AFTER_LOAD_SCRIPT", false), "MATVIEW_AFTER_LOAD_SCRIPT");
                }
            }
        }

        private void loadScriptsValidation(VDBMetaData vdb, ValidatorReport report, MetadataValidator metadataValidator, ModelMetaData model, Table matView, String script, String option) {
            if (script == null) {
                return;
            }
            QueryMetadataInterface metadata = (QueryMetadataInterface)vdb.getAttachment(QueryMetadataInterface.class);
            QueryParser queryParser = QueryParser.getQueryParser();
            try {
                Command command = queryParser.parseCommand(script);
                if (command instanceof CreateProcedureCommand) {
                    ((CreateProcedureCommand)command).setResultSetColumns(Collections.EMPTY_LIST);
                }
                QueryResolver.resolveCommand(command, metadata);
                ValidationVisitor visitor = new ValidationVisitor();
                ValidatorReport subReport = Validator.validate(command, metadata, visitor);
                metadataValidator.processReport(model, (AbstractMetadataRecord)matView, report, subReport);
            }
            catch (QueryParserException | QueryResolverException | TeiidComponentException e) {
                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31198, new Object[]{matView.getFullName(), option, script, e}));
            }
        }

        private void verifyTableColumns(ModelMetaData model, ValidatorReport report, MetadataValidator metadataValidator, Table view, Table table) {
            List matViewColumns = view.getColumns();
            for (int i = 0; i < matViewColumns.size(); ++i) {
                Column matViewColumn = (Column)matViewColumns.get(i);
                Column tableColumn = table.getColumnByName(matViewColumn.getName());
                if (tableColumn == null) {
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31193, new Object[]{matViewColumn.getName(), table.getFullName(), view.getFullName()}));
                    continue;
                }
                if (matViewColumn.getDatatypeUUID().equals(tableColumn.getDatatypeUUID())) continue;
                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31194, new Object[]{tableColumn.getName(), table.getFullName(), matViewColumn.getName(), view.getFullName()}));
            }
        }
    }

    static class ResolveQueryPlans
    implements MetadataRule {
        ResolveQueryPlans() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            QueryMetadataInterface metadata = (QueryMetadataInterface)vdb.getAttachment(QueryMetadataInterface.class);
            metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                MetadataFactory mf = new MetadataFactory(vdb.getName(), vdb.getVersion(), metadataValidator.typeMap, model){

                    protected void setUUID(AbstractMetadataRecord record) {
                        if (this.count >= 0) {
                            this.count = Integer.MIN_VALUE;
                        }
                        super.setUUID(record);
                    }
                };
                mf.setBuiltinDataTypes((Map)store.getDatatypes());
                for (AbstractMetadataRecord record : schema.getResolvingOrder()) {
                    Procedure p;
                    if (record instanceof Table) {
                        Table t = (Table)record;
                        if (t.getTableType() == Table.Type.Document || t.getTableType() == Table.Type.XmlMappingClass || t.getTableType() == Table.Type.XmlStagingTable || !t.isVirtual() || t.getTableType() == Table.Type.TemporaryTable) continue;
                        if (t.getSelectTransformation() == null) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31079, new Object[]{t.getFullName(), model.getName()}));
                            continue;
                        }
                        metadataValidator.validate(vdb, model, (AbstractMetadataRecord)t, report, metadata, mf);
                        continue;
                    }
                    if (!(record instanceof Procedure) || !(p = (Procedure)record).isVirtual()) continue;
                    if (p.getQueryPlan() == null) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31081, new Object[]{p.getFullName(), model.getName()}));
                        continue;
                    }
                    metadataValidator.validate(vdb, model, (AbstractMetadataRecord)p, report, metadata, mf);
                }
            }
        }
    }

    static class SourceModelArtifacts
    implements MetadataRule {
        SourceModelArtifacts() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (!t.isPhysical() || model.isSource()) continue;
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31075, new Object[]{t.getFullName(), model.getName()}));
                }
                HashSet<String> names = new HashSet<String>();
                for (Procedure p : schema.getProcedures().values()) {
                    boolean hasReturn = false;
                    names.clear();
                    for (int i = 0; i < p.getParameters().size(); ++i) {
                        ProcedureParameter param = (ProcedureParameter)p.getParameters().get(i);
                        if (param.isVarArg() && param != p.getParameters().get(p.getParameters().size() - 1)) {
                            for (int j = i + 1; j < p.getParameters().size(); ++j) {
                                ProcedureParameter param1 = (ProcedureParameter)p.getParameters().get(j);
                                if (param1.getType() != ProcedureParameter.Type.In && param1.getType() != ProcedureParameter.Type.InOut || !param1.isVarArg() && (param1.getNullType() == BaseColumn.NullType.Nullable || param1.getDefaultValue() != null)) continue;
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31112, new Object[]{p.getFullName()}));
                            }
                        }
                        if (param.getType() == ProcedureParameter.Type.ReturnValue) {
                            if (hasReturn) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31107, new Object[]{p.getFullName()}));
                            }
                            hasReturn = true;
                        } else if (p.isFunction() && param.getType() != ProcedureParameter.Type.In) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31165, new Object[]{p.getFullName(), param.getFullName()}));
                        }
                        if (names.add(param.getName())) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31106, new Object[]{p.getFullName(), param.getFullName()}));
                    }
                    if (!p.isVirtual() && !model.isSource()) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31077, new Object[]{p.getFullName(), model.getName()}));
                    }
                    if (!p.isFunction()) continue;
                    if (!hasReturn) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31166, new Object[]{p.getFullName()}));
                    }
                    if (!p.isVirtual() || p.getQueryPlan() != null) continue;
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31167, new Object[]{p.getFullName()}));
                }
                for (FunctionMethod func : schema.getFunctions().values()) {
                    for (FunctionParameter param : func.getInputParameters()) {
                        if (!param.isVarArg() || param == func.getInputParameters().get(func.getInputParameterCount() - 1)) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31112, new Object[]{func.getFullName()}));
                    }
                    if (!func.getPushdown().equals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN) || model.isSource()) continue;
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31078, new Object[]{func.getFullName(), model.getName()}));
                }
            }
        }
    }

    static class MinimalMetadata
    implements MetadataRule {
        MinimalMetadata() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                if (schema.getTables().isEmpty() && schema.getProcedures().isEmpty() && schema.getFunctions().isEmpty()) {
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31070, new Object[]{model.getName()}));
                }
                for (Table t : schema.getTables().values()) {
                    if (t.getColumns() == null || t.getColumns().size() == 0) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31071, new Object[]{t.getFullName()}));
                    }
                    TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    this.validateConstraintNames(metadataValidator, report, model, t.getAllKeys(), names);
                    this.validateConstraintNames(metadataValidator, report, model, t.getFunctionBasedIndexes(), names);
                }
                if (schema.getFunctions().isEmpty()) continue;
                ActivityReport funcReport = new ActivityReport("Translator metadata load " + model.getName());
                FunctionMetadataValidator.validateFunctionMethods(schema.getFunctions().values(), report);
                if (!report.hasItems()) continue;
                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31073, new Object[]{funcReport}));
            }
        }

        private void validateConstraintNames(MetadataValidator metadataValidator, ValidatorReport report, ModelMetaData model, Collection<KeyRecord> keys, Set<String> names) {
            for (KeyRecord record : keys) {
                if (record.getName() == null || names.add(record.getName())) continue;
                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31152, new Object[]{record.getFullName()}));
            }
        }
    }

    static interface MetadataRule {
        public void execute(VDBMetaData var1, MetadataStore var2, ValidatorReport var3, MetadataValidator var4);
    }
}

