/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.teiid.query.report.ReportItem;
import org.teiid.query.sql.LanguageObject;

public class ValidatorFailure
extends ReportItem {
    public static final String VALIDATOR_FAILURE = "ValidatorFailure";
    private transient Collection<LanguageObject> invalidObjects;
    private Status status = Status.ERROR;

    public ValidatorFailure(String description) {
        super(VALIDATOR_FAILURE);
        this.setMessage(description);
        this.invalidObjects = Collections.emptyList();
    }

    public ValidatorFailure(String description, LanguageObject object) {
        super(VALIDATOR_FAILURE);
        this.setMessage(description);
        this.invalidObjects = new ArrayList<LanguageObject>(1);
        this.invalidObjects.add(object);
    }

    public ValidatorFailure(String description, Collection<? extends LanguageObject> objects) {
        super(VALIDATOR_FAILURE);
        this.setMessage(description);
        this.invalidObjects = new ArrayList<LanguageObject>(objects);
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getInvalidObjectCount() {
        if (this.invalidObjects == null) {
            return 0;
        }
        return this.invalidObjects.size();
    }

    public Collection<LanguageObject> getInvalidObjects() {
        return this.invalidObjects;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public static enum Status {
        ERROR,
        WARNING;

    }
}

