/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.teiid.language.SortSpecification;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class OrderByItem
implements LanguageObject {
    private static final long serialVersionUID = 6937561370697819126L;
    private Integer expressionPosition;
    private boolean ascending = true;
    private Expression symbol;
    private SortSpecification.NullOrdering nullOrdering;

    public OrderByItem(Expression symbol, boolean ascending) {
        this.setSymbol(symbol);
        this.ascending = ascending;
    }

    public int getExpressionPosition() {
        return this.expressionPosition == null ? -1 : this.expressionPosition;
    }

    public void setExpressionPosition(int expressionPosition) {
        this.expressionPosition = expressionPosition;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public Expression getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Expression symbol) {
        if (symbol != null && !(symbol instanceof Symbol) && !(symbol instanceof Constant)) {
            symbol = new ExpressionSymbol("expr", symbol);
        }
        this.symbol = symbol;
    }

    public SortSpecification.NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    public void setNullOrdering(SortSpecification.NullOrdering nullOrdering) {
        this.nullOrdering = nullOrdering;
    }

    public boolean isUnrelated() {
        return this.getExpressionPosition() == -1;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public OrderByItem clone() {
        OrderByItem clone = new OrderByItem((Expression)this.symbol.clone(), this.ascending);
        clone.expressionPosition = this.expressionPosition;
        clone.nullOrdering = this.nullOrdering;
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderByItem)) {
            return false;
        }
        OrderByItem o = (OrderByItem)obj;
        return o.symbol.equals(this.symbol) && o.ascending == this.ascending && o.nullOrdering == this.nullOrdering;
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

