/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Collections;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.DependentCriteriaProcessor;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;

public class DependentAccessNode
extends AccessNode {
    private int maxSetSize;
    private int maxPredicates;
    private boolean pushdown;
    private DependentCriteriaProcessor criteriaProcessor;
    private Criteria dependentCrit;
    private boolean sort = true;
    private Command rewrittenCommand;
    private boolean useBindings;
    private boolean complexQuery;

    public DependentAccessNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        if (this.criteriaProcessor != null) {
            this.criteriaProcessor.close();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.criteriaProcessor = null;
        this.dependentCrit = null;
        this.sort = true;
        this.rewrittenCommand = null;
    }

    @Override
    protected Command nextCommand() throws TeiidProcessingException, TeiidComponentException {
        if (this.rewrittenCommand == null) {
            Command atomicCommand = super.nextCommand();
            try {
                DependentAccessNode.rewriteAndEvaluate(atomicCommand, this.getEvaluator(Collections.emptyMap()), this.getContext(), this.getContext().getMetadata());
            }
            catch (BlockedException e) {
                if (this.sort && ((Query)atomicCommand).getOrderBy() != null) {
                    this.declineSort();
                }
                throw e;
            }
            this.rewrittenCommand = atomicCommand;
            this.nextCommand = null;
        }
        if (this.nextCommand == null && this.rewrittenCommand != null) {
            this.nextCommand = (Command)this.rewrittenCommand.clone();
        }
        return super.nextCommand();
    }

    @Override
    public Object clone() {
        DependentAccessNode clonedNode = new DependentAccessNode(super.getID());
        clonedNode.maxSetSize = this.maxSetSize;
        clonedNode.maxPredicates = this.maxPredicates;
        clonedNode.pushdown = this.pushdown;
        clonedNode.useBindings = this.useBindings;
        clonedNode.complexQuery = this.complexQuery;
        super.copyTo(clonedNode);
        return clonedNode;
    }

    public int getMaxSetSize() {
        return this.maxSetSize;
    }

    public int getMaxPredicates() {
        return this.maxPredicates;
    }

    public void setMaxPredicates(int maxPredicates) {
        this.maxPredicates = maxPredicates;
    }

    public void setMaxSetSize(int maxSize) {
        this.maxSetSize = maxSize;
    }

    @Override
    protected boolean prepareNextCommand(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        Assertion.assertTrue((boolean)(atomicCommand instanceof Query));
        Query query = (Query)atomicCommand;
        if (this.criteriaProcessor == null) {
            this.criteriaProcessor = new DependentCriteriaProcessor(this.maxSetSize, this.maxPredicates, this, query.getCriteria());
            this.criteriaProcessor.setPushdown(this.pushdown);
            this.criteriaProcessor.setUseBindings(this.useBindings);
            this.criteriaProcessor.setComplexQuery(this.complexQuery);
        }
        if (this.dependentCrit == null) {
            this.dependentCrit = this.criteriaProcessor.prepareCriteria();
        }
        query.setCriteria(this.dependentCrit);
        if (this.sort && query.getOrderBy() != null && this.criteriaProcessor.hasNextCommand()) {
            this.declineSort();
        }
        if (!this.sort) {
            query.setOrderBy(null);
        }
        boolean result = RelationalNodeUtil.shouldExecute(atomicCommand, true);
        this.dependentCrit = null;
        this.criteriaProcessor.consumedCriteria();
        return result;
    }

    private void declineSort() {
        JoinNode joinNode;
        RelationalNode parent;
        RelationalNode child = this;
        for (parent = this.getParent(); parent != null && !(parent instanceof JoinNode); parent = parent.getParent()) {
            child = parent;
        }
        if (parent != null && (joinNode = (JoinNode)parent).getJoinStrategy() instanceof MergeJoinStrategy) {
            MergeJoinStrategy mjs = (MergeJoinStrategy)joinNode.getJoinStrategy();
            if (joinNode.getChildren()[0] == child) {
                mjs.setProcessingSortLeft(true);
            } else {
                mjs.setProcessingSortRight(true);
            }
        }
        this.sort = false;
    }

    @Override
    protected boolean hasNextCommand() {
        return this.criteriaProcessor.hasNextCommand();
    }

    public void setPushdown(boolean pushdown) {
        this.pushdown = pushdown;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        Boolean required = super.requiresTransaction(transactionalReads);
        if (required != null) {
            return required;
        }
        if (transactionalReads || !(this.getCommand() instanceof QueryCommand)) {
            return true;
        }
        return null;
    }

    public boolean isUseBindings() {
        return this.useBindings;
    }

    public void setUseBindings(boolean useBindings) {
        this.useBindings = useBindings;
    }

    public void setComplexQuery(boolean complexQuery) {
        this.complexQuery = complexQuery;
    }
}

