/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Array
implements Expression {
    private Class<?> type;
    private List<Expression> expressions;
    private boolean implicit;

    public Array(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public Array(Class<?> baseType, List<Expression> expresssions) {
        this.setComponentType(baseType);
        this.expressions = expresssions;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        if (type != null) {
            Assertion.assertTrue((boolean)type.isArray());
        }
        this.type = type;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Array clone() {
        Array clone = new Array(LanguageObject.Util.deepClone(this.getExpressions(), Expression.class));
        clone.type = this.type;
        clone.implicit = this.implicit;
        return clone;
    }

    public Class<?> getComponentType() {
        if (this.type != null) {
            return this.type.getComponentType();
        }
        return null;
    }

    public void setComponentType(Class<?> baseType) {
        this.type = baseType != null ? DataTypeManager.getArrayType(baseType) : null;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public int hashCode() {
        return HashCodeUtil.expHashCode((int)0, this.getExpressions());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Array)) {
            return false;
        }
        Array other = (Array)obj;
        return EquivalenceUtil.areEqual(this.type, other.type) && EquivalenceUtil.areEqual(this.expressions, other.expressions);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }
}

