/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.client.ResizingArrayList;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.LightWeightCopyOnWriteList;
import org.teiid.common.buffer.STree;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.QueryPlugin;

class SPage
implements Cloneable {
    static final Map<Long, PhantomReference<Object>> REFERENCES = new ConcurrentHashMap<Long, PhantomReference<Object>>();
    private static ReferenceQueue<Object> QUEUE = new ReferenceQueue();
    private static AtomicLong counter = new AtomicLong();
    STree stree;
    private long id;
    protected SPage next;
    protected SPage prev;
    protected Long managedBatch;
    protected Object trackingObject;
    protected List<List<?>> values;
    protected List<SPage> children;

    SPage(STree stree, boolean leaf) {
        this.stree = stree;
        this.id = counter.getAndIncrement();
        stree.pages.put(this.id, this);
        this.values = new ResizingArrayList();
        if (!leaf) {
            this.children = new ResizingArrayList();
        }
    }

    public SPage clone(STree tree) {
        try {
            if (this.managedBatch != null && this.trackingObject == null) {
                this.trackingObject = new Object();
                CleanupReference managedBatchReference = new CleanupReference(this.trackingObject, this.managedBatch, this.stree.getBatchManager(this.children == null).getBatchManagerReference());
                REFERENCES.put(this.managedBatch, managedBatchReference);
            }
            SPage clone = (SPage)super.clone();
            clone.stree = tree;
            if (this.children != null) {
                clone.children = new ResizingArrayList(this.children);
            }
            if (this.values != null) {
                clone.values = new ResizingArrayList(this.values);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30038, (Throwable)e);
        }
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SearchResult search(SPage page, List k, List<SearchResult> parent) throws TeiidComponentException {
        List<List<?>> previousValues = null;
        while (true) {
            int flippedIndex;
            int index;
            List<List<?>> values;
            block12: {
                values = page.getValues();
                index = Collections.binarySearch(values, k, page.stree.comparator);
                flippedIndex = -index - 1;
                if (previousValues != null) {
                    if (flippedIndex == 0) {
                        return new SearchResult(-previousValues.size() - 1, page.prev, previousValues);
                    }
                    if (parent != null && index != 0) {
                        page.stree.updateLock.lock();
                        try {
                            index = Collections.binarySearch(values, k, page.stree.comparator);
                            if (index == 0) break block12;
                            SPage childPage = page;
                            List oldKey = null;
                            List newKey = page.stree.extractKey(values.get(0));
                            ListIterator<SearchResult> desc = parent.listIterator();
                            while (desc.hasPrevious()) {
                                SearchResult sr = desc.previous();
                                int parentIndex = Math.max(0, -sr.index - 2);
                                if (oldKey == null) {
                                    oldKey = sr.values.set(parentIndex, newKey);
                                } else {
                                    if (page.stree.comparator.compare(oldKey, sr.values.get(parentIndex)) != 0) break;
                                    sr.values.set(parentIndex, newKey);
                                }
                                sr.page.children.set(parentIndex, childPage);
                                sr.page.setValues(sr.values);
                                childPage = sr.page;
                            }
                        }
                        finally {
                            page.stree.updateLock.unlock();
                        }
                    }
                }
            }
            if (flippedIndex != values.size() || page.next == null) {
                return new SearchResult(index, page, values);
            }
            previousValues = values;
            page = page.next;
        }
    }

    protected void setValues(List<List<?>> values) throws TeiidComponentException {
        if (values instanceof LightWeightCopyOnWriteList) {
            values = ((LightWeightCopyOnWriteList)values).getList();
        }
        if (values.size() < this.stree.minPageSize || this.stree.getRowCount() < (long)this.stree.minStorageSize) {
            this.setDirectValues(values);
            return;
        }
        if (this.stree.batchInsert && this.children == null && values.size() < this.stree.leafSize) {
            this.setDirectValues(values);
            this.stree.incompleteInsert = this;
            return;
        }
        this.values = null;
        this.managedBatch = this.stree.getBatchManager(this.children == null).createManagedBatch(values, this.managedBatch, this.trackingObject == null);
        this.trackingObject = null;
    }

    private void setDirectValues(List<List<?>> values) {
        if (this.managedBatch != null && this.trackingObject == null) {
            this.stree.getBatchManager(this.children == null).remove(this.managedBatch);
            this.managedBatch = null;
            this.trackingObject = null;
        }
        this.values = values;
    }

    protected void remove(boolean force) {
        if (this.managedBatch != null) {
            if (force || this.trackingObject == null) {
                this.stree.getBatchManager(this.children == null).remove(this.managedBatch);
            }
            this.managedBatch = null;
            this.trackingObject = null;
        }
        this.values = null;
        this.children = null;
    }

    protected List<List<?>> getValues() throws TeiidComponentException {
        CleanupReference ref;
        if (this.values != null) {
            return this.values;
        }
        if (this.managedBatch == null) {
            throw new AssertionError((Object)"Batch removed");
        }
        for (int i = 0; i < 10 && (ref = (CleanupReference)QUEUE.poll()) != null; ++i) {
            if (REFERENCES.remove(ref.batch) == null) continue;
            ref.cleanup();
        }
        List<List<?>> result = this.stree.getBatchManager(this.children == null).getBatch(this.managedBatch, true);
        if (this.trackingObject != null) {
            return new LightWeightCopyOnWriteList(result);
        }
        return result;
    }

    static void merge(LinkedList<SearchResult> places, List<List<?>> nextValues, SPage current, List<List<?>> currentValues) throws TeiidComponentException {
        SearchResult parent = places.peekLast();
        if (parent != null) {
            SPage.correctParents(parent.page, nextValues.get(0), current.next, current);
        }
        currentValues.addAll(nextValues);
        if (current.children != null) {
            current.children.addAll(current.next.children);
        }
        current.next.remove(false);
        current.next = current.next.next;
        if (current.next != null) {
            current.next.prev = current;
        }
        current.setValues(currentValues);
    }

    static void correctParents(SPage parent, List key, SPage page, SPage nextPage) throws TeiidComponentException {
        SearchResult location = SPage.search(parent, key, null);
        while (location.index == -1 && location.page.prev != null) {
            parent = location.page.prev;
            location = SPage.search(parent, key, null);
        }
        parent = location.page;
        int index = location.index;
        if (index < 0) {
            index = -index - 1;
        }
        while (parent != null) {
            while (index < parent.children.size()) {
                if (parent.children.get(index) != page) {
                    return;
                }
                parent.children.set(index++, nextPage);
            }
            index = 0;
            parent = parent.next;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        try {
            List<List<?>> tb = this.getValues();
            result.append(this.id);
            if (this.children == null) {
                if (tb.size() <= 1) {
                    result.append(tb);
                } else {
                    result.append("[").append(tb.get(0)).append(" . ").append(tb.size()).append(" . ").append(tb.get(tb.size() - 1)).append("]");
                }
            } else {
                result.append("[");
                for (int i = 0; i < this.children.size(); ++i) {
                    result.append(tb.get(i)).append("->").append(this.children.get(i).getId());
                    if (i >= this.children.size() - 1) continue;
                    result.append(", ");
                }
                result.append("]");
            }
        }
        catch (Throwable e) {
            result.append("Removed");
        }
        return result.toString();
    }

    static class CleanupReference
    extends PhantomReference<Object> {
        private Long batch;
        private Reference<? extends BatchManager> ref;

        public CleanupReference(Object referent, Long batch, Reference<? extends BatchManager> ref) {
            super(referent, QUEUE);
            this.batch = batch;
            this.ref = ref;
        }

        public void cleanup() {
            try {
                BatchManager batchManager = this.ref.get();
                if (batchManager != null) {
                    batchManager.remove(this.batch);
                }
            }
            finally {
                this.clear();
            }
        }
    }

    static class SearchResult {
        int index;
        SPage page;
        List<List<?>> values;

        public SearchResult(int index, SPage page, List<List<?>> values) {
            this.index = index;
            this.page = page;
            this.values = values;
        }
    }
}

