/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.client.plan.Annotation;
import org.teiid.common.buffer.LobManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.internal.process.Request;
import org.teiid.metadata.Procedure;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.BasicQueryMetadata;
import org.teiid.query.metadata.MaterializationMetadataRepository;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.TriggerActionPlanner;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.PartitionAnalyzer;
import org.teiid.query.optimizer.relational.PlanHints;
import org.teiid.query.optimizer.relational.PlanToProcessConverter;
import org.teiid.query.optimizer.relational.RowBasedSecurityHelper;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleApplySecurity;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.optimizer.relational.rules.RuleChooseDependent;
import org.teiid.query.optimizer.relational.rules.RuleCollapseSource;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RuleMergeCriteria;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.PlanExecutionNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FilteredCommand;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.query.validator.ValidationVisitor;

public class RelationalPlanner {
    public static final String MAT_PREFIX = "#MAT_";
    private AnalysisRecord analysisRecord;
    private Command parentCommand;
    private IDGenerator idGenerator;
    CommandContext context;
    CapabilitiesFinder capFinder;
    QueryMetadataInterface metadata;
    private PlanHints hints = new PlanHints();
    private Option option;
    private SourceHint sourceHint;
    private WithPlanningState withPlanningState;
    private Set<GroupSymbol> withGroups;
    private boolean processWith = true;
    private static final Comparator<GroupSymbol> nonCorrelatedComparator = new Comparator<GroupSymbol>(){

        @Override
        public int compare(GroupSymbol arg0, GroupSymbol arg1) {
            return arg0.getNonCorrelationName().compareTo(arg1.getNonCorrelationName());
        }
    };
    private static ThreadLocal<HashSet<PlanningStackEntry>> planningStack = new ThreadLocal<HashSet<PlanningStackEntry>>(){

        @Override
        protected HashSet<PlanningStackEntry> initialValue() {
            return new LinkedHashSet<PlanningStackEntry>();
        }
    };

    public RelationalPlan optimize(Command command) throws QueryPlannerException, QueryMetadataException, TeiidComponentException, QueryResolverException {
        PlanNode plan;
        boolean debug = this.analysisRecord.recordDebug();
        if (debug) {
            this.analysisRecord.println("\n----------------------------------------------------------------------------");
            this.analysisRecord.println("GENERATE CANONICAL: \n" + command);
        }
        SourceHint previous = this.sourceHint;
        this.sourceHint = SourceHint.combine(previous, command.getSourceHint());
        PlanToProcessConverter planToProcessConverter = new PlanToProcessConverter(this.metadata, this.idGenerator, this.analysisRecord, this.capFinder, this.context);
        WithPlanningState saved = this.withPlanningState;
        this.withPlanningState = new WithPlanningState();
        Command original = (Command)command.clone();
        try {
            plan = this.generatePlan(command);
        }
        catch (TeiidProcessingException e) {
            throw new QueryPlannerException(e);
        }
        this.planWith(plan, command);
        if (plan.getType() == 64) {
            return (RelationalPlan)plan.getProperty(NodeConstants.Info.PROCESSOR_PLAN);
        }
        if (debug) {
            this.analysisRecord.println("\nCANONICAL PLAN: \n" + plan);
        }
        this.connectSubqueryContainers(plan, this.withPlanningState.pushdownWith);
        ArrayList<Expression> topCols = LanguageObject.Util.deepClone(command.getProjectedSymbols(), Expression.class);
        RuleStack rules = this.buildRules();
        plan = this.executeRules(rules, plan);
        RelationalPlan result = planToProcessConverter.convert(plan);
        boolean fullPushdown = false;
        if (!this.withPlanningState.pushdownWith.isEmpty()) {
            QueryCommand queryCommand;
            AccessNode aNode = CriteriaCapabilityValidatorVisitor.getAccessNode(result);
            if (aNode != null && (queryCommand = CriteriaCapabilityValidatorVisitor.getQueryCommand(aNode)) != null) {
                fullPushdown = true;
                for (SubqueryContainer<?> subqueryContainer : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(queryCommand)) {
                    if (!(subqueryContainer instanceof SubqueryContainer.Evaluatable) || !((SubqueryContainer.Evaluatable)subqueryContainer).shouldEvaluate()) continue;
                    fullPushdown = false;
                    break;
                }
            }
            this.assignWithClause(result.getRootNode(), this.withPlanningState.pushdownWith, false);
            ArrayList toReplan = new ArrayList();
            for (Map.Entry entry : this.withPlanningState.pushdownState.entrySet()) {
                if (!Boolean.TRUE.equals(entry.getValue())) continue;
                GroupSymbol gs = this.withPlanningState.pushdownWith.get(entry.getKey()).getGroupSymbol();
                TempMetadataID tmi = (TempMetadataID)gs.getMetadataID();
                tmi.getTableData().setModel(TempMetadataAdapter.TEMP_MODEL);
                toReplan.add(entry.getKey());
            }
            if (!toReplan.isEmpty()) {
                for (WithQueryCommand withQueryCommand : this.withPlanningState.withList.values()) {
                    this.context.getGroups().remove(withQueryCommand.getGroupSymbol().getName());
                }
                this.sourceHint = previous;
                this.withPlanningState = saved;
                if (debug) {
                    this.analysisRecord.println("\nReplanning due to multiple common table references: " + toReplan + "\n");
                }
                return this.optimize(original);
            }
        }
        if (!fullPushdown && !this.withPlanningState.withList.isEmpty()) {
            result.setWith(new ArrayList<WithQueryCommand>(this.withPlanningState.withList.values()));
        }
        result.setOutputElements(topCols);
        this.sourceHint = previous;
        this.withPlanningState = saved;
        return result;
    }

    private void planWith(PlanNode plan, Command command) throws QueryPlannerException, QueryMetadataException, TeiidComponentException, QueryResolverException {
        if (this.withPlanningState.withList.isEmpty()) {
            return;
        }
        RuleStack stack = new RuleStack();
        stack.push(new RuleAssignOutputElements(false));
        if (this.hints.hasRowBasedSecurity) {
            stack.push(new RuleApplySecurity());
        }
        RelationalPlanner planner = new RelationalPlanner();
        planner.processWith = false;
        planner.initialize(command, this.idGenerator, this.metadata, this.capFinder, this.analysisRecord, this.context);
        planner.executeRules(stack, plan);
        List<Command> commands = CommandCollectorVisitor.getCommands(command, true);
        while (!commands.isEmpty()) {
            Command cmd = commands.remove(commands.size() - 1);
            commands.addAll(CommandCollectorVisitor.getCommands(cmd, true));
            try {
                if (cmd instanceof Query && ((Query)cmd).getIsXML()) continue;
                PlanNode temp = planner.generatePlan((Command)cmd.clone());
                stack.push(new RuleAssignOutputElements(false));
                planner.executeRules(stack, temp);
            }
            catch (TeiidProcessingException e) {
                throw new QueryPlannerException(e);
            }
        }
        for (WithQueryCommand with : this.withPlanningState.withList.values()) {
            AccessNode aNode;
            QueryCommand subCommand = with.getCommand();
            if (subCommand instanceof Query && ((Query)subCommand).getIsXML()) {
                ProcessorPlan subPlan = QueryOptimizer.optimizePlan(subCommand, this.metadata, this.idGenerator, this.capFinder, this.analysisRecord, this.context);
                subCommand.setProcessorPlan(subPlan);
                continue;
            }
            TempMetadataID tid = (TempMetadataID)with.getGroupSymbol().getMetadataID();
            if (tid.getTableData().getModel() != TempMetadataAdapter.TEMP_MODEL) {
                tid.getTableData().setModel(null);
            }
            List<TempMetadataID> elements = tid.getElements();
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (int i = elements.size() - 1; i >= 0; --i) {
                TempMetadataID elem = elements.get(i);
                if (elem.isAccessed()) continue;
                toRemove.add(i);
            }
            if (!toRemove.isEmpty()) {
                GroupSymbol gs = new GroupSymbol("x");
                gs = RulePlaceAccess.recontextSymbol(gs, this.context.getGroups());
                Query query = QueryRewriter.createInlineViewQuery(gs, subCommand, this.metadata, ResolverUtil.resolveElementsInGroup(with.getGroupSymbol(), this.metadata));
                Iterator iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    query.getSelect().getSymbols().set(i, new ExpressionSymbol(elements.get(i).getName(), new Constant(null, elements.get(i).getType())));
                }
                subCommand = query;
                with.setCommand(subCommand);
            }
            if (with.isRecursive()) {
                SetQuery setQuery = (SetQuery)subCommand;
                QueryCommand qc = setQuery.getLeftQuery();
                RelationalPlan subPlan = this.optimize(qc);
                qc.setProcessorPlan(subPlan);
                AccessNode aNode2 = CriteriaCapabilityValidatorVisitor.getAccessNode(subPlan);
                Object modelID = null;
                QueryCommand withCommand = null;
                if (aNode2 != null && (modelID = CriteriaCapabilityValidatorVisitor.validateCommandPushdown(null, this.metadata, this.capFinder, aNode2, false)) != null) {
                    if (with.getGroupSymbol().getModelMetadataId() != null || !CapabilitiesUtil.supports(SourceCapabilities.Capability.RECURSIVE_COMMON_TABLE_EXPRESSIONS, modelID, this.metadata, this.capFinder) || with.isMaterialize()) {
                        modelID = null;
                    } else {
                        withCommand = CriteriaCapabilityValidatorVisitor.getQueryCommand(aNode2);
                        if (withCommand != null) {
                            ((TempMetadataID)with.getGroupSymbol().getMetadataID()).getTableData().setModel(modelID);
                        }
                    }
                }
                QueryCommand qc1 = setQuery.getRightQuery();
                RelationalPlan subPlan1 = this.optimize((Command)qc1.clone());
                qc1.setProcessorPlan(subPlan1);
                if (this.isPushdownValid(with, setQuery, modelID, withCommand, subPlan1) || withCommand == null) continue;
                ((TempMetadataID)with.getGroupSymbol().getMetadataID()).getTableData().setModel(null);
                subPlan1 = this.optimize(qc1);
                qc1.setProcessorPlan(subPlan1);
                continue;
            }
            RelationalPlan subPlan = this.optimize(subCommand);
            subCommand.setProcessorPlan(subPlan);
            RelationalPlan procPlan = subPlan;
            RelationalNode root = procPlan.getRootNode();
            Number planCardinality = root.getEstimateNodeCardinality();
            if (planCardinality != null) {
                ((TempMetadataID)with.getGroupSymbol().getMetadataID()).setCardinality(planCardinality.intValue());
            }
            if ((aNode = CriteriaCapabilityValidatorVisitor.getAccessNode(procPlan)) == null) continue;
            Object modelID = CriteriaCapabilityValidatorVisitor.validateCommandPushdown(null, this.metadata, this.capFinder, aNode, false);
            QueryCommand withCommand = CriteriaCapabilityValidatorVisitor.getQueryCommand(aNode);
            if (modelID == null || withCommand == null || with.getGroupSymbol().getModelMetadataId() != null || !CapabilitiesUtil.supports(SourceCapabilities.Capability.COMMON_TABLE_EXPRESSIONS, modelID, this.metadata, this.capFinder) || with.isMaterialize()) continue;
            WithQueryCommand wqc = new WithQueryCommand(with.getGroupSymbol(), with.getColumns(), withCommand);
            wqc.setNoInline(with.isNoInline());
            ((TempMetadataID)with.getGroupSymbol().getMetadataID()).getTableData().setModel(modelID);
            this.withPlanningState.pushdownWith.put(with.getGroupSymbol().getName(), wqc);
        }
    }

    private boolean isPushdownValid(WithQueryCommand with, SetQuery setQuery, Object modelID, QueryCommand withCommand, RelationalPlan subPlan1) throws QueryMetadataException, TeiidComponentException {
        AccessNode aNode1 = CriteriaCapabilityValidatorVisitor.getAccessNode(subPlan1);
        if (aNode1 == null) {
            return false;
        }
        Object modelID1 = CriteriaCapabilityValidatorVisitor.validateCommandPushdown(null, this.metadata, this.capFinder, aNode1, false);
        QueryCommand withCommand1 = CriteriaCapabilityValidatorVisitor.getQueryCommand(aNode1);
        if (modelID1 == null || withCommand1 == null) {
            return false;
        }
        if (CapabilitiesUtil.isSameConnector(modelID, modelID1, this.metadata, this.capFinder)) {
            SetQuery pushdownSetQuery = new SetQuery(SetQuery.Operation.UNION, setQuery.isAll(), withCommand, withCommand1);
            WithQueryCommand wqc = new WithQueryCommand(with.getGroupSymbol(), with.getColumns(), pushdownSetQuery);
            wqc.setRecursive(true);
            this.withPlanningState.pushdownWith.put(with.getGroupSymbol().getName(), wqc);
            return true;
        }
        return false;
    }

    private void processWith(QueryCommand command, List<WithQueryCommand> withList) throws QueryMetadataException, TeiidComponentException {
        for (int i = 0; i < withList.size(); ++i) {
            GroupSymbol old;
            WithQueryCommand with = withList.get(i);
            WithQueryCommand existing = this.withPlanningState.withList.get(with.getCommand());
            if (existing != null) {
                old = with.getGroupSymbol();
                this.replaceSymbol(command, old, existing.getGroupSymbol());
                continue;
            }
            old = with.getGroupSymbol();
            if (!this.context.getGroups().add(old.getName()) || old.getName().matches("(g|v)_\\d*")) {
                GroupSymbol gs = RulePlaceAccess.recontextSymbol(old, this.context.getGroups());
                LinkedHashMap<ElementSymbol, Expression> replacementSymbols = FrameUtil.buildSymbolMap(old, gs, this.metadata);
                gs.setDefinition(null);
                with.setGroupSymbol(gs);
                with.setColumns(new ArrayList<Expression>(replacementSymbols.values()));
                this.replaceSymbol(command, old, gs);
            }
            this.context.getAliasMapping().put(with.getGroupSymbol().getName(), old.getName());
            this.withPlanningState.withList.put(with.getCommand(), with);
        }
    }

    private void replaceSymbol(QueryCommand command, final GroupSymbol old, final GroupSymbol gs) {
        PreOrPostOrderNavigator nav = new PreOrPostOrderNavigator(new LanguageVisitor(){

            @Override
            public void visit(UnaryFromClause obj) {
                if (old.getMetadataID() == obj.getGroup().getMetadataID()) {
                    String def = obj.getGroup().getDefinition();
                    if (def != null) {
                        String name = obj.getGroup().getName();
                        obj.setGroup(gs.clone());
                        obj.getGroup().setDefinition(gs.getName());
                        obj.getGroup().setName(name);
                    } else {
                        obj.setGroup(gs);
                    }
                }
            }

            @Override
            public void visit(ElementSymbol es) {
                if (es.getGroupSymbol().getMetadataID() == old.getMetadataID()) {
                    String def = es.getGroupSymbol().getDefinition();
                    if (def != null) {
                        String name = es.getGroupSymbol().getName();
                        es.setGroupSymbol(gs.clone());
                        es.getGroupSymbol().setDefinition(gs.getName());
                        es.getGroupSymbol().setName(name);
                    } else {
                        es.setGroupSymbol(gs);
                    }
                }
            }

            @Override
            public void visit(Reference obj) {
                if (obj.getExpression() != null) {
                    this.visit(obj.getExpression());
                }
            }
        }, true, true){

            @Override
            public void visit(UnaryFromClause obj) {
                super.visit(obj);
                if (obj.getExpandedCommand() != null && !obj.getGroup().isProcedure()) {
                    obj.getExpandedCommand().acceptVisitor(this);
                }
            }
        };
        command.acceptVisitor(nav);
    }

    /*
     * WARNING - void declaration
     */
    private void assignWithClause(RelationalNode node, LinkedHashMap<String, WithQueryCommand> pushdownWith, boolean repeated) throws QueryPlannerException, TeiidComponentException {
        void var6_10;
        ProcessorPlan plan;
        ArrayList subCommands = new ArrayList();
        if (node instanceof SubqueryAwareRelationalNode) {
            for (LanguageObject languageObject : ((SubqueryAwareRelationalNode)node).getObjects()) {
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(languageObject, subCommands);
                if (subCommands.isEmpty()) continue;
                for (SubqueryContainer subqueryContainer : subCommands) {
                    if (!(((Command)subqueryContainer.getCommand()).getProcessorPlan() instanceof RelationalPlan)) continue;
                    this.assignWithClause(((RelationalPlan)((Command)subqueryContainer.getCommand()).getProcessorPlan()).getRootNode(), pushdownWith, repeated | (((Command)subqueryContainer.getCommand()).getCorrelatedReferences() != null && !((Command)subqueryContainer.getCommand()).getCorrelatedReferences().asMap().isEmpty()));
                }
                subCommands.clear();
            }
        }
        if (node instanceof PlanExecutionNode && (plan = ((PlanExecutionNode)node).getProcessorPlan()) instanceof RelationalPlan) {
            node = ((RelationalPlan)plan).getRootNode();
        }
        if (node instanceof AccessNode) {
            Command command;
            AccessNode accessNode = (AccessNode)node;
            Map<GroupSymbol, RelationalPlan> map = accessNode.getSubPlans();
            if (map != null) {
                for (RelationalPlan relationalPlan : map.values()) {
                    this.assignWithClause(relationalPlan.getRootNode(), pushdownWith, false);
                }
            }
            if ((command = accessNode.getCommand()) instanceof Insert && ((Insert)command).getQueryExpression() != null) {
                command = ((Insert)command).getQueryExpression();
            }
            if (command instanceof QueryCommand) {
                if (this.withGroups == null) {
                    this.withGroups = new TreeSet<GroupSymbol>(nonCorrelatedComparator);
                } else {
                    this.withGroups.clear();
                }
                GroupCollectorVisitor.getGroupsIgnoreInlineViewsAndEvaluatableSubqueries(command, this.withGroups);
                ArrayList<WithQueryCommand> arrayList = new ArrayList<WithQueryCommand>();
                this.discoverWith(pushdownWith, command, arrayList, new ArrayList<GroupSymbol>(this.withGroups));
                if (!arrayList.isEmpty()) {
                    ArrayList<WithQueryCommand> pushed = new ArrayList<WithQueryCommand>(arrayList);
                    final HashMap<GroupSymbol, Integer> order = new HashMap<GroupSymbol, Integer>();
                    for (WithQueryCommand withQueryCommand : pushdownWith.values()) {
                        order.put(withQueryCommand.getGroupSymbol(), order.size());
                    }
                    Collections.sort(arrayList, new Comparator<WithQueryCommand>(){

                        @Override
                        public int compare(WithQueryCommand o1, WithQueryCommand o2) {
                            return ((Integer)order.get(o1.getGroupSymbol())).compareTo((Integer)order.get(o2.getGroupSymbol()));
                        }
                    });
                    for (int i = 0; i < arrayList.size(); ++i) {
                        WithQueryCommand wqc = (WithQueryCommand)arrayList.get(i);
                        List<WithQueryCommand> with2 = wqc.getCommand().getWith();
                        if (with2 == null) continue;
                        arrayList.addAll(i, with2);
                        i += with2.size();
                        wqc.getCommand().setWith(null);
                    }
                    QueryCommand query = (QueryCommand)command;
                    List<SubqueryContainer<?>> subqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(query);
                    this.withGroups.clear();
                    for (WithQueryCommand wqc : arrayList) {
                        this.withGroups.add(wqc.getGroupSymbol());
                    }
                    this.pullupWith(arrayList, subqueries, this.withGroups);
                    if (query.getWith() != null) {
                        query.getWith().addAll(arrayList);
                    } else {
                        query.setWith(arrayList);
                    }
                    for (WithQueryCommand wqc : pushed) {
                        Object o = this.withPlanningState.pushdownState.get(wqc.getGroupSymbol().getName());
                        if (o == null) {
                            o = !repeated ? (accessNode.info != null ? (Constable)Integer.valueOf(accessNode.info.id) : (Constable)Boolean.FALSE) : Boolean.TRUE;
                        } else if (o instanceof Integer) {
                            if (accessNode.info == null || !o.equals(accessNode.info.id)) {
                                o = Boolean.TRUE;
                            }
                        } else {
                            o = Boolean.TRUE;
                        }
                        this.withPlanningState.pushdownState.put(wqc.getGroupSymbol().getName(), o);
                    }
                    accessNode.setShouldEvaluateExpressions(true);
                }
            }
        }
        RelationalNode[] children = node.getChildren();
        boolean bl = false;
        while (var6_10 < node.getChildCount()) {
            this.assignWithClause(children[var6_10], pushdownWith, repeated);
            ++var6_10;
        }
    }

    private void pullupWith(List<WithQueryCommand> with, List<SubqueryContainer<?>> subqueries, Set<GroupSymbol> knownWithGroups) {
        for (SubqueryContainer<?> subquery : subqueries) {
            if (!(subquery.getCommand() instanceof QueryCommand)) continue;
            QueryCommand qc = (QueryCommand)subquery.getCommand();
            if (qc.getWith() != null) {
                Iterator<WithQueryCommand> i = qc.getWith().iterator();
                while (i.hasNext()) {
                    WithQueryCommand wqc = i.next();
                    if (!knownWithGroups.contains(wqc.getGroupSymbol())) continue;
                    i.remove();
                }
                if (qc.getWith().isEmpty()) {
                    qc.setWith(null);
                }
            }
            this.pullupWith(with, ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(qc), knownWithGroups);
        }
    }

    private void discoverWith(LinkedHashMap<String, WithQueryCommand> pushdownWith, Command command, List<WithQueryCommand> with, Collection<GroupSymbol> groups) throws QueryMetadataException, TeiidComponentException {
        for (GroupSymbol groupSymbol : groups) {
            WithQueryCommand clause;
            if (!groupSymbol.isPushedCommonTable() || (clause = pushdownWith.get(groupSymbol.getNonCorrelationName())) == null) continue;
            TreeSet<GroupSymbol> temp = new TreeSet<GroupSymbol>(nonCorrelatedComparator);
            GroupCollectorVisitor.getGroupsIgnoreInlineViewsAndEvaluatableSubqueries(clause.getCommand(), temp);
            temp.removeAll(this.withGroups);
            this.discoverWith(pushdownWith, command, with, temp);
            with.add(clause.clone());
            this.withGroups.add(clause.getGroupSymbol());
            command.setSourceHint(SourceHint.combine(command.getSourceHint(), clause.getCommand().getSourceHint()));
        }
    }

    public void initialize(Command command, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) {
        this.parentCommand = command;
        this.idGenerator = idGenerator;
        this.metadata = metadata;
        this.capFinder = capFinder;
        this.analysisRecord = analysisRecord;
        this.context = context;
    }

    private void connectSubqueryContainers(PlanNode plan, LinkedHashMap<String, WithQueryCommand> pushdownWith) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode node : NodeEditor.findAllNodes(plan, 252)) {
            Set<GroupSymbol> groupSymbols = RelationalPlanner.getGroupSymbols(node);
            List<SubqueryContainer<?>> subqueryContainers = node.getSubqueryContainers();
            this.planSubqueries(pushdownWith, groupSymbols, node, subqueryContainers, false);
            node.addGroups(GroupsUsedByElementsVisitor.getGroups(node.getCorrelatedReferenceElements()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void planSubqueries(LinkedHashMap<String, WithQueryCommand> pushdownWith, Set<GroupSymbol> groupSymbols, PlanNode node, List<SubqueryContainer<?>> subqueryContainers, boolean isStackEntry) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        if (subqueryContainers.isEmpty()) {
            return;
        }
        Set<GroupSymbol> localGroupSymbols = groupSymbols;
        if (node != null) {
            if (node.getType() == 4) {
                localGroupSymbols = RelationalPlanner.getGroupSymbols(node);
            } else if (node.getType() == 128) {
                localGroupSymbols = RelationalPlanner.getGroupSymbols(node.getFirstChild());
            }
        }
        for (SubqueryContainer<?> container : subqueryContainers) {
            if (((Command)container.getCommand()).getProcessorPlan() != null) continue;
            Command subCommand = (Command)((Command)container.getCommand()).clone();
            List<SubqueryContainer<?>> containers = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(container.getCommand());
            List<SubqueryContainer<?>> cloneContainers = null;
            if (!containers.isEmpty()) {
                cloneContainers = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(subCommand);
            }
            Set entries = null;
            PlanningStackEntry stackEntry = null;
            if (isStackEntry) {
                entries = planningStack.get();
                stackEntry = this.createPlanningStackEntry(groupSymbols.iterator().next(), subCommand, false, entries);
            }
            try {
                PlanNode grouping;
                ArrayList<Reference> correlatedReferences = new ArrayList<Reference>();
                CorrelatedReferenceCollectorVisitor.collectReferences(subCommand, localGroupSymbols, correlatedReferences, this.metadata);
                ProcessorPlan procPlan = QueryOptimizer.optimizePlan(subCommand, this.metadata, this.idGenerator, this.capFinder, this.analysisRecord, this.context);
                ((Command)container.getCommand()).setProcessorPlan(procPlan);
                this.setCorrelatedReferences(container, correlatedReferences);
                if (!containers.isEmpty()) {
                    for (int i = 0; i < containers.size(); ++i) {
                        Object c = containers.get(i).getCommand();
                        Object clone = cloneContainers.get(i).getCommand();
                        ArrayList<Reference> refs = new ArrayList<Reference>();
                        CorrelatedReferenceCollectorVisitor.collectReferences(c, localGroupSymbols, refs, this.metadata);
                        this.setCorrelatedReferences(containers.get(i), refs);
                        ((Command)c).setProcessorPlan(((Command)clone).getProcessorPlan());
                    }
                }
                if (node != null && node.getType() != 4 && node.getType() != 128 && !correlatedReferences.isEmpty() && (grouping = NodeEditor.findNodePreOrder(node, 128, 68)) != null) {
                    SymbolMap map = (SymbolMap)grouping.getProperty(NodeConstants.Info.SYMBOL_MAP);
                    SymbolMap symbolMap = ((Command)container.getCommand()).getCorrelatedReferences();
                    for (Map.Entry<ElementSymbol, Expression> entry : map.asMap().entrySet()) {
                        ElementSymbol es;
                        if (!(entry.getValue() instanceof ElementSymbol) || symbolMap.getMappedExpression(es = (ElementSymbol)entry.getValue()) == null) continue;
                        symbolMap.addMapping(es, entry.getKey());
                    }
                }
                if (entries == null) continue;
                entries.remove(stackEntry);
            }
            catch (Throwable throwable) {
                if (entries != null) {
                    entries.remove(stackEntry);
                }
                throw throwable;
            }
        }
    }

    private void setCorrelatedReferences(SubqueryContainer<?> container, List<Reference> correlatedReferences) {
        if (!correlatedReferences.isEmpty()) {
            SymbolMap map = new SymbolMap();
            for (Reference reference : correlatedReferences) {
                map.addMapping(reference.getExpression(), reference.getExpression());
            }
            ((Command)container.getCommand()).setCorrelatedReferences(map);
        }
    }

    private static Set<GroupSymbol> getGroupSymbols(PlanNode plan) {
        HashSet<GroupSymbol> groupSymbols = new HashSet<GroupSymbol>();
        for (PlanNode source : NodeEditor.findAllNodes(plan, 192, 192)) {
            groupSymbols.addAll(source.getGroups());
        }
        return groupSymbols;
    }

    private void distributeDependentHints(Collection<String> groups, PlanNode plan, NodeConstants.Info hintProperty, Collection<? extends Object> vals) throws QueryMetadataException, TeiidComponentException {
        if (groups == null || groups.isEmpty()) {
            return;
        }
        List<PlanNode> nodes = NodeEditor.findAllNodes(plan, 64);
        Iterator<? extends Object> valIter = vals.iterator();
        for (String groupName : groups) {
            Object val = valIter.next();
            boolean appliedHint = false;
            if (groupName.startsWith("@")) {
                appliedHint = this.applyGlobalTableHint(plan, hintProperty, groupName.substring(1), val);
            }
            if (!appliedHint) {
                appliedHint = RelationalPlanner.applyHint(nodes, groupName, hintProperty, val);
            }
            if (appliedHint) continue;
            Collection groupNames = this.metadata.getGroupsForPartialName(groupName);
            if (groupNames.size() == 1) {
                groupName = (String)groupNames.iterator().next();
                appliedHint = RelationalPlanner.applyHint(nodes, groupName, hintProperty, val);
            }
            if (appliedHint) continue;
            String msg = QueryPlugin.Util.getString("ERR.015.004.0010", new Object[]{groupName});
            if (!this.analysisRecord.recordAnnotations()) continue;
            this.analysisRecord.addAnnotation(new Annotation("Hints", msg, "ignoring hint", Annotation.Priority.MEDIUM));
        }
    }

    private static boolean applyHint(List<PlanNode> nodes, String groupName, NodeConstants.Info hintProperty, Object value) {
        boolean appliedHint = false;
        for (PlanNode node : nodes) {
            GroupSymbol nodeGroup = node.getGroups().iterator().next();
            String sDefinition = nodeGroup.getDefinition();
            if (!nodeGroup.getName().equalsIgnoreCase(groupName) && (sDefinition == null || !sDefinition.equalsIgnoreCase(groupName))) continue;
            node.setProperty(hintProperty, value);
            appliedHint = true;
        }
        return appliedHint;
    }

    private boolean applyGlobalTableHint(PlanNode plan, NodeConstants.Info hintProperty, String groupName, Object value) {
        GroupSymbol gs = new GroupSymbol(groupName);
        List nameParts = StringUtil.split((String)gs.getName(), (String)".");
        PlanNode root = plan;
        boolean found = true;
        block0: for (int i = 0; i < nameParts.size() && found; ++i) {
            String part = (String)nameParts.get(i);
            List<PlanNode> targets = NodeEditor.findAllNodes(root.getFirstChild(), 64, 64);
            boolean leaf = i == nameParts.size() - 1;
            found = false;
            for (PlanNode planNode : targets) {
                if (!part.equalsIgnoreCase(planNode.getGroups().iterator().next().getShortName())) continue;
                if (leaf) {
                    planNode.setProperty(hintProperty, value);
                    return true;
                }
                if (planNode.getChildren().isEmpty()) {
                    return false;
                }
                root = planNode;
                found = true;
                continue block0;
            }
        }
        return false;
    }

    public RuleStack buildRules() {
        RuleStack rules = new RuleStack();
        rules.setPlanner(this);
        rules.push(RuleConstants.COLLAPSE_SOURCE);
        rules.push(RuleConstants.PLAN_SORTS);
        if (this.hints.hasJoin || this.hints.hasCriteria || this.hints.hasRowBasedSecurity) {
            rules.push(new RuleMergeCriteria(this.idGenerator, this.capFinder, this.analysisRecord, this.context, this.metadata));
        }
        if (this.hints.hasJoin) {
            rules.push(RuleConstants.IMPLEMENT_JOIN_STRATEGY);
        }
        rules.push(RuleConstants.CALCULATE_COST);
        if (this.hints.hasLimit) {
            rules.push(RuleConstants.PUSH_LIMIT);
        }
        rules.push(new RuleAssignOutputElements(true));
        if (this.hints.hasRelationalProc) {
            rules.push(RuleConstants.PLAN_PROCEDURES);
        }
        if (this.hints.hasJoin) {
            rules.push(RuleConstants.CHOOSE_DEPENDENT);
        }
        if (this.hints.hasAggregates) {
            rules.push(new RulePushAggregates(this.idGenerator));
            if (this.hints.hasJoin) {
                rules.push(new RuleChooseDependent(true));
            }
        }
        if (this.hints.hasJoin) {
            rules.push(RuleConstants.CHOOSE_JOIN_STRATEGY);
            rules.push(RuleConstants.PLAN_OUTER_JOINS);
            rules.push(RuleConstants.RAISE_ACCESS);
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
            rules.push(RuleConstants.PLAN_JOINS);
        }
        if (this.hints.hasJoin) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
            rules.push(RuleConstants.COPY_CRITERIA);
        }
        rules.push(RuleConstants.RAISE_ACCESS);
        if (this.hints.hasFunctionBasedColumns) {
            rules.push(RuleConstants.SUBSTITUTE_EXPRESSIONS);
        }
        if (this.hints.hasSetQuery) {
            rules.push(RuleConstants.PLAN_UNIONS);
        }
        if (this.hints.hasCriteria || this.hints.hasJoin || this.hints.hasVirtualGroups) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
        }
        if (this.hints.hasJoin) {
            rules.push(RuleConstants.PUSH_NON_JOIN_CRITERIA);
        }
        if (this.hints.hasVirtualGroups) {
            rules.push(RuleConstants.MERGE_VIRTUAL);
        }
        if (this.hints.hasJoin && this.hints.hasSetQuery) {
            rules.push(RuleConstants.DECOMPOSE_JOIN);
            rules.push(RuleConstants.MERGE_VIRTUAL);
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        } else if (this.hints.hasCriteria) {
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        if (this.hints.hasJoin && this.hints.hasOptionalJoin) {
            rules.push(RuleConstants.REMOVE_OPTIONAL_JOINS);
        }
        if (this.hints.hasVirtualGroups || this.hints.hasJoin && this.hints.hasOptionalJoin) {
            rules.push(new RuleAssignOutputElements(false));
        }
        if (this.hints.hasRowBasedSecurity && this.withPlanningState.withList.isEmpty()) {
            rules.push(new RuleApplySecurity());
        }
        rules.push(RuleConstants.PLACE_ACCESS);
        return rules;
    }

    public PlanNode executeRules(RuleStack rules, PlanNode plan) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean debug = this.analysisRecord.recordDebug();
        while (!rules.isEmpty()) {
            if (debug) {
                this.analysisRecord.println("\n============================================================================");
            }
            OptimizerRule rule = rules.pop();
            if (debug) {
                this.analysisRecord.println("EXECUTING " + rule);
            }
            plan = rule.execute(plan, this.metadata, this.capFinder, rules, this.analysisRecord, this.context);
            if (!debug) continue;
            this.analysisRecord.println("\nAFTER: \n" + plan.nodeToString(true));
        }
        return plan;
    }

    public PlanNode generatePlan(Command cmd) throws TeiidComponentException, TeiidProcessingException {
        Option savedOption = this.option;
        this.option = cmd.getOption();
        if (this.option == null) {
            if (savedOption != null) {
                this.option = savedOption;
            }
        } else if (savedOption != null && savedOption.isNoCache() && savedOption != this.option) {
            if (savedOption.getNoCacheGroups() == null || savedOption.getNoCacheGroups().isEmpty()) {
                if (this.option.getNoCacheGroups() != null) {
                    this.option.getNoCacheGroups().clear();
                }
            } else if (this.option.getNoCacheGroups() != null && !this.option.getNoCacheGroups().isEmpty()) {
                for (String noCache : savedOption.getNoCacheGroups()) {
                    this.option.addNoCacheGroup(noCache);
                }
            }
            this.option.setNoCache(true);
        }
        PlanNode result = null;
        switch (cmd.getType()) {
            case 1: {
                result = this.createQueryPlan((QueryCommand)cmd, null);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                result = this.createUpdatePlan(cmd);
                break;
            }
            case 6: {
                result = this.createStoredProcedurePlan((StoredProcedure)cmd);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid command type");
            }
        }
        if (cmd.getOption() != null) {
            if (cmd.getOption().getMakeDepOptions() != null) {
                this.distributeDependentHints(cmd.getOption().getDependentGroups(), result, NodeConstants.Info.MAKE_DEP, cmd.getOption().getMakeDepOptions());
            }
            if (cmd.getOption().getNotDependentGroups() != null) {
                this.distributeDependentHints(cmd.getOption().getNotDependentGroups(), result, NodeConstants.Info.MAKE_NOT_DEP, Collections.nCopies(cmd.getOption().getNotDependentGroups().size(), Boolean.TRUE));
            }
        }
        this.option = savedOption;
        return result;
    }

    PlanNode createUpdatePlan(Command command) throws TeiidComponentException, TeiidProcessingException {
        Insert insert;
        PlanNode projectNode = NodeFactory.getNewNode(8);
        List<Expression> cols = command.getProjectedSymbols();
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, cols);
        PlanNode sourceNode = NodeFactory.getNewNode(64);
        sourceNode.setProperty(NodeConstants.Info.ATOMIC_REQUEST, command);
        sourceNode.setProperty(NodeConstants.Info.VIRTUAL_COMMAND, command);
        boolean usingTriggerAction = false;
        if (command instanceof ProcedureContainer) {
            ProcedureContainer container = (ProcedureContainer)command;
            usingTriggerAction = this.addNestedProcedure(sourceNode, container, container.getGroup().getMetadataID());
        }
        GroupSymbol target = ((TargetedCommand)((Object)command)).getGroup();
        sourceNode.addGroup(target);
        Object id = RelationalPlanner.getTrackableGroup(target, this.metadata);
        if (id != null) {
            this.context.accessedPlanningObject(id);
        }
        RelationalPlanner.attachLast(projectNode, sourceNode);
        if (!usingTriggerAction && command instanceof Insert && (insert = (Insert)command).getQueryExpression() != null) {
            PlanNode plan = this.generatePlan(insert.getQueryExpression());
            RelationalPlanner.attachLast(sourceNode, plan);
            RelationalPlanner.mergeTempMetadata(insert.getQueryExpression(), insert);
            projectNode.setProperty(NodeConstants.Info.INTO_GROUP, insert.getGroup());
            if (this.sourceHint != null) {
                projectNode.setProperty(NodeConstants.Info.SOURCE_HINT, this.sourceHint);
            }
            if (insert.getConstraint() != null) {
                projectNode.setProperty(NodeConstants.Info.CONSTRAINT, insert.getConstraint());
            }
            if (insert.isUpsert()) {
                projectNode.setProperty(NodeConstants.Info.UPSERT, true);
            }
        }
        if (usingTriggerAction && FrameUtil.getNestedPlan(projectNode) instanceof RelationalPlan) {
            sourceNode.removeFromParent();
            return sourceNode;
        }
        return projectNode;
    }

    /*
     * WARNING - void declaration
     */
    private boolean addNestedProcedure(PlanNode sourceNode, ProcedureContainer container, Object metadataId) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        void var5_11;
        Set entries;
        Object sp;
        if (container instanceof StoredProcedure && ((StoredProcedure)(sp = (StoredProcedure)container)).getProcedureID() instanceof Procedure) {
            this.context.accessedPlanningObject(((StoredProcedure)sp).getProcedureID());
        }
        for (SubqueryContainer subqueryContainer : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(container)) {
            if (((Command)subqueryContainer.getCommand()).getCorrelatedReferences() != null) continue;
            ArrayList<Reference> correlatedReferences = new ArrayList<Reference>();
            CorrelatedReferenceCollectorVisitor.collectReferences(subqueryContainer.getCommand(), Arrays.asList(container.getGroup()), correlatedReferences, this.metadata);
            this.setCorrelatedReferences(subqueryContainer, correlatedReferences);
        }
        String cacheString = "transformation/" + container.getClass().getSimpleName().toUpperCase();
        Command command = (Command)this.metadata.getFromMetadataCache(metadataId, cacheString);
        if (command == null) {
            Command command2 = QueryResolver.expandCommand(container, this.metadata, this.analysisRecord);
            if (command2 != null) {
                if (command2 instanceof CreateProcedureCommand) {
                    ((CreateProcedureCommand)command2).setProjectedSymbols(container.getProjectedSymbols());
                }
                Request.validateWithVisitor(new ValidationVisitor(), this.metadata, command2);
                this.metadata.addToMetadataCache(metadataId, cacheString, command2.clone());
            }
        } else {
            Command command3 = (Command)command.clone();
            if (command3 instanceof CreateProcedureCommand) {
                ((CreateProcedureCommand)command3).setProjectedSymbols(container.getProjectedSymbols());
            }
        }
        boolean checkRowBasedSecurity = true;
        if (!container.getGroup().isProcedure() && !this.metadata.isVirtualGroup(metadataId) && (entries = (Set)planningStack.get()).contains(new PlanningStackEntry(container, container.getGroup()))) {
            checkRowBasedSecurity = false;
        }
        if (checkRowBasedSecurity) {
            void var5_9;
            Command command4 = RowBasedSecurityHelper.checkUpdateRowBasedFilters(container, (Command)var5_9, this);
        }
        if (var5_11 != null) {
            if (var5_11 instanceof TriggerAction) {
                TriggerAction ta = (TriggerAction)var5_11;
                ProcessorPlan plan = new TriggerActionPlanner().optimize((ProcedureContainer)container.clone(), ta, this.idGenerator, this.metadata, this.capFinder, this.analysisRecord, this.context);
                sourceNode.setProperty(NodeConstants.Info.PROCESSOR_PLAN, plan);
                return true;
            }
            if (var5_11.getCacheHint() != null && container instanceof StoredProcedure) {
                StoredProcedure sp2 = (StoredProcedure)container;
                boolean noCache = RelationalPlanner.isNoCacheGroup(this.metadata, sp2.getProcedureID(), this.option);
                if (!noCache) {
                    if (!this.context.isResultSetCacheEnabled()) {
                        RelationalPlanner.recordAnnotation(this.analysisRecord, "Cached Procedure", Annotation.Priority.MEDIUM, "SimpleQueryResolver.procedure_cache_not_usable", container.getGroup(), "result set cache disabled");
                    } else if (!container.areResultsCachable()) {
                        RelationalPlanner.recordAnnotation(this.analysisRecord, "Cached Procedure", Annotation.Priority.MEDIUM, "SimpleQueryResolver.procedure_cache_not_usable", container.getGroup(), "procedure performs updates");
                    } else if (LobManager.getLobIndexes(new ArrayList<ElementSymbol>(sp2.getProcedureParameters().keySet())) != null) {
                        RelationalPlanner.recordAnnotation(this.analysisRecord, "Cached Procedure", Annotation.Priority.MEDIUM, "SimpleQueryResolver.procedure_cache_not_usable", container.getGroup(), "lob parameters");
                    }
                    container.getGroup().setGlobalTable(true);
                    container.setCacheHint(var5_11.getCacheHint());
                    RelationalPlanner.recordAnnotation(this.analysisRecord, "Cached Procedure", Annotation.Priority.LOW, "SimpleQueryResolver.procedure_cache_used", container.getGroup());
                    return false;
                }
                RelationalPlanner.recordAnnotation(this.analysisRecord, "Cached Procedure", Annotation.Priority.LOW, "SimpleQueryResolver.procedure_cache_not_used", container.getGroup());
            }
            this.addNestedCommand(sourceNode, container.getGroup(), container, (Command)var5_11, false, true);
        }
        List<SubqueryContainer<?>> subqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(container);
        if (var5_11 == null && container instanceof FilteredCommand) {
            boolean compensate = false;
            boolean isTemp = container.getGroup().isTempTable() && this.metadata.getModelID(container.getGroup().getMetadataID()) == TempMetadataAdapter.TEMP_MODEL;
            try {
                this.planSubqueries(container, (Command)var5_11, subqueries, true);
            }
            catch (QueryPlannerException e) {
                if (!isTemp) {
                    throw e;
                }
                compensate = true;
            }
            if (!isTemp && !CriteriaCapabilityValidatorVisitor.canPushLanguageObject(container, this.metadata.getModelID(container.getGroup().getMetadataID()), this.metadata, this.capFinder, this.analysisRecord)) {
                compensate = true;
            }
            if (compensate) {
                void var5_14;
                this.validateRowProcessing(container);
                if (container instanceof Update) {
                    Command command5 = QueryRewriter.createUpdateProcedure((Update)container, this.metadata, this.context);
                } else {
                    Command command6 = QueryRewriter.createDeleteProcedure((Delete)container, this.metadata, this.context);
                }
                this.addNestedCommand(sourceNode, container.getGroup(), container, (Command)var5_14, false, true);
                return false;
            }
        }
        this.planSubqueries(container, (Command)var5_11, subqueries, false);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void planSubqueries(ProcedureContainer container, Command c, List<SubqueryContainer<?>> subqueries, boolean initial) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean isSourceTemp = c == null && container.getGroup().isTempTable() && this.metadata.getModelID(container.getGroup().getMetadataID()) == TempMetadataAdapter.TEMP_MODEL;
        for (SubqueryContainer<?> subqueryContainer : subqueries) {
            if (isSourceTemp) {
                if (((Command)subqueryContainer.getCommand()).getCorrelatedReferences() != null) throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30253, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30253, new Object[]{container}));
                if (subqueryContainer instanceof ScalarSubquery) {
                    ((ScalarSubquery)subqueryContainer).setShouldEvaluate(true);
                } else {
                    if (!(subqueryContainer instanceof ExistsCriteria)) throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30253, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30253, new Object[]{container}));
                    ((ExistsCriteria)subqueryContainer).setShouldEvaluate(true);
                }
            }
            if (((Command)subqueryContainer.getCommand()).getProcessorPlan() == null) {
                Object subCommand = initial ? (Command)((Command)subqueryContainer.getCommand()).clone() : subqueryContainer.getCommand();
                ProcessorPlan plan = QueryOptimizer.optimizePlan(subCommand, this.metadata, null, this.capFinder, this.analysisRecord, this.context);
                ((Command)subqueryContainer.getCommand()).setProcessorPlan(plan);
            }
            if (c != null || initial) continue;
            RuleCollapseSource.prepareSubquery(subqueryContainer);
        }
    }

    void validateRowProcessing(ProcedureContainer container) throws TeiidComponentException, QueryMetadataException, QueryPlannerException {
        if (this.metadata.getUniqueKeysInGroup(container.getGroup().getMetadataID()).isEmpty() || !CapabilitiesUtil.supports(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, this.metadata.getModelID(container.getGroup().getMetadataID()), this.metadata, this.capFinder)) {
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30253, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30253, new Object[]{container}));
        }
    }

    PlanNode createStoredProcedurePlan(StoredProcedure storedProc) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        PlanNode projectNode = RelationalPlanner.attachProject(null, storedProc.getProjectedSymbols());
        PlanNode sourceNode = NodeFactory.getNewNode(64);
        sourceNode.setProperty(NodeConstants.Info.VIRTUAL_COMMAND, storedProc);
        this.addNestedProcedure(sourceNode, storedProc, storedProc.getProcedureID());
        this.hints.hasRelationalProc |= storedProc.isProcedureRelational();
        if (!this.hints.hasRowBasedSecurity && RowBasedSecurityHelper.applyRowSecurity(this.metadata, storedProc.getGroup(), this.context)) {
            this.hints.hasRowBasedSecurity = true;
        }
        sourceNode.addGroup(storedProc.getGroup());
        RelationalPlanner.attachLast(projectNode, sourceNode);
        return projectNode;
    }

    PlanNode createQueryPlan(QueryCommand command, List<OrderBy> parentOrderBys) throws TeiidComponentException, TeiidProcessingException {
        List<WithQueryCommand> withList;
        if (this.processWith && (withList = command.getWith()) != null) {
            this.processWith(command, withList);
        }
        PlanNode node = null;
        if (command instanceof Query) {
            node = this.createQueryPlan((Query)command, parentOrderBys);
        } else {
            this.hints.hasSetQuery = true;
            SetQuery query = (SetQuery)command;
            SourceHint previous = this.sourceHint;
            this.sourceHint = SourceHint.combine(previous, query.getProjectedQuery().getSourceHint());
            if (command.getOrderBy() != null) {
                if (parentOrderBys == null) {
                    parentOrderBys = new ArrayList<OrderBy>(2);
                }
                parentOrderBys.add(command.getOrderBy());
            }
            PlanNode leftPlan = this.createQueryPlan(query.getLeftQuery(), parentOrderBys);
            if (command.getOrderBy() != null) {
                parentOrderBys.remove(parentOrderBys.size() - 1);
            }
            PlanNode rightPlan = this.createQueryPlan(query.getRightQuery(), null);
            node = NodeFactory.getNewNode(256);
            node.setProperty(NodeConstants.Info.SET_OPERATION, (Object)query.getOperation());
            node.setProperty(NodeConstants.Info.USE_ALL, query.isAll());
            this.sourceHint = previous;
            RelationalPlanner.attachLast(node, leftPlan);
            RelationalPlanner.attachLast(node, rightPlan);
        }
        if (command.getOrderBy() != null) {
            node = RelationalPlanner.attachSorting(node, command.getOrderBy());
        }
        if (command.getLimit() != null) {
            node = RelationalPlanner.attachTupleLimit(node, command.getLimit(), this.hints);
        }
        return node;
    }

    private PlanNode createQueryPlan(Query query, List<OrderBy> parentOrderBys) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        PlanNode plan = null;
        LinkedHashSet windowFunctions = new LinkedHashSet();
        if (query.getFrom() != null) {
            boolean hasGrouping;
            FromClause fromClause = RelationalPlanner.mergeClauseTrees(query.getFrom());
            PlanNode dummyRoot = new PlanNode();
            this.buildTree(fromClause, dummyRoot);
            plan = dummyRoot.getFirstChild();
            this.hints.hasJoin = this.hints.hasJoin | plan.getType() == 4;
            if (query.getCriteria() != null) {
                plan = RelationalPlanner.attachCriteria(plan, query.getCriteria(), false);
                this.hints.hasCriteria = true;
            }
            LinkedHashSet<AggregateSymbol> aggs = new LinkedHashSet<AggregateSymbol>();
            AggregateSymbolCollectorVisitor.getAggregates(query.getSelect(), aggs, null, null, windowFunctions, null);
            boolean bl = hasGrouping = !aggs.isEmpty();
            if (query.getHaving() != null) {
                aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(query.getHaving(), true));
                hasGrouping = true;
            }
            if (query.getGroupBy() != null) {
                hasGrouping = true;
            }
            if (hasGrouping) {
                plan = this.attachGrouping(plan, query, aggs, parentOrderBys);
            }
            if (query.getHaving() != null) {
                plan = RelationalPlanner.attachCriteria(plan, query.getHaving(), true);
                this.hints.hasCriteria = true;
            }
        }
        plan = RelationalPlanner.attachProject(plan, query.getSelect().getProjectedSymbols());
        if (query.getOrderBy() != null) {
            AggregateSymbolCollectorVisitor.getAggregates(query.getOrderBy(), null, null, null, windowFunctions, null);
        }
        if (!windowFunctions.isEmpty()) {
            plan.setProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS, true);
        }
        if (query.getSelect().isDistinct()) {
            plan = RelationalPlanner.attachDupRemoval(plan);
        }
        return plan;
    }

    private static FromClause mergeClauseTrees(From from) {
        List<FromClause> clauses = from.getClauses();
        while (clauses.size() > 1) {
            FromClause first = from.getClauses().remove(0);
            FromClause second = from.getClauses().remove(0);
            JoinPredicate jp = new JoinPredicate(first, second, JoinType.JOIN_CROSS);
            clauses.add(0, jp);
        }
        return clauses.get(0);
    }

    void buildTree(FromClause clause, PlanNode parent) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        PlanNode node = null;
        if (clause instanceof UnaryFromClause) {
            UnaryFromClause ufc = (UnaryFromClause)clause;
            GroupSymbol group = ufc.getGroup();
            if (this.metadata.isVirtualGroup(group.getMetadataID())) {
                this.hints.hasVirtualGroups = true;
            }
            if (!this.hints.hasRowBasedSecurity && RowBasedSecurityHelper.applyRowSecurity(this.metadata, group, this.context)) {
                this.hints.hasRowBasedSecurity = true;
            }
            if (this.metadata.getFunctionBasedExpressions(group.getMetadataID()) != null) {
                this.hints.hasFunctionBasedColumns = true;
            }
            boolean planningStackEntry = true;
            Command nestedCommand = ufc.getExpandedCommand();
            if (nestedCommand != null) {
                if (!group.isProcedure()) {
                    planningStackEntry = false;
                    this.hints.hasVirtualGroups = true;
                }
            } else if (!group.isProcedure()) {
                Object id = RelationalPlanner.getTrackableGroup(group, this.metadata);
                if (id != null) {
                    this.context.accessedPlanningObject(id);
                }
                if (!group.isTempGroupSymbol() && this.metadata.isVirtualGroup(group.getMetadataID())) {
                    nestedCommand = this.resolveVirtualGroup(group);
                }
            }
            node = NodeFactory.getNewNode(64);
            if (ufc.isNoUnnest()) {
                node.setProperty(NodeConstants.Info.NO_UNNEST, Boolean.TRUE);
            }
            node.addGroup(group);
            if (nestedCommand != null) {
                UpdateValidator.UpdateInfo info = ProcedureContainerResolver.getUpdateInfo(group, this.metadata);
                if (info != null && info.getPartitionInfo() != null && !info.getPartitionInfo().isEmpty()) {
                    node.setProperty(NodeConstants.Info.PARTITION_INFO, info.getPartitionInfo());
                }
                SourceHint previous = this.sourceHint;
                if (nestedCommand.getSourceHint() != null) {
                    this.sourceHint = SourceHint.combine(previous, nestedCommand.getSourceHint());
                }
                this.addNestedCommand(node, group, nestedCommand, nestedCommand, true, planningStackEntry);
                this.sourceHint = previous;
            } else if (this.sourceHint != null) {
                node.setProperty(NodeConstants.Info.SOURCE_HINT, this.sourceHint);
            }
            if (group.getName().contains("__")) {
                this.context.getGroups().add(group.getName());
            }
            parent.addLastChild(node);
        } else if (clause instanceof JoinPredicate) {
            JoinPredicate jp = (JoinPredicate)clause;
            node = NodeFactory.getNewNode(4);
            node.setProperty(NodeConstants.Info.JOIN_TYPE, jp.getJoinType());
            node.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.NESTED_LOOP);
            node.setProperty(NodeConstants.Info.JOIN_CRITERIA, jp.getJoinCriteria());
            if (jp.isPreserve()) {
                node.setProperty(NodeConstants.Info.PRESERVE, Boolean.TRUE);
            }
            if (jp.getJoinType() == JoinType.JOIN_LEFT_OUTER) {
                this.hints.hasOptionalJoin = true;
            }
            parent.addLastChild(node);
            FromClause[] clauses = new FromClause[]{jp.getLeftClause(), jp.getRightClause()};
            for (int i = 0; i < 2; ++i) {
                if (jp.isPreserve() && clauses[i] instanceof JoinPredicate) {
                    ((JoinPredicate)clauses[i]).setPreserve(true);
                }
                this.buildTree(clauses[i], node);
                node.addGroups(node.getLastChild().getGroups());
            }
        } else if (clause instanceof SubqueryFromClause) {
            Map<ElementSymbol, List<Set<Constant>>> partitionInfo;
            SubqueryFromClause sfc = (SubqueryFromClause)clause;
            GroupSymbol group = sfc.getGroupSymbol();
            Command nestedCommand = sfc.getCommand();
            node = NodeFactory.getNewNode(64);
            if (sfc.isLateral()) {
                sfc.getCommand().setCorrelatedReferences(this.getCorrelatedReferences(parent, node, sfc));
            }
            if (sfc.isNoUnnest()) {
                node.setProperty(NodeConstants.Info.NO_UNNEST, Boolean.TRUE);
            }
            SourceHint previous = this.sourceHint;
            if (nestedCommand.getSourceHint() != null) {
                this.sourceHint = SourceHint.combine(previous, nestedCommand.getSourceHint());
            }
            node.addGroup(group);
            this.addNestedCommand(node, group, nestedCommand, nestedCommand, true, false);
            this.sourceHint = previous;
            if (nestedCommand instanceof SetQuery && !(partitionInfo = PartitionAnalyzer.extractPartionInfo((SetQuery)nestedCommand, ResolverUtil.resolveElementsInGroup(group, this.metadata))).isEmpty()) {
                node.setProperty(NodeConstants.Info.PARTITION_INFO, partitionInfo);
            }
            this.hints.hasVirtualGroups = true;
            parent.addLastChild(node);
            if (group.getName().contains("__")) {
                this.context.getGroups().add(group.getName());
            }
        } else if (clause instanceof TableFunctionReference) {
            ArrayTable at;
            JoinType jt;
            TableFunctionReference tt = (TableFunctionReference)clause;
            GroupSymbol group = tt.getGroupSymbol();
            if (group.getName().contains("__")) {
                this.context.getGroups().add(group.getName());
            }
            if (parent.getType() == 4 && tt instanceof ArrayTable && (jt = (JoinType)parent.getProperty(NodeConstants.Info.JOIN_TYPE)) != JoinType.JOIN_FULL_OUTER && parent.getChildCount() > 0 && ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(at = (ArrayTable)tt).isEmpty()) {
                List<ElementSymbol> symbols = at.getProjectedSymbols();
                FunctionLibrary funcLib = this.metadata.getFunctionLibrary();
                FunctionDescriptor descriptor = funcLib.findFunction("array_get", new Class[]{DataTypeManager.DefaultDataClasses.OBJECT, DataTypeManager.DefaultDataClasses.INTEGER});
                Query query = new Query();
                Select select = new Select();
                query.setSelect(select);
                for (int i = 0; i < symbols.size(); ++i) {
                    ElementSymbol es = symbols.get(i);
                    Function f = new Function("array_get", new Expression[]{(Expression)at.getArrayValue().clone(), new Constant(i + 1)});
                    f.setType(DataTypeManager.DefaultDataClasses.OBJECT);
                    f.setFunctionDescriptor(descriptor);
                    Function ex = f;
                    if (es.getType() != DataTypeManager.DefaultDataClasses.OBJECT) {
                        ex = ResolverUtil.getConversion(ex, "object", DataTypeManager.getDataTypeName(es.getType()), false, this.metadata.getFunctionLibrary());
                    }
                    select.addSymbol(new AliasSymbol(es.getShortName(), ex));
                }
                SubqueryFromClause sfc = new SubqueryFromClause(at.getGroupSymbol(), (Command)query);
                sfc.setLateral(true);
                this.buildTree(sfc, parent);
                if (!jt.isOuter()) {
                    ArrayList<IsNullCriteria> joinCriteria;
                    IsNullCriteria criteria = new IsNullCriteria((Expression)at.getArrayValue().clone());
                    if (sfc.getCommand().getCorrelatedReferences() != null) {
                        RuleMergeCriteria.ReferenceReplacementVisitor rrv = new RuleMergeCriteria.ReferenceReplacementVisitor(sfc.getCommand().getCorrelatedReferences());
                        PreOrPostOrderNavigator.doVisit(criteria, rrv, true);
                    }
                    criteria.setNegated(true);
                    if (jt == JoinType.JOIN_CROSS) {
                        parent.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_INNER);
                    }
                    if ((joinCriteria = (ArrayList<IsNullCriteria>)parent.getProperty(NodeConstants.Info.JOIN_CRITERIA)) == null) {
                        joinCriteria = new ArrayList<IsNullCriteria>(2);
                    }
                    joinCriteria.add(criteria);
                    parent.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
                }
                return;
            }
            node = NodeFactory.getNewNode(64);
            node.setProperty(NodeConstants.Info.TABLE_FUNCTION, tt);
            tt.setCorrelatedReferences(this.getCorrelatedReferences(parent, node, tt));
            node.addGroup(group);
            parent.addLastChild(node);
        } else {
            throw new AssertionError((Object)"Unknown Type");
        }
        if (clause.isOptional()) {
            node.setProperty(NodeConstants.Info.IS_OPTIONAL, Boolean.TRUE);
            this.hints.hasOptionalJoin = true;
        }
        if (clause.getMakeDep() != null) {
            node.setProperty(NodeConstants.Info.MAKE_DEP, clause.getMakeDep());
        } else if (clause.isMakeNotDep()) {
            node.setProperty(NodeConstants.Info.MAKE_NOT_DEP, Boolean.TRUE);
        }
        if (clause.getMakeInd() != null) {
            node.setProperty(NodeConstants.Info.MAKE_IND, clause.getMakeInd());
        }
    }

    public static Object getTrackableGroup(GroupSymbol group, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        Object metadataID = group.getMetadataID();
        if (group.isTempGroupSymbol()) {
            QueryMetadataInterface qmi = metadata.getSessionMetadata();
            try {
                Object mid;
                if (group.isGlobalTable()) {
                    return metadataID;
                }
                if (qmi != null && ((mid = qmi.getGroupID(group.getNonCorrelationName())) == metadataID || metadata.isVirtualGroup(metadataID))) {
                    return mid;
                }
            }
            catch (QueryMetadataException queryMetadataException) {
                // empty catch block
            }
            if (metadata.isVirtualGroup(metadataID)) {
                return metadataID;
            }
        } else {
            return metadataID;
        }
        return null;
    }

    private SymbolMap getCorrelatedReferences(PlanNode parent, PlanNode node, LanguageObject lo) {
        PlanNode rootJoin = parent;
        while (rootJoin.getParent() != null && rootJoin.getParent().getType() == 4 && !rootJoin.getParent().getGroups().isEmpty()) {
            rootJoin = rootJoin.getParent();
        }
        ArrayList<Reference> correlatedReferences = new ArrayList<Reference>();
        CorrelatedReferenceCollectorVisitor.collectReferences(lo, rootJoin.getGroups(), correlatedReferences, this.metadata);
        if (correlatedReferences.isEmpty()) {
            return null;
        }
        SymbolMap map = new SymbolMap();
        for (Reference reference : correlatedReferences) {
            map.addMapping(reference.getExpression(), reference.getExpression());
        }
        node.setProperty(NodeConstants.Info.CORRELATED_REFERENCES, map);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNestedCommand(PlanNode node, GroupSymbol group, Command nestedCommand, Command toPlan, boolean merge, boolean isStackEntry) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        block14: {
            QueryCommand queryCommand;
            if (nestedCommand instanceof QueryCommand && (queryCommand = (QueryCommand)nestedCommand).getLimit() == null) {
                queryCommand.setOrderBy(null);
            }
            Set entries = null;
            PlanningStackEntry entry = null;
            if (isStackEntry) {
                entries = planningStack.get();
                entry = this.createPlanningStackEntry(group, nestedCommand, toPlan.getType() == 7, entries);
            }
            try {
                node.setProperty(NodeConstants.Info.NESTED_COMMAND, nestedCommand);
                if (merge && nestedCommand instanceof Query && QueryResolver.isXMLQuery((Query)nestedCommand, this.metadata)) {
                    merge = false;
                }
                if (merge) {
                    RelationalPlanner.mergeTempMetadata(nestedCommand, this.parentCommand);
                    PlanNode childRoot = this.generatePlan(nestedCommand);
                    node.addFirstChild(childRoot);
                    List<Expression> projectCols = nestedCommand.getProjectedSymbols();
                    SymbolMap map = SymbolMap.createSymbolMap(group, projectCols, this.metadata);
                    node.setProperty(NodeConstants.Info.SYMBOL_MAP, map);
                } else {
                    QueryMetadataInterface actualMetadata = this.metadata;
                    if (actualMetadata instanceof TempMetadataAdapter) {
                        actualMetadata = ((TempMetadataAdapter)this.metadata).getMetadata();
                    }
                    ProcessorPlan plan = QueryOptimizer.optimizePlan(toPlan, actualMetadata, this.idGenerator, this.capFinder, this.analysisRecord, this.context);
                    if (nestedCommand instanceof StoredProcedure && plan instanceof ProcedurePlan) {
                        StoredProcedure container = (StoredProcedure)nestedCommand;
                        ProcedurePlan pp = (ProcedurePlan)plan;
                        pp.setUpdateCount(container.getUpdateCount());
                        if (container.returnParameters()) {
                            LinkedList<ElementSymbol> outParams = new LinkedList<ElementSymbol>();
                            for (SPParameter param : container.getParameters()) {
                                if (param.getParameterType() != 4) continue;
                                outParams.add(param.getParameterSymbol());
                            }
                            for (SPParameter param : container.getParameters()) {
                                if (param.getParameterType() != 3 && param.getParameterType() != 2) continue;
                                outParams.add(param.getParameterSymbol());
                            }
                            if (outParams.size() > 0) {
                                pp.setOutParams(outParams);
                            }
                        }
                        pp.setParams(container.getProcedureParameters());
                    }
                    node.setProperty(NodeConstants.Info.PROCESSOR_PLAN, plan);
                }
                if (entries == null) break block14;
                entries.remove(entry);
            }
            catch (Throwable throwable) {
                if (entries != null) {
                    entries.remove(entry);
                }
                throw throwable;
            }
        }
    }

    public PlanningStackEntry createPlanningStackEntry(GroupSymbol group, Command nestedCommand, boolean isUpdateProcedure, Set<PlanningStackEntry> entries) throws TeiidComponentException, QueryMetadataException, QueryPlannerException {
        PlanningStackEntry entry = new PlanningStackEntry(nestedCommand, group);
        if (!entries.add(entry)) {
            if (isUpdateProcedure && !this.metadata.isVirtualGroup(group.getMetadataID())) {
                throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30254, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30254, new Object[]{nestedCommand}));
            }
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID31124, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31124, new Object[]{nestedCommand.getClass().getSimpleName(), group.getNonCorrelationName(), entries}));
        }
        return entry;
    }

    private static PlanNode attachCriteria(PlanNode plan, Criteria criteria, boolean isHaving) {
        List<Criteria> crits = Criteria.separateCriteriaByAnd(criteria);
        for (Criteria crit : crits) {
            PlanNode critNode = RelationalPlanner.createSelectNode(crit, isHaving);
            RelationalPlanner.attachLast(critNode, plan);
            plan = critNode;
        }
        return plan;
    }

    public static PlanNode createSelectNode(Criteria crit, boolean isHaving) {
        PlanNode critNode = NodeFactory.getNewNode(16);
        critNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, crit);
        if (!(!isHaving || ElementCollectorVisitor.getAggregates(crit, false).isEmpty() && ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(crit).isEmpty())) {
            critNode.setProperty(NodeConstants.Info.IS_HAVING, Boolean.TRUE);
        }
        critNode.addGroups(GroupsUsedByElementsVisitor.getGroups(crit));
        critNode.addGroups(GroupsUsedByElementsVisitor.getGroups(critNode.getCorrelatedReferenceElements()));
        return critNode;
    }

    private PlanNode attachGrouping(PlanNode plan, Query query, Collection<AggregateSymbol> aggs, List<OrderBy> parentOrderBys) throws QueryMetadataException, TeiidComponentException {
        GroupBy groupBy = query.getGroupBy();
        List<Expression> groupingCols = null;
        PlanNode groupNode = NodeFactory.getNewNode(128);
        if (groupBy != null) {
            groupingCols = groupBy.getSymbols();
            if (groupBy.isRollup()) {
                groupNode.setProperty(NodeConstants.Info.ROLLUP, Boolean.TRUE);
            }
        }
        Map<Expression, ElementSymbol> mapping = RelationalPlanner.buildGroupingNode(aggs, groupingCols, groupNode, this.context, this.idGenerator).inserseMapping();
        RelationalPlanner.attachLast(groupNode, plan);
        HashMap<Expression, Expression> subMapping = null;
        for (Map.Entry<Expression, ElementSymbol> entry : mapping.entrySet()) {
            if (entry.getKey() instanceof ElementSymbol) continue;
            ExpressionMappingVisitor emv = new ExpressionMappingVisitor(null){

                @Override
                public Expression replaceExpression(Expression element) {
                    if (element instanceof ElementSymbol) {
                        return new Reference((ElementSymbol)element);
                    }
                    return element;
                }
            };
            Expression key = (Expression)entry.getKey().clone();
            PostOrderNavigator.doVisit(key, emv);
            if (subMapping == null) {
                subMapping = new HashMap<Expression, Expression>();
            }
            ElementSymbol value = entry.getValue().clone();
            value.setIsExternalReference(true);
            subMapping.put(key, new Reference(value));
        }
        this.replaceExpressions(query.getHaving(), mapping, subMapping);
        this.replaceExpressions(query.getSelect(), mapping, subMapping);
        this.replaceExpressions(query.getOrderBy(), mapping, subMapping);
        if (parentOrderBys != null) {
            for (OrderBy parentOrderBy : parentOrderBys) {
                this.replaceExpressions(parentOrderBy, mapping, subMapping);
            }
        }
        this.hints.hasAggregates = true;
        return groupNode;
    }

    private void replaceExpressions(LanguageObject lo, Map<Expression, ElementSymbol> mapping, Map<Expression, Expression> subMapping) {
        if (lo == null) {
            return;
        }
        ExpressionMappingVisitor.mapExpressions(lo, mapping);
        if (subMapping != null) {
            for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(lo)) {
                ExpressionMappingVisitor.mapExpressions(container.getCommand(), subMapping);
            }
        }
    }

    public static SymbolMap buildGroupingNode(Collection<AggregateSymbol> aggs, List<? extends Expression> groupingCols, PlanNode groupNode, CommandContext cc, IDGenerator idGenerator) throws QueryMetadataException, TeiidComponentException {
        AliasSymbol as;
        SymbolMap map = new SymbolMap();
        aggs = LanguageObject.Util.deepClone(aggs, AggregateSymbol.class);
        groupingCols = LanguageObject.Util.deepClone(groupingCols, Expression.class);
        GroupSymbol group = new GroupSymbol("anon_grp" + idGenerator.nextInt());
        if (!cc.getGroups().add(group.getName())) {
            group = RulePlaceAccess.recontextSymbol(group, cc.getGroups());
        }
        TempMetadataStore tms = new TempMetadataStore();
        int i = 0;
        LinkedList<AliasSymbol> symbols = new LinkedList<AliasSymbol>();
        LinkedList<Expression> targets = new LinkedList<Expression>();
        if (groupingCols != null) {
            groupNode.setProperty(NodeConstants.Info.GROUP_COLS, groupingCols);
            groupNode.addGroups(GroupsUsedByElementsVisitor.getGroups(groupingCols));
            for (Expression expression : groupingCols) {
                as = new AliasSymbol("gcol" + i++, new ExpressionSymbol("expr", expression));
                targets.add(expression);
                symbols.add(as);
            }
        }
        i = 0;
        for (AggregateSymbol aggregateSymbol : aggs) {
            as = new AliasSymbol("agg" + i++, new ExpressionSymbol("expr", aggregateSymbol));
            targets.add(aggregateSymbol);
            symbols.add(as);
        }
        group.setMetadataID(tms.addTempGroup(group.getName(), symbols, true, false));
        Iterator targetIter = targets.iterator();
        for (ElementSymbol es : ResolverUtil.resolveElementsInGroup(group, new TempMetadataAdapter(new BasicQueryMetadata(), tms))) {
            Expression target = (Expression)targetIter.next();
            es.setAggregate(target instanceof AggregateSymbol);
            map.addMapping(es, target);
        }
        groupNode.setProperty(NodeConstants.Info.SYMBOL_MAP, map);
        groupNode.addGroup(group);
        return map;
    }

    private static PlanNode attachSorting(PlanNode plan, OrderBy orderBy) {
        PlanNode sortNode = NodeFactory.getNewNode(32);
        sortNode.setProperty(NodeConstants.Info.SORT_ORDER, orderBy);
        if (orderBy.hasUnrelated()) {
            sortNode.setProperty(NodeConstants.Info.UNRELATED_SORT, true);
        }
        sortNode.addGroups(GroupsUsedByElementsVisitor.getGroups(orderBy));
        RelationalPlanner.attachLast(sortNode, plan);
        return sortNode;
    }

    private static PlanNode attachTupleLimit(PlanNode plan, Limit limit, PlanHints hints) {
        hints.hasLimit = true;
        PlanNode limitNode = NodeFactory.getNewNode(1024);
        boolean attach = false;
        if (limit.getOffset() != null) {
            limitNode.setProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT, limit.getOffset());
            attach = true;
        }
        if (limit.getRowLimit() != null) {
            limitNode.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, limit.getRowLimit());
            attach = true;
        }
        if (attach) {
            if (limit.isImplicit()) {
                limitNode.setProperty(NodeConstants.Info.IS_IMPLICIT_LIMIT, true);
            }
            if (!limit.isStrict()) {
                limitNode.setProperty(NodeConstants.Info.IS_NON_STRICT, true);
            }
            RelationalPlanner.attachLast(limitNode, plan);
            plan = limitNode;
        }
        return plan;
    }

    private static PlanNode attachDupRemoval(PlanNode plan) {
        PlanNode dupNode = NodeFactory.getNewNode(2);
        RelationalPlanner.attachLast(dupNode, plan);
        return dupNode;
    }

    private static PlanNode attachProject(PlanNode plan, List<? extends Expression> select) {
        PlanNode projectNode = RelationalPlanner.createProjectNode(select);
        RelationalPlanner.attachLast(projectNode, plan);
        return projectNode;
    }

    public static PlanNode createProjectNode(List<? extends Expression> select) {
        PlanNode projectNode = NodeFactory.getNewNode(8);
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, select);
        projectNode.addGroups(GroupsUsedByElementsVisitor.getGroups(select));
        return projectNode;
    }

    static final void attachLast(PlanNode parent, PlanNode child) {
        if (child != null) {
            parent.addLastChild(child);
        }
    }

    static void mergeTempMetadata(Command childCommand, Command parentCommand) {
        TempMetadataStore childTempMetadata = childCommand.getTemporaryMetadata();
        if (childTempMetadata != null && !childTempMetadata.getData().isEmpty()) {
            TempMetadataStore parentTempMetadata = parentCommand.getTemporaryMetadata();
            if (parentTempMetadata == null) {
                parentCommand.setTemporaryMetadata(childTempMetadata);
            } else {
                parentTempMetadata.getData().putAll(childTempMetadata.getData());
            }
        }
    }

    private Command resolveVirtualGroup(GroupSymbol virtualGroup) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        QueryNode qnode = null;
        Object metadataID = virtualGroup.getMetadataID();
        boolean noCache = RelationalPlanner.isNoCacheGroup(this.metadata, metadataID, this.option);
        boolean isMaterializedGroup = this.metadata.hasMaterialization(metadataID);
        String cacheString = "SELECT";
        if (isMaterializedGroup) {
            boolean isImplicitGlobal;
            Object matMetadataId = this.metadata.getMaterialization(metadataID);
            String matTableName = null;
            CacheHint hint = null;
            boolean bl = isImplicitGlobal = matMetadataId == null;
            if (isImplicitGlobal) {
                TempMetadataID tid = this.context.getGlobalTableStore().getGlobalTempTableMetadataId(metadataID);
                matTableName = tid.getID();
                hint = tid.getCacheHint();
                matMetadataId = tid;
            } else {
                matTableName = this.metadata.getFullName(matMetadataId);
            }
            if (noCache) {
                qnode = this.metadata.getVirtualPlan(metadataID);
                RelationalPlanner.recordAnnotation(this.analysisRecord, "Materialized View", Annotation.Priority.LOW, "SimpleQueryResolver.materialized_table_not_used", virtualGroup, matTableName);
            } else {
                this.context.accessedPlanningObject(matMetadataId);
                qnode = new QueryNode(null);
                ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
                for (ElementSymbol el : ResolverUtil.resolveElementsInGroup(virtualGroup, this.metadata)) {
                    symbols.add(new ElementSymbol(el.getShortName()));
                }
                Query query = this.createMatViewQuery(metadataID, matMetadataId, matTableName, symbols, isImplicitGlobal);
                query.setCacheHint(hint);
                qnode.setCommand(query);
                cacheString = "matview";
                RelationalPlanner.recordAnnotation(this.analysisRecord, "Materialized View", Annotation.Priority.LOW, "SimpleQueryResolver.Query_was_redirected_to_Mat_table", virtualGroup, matTableName);
            }
        } else {
            qnode = this.metadata.getVirtualPlan(metadataID);
        }
        Command result = (Command)QueryResolver.resolveView(virtualGroup, qnode, cacheString, this.metadata, false).getCommand().clone();
        return QueryRewriter.rewrite(result, this.metadata, this.context);
    }

    public static Query createMatViewQuery(Object matMetadataId, String matTableName, List<? extends Expression> select, boolean isGlobal) {
        Query query = new Query();
        query.setSelect(new Select(select));
        GroupSymbol gs = new GroupSymbol(matTableName);
        gs.setGlobalTable(isGlobal);
        gs.setMetadataID(matMetadataId);
        query.setFrom(new From(Arrays.asList(new UnaryFromClause(gs))));
        return query;
    }

    public Query createMatViewQuery(Object viewMatadataId, Object matMetadataId, String matTableName, List<? extends Expression> select, boolean isGlobal) throws QueryMetadataException, TeiidComponentException {
        Query query = new Query();
        query.setSelect(new Select(select));
        GroupSymbol gs = new GroupSymbol(matTableName);
        gs.setGlobalTable(isGlobal);
        gs.setMetadataID(matMetadataId);
        query.setFrom(new From(Arrays.asList(new UnaryFromClause(gs))));
        boolean allow = false;
        if (!(viewMatadataId instanceof TempMetadataID)) {
            allow = Boolean.parseBoolean(this.metadata.getExtensionProperty(viewMatadataId, "{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", false));
            allow &= this.metadata.getMaterialization(viewMatadataId) != null;
        }
        if (allow) {
            String onErrorAction;
            String statusTableName = this.metadata.getExtensionProperty(viewMatadataId, "{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE", false);
            String scope = this.metadata.getExtensionProperty(viewMatadataId, "{http://www.teiid.org/ext/relational/2012}MATVIEW_SHARE_SCOPE", false);
            if (scope == null) {
                scope = MaterializationMetadataRepository.Scope.NONE.name();
            }
            if ((onErrorAction = this.metadata.getExtensionProperty(viewMatadataId, "{http://www.teiid.org/ext/relational/2012}MATVIEW_ONERROR_ACTION", false)) == null || !MaterializationMetadataRepository.ErrorAction.IGNORE.name().equalsIgnoreCase(onErrorAction)) {
                String schemaName = this.metadata.getName(this.metadata.getModelID(viewMatadataId));
                String viewName = this.metadata.getName(viewMatadataId);
                Constant expr1 = new Constant(schemaName);
                Constant expr2 = new Constant(viewName);
                ElementSymbol expr3 = new ElementSymbol("Valid");
                ElementSymbol expr4 = new ElementSymbol("LoadState");
                Query subquery = new Query();
                Select subSelect = new Select();
                subSelect.addSymbol(new Function("mvstatus", new Expression[]{expr1, expr2, expr3, expr4, new Constant(onErrorAction)}));
                subquery.setSelect(subSelect);
                GroupSymbol statusTable = new GroupSymbol(statusTableName);
                statusTable.setGlobalTable(false);
                Query one = new Query();
                Select s = new Select();
                s.addSymbol(new Constant(1));
                one.setSelect(s);
                CompoundCriteria cc = null;
                CompareCriteria c1 = new CompareCriteria(new ElementSymbol("VDBName"), 1, new Constant(this.context.getVdbName()));
                CompareCriteria c2 = new CompareCriteria(new ElementSymbol("VDBVersion"), 1, new Constant(String.valueOf(this.context.getVdbVersion())));
                CompareCriteria c3 = new CompareCriteria(new ElementSymbol("SchemaName"), 1, new Constant(schemaName));
                CompareCriteria c4 = new CompareCriteria(new ElementSymbol("Name"), 1, new Constant(viewName));
                if (scope.equalsIgnoreCase(MaterializationMetadataRepository.Scope.NONE.name())) {
                    cc = new CompoundCriteria(0, Arrays.asList(c1, c2, c3, c4));
                } else if (scope.equalsIgnoreCase(MaterializationMetadataRepository.Scope.VDB.name())) {
                    cc = new CompoundCriteria(0, Arrays.asList(c1, c3, c4));
                } else if (scope.equalsIgnoreCase(MaterializationMetadataRepository.Scope.SCHEMA.name())) {
                    cc = new CompoundCriteria(0, Arrays.asList(c3, c4));
                }
                subquery.setFrom(new From(Arrays.asList(new JoinPredicate((FromClause)new SubqueryFromClause("x", (Command)one), (FromClause)new UnaryFromClause(statusTable), JoinType.JOIN_LEFT_OUTER, cc))));
                query.setCriteria(new CompareCriteria(new Constant(1), 1, new ScalarSubquery(subquery)));
            }
        }
        return query;
    }

    public static boolean isNoCacheGroup(QueryMetadataInterface metadata, Object metadataID, Option option) throws QueryMetadataException, TeiidComponentException {
        if (option == null || !option.isNoCache()) {
            return false;
        }
        if (option.getNoCacheGroups() == null || option.getNoCacheGroups().isEmpty()) {
            return true;
        }
        String fullName = metadata.getFullName(metadataID);
        for (String groupName : option.getNoCacheGroups()) {
            if (!groupName.equalsIgnoreCase(fullName)) continue;
            return true;
        }
        return false;
    }

    private static void recordAnnotation(AnalysisRecord analysis, String type, Annotation.Priority priority, String msgKey, Object ... parts) {
        if (analysis.recordAnnotations()) {
            Annotation annotation = new Annotation(type, QueryPlugin.Util.getString(msgKey, parts), null, priority);
            analysis.addAnnotation(annotation);
        }
    }

    private static class WithPlanningState {
        LinkedHashMap<QueryCommand, WithQueryCommand> withList = new LinkedHashMap();
        LinkedHashMap<String, WithQueryCommand> pushdownWith = new LinkedHashMap();
        LinkedHashMap<String, Object> pushdownState = new LinkedHashMap();

        private WithPlanningState() {
        }
    }

    private static class PlanningStackEntry {
        Command command;
        GroupSymbol group;

        public PlanningStackEntry(Command command, GroupSymbol group) {
            this.command = command;
            this.group = group;
        }

        public int hashCode() {
            return HashCodeUtil.hashCode((int)this.group.getMetadataID().hashCode(), (int)this.command.getType());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PlanningStackEntry)) {
                return false;
            }
            PlanningStackEntry other = (PlanningStackEntry)obj;
            return this.group.getMetadataID().equals(other.group.getMetadataID()) && this.command.getType() == other.command.getType();
        }

        public String toString() {
            return this.command.getClass().getSimpleName() + " " + this.group.getNonCorrelationName().toString();
        }
    }
}

