/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.InvalidFunctionException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.GroupInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.IsDistinctCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.proc.ExceptionExpression;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.XMLExists;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;

public class ResolverVisitor
extends LanguageVisitor {
    public static final String TEIID_PASS_THROUGH_TYPE = "teiid:pass-through-type";
    private static final String SYS_PREFIX = "SYS.";
    private Collection<GroupSymbol> groups;
    private GroupContext externalContext;
    protected QueryMetadataInterface metadata;
    private TeiidComponentException componentException;
    private QueryResolverException resolverException;
    private Map<Function, QueryResolverException> unresolvedFunctions;
    private boolean findShortName;
    private List<ElementSymbol> matches = new ArrayList<ElementSymbol>(2);
    private List<GroupSymbol> groupMatches = new ArrayList<GroupSymbol>(2);
    private boolean hasUserDefinedAggregate;

    public ResolverVisitor(QueryMetadataInterface metadata, Collection<GroupSymbol> internalGroups, GroupContext externalContext) {
        this.groups = internalGroups;
        this.externalContext = externalContext;
        this.metadata = metadata;
        this.findShortName = metadata.findShortName();
    }

    public void setGroups(Collection<GroupSymbol> groups) {
        this.groups = groups;
    }

    @Override
    public void visit(ElementSymbol obj) {
        try {
            this.resolveElementSymbol(obj);
        }
        catch (QueryMetadataException e) {
            this.handleException(this.handleUnresolvedElement(obj, e.getMessage()));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    private QueryResolverException handleUnresolvedElement(ElementSymbol symbol, String description) {
        UnresolvedSymbolDescription usd = new UnresolvedSymbolDescription(symbol.toString(), description);
        QueryResolverException e = new QueryResolverException(usd.getDescription());
        e.setUnresolvedSymbols(Arrays.asList(usd));
        return e;
    }

    private void resolveElementSymbol(ElementSymbol elementSymbol) throws TeiidComponentException, QueryResolverException {
        if (elementSymbol.getMetadataID() != null) {
            return;
        }
        String groupContext = null;
        if (elementSymbol.getGroupSymbol() != null) {
            groupContext = elementSymbol.getGroupSymbol().getName();
        }
        String elementShortName = elementSymbol.getShortName();
        if (groupContext != null) {
            groupContext = elementSymbol.getGroupSymbol().getName();
            try {
                if (this.findShortName && this.internalResolveElementSymbol(elementSymbol, null, elementShortName, groupContext)) {
                    elementSymbol.setDisplayMode(ElementSymbol.DisplayMode.SHORT_OUTPUT_NAME);
                    return;
                }
            }
            catch (QueryResolverException queryResolverException) {
            }
            catch (QueryMetadataException queryMetadataException) {
                // empty catch block
            }
        }
        this.internalResolveElementSymbol(elementSymbol, groupContext, elementShortName, null);
    }

    private boolean internalResolveElementSymbol(ElementSymbol elementSymbol, String groupContext, String shortCanonicalName, String expectedGroupContext) throws TeiidComponentException, QueryResolverException {
        List<GroupSymbol> matchedGroups2;
        boolean isExternal = false;
        boolean groupMatched = false;
        GroupContext root = null;
        if (this.groups != null || this.externalContext != null) {
            if (this.groups != null) {
                root = new GroupContext(this.externalContext, this.groups);
            }
            if (root == null) {
                isExternal = true;
                root = this.externalContext;
            }
        } else {
            try {
                matchedGroups2 = new LinkedList<GroupSymbol>();
                if (groupContext != null) {
                    Object groupID = this.metadata.getGroupID(groupContext);
                    GroupSymbol groupSymbol = new GroupSymbol(groupContext);
                    groupSymbol.setMetadataID(groupID);
                    ((LinkedList)matchedGroups2).add(groupSymbol);
                }
                root = new GroupContext(null, matchedGroups2);
            }
            catch (QueryMetadataException matchedGroups2) {
                // empty catch block
            }
        }
        this.matches.clear();
        this.groupMatches.clear();
        while (root != null) {
            matchedGroups2 = ResolverUtil.findMatchingGroups(groupContext, root.getGroups(), this.metadata);
            if (matchedGroups2 != null && !matchedGroups2.isEmpty()) {
                groupMatched = true;
                this.resolveAgainstGroups(shortCanonicalName, matchedGroups2);
                if (this.matches.size() > 1) {
                    throw this.handleUnresolvedElement(elementSymbol, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31117, new Object[]{elementSymbol, this.groupMatches}));
                }
                if (this.matches.size() == 1) break;
            }
            root = root.getParent();
            isExternal = true;
        }
        if (this.matches.isEmpty()) {
            if (groupMatched) {
                throw this.handleUnresolvedElement(elementSymbol, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31118, new Object[]{elementSymbol}));
            }
            throw this.handleUnresolvedElement(elementSymbol, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31119, new Object[]{elementSymbol}));
        }
        ElementSymbol resolvedSymbol = this.matches.get(0);
        GroupSymbol resolvedGroup = this.groupMatches.get(0);
        String oldName = elementSymbol.getOutputName();
        if (expectedGroupContext != null && !ResolverUtil.nameMatchesGroup(expectedGroupContext, resolvedGroup.getName())) {
            return false;
        }
        elementSymbol.setIsExternalReference(isExternal);
        elementSymbol.setType(resolvedSymbol.getType());
        elementSymbol.setMetadataID(resolvedSymbol.getMetadataID());
        elementSymbol.setGroupSymbol(resolvedGroup);
        elementSymbol.setShortName(resolvedSymbol.getShortName());
        if (this.metadata.useOutputName()) {
            elementSymbol.setOutputName(oldName);
        }
        return true;
    }

    private void resolveAgainstGroups(String elementShortName, Collection<GroupSymbol> matchedGroups) throws QueryMetadataException, TeiidComponentException {
        for (GroupSymbol group : matchedGroups) {
            GroupInfo groupInfo = ResolverUtil.getGroupInfo(group, this.metadata);
            ElementSymbol result = groupInfo.getSymbol(elementShortName);
            if (result == null) continue;
            this.matches.add(result);
            this.groupMatches.add(group);
        }
    }

    @Override
    public void visit(BetweenCriteria obj) {
        try {
            this.resolveBetweenCriteria(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CompareCriteria obj) {
        try {
            this.resolveCompareCriteria(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(MatchCriteria obj) {
        try {
            this.resolveMatchCriteria(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SetCriteria obj) {
        try {
            this.resolveSetCriteria(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        if (obj.getCommand() != null) {
            try {
                obj.setLeftExpression(ResolverUtil.resolveSubqueryPredicateCriteria(obj.getLeftExpression(), obj, this.metadata));
            }
            catch (QueryResolverException e) {
                this.handleException(e);
            }
            catch (TeiidComponentException e) {
                this.handleException(e);
            }
        } else {
            try {
                this.resolveQuantifiedCompareArray(obj);
            }
            catch (QueryResolverException e) {
                this.handleException(e);
            }
        }
    }

    private void resolveQuantifiedCompareArray(SubqueryCompareCriteria obj) throws QueryResolverException, AssertionError {
        boolean rightChar;
        boolean leftChar;
        String rightTypeName;
        String leftTypeName;
        Expression leftExpression;
        block8: {
            Class<?> expressionType = obj.getArrayExpression().getType();
            if (expressionType == null || !expressionType.isArray()) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31175, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31175, new Object[]{obj.getArrayExpression(), expressionType}));
            }
            Class<?> rightType = expressionType.getComponentType();
            leftExpression = obj.getLeftExpression();
            this.setDesiredType(leftExpression, rightType, obj);
            if (leftExpression.getType().equals(rightType)) {
                return;
            }
            leftTypeName = DataTypeManager.getDataTypeName(leftExpression.getType());
            rightTypeName = DataTypeManager.getDataTypeName(rightType);
            if (leftExpression.getType() == DataTypeManager.DefaultDataClasses.NULL) {
                obj.setLeftExpression(ResolverUtil.convertExpression(leftExpression, rightTypeName, this.metadata));
                return;
            }
            leftChar = ResolverVisitor.isCharacter(leftExpression, true);
            rightChar = ResolverVisitor.isCharacter(rightType, true);
            if (leftExpression instanceof Constant && (!rightChar || leftChar)) {
                try {
                    obj.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, rightTypeName, this.metadata));
                    return;
                }
                catch (QueryResolverException qre) {
                    if (!leftChar || this.metadata.widenComparisonToString()) break block8;
                    throw qre;
                }
            }
        }
        if (rightChar ^ leftChar && !this.metadata.widenComparisonToString()) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31172, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31172, new Object[]{obj}));
        }
        if (ResolverUtil.canImplicitlyConvert(leftTypeName, rightTypeName)) {
            obj.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, rightTypeName, this.metadata));
            return;
        }
        throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30072, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30072, new Object[]{leftTypeName, rightTypeName, obj}));
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        try {
            obj.setExpression(ResolverUtil.resolveSubqueryPredicateCriteria(obj.getExpression(), obj, this.metadata));
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(IsNullCriteria obj) {
        try {
            this.setDesiredType(obj.getExpression(), DataTypeManager.DefaultDataClasses.OBJECT, obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(IsDistinctCriteria isDistinctCriteria) {
        try {
            ResolverUtil.resolveGroup(isDistinctCriteria.getLeftRowValue(), this.metadata);
            ResolverUtil.resolveGroup(isDistinctCriteria.getRightRowValue(), this.metadata);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(Function obj) {
        try {
            this.resolveFunction(obj, this.metadata.getFunctionLibrary());
            if (obj.isAggregate()) {
                this.hasUserDefinedAggregate = true;
            }
        }
        catch (QueryResolverException e) {
            if (QueryPlugin.Event.TEIID30069.name().equals(e.getCode()) || QueryPlugin.Event.TEIID30067.name().equals(e.getCode())) {
                if (this.unresolvedFunctions == null) {
                    this.unresolvedFunctions = new LinkedHashMap<Function, QueryResolverException>();
                }
                this.unresolvedFunctions.put(obj, e);
            } else {
                this.handleException(e);
            }
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(Array array) {
        try {
            if (array.getComponentType() != null) {
                String type = DataTypeManager.getDataTypeName(array.getComponentType());
                for (int i = 0; i < array.getExpressions().size(); ++i) {
                    Expression expr = array.getExpressions().get(i);
                    this.setDesiredType(expr, array.getComponentType(), array);
                    if (array.getComponentType() == DataTypeManager.DefaultDataClasses.OBJECT) continue;
                    array.getExpressions().set(i, ResolverUtil.convertExpression(expr, type, this.metadata));
                }
            } else {
                ResolverVisitor.resolveComponentType(array);
            }
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    public static void resolveComponentType(Array array) {
        Class type = null;
        for (int i = 0; i < array.getExpressions().size(); ++i) {
            Class<?> baseType;
            Expression expr = array.getExpressions().get(i);
            for (baseType = expr.getType(); baseType != null && baseType.isArray(); baseType = baseType.getComponentType()) {
            }
            if (baseType == DataTypeManager.DefaultDataClasses.NULL) continue;
            if (type == null) {
                type = expr.getType();
                continue;
            }
            if (type == expr.getType()) continue;
            type = DataTypeManager.DefaultDataClasses.OBJECT;
        }
        if (type == null) {
            type = DataTypeManager.DefaultDataClasses.NULL;
        }
        array.setComponentType(type);
    }

    @Override
    public void visit(CaseExpression obj) {
        try {
            this.resolveCaseExpression(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        try {
            this.resolveSearchedCaseExpression(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SetClause obj) {
        String type = DataTypeManager.getDataTypeName(obj.getSymbol().getType());
        try {
            this.setDesiredType(obj.getValue(), obj.getSymbol().getType(), obj);
            obj.setValue(ResolverUtil.convertExpression(obj.getValue(), type, this.metadata));
        }
        catch (QueryResolverException e) {
            this.handleException(new QueryResolverException((Throwable)((Object)e), QueryPlugin.Util.getString("SetClause.resolvingError", new Object[]{obj.getValue(), obj.getSymbol(), type})));
        }
    }

    @Override
    public void visit(XMLSerialize obj) {
        try {
            obj.setExpression(ResolverUtil.convertExpression(obj.getExpression(), "xml", this.metadata));
        }
        catch (QueryResolverException e) {
            this.handleException(new QueryResolverException((Throwable)((Object)e), QueryPlugin.Util.getString("XMLSerialize.resolvingError", new Object[]{obj})));
        }
    }

    @Override
    public void visit(XMLQuery obj) {
        try {
            ResolverUtil.setDesiredType(obj.getPassing(), obj);
            obj.compileXqueryExpression();
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(XMLExists obj) {
        this.visit(obj.getXmlQuery());
    }

    @Override
    public void visit(QueryString obj) {
        try {
            obj.setPath(ResolverUtil.convertExpression(obj.getPath(), "string", this.metadata));
            for (DerivedColumn col : obj.getArgs()) {
                col.setExpression(ResolverUtil.convertExpression(col.getExpression(), "string", this.metadata));
            }
        }
        catch (QueryResolverException e) {
            this.handleException(new QueryResolverException((Throwable)((Object)e), QueryPlugin.Util.getString("XMLQuery.resolvingError", new Object[]{obj})));
        }
    }

    @Override
    public void visit(ExpressionCriteria obj) {
        try {
            obj.setExpression(ResolverUtil.convertExpression(obj.getExpression(), "boolean", this.metadata));
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(ExceptionExpression obj) {
        try {
            if (obj.getErrorCode() != null) {
                obj.setErrorCode(ResolverUtil.convertExpression(obj.getErrorCode(), "integer", this.metadata));
            }
            obj.setMessage(ResolverUtil.convertExpression(obj.getMessage(), "string", this.metadata));
            if (obj.getSqlState() != null) {
                obj.setSqlState(ResolverUtil.convertExpression(obj.getSqlState(), "string", this.metadata));
            }
            ResolverVisitor.checkException(obj.getParent());
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    public static void checkException(Expression obj) throws QueryResolverException {
        if (obj == null || obj instanceof ExceptionExpression) {
            return;
        }
        if (obj instanceof ElementSymbol) {
            ElementSymbol es = (ElementSymbol)obj;
            if (!(es.getMetadataID() instanceof TempMetadataID)) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31120, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31120, new Object[]{obj}));
            }
            TempMetadataID tid = (TempMetadataID)es.getMetadataID();
            if (tid.getType() != Exception.class) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31120, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31120, new Object[]{obj}));
            }
        } else if (obj instanceof Constant) {
            Constant c = (Constant)obj;
            if (!(c.getValue() instanceof Exception)) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31120, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31120, new Object[]{obj}));
            }
        } else {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31120, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31120, new Object[]{obj}));
        }
    }

    @Override
    public void visit(AggregateSymbol obj) {
        if (obj.getCondition() != null) {
            try {
                obj.setCondition(ResolverUtil.convertExpression(obj.getCondition(), "boolean", this.metadata));
            }
            catch (QueryResolverException e) {
                this.handleException(e);
            }
        }
        switch (obj.getAggregateFunction()) {
            case USER_DEFINED: {
                this.visit((Function)obj);
                break;
            }
            case STRING_AGG: {
                try {
                    if (obj.getArgs().length != 2) {
                        throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31140, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31140, new Object[]{obj}));
                    }
                    if (obj.getType() != null) break;
                    Expression arg = obj.getArg(0);
                    Expression arg1 = obj.getArg(1);
                    Class type = null;
                    if (this.isBinary(arg)) {
                        this.setDesiredType(arg1, DataTypeManager.DefaultDataClasses.BLOB, obj);
                        if (this.isBinary(arg1)) {
                            type = DataTypeManager.DefaultDataClasses.BLOB;
                        }
                    } else if (ResolverVisitor.isCharacter(arg, false)) {
                        this.setDesiredType(arg1, DataTypeManager.DefaultDataClasses.CLOB, obj);
                        if (ResolverVisitor.isCharacter(arg1, false)) {
                            type = DataTypeManager.DefaultDataClasses.CLOB;
                        }
                    } else if (arg.getType() == null) {
                        if (this.isBinary(arg1)) {
                            this.setDesiredType(arg, DataTypeManager.DefaultDataClasses.BLOB, obj);
                            if (this.isBinary(arg)) {
                                type = DataTypeManager.DefaultDataClasses.BLOB;
                            }
                        } else if (ResolverVisitor.isCharacter(arg1, false)) {
                            this.setDesiredType(arg, DataTypeManager.DefaultDataClasses.CLOB, obj);
                            if (ResolverVisitor.isCharacter(arg, false)) {
                                type = DataTypeManager.DefaultDataClasses.CLOB;
                            }
                        }
                    }
                    if (type == null) {
                        throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31141, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31141, new Object[]{obj}));
                    }
                    obj.setType(type);
                    break;
                }
                catch (QueryResolverException e) {
                    this.handleException(e);
                }
            }
        }
    }

    static boolean isCharacter(Expression arg, boolean includeChar) {
        Class<?> type = arg.getType();
        return ResolverVisitor.isCharacter(type, includeChar);
    }

    static boolean isCharacter(Class<?> type, boolean includeChar) {
        return type == DataTypeManager.DefaultDataClasses.STRING || type == DataTypeManager.DefaultDataClasses.CLOB || includeChar && type == DataTypeManager.DefaultDataClasses.CHAR;
    }

    private boolean isBinary(Expression arg) {
        return arg.getType() == DataTypeManager.DefaultDataClasses.VARBINARY || arg.getType() == DataTypeManager.DefaultDataClasses.BLOB;
    }

    public TeiidComponentException getComponentException() {
        return this.componentException;
    }

    public QueryResolverException getResolverException() {
        return this.resolverException;
    }

    void handleException(TeiidComponentException e) {
        this.componentException = e;
        this.setAbort(true);
    }

    void handleException(QueryResolverException e) {
        this.resolverException = e;
        this.setAbort(true);
    }

    public void throwException(boolean includeUnresolvedFunctions) throws TeiidComponentException, QueryResolverException {
        if (this.getComponentException() != null) {
            throw this.getComponentException();
        }
        if (this.getResolverException() != null) {
            throw this.getResolverException();
        }
        if (includeUnresolvedFunctions && this.unresolvedFunctions != null && !this.unresolvedFunctions.isEmpty()) {
            throw this.unresolvedFunctions.values().iterator().next();
        }
    }

    void resolveFunction(Function function, FunctionLibrary library) throws QueryResolverException, TeiidComponentException {
        List<FunctionDescriptor> fds;
        if (function.getFunctionDescriptor() != null) {
            return;
        }
        boolean hasArgWithoutType = false;
        Expression[] args = function.getArgs();
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i].getType();
            if (types[i] != null) continue;
            if (!(args[i] instanceof Reference)) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30067, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30067, new Object[]{args[i], function}));
            }
            hasArgWithoutType = true;
        }
        if (FunctionLibrary.isConvert(function) && hasArgWithoutType) {
            Constant constant = (Constant)function.getArg(1);
            Class type = DataTypeManager.getDataTypeClass((String)((String)constant.getValue()));
            this.setDesiredType(function.getArg(0), type, function);
            types[0] = type;
            hasArgWithoutType = false;
        }
        try {
            fds = this.findWithImplicitConversions(library, function, args, types, hasArgWithoutType);
            if (fds.isEmpty()) {
                if (!library.hasFunctionMethod(function.getName(), args.length)) {
                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30068, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30068, new Object[]{function}));
                }
                if (hasArgWithoutType) {
                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30069, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30069, new Object[]{function}));
                }
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30070, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30070, new Object[]{function}));
            }
            if (fds.size() > 1) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31150, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31150, new Object[]{function}));
            }
        }
        catch (InvalidFunctionException e) {
            if (hasArgWithoutType) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30069, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30069, new Object[]{function}));
            }
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31150, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31150, new Object[]{function}));
        }
        FunctionDescriptor fd = fds.get(0);
        if (fd.getMethod().isVarArgs() && fd.getTypes().length == types.length && library.isVarArgArrayParam(fd.getMethod(), types, types.length - 1, fd.getTypes()[types.length - 1])) {
            fd = fd.clone();
            fd.setCalledWithVarArgArrayParam(true);
        }
        if (fd.isSystemFunction("convert") || fd.isSystemFunction("cast")) {
            String dataType = (String)((Constant)args[1]).getValue();
            Class dataTypeClass = DataTypeManager.getDataTypeClass((String)dataType);
            fd = library.findTypedConversionFunction(args[0].getType(), dataTypeClass);
            Class<?> srcTypeClass = args[0].getType();
            if (srcTypeClass != null && dataTypeClass != null && !srcTypeClass.equals(dataTypeClass) && !DataTypeManager.isTransformable(srcTypeClass, (Class)dataTypeClass)) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30071, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30071, new Object[]{DataTypeManager.getDataTypeName(srcTypeClass), dataType}));
            }
        } else if (fd.isSystemFunction("lookup")) {
            ResolverUtil.ResolvedLookup lookup = ResolverUtil.resolveLookup(function, this.metadata);
            fd = library.copyFunctionChangeReturnType(fd, lookup.getReturnElement().getType());
        } else if (fd.isSystemFunction("array_get")) {
            if (args[0].getType() != null && args[0].getType().isArray()) {
                fd = library.copyFunctionChangeReturnType(fd, args[0].getType().getComponentType());
            } else {
                if (function.getType() != null) {
                    this.setDesiredType(args[0], function.getType(), function);
                }
                if (args[0].getType() != DataTypeManager.DefaultDataClasses.OBJECT) {
                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31145, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31145, new Object[]{DataTypeManager.getDataTypeName(args[0].getType()), function}));
                }
            }
        } else if (Boolean.valueOf(fd.getMethod().getProperty(TEIID_PASS_THROUGH_TYPE, false)).booleanValue()) {
            fd = library.copyFunctionChangeReturnType(fd, args[0].getType());
        }
        function.setFunctionDescriptor(fd);
        function.setType(fd.getReturnType());
        if ("SYS".equals(fd.getSchema()) && StringUtil.startsWithIgnoreCase((String)function.getName(), (String)SYS_PREFIX)) {
            function.setName(function.getName().substring(SYS_PREFIX.length()));
        }
    }

    private List<FunctionDescriptor> findWithImplicitConversions(FunctionLibrary library, Function function, Expression[] args, Class<?>[] types, boolean hasArgWithoutType) throws QueryResolverException, TeiidComponentException, InvalidFunctionException {
        FunctionLibrary.ConversionResult cr = library.determineNecessaryConversions(function.getName(), function.getType(), args, types, hasArgWithoutType);
        if (cr.method == null) {
            return Collections.emptyList();
        }
        Class<?>[] newSignature = types;
        if (cr.needsConverion) {
            FunctionDescriptor[] conversions = library.getConverts(cr.method, types);
            newSignature = new Class[conversions.length];
            for (int i = 0; i < conversions.length; ++i) {
                Class<?> newType = types[i];
                if (conversions[i] != null) {
                    newType = conversions[i].getReturnType();
                    this.setDesiredType(args[i], newType, function);
                    if (types[i] != null && newType != DataTypeManager.DefaultDataClasses.OBJECT) {
                        if (args[i] instanceof Constant && newType == DataTypeManager.DefaultDataClasses.TIMESTAMP) {
                            args[i] = ResolverUtil.getProperlyTypedConstant(((Constant)args[i]).getValue(), newType);
                        } else {
                            function.insertConversion(i, conversions[i]);
                        }
                    }
                }
                newSignature[i] = newType;
            }
        }
        String name = cr.method.getFullName();
        return library.findAllFunctions(name, newSignature);
    }

    void resolveBetweenCriteria(BetweenCriteria criteria) throws QueryResolverException, TeiidComponentException {
        Expression exp = criteria.getExpression();
        Expression lower = criteria.getLowerExpression();
        Expression upper = criteria.getUpperExpression();
        this.setDesiredType(exp, lower.getType() == null ? upper.getType() : lower.getType(), criteria);
        this.setDesiredType(lower, exp.getType(), criteria);
        this.setDesiredType(upper, exp.getType(), criteria);
        if (exp.getType() == lower.getType() && exp.getType() == upper.getType()) {
            return;
        }
        String expTypeName = DataTypeManager.getDataTypeName(exp.getType());
        String lowerTypeName = DataTypeManager.getDataTypeName(lower.getType());
        String upperTypeName = DataTypeManager.getDataTypeName(upper.getType());
        String[] types = new String[]{lowerTypeName, upperTypeName};
        Class<?> type = null;
        String commonType = ResolverUtil.getCommonType(types);
        if (commonType != null) {
            type = DataTypeManager.getDataTypeClass((String)commonType);
        }
        boolean exprChar = ResolverVisitor.isCharacter(exp, true);
        if (exp.getType() != DataTypeManager.DefaultDataClasses.NULL) {
            boolean success = true;
            if (!exprChar || this.metadata.widenComparisonToString() || ResolverVisitor.isCharacter(lower, true)) {
                try {
                    criteria.setLowerExpression(ResolverUtil.convertExpression(lower, lowerTypeName, expTypeName, this.metadata));
                    lower = criteria.getLowerExpression();
                    lowerTypeName = DataTypeManager.getDataTypeName(lower.getType());
                }
                catch (QueryResolverException e) {
                    if (lower instanceof Constant && ResolverVisitor.isCharacter(lower, true) && !this.metadata.widenComparisonToString()) {
                        throw e;
                    }
                    if (type == null) {
                        type = lower.getType();
                    }
                    success = false;
                }
            } else {
                success = false;
            }
            if (!exprChar || this.metadata.widenComparisonToString() || ResolverVisitor.isCharacter(upper, true)) {
                try {
                    criteria.setUpperExpression(ResolverUtil.convertExpression(upper, upperTypeName, expTypeName, this.metadata));
                    upper = criteria.getUpperExpression();
                    upperTypeName = DataTypeManager.getDataTypeName(upper.getType());
                }
                catch (QueryResolverException e) {
                    if (lower instanceof Constant && ResolverVisitor.isCharacter(lower, true) && !this.metadata.widenComparisonToString()) {
                        throw e;
                    }
                    if (type == null) {
                        type = upper.getType();
                    }
                    success = false;
                }
            } else {
                success = false;
            }
            if (success) {
                return;
            }
        }
        if (type == null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30072, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30077, new Object[]{criteria}));
        }
        String typeName = DataTypeManager.getDataTypeName((Class)type);
        if (!ResolverVisitor.isCharacter(type, true) || this.metadata.widenComparisonToString() || exp.getType() == DataTypeManager.DefaultDataClasses.NULL) {
            criteria.setExpression(ResolverUtil.convertExpression(exp, expTypeName, typeName, this.metadata));
        } else if (type != exp.getType()) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31172, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31172, new Object[]{criteria}));
        }
        if (lower.getType() != type) {
            if (!this.metadata.widenComparisonToString() && exprChar ^ ResolverVisitor.isCharacter(lower, true)) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31172, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31172, new Object[]{criteria}));
            }
            criteria.setLowerExpression(ResolverUtil.convertExpression(lower, lowerTypeName, typeName, this.metadata));
        }
        if (upper.getType() != type) {
            if (!this.metadata.widenComparisonToString() && exprChar ^ ResolverVisitor.isCharacter(lower, true)) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31172, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31172, new Object[]{criteria}));
            }
            criteria.setUpperExpression(ResolverUtil.convertExpression(upper, upperTypeName, typeName, this.metadata));
        }
    }

    void resolveCompareCriteria(CompareCriteria ccrit) throws QueryResolverException {
        boolean rightChar;
        boolean leftChar;
        String rightTypeName;
        String leftTypeName;
        Expression rightExpression;
        Expression leftExpression;
        block14: {
            block13: {
                leftExpression = ccrit.getLeftExpression();
                rightExpression = ccrit.getRightExpression();
                this.setDesiredType(leftExpression, rightExpression.getType(), ccrit);
                this.setDesiredType(rightExpression, leftExpression.getType(), ccrit);
                if (leftExpression.getType() == rightExpression.getType()) {
                    return;
                }
                leftTypeName = DataTypeManager.getDataTypeName(leftExpression.getType());
                rightTypeName = DataTypeManager.getDataTypeName(rightExpression.getType());
                if (leftExpression.getType() == DataTypeManager.DefaultDataClasses.NULL) {
                    ccrit.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, rightTypeName, this.metadata));
                    return;
                }
                if (rightExpression.getType() == DataTypeManager.DefaultDataClasses.NULL) {
                    ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName, this.metadata));
                    return;
                }
                leftChar = ResolverVisitor.isCharacter(leftExpression, true);
                rightChar = ResolverVisitor.isCharacter(rightExpression, true);
                if (rightExpression instanceof Constant && (!leftChar || rightChar)) {
                    try {
                        ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName, this.metadata));
                        return;
                    }
                    catch (QueryResolverException qre) {
                        if (!rightChar || this.metadata.widenComparisonToString()) break block13;
                        throw qre;
                    }
                }
            }
            if (leftExpression instanceof Constant && (!rightChar || leftChar)) {
                try {
                    ccrit.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, rightTypeName, this.metadata));
                    return;
                }
                catch (QueryResolverException qre) {
                    if (!leftChar || this.metadata.widenComparisonToString()) break block14;
                    throw qre;
                }
            }
        }
        if (rightChar ^ leftChar && !this.metadata.widenComparisonToString()) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31172, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31172, new Object[]{ccrit}));
        }
        if (ResolverUtil.canImplicitlyConvert(leftTypeName, rightTypeName)) {
            ccrit.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, rightTypeName, this.metadata));
            return;
        }
        if (ResolverUtil.canImplicitlyConvert(rightTypeName, leftTypeName)) {
            ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName, this.metadata));
            return;
        }
        String commonType = ResolverUtil.getCommonType(new String[]{leftTypeName, rightTypeName});
        if (commonType == null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30072, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30072, new Object[]{leftTypeName, rightTypeName, ccrit}));
        }
        ccrit.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, commonType, this.metadata));
        ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, commonType, this.metadata));
    }

    void resolveMatchCriteria(MatchCriteria mcrit) throws QueryResolverException {
        this.setDesiredType(mcrit.getLeftExpression(), mcrit.getRightExpression().getType(), mcrit);
        mcrit.setLeftExpression(this.resolveMatchCriteriaExpression(mcrit, mcrit.getLeftExpression()));
        this.setDesiredType(mcrit.getRightExpression(), mcrit.getLeftExpression().getType(), mcrit);
        mcrit.setRightExpression(this.resolveMatchCriteriaExpression(mcrit, mcrit.getRightExpression()));
    }

    Expression resolveMatchCriteriaExpression(MatchCriteria mcrit, Expression expr) throws QueryResolverException {
        String type = DataTypeManager.getDataTypeName(expr.getType());
        Expression result = expr;
        if (type != null && !ResolverVisitor.isCharacter(expr, false)) {
            if (ResolverUtil.canImplicitlyConvert(type, "string")) {
                result = ResolverUtil.convertExpression(expr, type, "string", this.metadata);
            } else if (ResolverUtil.canImplicitlyConvert(type, "clob")) {
                result = ResolverUtil.convertExpression(expr, type, "clob", this.metadata);
            } else {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30074, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30074, new Object[]{mcrit}));
            }
        }
        return result;
    }

    void resolveSetCriteria(SetCriteria scrit) throws QueryResolverException {
        Class<?> exprType = scrit.getExpression().getType();
        if (exprType == null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30075, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30075, new Object[]{scrit.getExpression()}));
        }
        boolean same = true;
        Iterator valIter = scrit.getValues().iterator();
        String[] types = new String[scrit.getValues().size()];
        int i = 0;
        Class<?> type = null;
        while (valIter.hasNext()) {
            Expression value = (Expression)valIter.next();
            if (value.getType() != exprType) {
                same = false;
            }
            types[i++] = DataTypeManager.getDataTypeName(value.getType());
            type = value.getType();
        }
        if (same && type == exprType) {
            return;
        }
        if (!same) {
            String commonType = ResolverUtil.getCommonType(types);
            type = commonType != null ? DataTypeManager.getDataTypeClass((String)commonType) : null;
        }
        String exprTypeName = DataTypeManager.getDataTypeName(exprType);
        boolean attemptConvert = !ResolverVisitor.isCharacter(exprType, true) || this.metadata.widenComparisonToString();
        ArrayList<Expression> newVals = new ArrayList<Expression>(scrit.getValues().size());
        if (scrit.getExpression().getType() != DataTypeManager.DefaultDataClasses.NULL) {
            for (Expression value : scrit.getValues()) {
                this.setDesiredType(value, exprType, scrit);
                if (value.getType() != exprType) {
                    String valTypeName = DataTypeManager.getDataTypeName(value.getType());
                    if (!attemptConvert && !ResolverVisitor.isCharacter(value.getType(), true)) continue;
                    try {
                        newVals.add(ResolverUtil.convertExpression(value, valTypeName, exprTypeName, this.metadata));
                        continue;
                    }
                    catch (QueryResolverException e) {
                        if (value instanceof Constant && ResolverVisitor.isCharacter(value, true) && !this.metadata.widenComparisonToString()) {
                            throw e;
                        }
                        if (type != null) break;
                        type = value.getType();
                        break;
                    }
                }
                newVals.add(value);
            }
            if (newVals.size() == scrit.getValues().size()) {
                scrit.setValues(newVals);
                return;
            }
        }
        if (type == null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30077, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30077, new Object[]{scrit}));
        }
        String setTypeName = DataTypeManager.getDataTypeName(type);
        if (!ResolverVisitor.isCharacter(type, true) || this.metadata.widenComparisonToString() || scrit.getExpression().getType() == DataTypeManager.DefaultDataClasses.NULL) {
            scrit.setExpression(ResolverUtil.convertExpression(scrit.getExpression(), exprTypeName, setTypeName, this.metadata));
        } else if (type != scrit.getExpression().getType()) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31172, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31172, new Object[]{scrit}));
        }
        boolean exprChar = ResolverVisitor.isCharacter(scrit.getExpression(), true);
        newVals.clear();
        for (Expression value : scrit.getValues()) {
            if (value.getType() == null) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30075, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30075, new Object[]{value}));
            }
            if (value.getType() != type) {
                if (!this.metadata.widenComparisonToString() && exprChar ^ ResolverVisitor.isCharacter(value, true)) {
                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31172, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31172, new Object[]{scrit}));
                }
                value = ResolverUtil.convertExpression(value, setTypeName, this.metadata);
            }
            newVals.add(value);
        }
        scrit.setValues(newVals);
    }

    void resolveCaseExpression(CaseExpression obj) throws QueryResolverException {
        String whenTypeName;
        if (obj.getType() != null) {
            return;
        }
        int whenCount = obj.getWhenCount();
        Expression expr = obj.getExpression();
        Class<?> whenType = null;
        Class<?> thenType = null;
        for (int i = 0; i < whenCount; ++i) {
            if (whenType == null) {
                whenType = obj.getWhenExpression(i).getType();
            }
            if (thenType != null) continue;
            thenType = obj.getThenExpression(i).getType();
        }
        Expression elseExpr = obj.getElseExpression();
        if (elseExpr != null && thenType == null) {
            thenType = elseExpr.getType();
        }
        ArrayList<String> whenTypeNames = new ArrayList<String>(whenCount + 1);
        ArrayList<String> thenTypeNames = new ArrayList<String>(whenCount + 1);
        this.setDesiredType(expr, whenType, obj);
        whenTypeNames.add(DataTypeManager.getDataTypeName(expr.getType()));
        Expression when = null;
        Expression then = null;
        boolean whenNotChar = false;
        for (int i = 0; i < whenCount; ++i) {
            when = obj.getWhenExpression(i);
            then = obj.getThenExpression(i);
            this.setDesiredType(when, expr.getType(), obj);
            this.setDesiredType(then, thenType, obj);
            if (!whenTypeNames.contains(DataTypeManager.getDataTypeName(when.getType()))) {
                whenTypeNames.add(DataTypeManager.getDataTypeName(when.getType()));
            }
            if (!ResolverVisitor.isCharacter(when.getType(), true)) {
                whenNotChar = true;
            }
            if (thenTypeNames.contains(DataTypeManager.getDataTypeName(then.getType()))) continue;
            thenTypeNames.add(DataTypeManager.getDataTypeName(then.getType()));
        }
        if (elseExpr != null) {
            this.setDesiredType(elseExpr, thenType, obj);
            if (!thenTypeNames.contains(DataTypeManager.getDataTypeName(elseExpr.getType()))) {
                thenTypeNames.add(DataTypeManager.getDataTypeName(elseExpr.getType()));
            }
        }
        if ((whenTypeName = ResolverUtil.getCommonType(whenTypeNames.toArray(new String[whenTypeNames.size()]))) == null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30079, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30079, new Object[]{"WHEN", obj}));
        }
        if (!this.metadata.widenComparisonToString() && whenNotChar && ResolverVisitor.isCharacter(DataTypeManager.getDataTypeClass((String)whenTypeName), true)) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31172, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31172, new Object[]{obj}));
        }
        String thenTypeName = ResolverUtil.getCommonType(thenTypeNames.toArray(new String[thenTypeNames.size()]));
        if (thenTypeName == null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30079, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30079, new Object[]{"THEN/ELSE", obj}));
        }
        obj.setExpression(ResolverUtil.convertExpression(obj.getExpression(), whenTypeName, this.metadata));
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(ResolverUtil.convertExpression(obj.getWhenExpression(i), whenTypeName, this.metadata));
            thens.add(ResolverUtil.convertExpression(obj.getThenExpression(i), thenTypeName, this.metadata));
        }
        obj.setWhen(whens, thens);
        if (elseExpr != null) {
            obj.setElseExpression(ResolverUtil.convertExpression(elseExpr, thenTypeName, this.metadata));
        }
        obj.setType(DataTypeManager.getDataTypeClass((String)thenTypeName));
    }

    private void setDesiredType(Expression obj, Class<?> type, LanguageObject surrounding) throws QueryResolverException {
        ResolverUtil.setDesiredType(obj, type, surrounding);
        if (!(obj instanceof Function)) {
            return;
        }
        if (this.unresolvedFunctions != null) {
            Function f = (Function)obj;
            if (f.getFunctionDescriptor() != null) {
                return;
            }
            this.unresolvedFunctions.remove(obj);
            obj.acceptVisitor(this);
            QueryResolverException e = this.unresolvedFunctions.get(obj);
            if (e != null) {
                throw e;
            }
        }
    }

    void resolveSearchedCaseExpression(SearchedCaseExpression obj) throws QueryResolverException {
        String thenTypeName;
        if (obj.getType() != null) {
            return;
        }
        int whenCount = obj.getWhenCount();
        Class<?> thenType = null;
        for (int i = 0; i < whenCount; ++i) {
            if (thenType != null) continue;
            thenType = obj.getThenExpression(i).getType();
        }
        Expression elseExpr = obj.getElseExpression();
        if (elseExpr != null && thenType == null) {
            thenType = elseExpr.getType();
        }
        ArrayList<String> thenTypeNames = new ArrayList<String>(whenCount + 1);
        Expression then = null;
        for (int i = 0; i < whenCount; ++i) {
            then = obj.getThenExpression(i);
            this.setDesiredType(then, thenType, obj);
            thenTypeNames.add(DataTypeManager.getDataTypeName(then.getType()));
        }
        if (elseExpr != null) {
            this.setDesiredType(elseExpr, thenType, obj);
            thenTypeNames.add(DataTypeManager.getDataTypeName(elseExpr.getType()));
        }
        if ((thenTypeName = ResolverUtil.getCommonType(thenTypeNames.toArray(new String[thenTypeNames.size()]))) == null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30079, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30079, new Object[]{"THEN/ELSE", obj}));
        }
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(ResolverUtil.convertExpression(obj.getThenExpression(i), thenTypeName, this.metadata));
        }
        obj.setWhen(obj.getWhen(), thens);
        if (elseExpr != null) {
            obj.setElseExpression(ResolverUtil.convertExpression(elseExpr, thenTypeName, this.metadata));
        }
        obj.setType(DataTypeManager.getDataTypeClass((String)thenTypeName));
    }

    public static void resolveLanguageObject(LanguageObject obj, QueryMetadataInterface metadata) throws TeiidComponentException, QueryResolverException {
        ResolverVisitor.resolveLanguageObject(obj, null, metadata);
    }

    public static void resolveLanguageObject(LanguageObject obj, Collection<GroupSymbol> groups, QueryMetadataInterface metadata) throws TeiidComponentException, QueryResolverException {
        ResolverVisitor.resolveLanguageObject(obj, groups, null, metadata);
    }

    public static void resolveLanguageObject(LanguageObject obj, Collection<GroupSymbol> groups, GroupContext externalContext, QueryMetadataInterface metadata) throws TeiidComponentException, QueryResolverException {
        if (obj == null) {
            return;
        }
        ResolverVisitor elementsVisitor = new ResolverVisitor(metadata, groups, externalContext);
        PostOrderNavigator.doVisit(obj, elementsVisitor);
        elementsVisitor.throwException(true);
    }

    public boolean hasUserDefinedAggregate() {
        return this.hasUserDefinedAggregate;
    }
}

