/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.query.QueryPlugin;
import org.teiid.translator.ExecutionFactory;

public class ConnectorManagerRepository
implements Serializable {
    private static final long serialVersionUID = -1611063218178314458L;
    private Map<String, ConnectorManager> repo = new ConcurrentHashMap<String, ConnectorManager>();
    private boolean shared;
    private ExecutionFactoryProvider provider;

    public ConnectorManagerRepository() {
    }

    protected ConnectorManagerRepository(boolean b) {
        this.shared = b;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void addConnectorManager(String connectorName, ConnectorManager mgr) {
        this.repo.put(connectorName, mgr);
    }

    public ConnectorManager getConnectorManager(String connectorName) {
        return this.repo.get(connectorName);
    }

    public Map<String, ConnectorManager> getConnectorManagers() {
        return this.repo;
    }

    public ConnectorManager removeConnectorManager(String connectorName) {
        return this.repo.remove(connectorName);
    }

    public void createConnectorManagers(VDBMetaData deployment, ExecutionFactoryProvider provider) throws ConnectorManagerException {
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            List sourceNames = model.getSourceNames();
            if (sourceNames.size() != new HashSet(sourceNames).size()) {
                throw new ConnectorManagerException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31101, new Object[]{model.getName(), deployment.getName(), deployment.getVersion()}));
            }
            if (sourceNames.size() > 1 && !model.isSupportsMultiSourceBindings()) {
                throw new ConnectorManagerException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31102, new Object[]{model.getName(), deployment.getName(), deployment.getVersion()}));
            }
            for (SourceMappingMetadata source : model.getSourceMappings()) {
                this.createConnectorManager(deployment, provider, source, false);
            }
        }
    }

    public void createConnectorManager(VDBMetaData deployment, ExecutionFactoryProvider provider, SourceMappingMetadata source, boolean replace) throws ConnectorManagerException {
        String name = source.getTranslatorName();
        String connection = source.getConnectionJndiName();
        this.createConnectorManager(source.getName(), name, connection, provider, replace);
    }

    public void createConnectorManager(String sourceName, String translatorName, String jndiName, ExecutionFactoryProvider provider, boolean replace) throws ConnectorManagerException {
        ConnectorManager cm = this.getConnectorManager(sourceName);
        ExecutionFactory<Object, Object> ef = null;
        if (cm != null) {
            if (!cm.getTranslatorName().equals(translatorName) || !EquivalenceUtil.areEqual((Object)cm.getConnectionName(), (Object)jndiName)) {
                if (!replace) {
                    throw new ConnectorManagerException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31103, new Object[]{sourceName}));
                }
                if (cm.getTranslatorName().equals(translatorName)) {
                    ef = cm.getExecutionFactory();
                }
            } else {
                return;
            }
        }
        if (ef == null && (ef = provider.getExecutionFactory(translatorName)) == null) {
            throw new ConnectorManagerException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31146, new Object[]{translatorName}));
        }
        cm = this.createConnectorManager(translatorName, jndiName, ef);
        this.addConnectorManager(sourceName, cm);
    }

    protected ConnectorManager createConnectorManager(String name, String connection, ExecutionFactory<Object, Object> ef) throws ConnectorManagerException {
        return new ConnectorManager(name, connection, ef);
    }

    public void setProvider(ExecutionFactoryProvider provider) {
        this.provider = provider;
    }

    public ExecutionFactoryProvider getProvider() {
        return this.provider;
    }

    public static interface ExecutionFactoryProvider {
        public ExecutionFactory<Object, Object> getExecutionFactory(String var1) throws ConnectorManagerException;
    }

    public static class ConnectorManagerException
    extends TeiidException {
        public ConnectorManagerException(String msg) {
            super(msg);
        }

        public ConnectorManagerException(Throwable t) {
            super(t);
        }
    }
}

