/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.Like;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RulePushSelectCriteria;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class NewCalculateCostUtil {
    public static final int UNKNOWN_JOIN_SCALING = 20;
    public static final float UNKNOWN_VALUE = -1.0f;
    private static final float compareTime = 1.0E-4f;
    private static final float readTime = 0.001f;
    private static final float procNewRequestTime = 1.0f;

    static float computeCostForTree(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        NewCalculateCostUtil.updateCardinality(node, metadata);
        return node.getCardinality();
    }

    static boolean updateCardinality(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Float cost = (Float)node.getProperty(NodeConstants.Info.EST_CARDINALITY);
        boolean updated = false;
        for (PlanNode child : node.getChildren()) {
            updated |= NewCalculateCostUtil.updateCardinality(child, metadata);
        }
        if (cost == null || updated) {
            NewCalculateCostUtil.computeNodeCost(node, metadata);
            return true;
        }
        return false;
    }

    private static void computeNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        switch (node.getType()) {
            case 64: {
                NewCalculateCostUtil.estimateSourceNodeCost(node, metadata);
                break;
            }
            case 16: {
                NewCalculateCostUtil.estimateSelectNodeCost(node, metadata);
                break;
            }
            case 4: {
                NewCalculateCostUtil.estimateJoinNodeCost(node, metadata);
                break;
            }
            case 2: {
                NewCalculateCostUtil.estimateNodeCost(node, FrameUtil.findTopCols(node), metadata);
                break;
            }
            case 128: {
                if (!node.hasCollectionProperty(NodeConstants.Info.GROUP_COLS)) {
                    NewCalculateCostUtil.setCardinalityEstimate(node, Float.valueOf(1.0f), true, metadata);
                    break;
                }
                NewCalculateCostUtil.estimateNodeCost(node, (List)node.getProperty(NodeConstants.Info.GROUP_COLS), metadata);
                break;
            }
            case 1: 
            case 32: {
                PlanNode child = node.getFirstChild();
                Float childCost = (Float)child.getProperty(NodeConstants.Info.EST_CARDINALITY);
                NewCalculateCostUtil.setCardinalityEstimate(node, childCost, true, metadata);
                break;
            }
            case 512: {
                NewCalculateCostUtil.setCardinalityEstimate(node, Float.valueOf(0.0f), true, metadata);
                break;
            }
            case 8: {
                Float childCost = null;
                if (node.getChildCount() != 0) {
                    PlanNode child = node.getFirstChild();
                    childCost = (Float)child.getProperty(NodeConstants.Info.EST_CARDINALITY);
                } else {
                    childCost = Float.valueOf(1.0f);
                }
                NewCalculateCostUtil.setCardinalityEstimate(node, childCost, true, metadata);
                break;
            }
            case 256: {
                NewCalculateCostUtil.estimateSetOpCost(node, metadata);
                break;
            }
            case 1024: {
                Expression limit;
                PlanNode child = node.getFirstChild();
                float childCost = child.getCardinality();
                Expression offset = (Expression)node.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
                Float cost = Float.valueOf(childCost);
                if (childCost != -1.0f && offset instanceof Constant) {
                    float offsetCost = childCost - ((Number)((Constant)offset).getValue()).floatValue();
                    cost = new Float(offsetCost < 0.0f ? 0.0f : offsetCost);
                }
                if ((limit = (Expression)node.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT)) instanceof Constant) {
                    float limitCost = ((Number)((Constant)limit).getValue()).floatValue();
                    cost = cost.floatValue() != -1.0f ? new Float(Math.min(limitCost, cost.floatValue())) : new Float(limitCost);
                }
                NewCalculateCostUtil.setCardinalityEstimate(node, cost, true, metadata);
                break;
            }
        }
    }

    private static void estimateSetOpCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float cost = 0.0f;
        SetQuery.Operation op = (SetQuery.Operation)((Object)node.getProperty(NodeConstants.Info.SET_OPERATION));
        float leftCost = ((Float)node.getFirstChild().getProperty(NodeConstants.Info.EST_CARDINALITY)).floatValue();
        float rightCost = ((Float)node.getLastChild().getProperty(NodeConstants.Info.EST_CARDINALITY)).floatValue();
        if (!node.hasBooleanProperty(NodeConstants.Info.USE_ALL)) {
            leftCost = NewCalculateCostUtil.getDistinctEstimate(node.getFirstChild(), metadata, leftCost);
            rightCost = NewCalculateCostUtil.getDistinctEstimate(node.getLastChild(), metadata, rightCost);
        }
        cost = NewCalculateCostUtil.getCombinedSetEstimate(op, leftCost, rightCost, !node.hasBooleanProperty(NodeConstants.Info.USE_ALL));
        NewCalculateCostUtil.setCardinalityEstimate(node, new Float(cost), true, metadata);
    }

    private static float getCombinedSetEstimate(SetQuery.Operation op, float leftCost, float rightCost, boolean distinct) {
        float cost = leftCost;
        switch (op) {
            case EXCEPT: {
                if (leftCost == -1.0f || rightCost == -1.0f) break;
                cost = Math.max(1.0f, leftCost - 0.5f * rightCost);
                break;
            }
            case INTERSECT: {
                if (rightCost == -1.0f) break;
                if (leftCost != -1.0f) {
                    cost = 0.5f * Math.min(leftCost, rightCost);
                    break;
                }
                cost = rightCost;
                break;
            }
            default: {
                if (leftCost == -1.0f || rightCost == -1.0f) break;
                cost = distinct ? Math.max(leftCost, rightCost) + 0.5f * Math.min(leftCost, rightCost) : rightCost + leftCost;
            }
        }
        return cost;
    }

    private static float getDistinctEstimate(PlanNode node, QueryMetadataInterface metadata, float cost) throws QueryMetadataException, TeiidComponentException {
        PlanNode projectNode = NodeEditor.findNodePreOrder(node, 8);
        float result = cost;
        if (projectNode != null && (result = NewCalculateCostUtil.getNDVEstimate(node.getParent(), metadata, cost, (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS), false)) == -1.0f) {
            if (cost == -1.0f) {
                return -1.0f;
            }
            return cost / 2.0f;
        }
        return result;
    }

    private static void setCardinalityEstimate(PlanNode node, Float bestEstimate, boolean setColEstimates, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        NewCalculateCostUtil.setCardinalityEstimate(node, bestEstimate, setColEstimates, metadata, 1.0f, 1.0f);
    }

    private static void setCardinalityEstimate(PlanNode node, Float bestEstimate, boolean setColEstimates, QueryMetadataInterface metadata, float leftPercent, float rightPercent) throws QueryMetadataException, TeiidComponentException {
        if (bestEstimate == null) {
            bestEstimate = Float.valueOf(-1.0f);
        }
        Float lastEstimate = (Float)node.setProperty(NodeConstants.Info.EST_CARDINALITY, bestEstimate);
        if (!(node.getParent() == null || lastEstimate != null && lastEstimate.equals(bestEstimate))) {
            node.getParent().setProperty(NodeConstants.Info.EST_CARDINALITY, null);
        }
        if (setColEstimates) {
            NewCalculateCostUtil.setColStatEstimates(node, bestEstimate.floatValue(), metadata, leftPercent, rightPercent);
            ColStats stats = (ColStats)node.getProperty(NodeConstants.Info.EST_COL_STATS);
            if (stats != null && node.getType() == 16) {
                float[] val;
                IsNullCriteria isNullCriteria;
                Collection<ElementSymbol> elements;
                Criteria predicateCriteria = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                if (predicateCriteria instanceof CompareCriteria) {
                    float[] val2;
                    CompareCriteria compCrit = (CompareCriteria)predicateCriteria;
                    Collection<ElementSymbol> elements2 = ElementCollectorVisitor.getElements((LanguageObject)compCrit.getLeftExpression(), true);
                    if (elements2.size() == 1 && EvaluatableVisitor.willBecomeConstant(compCrit.getRightExpression()) && (val2 = stats.get(elements2.iterator().next())) != null) {
                        val2[Stat.NNV.ordinal()] = 0.0f;
                        switch (compCrit.getOperator()) {
                            case 1: {
                                val2[Stat.NDV.ordinal()] = 1.0f;
                                val2[Stat.NDV_HIGH.ordinal()] = 1.0f;
                            }
                        }
                    }
                } else if (predicateCriteria instanceof SetCriteria) {
                    float[] val3;
                    SetCriteria setCriteria = (SetCriteria)predicateCriteria;
                    Collection<ElementSymbol> elements3 = ElementCollectorVisitor.getElements((LanguageObject)setCriteria.getExpression(), true);
                    if (elements3.size() == 1 && !setCriteria.isNegated() && (val3 = stats.get(elements3.iterator().next())) != null) {
                        val3[Stat.NNV.ordinal()] = 0.0f;
                        val3[Stat.NDV.ordinal()] = val3[Stat.NDV.ordinal()] == -1.0f ? (float)setCriteria.getNumberOfValues() : Math.min((float)setCriteria.getNumberOfValues(), val3[Stat.NDV.ordinal()]);
                        val3[Stat.NDV_HIGH.ordinal()] = val3[Stat.NDV_HIGH.ordinal()] == -1.0f ? (float)setCriteria.getNumberOfValues() : Math.min((float)setCriteria.getNumberOfValues(), val3[Stat.NDV_HIGH.ordinal()]);
                    }
                } else if (predicateCriteria instanceof IsNullCriteria && (elements = ElementCollectorVisitor.getElements((LanguageObject)(isNullCriteria = (IsNullCriteria)predicateCriteria).getExpression(), true)).size() == 1 && isNullCriteria.isNegated() && (val = stats.get(elements.iterator().next())) != null) {
                    val[Stat.NDV.ordinal()] = 0.0f;
                    val[Stat.NDV_HIGH.ordinal()] = 0.0f;
                }
            }
        }
    }

    private static void estimateJoinNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Iterator<PlanNode> children = node.getChildren().iterator();
        PlanNode child1 = children.next();
        float childCost1 = child1.getCardinality();
        PlanNode child2 = children.next();
        float childCost2 = child2.getCardinality();
        if (childCost1 == -1.0f || childCost2 == -1.0f) {
            NewCalculateCostUtil.setCardinalityEstimate(node, null, true, metadata);
            return;
        }
        JoinType joinType = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
        List joinCriteria = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        float baseCost = childCost1 * childCost2;
        float leftPercent = 1.0f;
        float rightPercent = 1.0f;
        if (joinCriteria != null && !joinCriteria.isEmpty()) {
            ArrayList<Expression> leftExpressions = null;
            ArrayList<Expression> rightExpressions = null;
            List<Criteria> nonEquiJoinCriteria = null;
            if (!node.hasCollectionProperty(NodeConstants.Info.LEFT_EXPRESSIONS)) {
                Set<GroupSymbol> leftGroups = child1.getGroups();
                Set<GroupSymbol> rightGroups = child2.getGroups();
                leftExpressions = new ArrayList<Expression>();
                rightExpressions = new ArrayList<Expression>();
                nonEquiJoinCriteria = new ArrayList<Criteria>();
                RuleChooseJoinStrategy.separateCriteria(leftGroups, rightGroups, leftExpressions, rightExpressions, joinCriteria, nonEquiJoinCriteria);
            } else {
                leftExpressions = (ArrayList<Expression>)node.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS);
                rightExpressions = (ArrayList<Expression>)node.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS);
                nonEquiJoinCriteria = (ArrayList<Criteria>)node.getProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA);
            }
            float leftNdv = NewCalculateCostUtil.getNDVEstimate(child1, metadata, childCost1, leftExpressions, null);
            float rightNdv = NewCalculateCostUtil.getNDVEstimate(child2, metadata, childCost2, rightExpressions, null);
            if (leftNdv != -1.0f && rightNdv != -1.0f) {
                baseCost = childCost1 / leftNdv * (childCost2 / rightNdv) * Math.min(leftNdv, rightNdv);
                leftPercent = leftNdv / Math.max(leftNdv, rightNdv);
                rightPercent = rightNdv / Math.max(leftNdv, rightNdv);
            } else {
                nonEquiJoinCriteria = joinCriteria;
            }
            if (!nonEquiJoinCriteria.isEmpty()) {
                Criteria crit = Criteria.combineCriteria(nonEquiJoinCriteria);
                baseCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(baseCost, node, crit, metadata);
            }
        }
        Float cost = null;
        if (JoinType.JOIN_CROSS.equals(joinType) || JoinType.JOIN_INNER.equals(joinType)) {
            cost = Float.valueOf(baseCost);
        } else if (JoinType.JOIN_FULL_OUTER.equals(joinType)) {
            cost = Float.valueOf(Math.max(childCost1 + childCost2, baseCost));
        } else if (JoinType.JOIN_LEFT_OUTER.equals(joinType)) {
            cost = Float.valueOf(Math.max(childCost1, baseCost));
        } else if (JoinType.JOIN_SEMI.equals(joinType) || JoinType.JOIN_ANTI_SEMI.equals(joinType)) {
            cost = Float.valueOf(Math.min(childCost1, baseCost));
        }
        NewCalculateCostUtil.setCardinalityEstimate(node, cost, true, metadata, leftPercent, rightPercent);
    }

    private static void estimateSelectNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        PlanNode child = node.getFirstChild();
        float childCost = child.getCardinality();
        Criteria selectCriteria = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        float newCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, node, selectCriteria, metadata);
        NewCalculateCostUtil.setCardinalityEstimate(node, Float.valueOf(newCost), true, metadata);
    }

    private static void setColStatEstimates(PlanNode node, float cardinality, QueryMetadataInterface metadata, float leftPercent, float rightPercent) throws QueryMetadataException, TeiidComponentException {
        if (cardinality == -1.0f) {
            return;
        }
        ColStats colStats = null;
        ColStats colStatsOther = null;
        float childCardinality = -1.0f;
        if (node.getChildCount() > 0) {
            childCardinality = node.getFirstChild().getCardinality();
            colStats = (ColStats)node.getFirstChild().getProperty(NodeConstants.Info.EST_COL_STATS);
        }
        float otherChildCardinality = -1.0f;
        List<? extends Expression> outputColsOther = null;
        if (node.getChildCount() > 1) {
            otherChildCardinality = node.getLastChild().getCardinality();
            colStatsOther = (ColStats)node.getLastChild().getProperty(NodeConstants.Info.EST_COL_STATS);
            outputColsOther = NewCalculateCostUtil.getOutputCols(node.getLastChild(), metadata);
        }
        SetQuery.Operation setOp = (SetQuery.Operation)((Object)node.getProperty(NodeConstants.Info.SET_OPERATION));
        List<? extends Expression> outputCols = NewCalculateCostUtil.getOutputCols(node, metadata);
        ColStats newColStats = new ColStats();
        for (int i = 0; i < outputCols.size(); ++i) {
            float[] stats;
            Expression expr = outputCols.get(i);
            float[] newStats = new float[3];
            Arrays.fill(newStats, -1.0f);
            if (childCardinality == -1.0f || setOp != null && (colStats == null || colStatsOther == null)) {
                newStats[Stat.NDV.ordinal()] = cardinality;
                newStats[Stat.NDV_HIGH.ordinal()] = cardinality;
                newStats[Stat.NNV.ordinal()] = 0.0f;
            } else if (setOp != null) {
                stats = colStats.get(expr);
                float[] statsOther = colStatsOther.get(outputColsOther.get(i));
                newStats[Stat.NDV.ordinal()] = Math.min(cardinality, NewCalculateCostUtil.getCombinedSetEstimate(setOp, stats[Stat.NDV.ordinal()], statsOther[Stat.NDV.ordinal()], true));
                newStats[Stat.NDV_HIGH.ordinal()] = Math.min(cardinality, NewCalculateCostUtil.getCombinedSetEstimate(setOp, stats[Stat.NDV_HIGH.ordinal()], statsOther[Stat.NDV_HIGH.ordinal()], true));
                newStats[Stat.NNV.ordinal()] = Math.min(cardinality, NewCalculateCostUtil.getCombinedSetEstimate(setOp, stats[Stat.NNV.ordinal()], statsOther[Stat.NNV.ordinal()], !node.hasBooleanProperty(NodeConstants.Info.USE_ALL)));
            } else {
                stats = null;
                float origCardinality = childCardinality;
                boolean left = true;
                if (colStats != null) {
                    stats = colStats.get(expr);
                }
                if (stats == null && colStatsOther != null) {
                    origCardinality = otherChildCardinality;
                    stats = colStatsOther.get(expr);
                    left = false;
                }
                origCardinality = Math.max(1.0f, origCardinality);
                if (stats == null) {
                    if (node.getType() == 8) {
                        HashSet elems = new HashSet();
                        ElementCollectorVisitor.getElements((LanguageObject)expr, elems);
                        newStats[Stat.NDV.ordinal()] = NewCalculateCostUtil.getStat(Stat.NDV, elems, node, childCardinality, metadata);
                        newStats[Stat.NDV_HIGH.ordinal()] = NewCalculateCostUtil.getStat(Stat.NDV_HIGH, elems, node, childCardinality, metadata);
                        newStats[Stat.NNV.ordinal()] = NewCalculateCostUtil.getStat(Stat.NNV, elems, node, childCardinality, metadata);
                    } else {
                        if (node.hasProperty(NodeConstants.Info.GROUP_COLS)) {
                            newStats[Stat.NDV.ordinal()] = cardinality / 3.0f;
                            newStats[Stat.NDV_HIGH.ordinal()] = cardinality / 3.0f;
                        } else {
                            newStats[Stat.NDV.ordinal()] = cardinality;
                            newStats[Stat.NDV_HIGH.ordinal()] = cardinality;
                        }
                        newStats[Stat.NNV.ordinal()] = -1.0f;
                    }
                } else {
                    if (node.getType() == 2 || node.getType() == 128 || node.getType() == 8 || node.getType() == 1) {
                        newStats[Stat.NDV.ordinal()] = Math.min(cardinality, stats[Stat.NDV.ordinal()]);
                        newStats[Stat.NDV_HIGH.ordinal()] = Math.min(cardinality, stats[Stat.NDV_HIGH.ordinal()]);
                    } else if (stats[Stat.NDV.ordinal()] != -1.0f) {
                        newStats[Stat.NDV.ordinal()] = stats[Stat.NDV.ordinal()] * Math.min(left ? leftPercent : rightPercent, cardinality / origCardinality);
                        newStats[Stat.NDV_HIGH.ordinal()] = stats[Stat.NDV_HIGH.ordinal()] * Math.min(left ? leftPercent : rightPercent, cardinality / origCardinality);
                        newStats[Stat.NDV.ordinal()] = Math.max(1.0f, newStats[Stat.NDV.ordinal()]);
                        newStats[Stat.NDV_HIGH.ordinal()] = Math.max(1.0f, newStats[Stat.NDV_HIGH.ordinal()]);
                    }
                    if (stats[Stat.NNV.ordinal()] != -1.0f) {
                        newStats[Stat.NNV.ordinal()] = stats[Stat.NNV.ordinal()] * Math.min(1.0f, cardinality / origCardinality);
                        newStats[Stat.NNV.ordinal()] = Math.max(1.0f, newStats[Stat.NNV.ordinal()]);
                    }
                }
            }
            newColStats.put(expr, newStats);
        }
        node.setProperty(NodeConstants.Info.EST_COL_STATS, newColStats);
    }

    private static void estimateSourceNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float cost = -1.0f;
        if (node.getChildCount() > 0) {
            SymbolMap references = (SymbolMap)node.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
            if (references == null) {
                PlanNode child = node.getFirstChild();
                cost = child.getCardinality();
                SymbolMap symbolMap = (SymbolMap)node.getProperty(NodeConstants.Info.SYMBOL_MAP);
                if (symbolMap != null) {
                    ColStats colStats = (ColStats)child.getProperty(NodeConstants.Info.EST_COL_STATS);
                    if (colStats != null) {
                        List<? extends Expression> outputCols = NewCalculateCostUtil.getOutputCols(node, metadata);
                        ColStats newColStats = new ColStats();
                        for (Expression expression : outputCols) {
                            if (!(expression instanceof ElementSymbol)) continue;
                            ElementSymbol es = (ElementSymbol)expression;
                            Expression ex = symbolMap.getMappedExpression(es);
                            float[] value = colStats.get(ex);
                            if (value == null) {
                                Collection<ElementSymbol> elems = ElementCollectorVisitor.getElements((LanguageObject)ex, true);
                                value = new float[3];
                                value[Stat.NDV.ordinal()] = NewCalculateCostUtil.getStat(Stat.NDV, elems, node, cost, metadata);
                                value[Stat.NDV_HIGH.ordinal()] = NewCalculateCostUtil.getStat(Stat.NDV_HIGH, elems, node, cost, metadata);
                                value[Stat.NNV.ordinal()] = NewCalculateCostUtil.getStat(Stat.NNV, elems, node, cost, metadata);
                            }
                            newColStats.put(es, value);
                        }
                        node.setProperty(NodeConstants.Info.EST_COL_STATS, newColStats);
                    } else {
                        colStats = NewCalculateCostUtil.createColStats(node, metadata, cost);
                        node.setProperty(NodeConstants.Info.EST_COL_STATS, colStats);
                    }
                }
            }
        } else {
            GroupSymbol group = node.getGroups().iterator().next();
            float cardinality = metadata.getCardinality(group.getMetadataID());
            if (cardinality <= -1.0f) {
                cardinality = group.isTempTable() && metadata.getModelID(group.getMetadataID()) == TempMetadataAdapter.TEMP_MODEL ? 256.0f : -1.0f;
            }
            cost = cardinality;
            if (!node.hasProperty(NodeConstants.Info.ATOMIC_REQUEST)) {
                ColStats colStats = NewCalculateCostUtil.createColStats(node, metadata, cost);
                node.setProperty(NodeConstants.Info.EST_COL_STATS, colStats);
            }
        }
        NewCalculateCostUtil.setCardinalityEstimate(node, new Float(cost), false, metadata);
    }

    private static ColStats createColStats(PlanNode node, QueryMetadataInterface metadata, float cardinality) throws QueryMetadataException, TeiidComponentException {
        ColStats colStats = new ColStats();
        List<? extends Expression> outputCols = NewCalculateCostUtil.getOutputCols(node, metadata);
        for (Expression expression : outputCols) {
            if (!(expression instanceof ElementSymbol)) continue;
            ElementSymbol es = (ElementSymbol)expression;
            float[] vals = new float[3];
            float ndv = metadata.getDistinctValues(es.getMetadataID());
            float nnv = metadata.getNullValues(es.getMetadataID());
            float ndv_high = ndv;
            if (cardinality != -1.0f) {
                float groupCardinality;
                if (ndv == -1.0f) {
                    if (NewCalculateCostUtil.usesKey(node, Arrays.asList(expression), metadata)) {
                        ndv = cardinality;
                        nnv = 0.0f;
                    } else {
                        Collection fks = metadata.getForeignKeysInGroup(es.getGroupSymbol().getMetadataID());
                        for (Object fk : fks) {
                            float cardinality2;
                            List fkColumns = metadata.getElementIDsInKey(fk);
                            if (fkColumns.size() != 1 || !fkColumns.get(0).equals(es.getMetadataID())) continue;
                            Object pk = metadata.getPrimaryKeyIDForForeignKeyID(fk);
                            List pkColumns = metadata.getElementIDsInKey(pk);
                            if (pkColumns.size() == 1) {
                                float distinctValues = metadata.getDistinctValues(pkColumns.get(0));
                                ndv = Math.min(cardinality, distinctValues);
                            }
                            if (ndv != -1.0f || (cardinality2 = metadata.getCardinality(metadata.getGroupIDForElementID(pkColumns.get(0)))) == -1.0f) continue;
                            ndv = Math.min(cardinality, cardinality2);
                        }
                    }
                    if (ndv == -1.0f) {
                        ndv = (float)Math.ceil(Math.pow(cardinality, 0.5));
                        ndv_high = cardinality / 2.0f;
                    } else {
                        ndv_high = ndv;
                    }
                }
                if ((groupCardinality = metadata.getCardinality(es.getGroupSymbol().getMetadataID())) != -1.0f && groupCardinality > cardinality) {
                    if (ndv != -1.0f) {
                        ndv *= cardinality / Math.max(1.0f, groupCardinality);
                        ndv = Math.max(ndv, 1.0f);
                        ndv_high = Math.min(ndv_high, groupCardinality);
                    }
                    if (nnv != -1.0f) {
                        nnv *= cardinality / Math.max(1.0f, groupCardinality);
                        nnv = Math.max(nnv, 1.0f);
                    }
                }
            }
            if (es.getType() == DataTypeManager.DefaultDataClasses.BOOLEAN) {
                ndv = ndv == -1.0f ? 2.0f : Math.min(ndv, 2.0f);
                ndv_high = ndv_high == -1.0f ? 2.0f : Math.min(ndv_high, 2.0f);
            } else if (es.getType() == DataTypeManager.DefaultDataClasses.BYTE) {
                ndv = ndv == -1.0f ? 2.0f : Math.min(ndv, 256.0f);
                ndv_high = ndv_high == -1.0f ? 2.0f : Math.min(ndv_high, 256.0f);
            }
            vals[Stat.NDV.ordinal()] = ndv;
            vals[Stat.NNV.ordinal()] = nnv;
            vals[Stat.NDV_HIGH.ordinal()] = ndv_high;
            colStats.put(es, vals);
        }
        return colStats;
    }

    private static List<? extends Expression> getOutputCols(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        List outputCols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        if (outputCols != null) {
            return outputCols;
        }
        PlanNode projectNode = NodeEditor.findNodePreOrder(node, 716);
        if (projectNode != null) {
            node = projectNode;
        }
        if (node.getType() == 8) {
            return (List)node.getProperty(NodeConstants.Info.PROJECT_COLS);
        }
        if (node.getType() == 128) {
            SymbolMap map = (SymbolMap)node.getProperty(NodeConstants.Info.SYMBOL_MAP);
            return map.getKeys();
        }
        LinkedList<ElementSymbol> elements = new LinkedList<ElementSymbol>();
        for (GroupSymbol group : node.getGroups()) {
            elements.addAll(ResolverUtil.resolveElementsInGroup(group, metadata));
        }
        return elements;
    }

    private static void estimateNodeCost(PlanNode node, List expressions, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        PlanNode child = node.getFirstChild();
        float childCost = child.getCardinality();
        if (childCost == -1.0f) {
            NewCalculateCostUtil.setCardinalityEstimate(node, null, true, metadata);
            return;
        }
        float cardinality = NewCalculateCostUtil.getNDVEstimate(node, metadata, childCost, expressions, true);
        NewCalculateCostUtil.setCardinalityEstimate(node, Float.valueOf(cardinality), true, metadata);
    }

    static float getStat(Stat stat, Collection<? extends Expression> elems, PlanNode node, float cardinality, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float result = 1.0f;
        int branch = 0;
        boolean branchFound = false;
        if (elems.size() > 1 && !(elems instanceof Set)) {
            elems = new HashSet<Expression>(elems);
        }
        if (cardinality != -1.0f) {
            cardinality = Math.max(1.0f, cardinality);
        }
        for (Expression expression : elems) {
            ColStats colStats = (ColStats)node.getProperty(NodeConstants.Info.EST_COL_STATS);
            if (node.getChildCount() == 0 && colStats == null) {
                colStats = NewCalculateCostUtil.createColStats(node, metadata, cardinality);
            } else if (colStats == null) {
                for (int i = branch; i < node.getChildCount(); ++i) {
                    PlanNode child = node.getChildren().get(i);
                    colStats = (ColStats)child.getProperty(NodeConstants.Info.EST_COL_STATS);
                    if (colStats == null) continue;
                    float[] stats = colStats.get(expression);
                    if (stats != null) {
                        if (node.getType() != 256) break;
                        branch = i;
                        branchFound = true;
                        break;
                    }
                    colStats = null;
                    if (branchFound) break;
                }
            }
            if (colStats == null) {
                return -1.0f;
            }
            float[] stats = colStats.get(expression);
            if (stats == null || stats[stat.ordinal()] == -1.0f) {
                if (stat == Stat.NDV) {
                    if (expression.getType() == DataTypeManager.DefaultDataClasses.BOOLEAN) {
                        if (elems.size() == 1) {
                            result = 2.0f;
                            continue;
                        }
                        if (cardinality != -1.0f) {
                            result *= Math.max(0.0f, cardinality - 2.0f) / cardinality;
                            continue;
                        }
                        result *= 2.0f;
                        continue;
                    }
                    if (expression.getType() == DataTypeManager.DefaultDataClasses.BYTE) {
                        if (elems.size() == 1) {
                            result = 256.0f;
                            continue;
                        }
                        if (cardinality != -1.0f) {
                            result *= Math.max(0.0f, cardinality - 256.0f) / cardinality;
                            continue;
                        }
                        result *= 256.0f;
                        continue;
                    }
                }
                return -1.0f;
            }
            if (elems.size() == 1) {
                result = stats[stat.ordinal()];
                continue;
            }
            if (cardinality != -1.0f) {
                result *= Math.max(0.0f, cardinality - stats[stat.ordinal()]) / cardinality;
                continue;
            }
            result *= stats[stat.ordinal()];
        }
        if (cardinality == -1.0f) {
            return result;
        }
        if (elems.size() > 1) {
            result = (1.0f - result) * cardinality;
        }
        return Math.min(result, cardinality);
    }

    static float recursiveEstimateCostOfCriteria(float childCost, PlanNode currentNode, Criteria crit, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float cost = childCost;
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            if (compCrit.getOperator() == 1) {
                cost = 0.0f;
            }
            if (NewCalculateCostUtil.isSingleTable(currentNode) && NewCalculateCostUtil.usesKey(compCrit, metadata)) {
                return 1.0f;
            }
            for (Criteria critPart : compCrit.getCriteria()) {
                float nextCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, currentNode, critPart, metadata);
                if (compCrit.getOperator() == 0) {
                    if (nextCost == -1.0f || !((cost = childCost != -1.0f ? (Math.min(cost, nextCost) + cost * nextCost / childCost) / 2.0f : (cost == -1.0f ? nextCost : Math.min(cost, nextCost))) <= 1.0f)) continue;
                    return 1.0f;
                }
                if (nextCost == -1.0f) {
                    return childCost;
                }
                cost += nextCost;
                if (childCost == -1.0f) continue;
                cost = Math.min(cost, childCost);
            }
            if (cost == -1.0f) {
                return childCost;
            }
        } else if (crit instanceof NotCriteria) {
            if (childCost == -1.0f) {
                return -1.0f;
            }
            float nextCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, currentNode, ((NotCriteria)crit).getCriteria(), metadata);
            if (nextCost == -1.0f) {
                return childCost;
            }
            cost -= nextCost;
        } else {
            cost = NewCalculateCostUtil.estimatePredicateCost(childCost, currentNode, (PredicateCriteria)crit, metadata);
            if (cost == -1.0f) {
                return childCost;
            }
        }
        cost = Math.max(cost, 1.0f);
        return cost;
    }

    private static void collectElementsOfValidCriteria(Criteria criteria, Collection<ElementSymbol> elements) {
        IsNullCriteria isNullCriteria;
        if (criteria instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)criteria;
            Iterator<Criteria> iter = compCrit.getCriteria().iterator();
            boolean first = true;
            Collection<ElementSymbol> savedElements = elements;
            if (compCrit.getOperator() == 1) {
                elements = new HashSet<ElementSymbol>();
            }
            while (iter.hasNext()) {
                if (compCrit.getOperator() == 0 || first) {
                    NewCalculateCostUtil.collectElementsOfValidCriteria(iter.next(), elements);
                    first = false;
                    continue;
                }
                HashSet<ElementSymbol> other = new HashSet<ElementSymbol>();
                NewCalculateCostUtil.collectElementsOfValidCriteria(iter.next(), other);
                elements.retainAll(other);
            }
            if (compCrit.getOperator() == 1) {
                savedElements.addAll(elements);
            }
        } else if (criteria instanceof CompareCriteria) {
            CompareCriteria compCrit = (CompareCriteria)criteria;
            if (compCrit.getOperator() == 1) {
                ElementCollectorVisitor.getElements((LanguageObject)compCrit, elements);
            }
        } else if (criteria instanceof MatchCriteria) {
            MatchCriteria matchCriteria = (MatchCriteria)criteria;
            if (!matchCriteria.isNegated()) {
                ElementCollectorVisitor.getElements((LanguageObject)matchCriteria, elements);
            }
        } else if (criteria instanceof AbstractSetCriteria) {
            AbstractSetCriteria setCriteria = (AbstractSetCriteria)criteria;
            if (!setCriteria.isNegated()) {
                ElementCollectorVisitor.getElements((LanguageObject)setCriteria.getExpression(), elements);
            }
        } else if (criteria instanceof IsNullCriteria && !(isNullCriteria = (IsNullCriteria)criteria).isNegated()) {
            ElementCollectorVisitor.getElements((LanguageObject)isNullCriteria.getExpression(), elements);
        }
    }

    private static float estimatePredicateCost(float childCost, PlanNode currentNode, PredicateCriteria predicateCriteria, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float cost = childCost;
        boolean isNegatedPredicateCriteria = false;
        if (predicateCriteria instanceof CompareCriteria) {
            CompareCriteria compCrit = (CompareCriteria)predicateCriteria;
            if (compCrit.isOptional()) {
                return childCost;
            }
            if (compCrit.getOperator() == 1 || compCrit.getOperator() == 2) {
                if (childCost == -1.0f) {
                    if (NewCalculateCostUtil.isSingleTable(currentNode) && EvaluatableVisitor.willBecomeConstant(compCrit.getRightExpression()) && NewCalculateCostUtil.usesKey(compCrit, metadata)) {
                        return 1.0f;
                    }
                    return -1.0f;
                }
                float ndv = NewCalculateCostUtil.getPredicateNDV(compCrit.getLeftExpression(), currentNode, childCost, metadata);
                if (!EvaluatableVisitor.willBecomeConstant(compCrit.getRightExpression())) {
                    float ndv1 = NewCalculateCostUtil.getPredicateNDV(compCrit.getRightExpression(), currentNode, childCost, metadata);
                    ndv = (float)Math.sqrt(ndv * ndv1);
                }
                cost = childCost / ndv;
                if (compCrit.getOperator() == 2) {
                    isNegatedPredicateCriteria = true;
                }
            } else {
                cost = NewCalculateCostUtil.getCostForComparison(childCost, metadata, compCrit);
            }
        } else if (predicateCriteria instanceof MatchCriteria) {
            if (childCost == -1.0f) {
                return -1.0f;
            }
            MatchCriteria matchCriteria = (MatchCriteria)predicateCriteria;
            float ndv = NewCalculateCostUtil.getPredicateNDV(matchCriteria.getLeftExpression(), currentNode, childCost, metadata);
            cost = NewCalculateCostUtil.estimateMatchCost(childCost, ndv, matchCriteria);
            isNegatedPredicateCriteria = matchCriteria.isNegated();
        } else if (predicateCriteria instanceof SetCriteria) {
            SetCriteria setCriteria = (SetCriteria)predicateCriteria;
            if (childCost == -1.0f) {
                if (NewCalculateCostUtil.isSingleTable(currentNode) && NewCalculateCostUtil.usesKey(setCriteria, metadata)) {
                    return setCriteria.getNumberOfValues();
                }
                return -1.0f;
            }
            float ndv = NewCalculateCostUtil.getPredicateNDV(setCriteria.getExpression(), currentNode, childCost, metadata);
            cost = childCost * (float)setCriteria.getNumberOfValues() / ndv;
            isNegatedPredicateCriteria = setCriteria.isNegated();
        } else if (predicateCriteria instanceof SubquerySetCriteria) {
            if (childCost == -1.0f) {
                return -1.0f;
            }
            SubquerySetCriteria setCriteria = (SubquerySetCriteria)predicateCriteria;
            cost = childCost / 3.0f;
            isNegatedPredicateCriteria = setCriteria.isNegated();
        } else if (predicateCriteria instanceof IsNullCriteria) {
            Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, true);
            IsNullCriteria isNullCriteria = (IsNullCriteria)predicateCriteria;
            float nnv = NewCalculateCostUtil.getStat(Stat.NNV, elements, currentNode, childCost, metadata);
            if (nnv == -1.0f) {
                if (childCost == -1.0f) {
                    return -1.0f;
                }
                float ndv = NewCalculateCostUtil.getPredicateNDV(isNullCriteria.getExpression(), currentNode, childCost, metadata);
                cost = (childCost - ndv) / 8.0f;
            } else {
                if (childCost == -1.0f) {
                    if (!isNullCriteria.isNegated()) {
                        return nnv;
                    }
                    return -1.0f;
                }
                cost = nnv;
            }
            isNegatedPredicateCriteria = isNullCriteria.isNegated();
        } else if (predicateCriteria instanceof DependentSetCriteria) {
            if (childCost == -1.0f) {
                return -1.0f;
            }
            DependentSetCriteria dsc = (DependentSetCriteria)predicateCriteria;
            if (dsc.getNdv() == -1.0f) {
                return childCost / 3.0f;
            }
            float ndv = NewCalculateCostUtil.getPredicateNDV(dsc.getExpression(), currentNode, childCost, metadata);
            cost = childCost * dsc.getNdv() / Math.max(1.0f, ndv);
        }
        if (cost == -1.0f) {
            return -1.0f;
        }
        if (cost > childCost) {
            cost = childCost;
        }
        if (isNegatedPredicateCriteria) {
            cost = cost != -1.0f ? Math.max(childCost - cost, 1.0f) : -1.0f;
        }
        return cost;
    }

    private static float getPredicateNDV(LanguageObject object, PlanNode currentNode, float childCost, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements(object, true);
        Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(elements);
        boolean multiGroup = groups.size() > 1;
        float ndv = NewCalculateCostUtil.getStat(Stat.NDV, elements, currentNode, childCost, metadata);
        if (ndv == -1.0f) {
            boolean usesKey = NewCalculateCostUtil.usesKey(elements, metadata);
            ndv = multiGroup ? (usesKey ? (float)Math.ceil(Math.sqrt(childCost)) : (float)Math.ceil(Math.sqrt(childCost) / 4.0)) : (usesKey ? childCost : (float)Math.ceil(Math.sqrt(childCost) / 2.0));
            ndv = Math.max(ndv, 1.0f);
        }
        return ndv;
    }

    private static float estimateMatchCost(float childCost, float ndv, MatchCriteria criteria) {
        Expression matchExpression = criteria.getRightExpression();
        if (matchExpression instanceof Constant && ((Constant)matchExpression).getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            String compareValue = (String)((Constant)matchExpression).getValue();
            if (criteria.getMode() != Like.MatchMode.REGEX && criteria.getEscapeChar() == '\u0000' && compareValue != null && compareValue.indexOf(37) < 0) {
                return childCost / 2.0f * (0.33333334f + 1.0f / ndv);
            }
        } else if (EvaluatableVisitor.willBecomeConstant(criteria.getLeftExpression())) {
            return childCost / ndv;
        }
        return childCost / 3.0f;
    }

    private static float getCostForComparison(float childCost, QueryMetadataInterface metadata, CompareCriteria compCrit) throws TeiidComponentException, QueryMetadataException {
        if (!(compCrit.getLeftExpression() instanceof ElementSymbol) || !(compCrit.getRightExpression() instanceof Constant)) {
            return childCost / 3.0f;
        }
        ElementSymbol element = (ElementSymbol)compCrit.getLeftExpression();
        Class<?> dataType = compCrit.getRightExpression().getType();
        String max = (String)metadata.getMaximumValue(element.getMetadataID());
        String min = (String)metadata.getMinimumValue(element.getMetadataID());
        if (max == null || min == null) {
            return childCost / 3.0f;
        }
        float cost = childCost;
        try {
            float maxValue = 0.0f;
            float minValue = 0.0f;
            Constant value = (Constant)compCrit.getRightExpression();
            float compareValue = 0.0f;
            if (dataType.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                compareValue = ((Timestamp)value.getValue()).getTime();
                maxValue = Timestamp.valueOf(max).getTime();
                minValue = Timestamp.valueOf(min).getTime();
            } else if (dataType.equals(DataTypeManager.DefaultDataClasses.TIME)) {
                compareValue = ((Time)value.getValue()).getTime();
                maxValue = Time.valueOf(max).getTime();
                minValue = Time.valueOf(min).getTime();
            } else if (dataType.equals(DataTypeManager.DefaultDataClasses.DATE)) {
                compareValue = ((Date)value.getValue()).getTime();
                maxValue = Timestamp.valueOf(max).getTime();
                minValue = Timestamp.valueOf(min).getTime();
            } else {
                if (!Number.class.isAssignableFrom(dataType)) {
                    return childCost / 3.0f;
                }
                compareValue = ((Number)value.getValue()).floatValue();
                maxValue = Integer.parseInt(max);
                minValue = Integer.parseInt(min);
            }
            float range = Math.max(maxValue - minValue, 1.0f);
            float costMultiple = 1.0f;
            if (compCrit.getOperator() == 4 || compCrit.getOperator() == 6) {
                costMultiple = (maxValue - compareValue) / range;
                if (compareValue < 0.0f && maxValue < 0.0f) {
                    costMultiple = 1.0f - costMultiple;
                }
            } else if (compCrit.getOperator() == 3 || compCrit.getOperator() == 5) {
                costMultiple = (compareValue - minValue) / range;
                if (compareValue < 0.0f && minValue < 0.0f) {
                    costMultiple = 1.0f - costMultiple;
                }
            }
            if (costMultiple > 1.0f) {
                costMultiple = 1.0f;
            } else if (costMultiple < 0.0f) {
                costMultiple = 0.0f;
            }
            cost = childCost * costMultiple;
        }
        catch (IllegalArgumentException e) {
            LogManager.logWarning((String)"org.teiid.PLANNER", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30029, new Object[0]));
            cost = childCost / 3.0f;
        }
        return cost;
    }

    static boolean usesKey(PlanNode planNode, Collection<? extends Expression> allElements, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        return NewCalculateCostUtil.isSingleTable(planNode) && NewCalculateCostUtil.usesKey(allElements, metadata);
    }

    static boolean isSingleTable(PlanNode planNode) {
        return planNode.getChildCount() == 0 || NodeEditor.findAllNodes(planNode, 64, 260).size() == 1;
    }

    public static boolean usesKey(Criteria crit, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        HashSet<ElementSymbol> elements = new HashSet<ElementSymbol>();
        NewCalculateCostUtil.collectElementsOfValidCriteria(crit, elements);
        return NewCalculateCostUtil.usesKey(elements, metadata);
    }

    public static boolean usesKey(Collection<? extends Expression> allElements, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        return NewCalculateCostUtil.usesKey(allElements, null, metadata, true);
    }

    public static boolean usesKey(Collection<? extends Expression> allElements, Set<GroupSymbol> groups, QueryMetadataInterface metadata, boolean unique) throws QueryMetadataException, TeiidComponentException {
        return NewCalculateCostUtil.getKeyUsed(allElements, groups, metadata, unique) != null;
    }

    public static Object getKeyUsed(Collection<? extends Expression> allElements, Set<GroupSymbol> groups, QueryMetadataInterface metadata, Boolean unique) throws QueryMetadataException, TeiidComponentException {
        if (allElements == null || allElements.size() == 0) {
            return null;
        }
        HashMap<GroupSymbol, ArrayList<Object>> groupMap = new HashMap<GroupSymbol, ArrayList<Object>>();
        for (Expression expression : allElements) {
            Expression ex = SymbolMap.getExpression(expression);
            if (!(ex instanceof ElementSymbol)) continue;
            ElementSymbol element = (ElementSymbol)ex;
            GroupSymbol group = element.getGroupSymbol();
            if (groups != null && !groups.contains(group)) continue;
            ArrayList<Object> elements = (ArrayList<Object>)groupMap.get(group);
            if (elements == null) {
                elements = new ArrayList<Object>();
                groupMap.put(group, elements);
            }
            elements.add(element.getMetadataID());
        }
        for (Map.Entry entry : groupMap.entrySet()) {
            GroupSymbol group = (GroupSymbol)entry.getKey();
            List elements = (List)entry.getValue();
            ArrayList keys = null;
            if (unique != null && unique.booleanValue() || unique == null) {
                keys = metadata.getUniqueKeysInGroup(group.getMetadataID());
            }
            if (unique != null && !unique.booleanValue() || unique == null) {
                keys = keys != null ? new ArrayList(keys) : new ArrayList(2);
                keys.addAll(metadata.getIndexesInGroup(group.getMetadataID()));
            }
            if (keys == null || keys.size() <= 0) continue;
            for (Object key : keys) {
                List keyElements = metadata.getElementIDsInKey(key);
                if (!elements.containsAll(keyElements)) continue;
                return key;
            }
        }
        return null;
    }

    private static float safeLog(float x) {
        return (float)Math.max(1.0, Math.log(x));
    }

    public static DependentCostAnalysis computeCostForDepJoin(PlanNode joinNode, boolean leftIndependent, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws TeiidComponentException, QueryMetadataException, QueryPlannerException {
        PlanNode independentNode = leftIndependent ? joinNode.getFirstChild() : joinNode.getLastChild();
        PlanNode dependentNode = leftIndependent ? joinNode.getLastChild() : joinNode.getFirstChild();
        List independentExpressions = (List)(leftIndependent ? joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS));
        List dependentExpressions = (List)(leftIndependent ? joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS));
        return NewCalculateCostUtil.computeCostForDepJoin(independentNode, dependentNode, independentExpressions, dependentExpressions, metadata, capFinder, context);
    }

    public static DependentCostAnalysis computeCostForDepJoin(PlanNode independentNode, PlanNode dependentNode, List independentExpressions, List dependentExpressions, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        float independentCardinality = NewCalculateCostUtil.computeCostForTree(independentNode, metadata);
        float dependentCardinality = NewCalculateCostUtil.computeCostForTree(dependentNode, metadata);
        DependentCostAnalysis dca = new DependentCostAnalysis();
        dca.maxNdv = new Float[independentExpressions.size()];
        dca.expectedNdv = new Float[independentExpressions.size()];
        if (independentCardinality == -1.0f || dependentCardinality == -1.0f) {
            return dca;
        }
        float processorBatchSize = 256.0f;
        if (context != null) {
            processorBatchSize = context.getProcessorBatchSize();
        }
        RulePushSelectCriteria rpsc = new RulePushSelectCriteria();
        rpsc.setCreatedNodes(new LinkedList<PlanNode>());
        for (int i = 0; i < independentExpressions.size(); ++i) {
            Expression indExpr = (Expression)independentExpressions.get(i);
            Collection<ElementSymbol> indElements = ElementCollectorVisitor.getElements((LanguageObject)indExpr, true);
            float indSymbolNDV = NewCalculateCostUtil.getNDVEstimate(independentNode, metadata, independentCardinality, indElements, true);
            boolean unknownNDV = false;
            if (indSymbolNDV == -1.0f) {
                indSymbolNDV = independentCardinality;
            }
            Expression depExpr = (Expression)dependentExpressions.get(i);
            LinkedList<Expression> depExpressions = new LinkedList<Expression>();
            LinkedList<PlanNode> targets = NewCalculateCostUtil.determineTargets(dependentNode, metadata, capFinder, rpsc, depExpr, depExpressions);
            Iterator exprIter = depExpressions.iterator();
            for (PlanNode target : targets) {
                float[] estimates;
                boolean usesIndex;
                float depTargetCardinality;
                Expression targerDepExpr = (Expression)exprIter.next();
                boolean isAccess = target.getType() == 1;
                PlanNode accessNode = isAccess ? target : NodeEditor.findParent(target, 1);
                float setCriteriaBatchSize = indSymbolNDV;
                if (accessNode != null) {
                    setCriteriaBatchSize = CapabilitiesUtil.getMaxInCriteriaSize(RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata), metadata, capFinder);
                    if (setCriteriaBatchSize < 1.0f) {
                        setCriteriaBatchSize = indSymbolNDV;
                    } else {
                        int numberOfSets = CapabilitiesUtil.getMaxDependentPredicates(RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata), metadata, capFinder);
                        if (numberOfSets > 0) {
                            setCriteriaBatchSize *= (float)Math.max(1, numberOfSets / dependentExpressions.size());
                        }
                    }
                } else if (indSymbolNDV > processorBatchSize) continue;
                Collection<ElementSymbol> depElems = ElementCollectorVisitor.getElements((LanguageObject)targerDepExpr, true);
                if (!isAccess) {
                    while (target.getParent().getType() == 16) {
                        target = target.getParent();
                    }
                }
                if ((depTargetCardinality = NewCalculateCostUtil.computeCostForTree(target, metadata)) == -1.0f) continue;
                float depSymbolNDV = NewCalculateCostUtil.getNDVEstimate(target, metadata, depTargetCardinality, depElems, isAccess ? Boolean.valueOf(true) : null);
                boolean usesKey = NewCalculateCostUtil.usesKey(target, depElems, metadata);
                if (depSymbolNDV == -1.0f) {
                    if (!usesKey) {
                        float indSymbolOrigNDV = indSymbolNDV;
                        float indCardinalityOrig = independentCardinality;
                        PlanNode indOrigNode = FrameUtil.findOriginatingNode(independentNode, GroupsUsedByElementsVisitor.getGroups(indElements));
                        if (indOrigNode != null && (indSymbolOrigNDV = NewCalculateCostUtil.getStat(Stat.NDV, indElements, indOrigNode, indCardinalityOrig = NewCalculateCostUtil.computeCostForTree(indOrigNode, metadata), metadata)) == -1.0f) {
                            indSymbolOrigNDV = indCardinalityOrig * indSymbolNDV / independentCardinality;
                        }
                        depSymbolNDV = Math.max((float)Math.pow(depTargetCardinality, 0.75), Math.min(indSymbolOrigNDV, depTargetCardinality));
                        unknownNDV = true;
                    } else {
                        depSymbolNDV = depTargetCardinality;
                    }
                }
                boolean bl = usesIndex = accessNode != null && usesKey;
                if (!usesKey && accessNode != null && target.getType() == 64 && target.getChildCount() == 0) {
                    usesIndex = NewCalculateCostUtil.usesKey(depElems, target.getGroups(), metadata, false);
                }
                if ((estimates = NewCalculateCostUtil.estimateCost(accessNode, setCriteriaBatchSize, usesIndex, depTargetCardinality, indSymbolNDV, dependentCardinality, depSymbolNDV))[1] < 0.0f) {
                    dca.expectedCardinality = dca.expectedCardinality == null ? Float.valueOf(estimates[0]) : Float.valueOf(Math.min(dca.expectedCardinality.floatValue(), estimates[0]));
                }
                if (unknownNDV || depSymbolNDV > 2.0f * NewCalculateCostUtil.getNDVEstimate(target, metadata, depTargetCardinality, depElems, null)) continue;
                dca.expectedNdv[i] = Float.valueOf(indSymbolNDV);
                float min = 0.0f;
                float max = Math.max(2.1474836E9f, indSymbolNDV);
                float tempNdv = indSymbolNDV;
                for (int j = 0; j < 10; ++j) {
                    if (estimates[1] > 1.0f) {
                        max = tempNdv;
                        tempNdv = (tempNdv + min) / 2.0f;
                    } else {
                        if (!(estimates[1] < 0.0f)) break;
                        min = tempNdv;
                        tempNdv = Math.min(tempNdv * 8.0f + 1.0f, (tempNdv + max) / 2.0f);
                    }
                    estimates = NewCalculateCostUtil.estimateCost(accessNode, setCriteriaBatchSize, usesIndex, depTargetCardinality, tempNdv, dependentCardinality, depSymbolNDV);
                }
                dca.maxNdv[i] = Float.valueOf(indSymbolNDV);
            }
        }
        return dca;
    }

    private static float[] estimateCost(PlanNode accessNode, float setCriteriaBatchSize, boolean usesIndex, float depTargetCardinality, float indSymbolNDV, float dependentCardinality, float depSymbolNDV) {
        float dependentAccessCardinality = Math.min(depTargetCardinality, depTargetCardinality * indSymbolNDV / depSymbolNDV);
        float scaledCardinality = Math.min(dependentCardinality, dependentCardinality * indSymbolNDV / depSymbolNDV);
        float numberComparisons = (usesIndex ? NewCalculateCostUtil.safeLog(depTargetCardinality) : depTargetCardinality) * (usesIndex ? indSymbolNDV : NewCalculateCostUtil.safeLog(indSymbolNDV));
        float newDependentQueries = accessNode == null ? 0.0f : (float)Math.ceil(indSymbolNDV / setCriteriaBatchSize);
        float relativeCost = newDependentQueries * 1.0f;
        float relativeComparisonCost = (numberComparisons - NewCalculateCostUtil.safeLog(scaledCardinality) + (scaledCardinality * NewCalculateCostUtil.safeLog(scaledCardinality) - dependentCardinality * NewCalculateCostUtil.safeLog(dependentCardinality))) * 1.0E-4f;
        float relativeReadCost = (dependentAccessCardinality - depTargetCardinality) * 0.001f;
        return new float[]{scaledCardinality, relativeCost + relativeComparisonCost + relativeReadCost};
    }

    private static LinkedList<PlanNode> determineTargets(PlanNode dependentNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RulePushSelectCriteria rpsc, Expression depExpr, LinkedList<Expression> depExpressions) throws QueryPlannerException, TeiidComponentException {
        LinkedList<PlanNode> targets = new LinkedList<PlanNode>();
        LinkedList<PlanNode> critNodes = new LinkedList<PlanNode>();
        critNodes.add(RelationalPlanner.createSelectNode(new DependentSetCriteria(depExpr, null), false));
        LinkedList<PlanNode> initialTargets = new LinkedList<PlanNode>();
        initialTargets.add(dependentNode);
        while (!critNodes.isEmpty()) {
            DependentSetCriteria dsc;
            PlanNode sourceNode;
            PlanNode critNode = (PlanNode)critNodes.remove();
            PlanNode initial = (PlanNode)initialTargets.remove();
            if (critNode.getGroups().isEmpty() || (sourceNode = FrameUtil.findOriginatingNode(initial, critNode.getGroups())) == null) continue;
            PlanNode target = sourceNode;
            PlanNode accessNode = NodeEditor.findParent(target, 1);
            if (accessNode != null) {
                PlanNode source;
                if (accessNode.hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP)) {
                    targets.clear();
                    break;
                }
                targets.add(accessNode);
                dsc = (DependentSetCriteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                depExpressions.add(dsc.getExpression());
                List<PlanNode> sources = NodeEditor.findAllNodes(target, 64, 64);
                if (sources.size() == 1 && (source = sources.get(0)).getChildCount() == 0) continue;
            }
            if (initial != sourceNode) {
                if (initial.getChildCount() > 1) {
                    initial.addAsParent(critNode);
                } else {
                    initial.getFirstChild().addAsParent(critNode);
                }
                target = rpsc.examinePath(critNode, sourceNode, metadata, capFinder);
                critNode.getParent().replaceChild(critNode, critNode.getFirstChild());
            }
            if (target != sourceNode || sourceNode.getType() == 64 && sourceNode.getChildCount() == 0) {
                if (target.hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP)) {
                    targets.clear();
                    break;
                }
                targets.add(target);
                dsc = (DependentSetCriteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                depExpressions.add(dsc.getExpression());
                continue;
            }
            switch (sourceNode.getType()) {
                case 64: {
                    DependentSetCriteria dsc2;
                    PlanNode child = sourceNode.getFirstChild();
                    child = FrameUtil.findOriginatingNode(child, child.getGroups());
                    if (child != null && child.getType() == 256) {
                        if (target.hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP)) {
                            targets.clear();
                            break;
                        }
                        targets.add(target);
                        dsc2 = (DependentSetCriteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                        depExpressions.add(dsc2.getExpression());
                        break;
                    }
                    if (!rpsc.pushAcrossFrame(sourceNode, critNode, metadata).booleanValue()) {
                        if (target.hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP)) {
                            targets.clear();
                            break;
                        }
                        targets.add(target);
                        dsc2 = (DependentSetCriteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                        depExpressions.add(dsc2.getExpression());
                    }
                    List<PlanNode> createdNodes = rpsc.getCreatedNodes();
                    for (PlanNode planNode : createdNodes) {
                        critNodes.add(planNode);
                        initialTargets.add(planNode.getFirstChild());
                        NodeEditor.removeChildNode(planNode.getParent(), planNode);
                    }
                    rpsc.getCreatedNodes().clear();
                    break;
                }
                case 128: {
                    if (!rpsc.pushAcrossGroupBy(sourceNode, critNode, metadata, false, capFinder)) break;
                    critNodes.add(critNode);
                    initialTargets.add(sourceNode.getFirstChild());
                }
            }
        }
        return targets;
    }

    static float getNDVEstimate(PlanNode indNode, QueryMetadataInterface metadata, float cardinality, Collection<? extends Expression> elems, Boolean useCardinalityIfUnknown) throws QueryMetadataException, TeiidComponentException {
        Set<GroupSymbol> groups;
        PlanNode source;
        float ndv_high;
        if (elems == null || elems.isEmpty()) {
            return cardinality;
        }
        float ndv = NewCalculateCostUtil.getStat(Stat.NDV, elems, indNode, cardinality, metadata);
        if (ndv != -1.0f && (useCardinalityIfUnknown == null || useCardinalityIfUnknown.booleanValue()) && (ndv_high = NewCalculateCostUtil.getStat(Stat.NDV_HIGH, elems, indNode, cardinality, metadata)) != -1.0f) {
            ndv = useCardinalityIfUnknown == null ? (float)Math.sqrt(ndv * ndv_high) : (ndv + ndv_high) / 2.0f;
        }
        if (ndv == -1.0f && (useCardinalityIfUnknown == null || useCardinalityIfUnknown.booleanValue()) && (source = FrameUtil.findOriginatingNode(indNode, groups = GroupsUsedByElementsVisitor.getGroups(elems))) != null) {
            ndv = NewCalculateCostUtil.getStat(Stat.NDV, elems, source, source.getCardinality(), metadata);
            if (ndv == -1.0f) {
                if (useCardinalityIfUnknown != null || source.getChildCount() == 0) {
                    ndv = source.getCardinality();
                }
                if (ndv != -1.0f && !NewCalculateCostUtil.usesKey(source, elems, metadata)) {
                    ndv /= 2.0f;
                }
            }
            if (ndv != -1.0f) {
                while (source != indNode) {
                    float parentCardinality = (source = source.getParent()).getCardinality();
                    if (parentCardinality == -1.0f || !(parentCardinality < ndv)) continue;
                    ndv = parentCardinality;
                }
            }
        }
        if (ndv == -1.0f) {
            if (cardinality == -1.0f) {
                return -1.0f;
            }
            if (NewCalculateCostUtil.usesKey(indNode, elems, metadata)) {
                ndv = cardinality;
            } else if (useCardinalityIfUnknown != null && useCardinalityIfUnknown.booleanValue()) {
                ndv = cardinality / 2.0f;
            } else {
                return -1.0f;
            }
        }
        if (cardinality != -1.0f && cardinality < ndv) {
            ndv = cardinality;
        }
        return Math.max(1.0f, ndv);
    }

    private static class ColStats
    extends LinkedHashMap<Expression, float[]> {
        private ColStats() {
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            int j = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                sb.append(e.getKey());
                sb.append('=');
                sb.append(Arrays.toString((float[])e.getValue()));
                ++j;
                if (!i.hasNext()) continue;
                sb.append(", ");
                if (j <= 3) continue;
                sb.append("...");
                break;
            }
            return sb.append('}').toString();
        }

        @Override
        public float[] put(Expression key, float[] value) {
            return super.put(SymbolMap.getExpression(key), value);
        }

        public float[] get(Expression key) {
            return (float[])super.get(SymbolMap.getExpression(key));
        }
    }

    public static class DependentCostAnalysis {
        Float[] maxNdv;
        Float[] expectedNdv;
        Float expectedCardinality;
    }

    static enum Stat {
        NDV,
        NDV_HIGH,
        NNV;

    }
}

