/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;

public class GroupsUsedByElementsVisitor {
    public static final void getGroups(LanguageObject obj, Collection<GroupSymbol> groups) {
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements(obj, true);
        for (ElementSymbol elementSymbol : elements) {
            if (elementSymbol.getGroupSymbol() == null) continue;
            groups.add(elementSymbol.getGroupSymbol());
        }
    }

    public static final Set<GroupSymbol> getGroups(LanguageObject obj) {
        LinkedHashSet<GroupSymbol> groups = new LinkedHashSet<GroupSymbol>();
        GroupsUsedByElementsVisitor.getGroups(obj, groups);
        return groups;
    }

    public static Set<GroupSymbol> getGroups(Collection<? extends LanguageObject> objects) {
        LinkedHashSet<GroupSymbol> groups = new LinkedHashSet<GroupSymbol>();
        GroupsUsedByElementsVisitor.getGroups(objects, groups);
        return groups;
    }

    public static void getGroups(Collection<? extends LanguageObject> objects, Set<GroupSymbol> groups) {
        for (LanguageObject languageObject : objects) {
            if (languageObject instanceof ElementSymbol) {
                ElementSymbol elem = (ElementSymbol)languageObject;
                groups.add(elem.getGroupSymbol());
                continue;
            }
            GroupsUsedByElementsVisitor.getGroups(languageObject, groups);
        }
    }
}

