/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class RuleRemoveOptionalJoins
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<PlanNode> projectNodes = NodeEditor.findAllNodes(plan, 8);
        HashSet<PlanNode> skipNodes = new HashSet<PlanNode>();
        for (PlanNode projectNode : projectNodes) {
            if (projectNode.getChildCount() == 0 || projectNode.getProperty(NodeConstants.Info.INTO_GROUP) != null) continue;
            PlanNode groupNode = NodeEditor.findNodePreOrder(projectNode, 128, 68);
            if (groupNode != null) {
                projectNode = groupNode;
            }
            Set<GroupSymbol> requiredForOptional = this.getRequiredGroupSymbols(projectNode.getFirstChild());
            boolean done = false;
            while (!done) {
                done = true;
                List<PlanNode> joinNodes = NodeEditor.findAllNodes(projectNode, 4, 64);
                for (PlanNode planNode : joinNodes) {
                    if (skipNodes.contains(planNode)) continue;
                    if (!planNode.getExportedCorrelatedReferences().isEmpty()) {
                        skipNodes.add(planNode);
                        continue;
                    }
                    Set<GroupSymbol> required = this.getRequiredGroupSymbols(planNode);
                    List<PlanNode> removed = this.removeJoin(required, requiredForOptional, planNode, planNode.getFirstChild(), analysisRecord, metadata);
                    if (removed != null) {
                        skipNodes.addAll(removed);
                        done = false;
                        continue;
                    }
                    removed = this.removeJoin(required, requiredForOptional, planNode, planNode.getLastChild(), analysisRecord, metadata);
                    if (removed == null) continue;
                    skipNodes.addAll(removed);
                    done = false;
                }
            }
        }
        return plan;
    }

    private Set<GroupSymbol> getRequiredGroupSymbols(PlanNode planNode) {
        return GroupsUsedByElementsVisitor.getGroups((Collection)planNode.getProperty(NodeConstants.Info.OUTPUT_COLS));
    }

    private List<PlanNode> removeJoin(Set<GroupSymbol> required, Set<GroupSymbol> requiredForOptional, PlanNode joinNode, PlanNode optionalNode, AnalysisRecord record, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean isRight;
        boolean correctFrame = false;
        boolean isOptional = optionalNode.hasBooleanProperty(NodeConstants.Info.IS_OPTIONAL);
        if (isOptional) {
            required = requiredForOptional;
            correctFrame = true;
        }
        if (!Collections.disjoint(optionalNode.getGroups(), required)) {
            return null;
        }
        if (isOptional) {
            HashSet<GroupSymbol> joinGroups = new HashSet<GroupSymbol>();
            PlanNode parentNode = joinNode;
            while (parentNode.getType() != 8) {
                PlanNode current = parentNode;
                parentNode = parentNode.getParent();
                if (current.getType() != 16 && current.getType() != 4) continue;
                Set<GroupSymbol> currentGroups = current.getGroups();
                if (current.getType() == 4) {
                    currentGroups = GroupsUsedByElementsVisitor.getGroups((List)current.getProperty(NodeConstants.Info.JOIN_CRITERIA));
                }
                if (Collections.disjoint(currentGroups, optionalNode.getGroups()) || optionalNode.getGroups().containsAll(currentGroups)) continue;
                boolean wasEmpty = joinGroups.isEmpty();
                boolean modified = joinGroups.addAll(current.getGroups());
                if (wasEmpty || !modified) continue;
                return null;
            }
        }
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        boolean usesKey = false;
        boolean bl = isRight = optionalNode == joinNode.getLastChild();
        if (!isOptional && (jt == JoinType.JOIN_INNER || jt == JoinType.JOIN_LEFT_OUTER && isRight)) {
            usesKey = this.isOptionalUsingKey(joinNode, optionalNode, metadata, isRight);
        }
        if (!(isOptional || usesKey || jt == JoinType.JOIN_LEFT_OUTER && isRight && !RuleRemoveOptionalJoins.useNonDistinctRows(joinNode.getParent()))) {
            return null;
        }
        PlanNode parentNode = joinNode.getParent();
        joinNode.removeChild(optionalNode);
        joinNode.getFirstChild().setProperty(NodeConstants.Info.OUTPUT_COLS, joinNode.getProperty(NodeConstants.Info.OUTPUT_COLS));
        NodeEditor.removeChildNode(parentNode, joinNode);
        joinNode.recordDebugAnnotation(isOptional ? "node was marked as optional " : "node will not affect the results", null, "Removing join node", record, null);
        while (parentNode.getType() != 8) {
            PlanNode current = parentNode;
            parentNode = parentNode.getParent();
            if (correctFrame) {
                List crits;
                if (current.getType() == 16) {
                    if (!Collections.disjoint(current.getGroups(), optionalNode.getGroups())) {
                        current.getFirstChild().setProperty(NodeConstants.Info.OUTPUT_COLS, current.getProperty(NodeConstants.Info.OUTPUT_COLS));
                        NodeEditor.removeChildNode(parentNode, current);
                    }
                } else if (current.getType() == 4 && !Collections.disjoint(current.getGroups(), optionalNode.getGroups()) && (crits = (List)current.getProperty(NodeConstants.Info.JOIN_CRITERIA)) != null && !crits.isEmpty()) {
                    JoinType joinType;
                    Iterator iterator = crits.iterator();
                    while (iterator.hasNext()) {
                        Criteria criteria = (Criteria)iterator.next();
                        if (Collections.disjoint(GroupsUsedByElementsVisitor.getGroups(criteria), optionalNode.getGroups())) continue;
                        iterator.remove();
                    }
                    if (crits.isEmpty() && (joinType = (JoinType)current.getProperty(NodeConstants.Info.JOIN_TYPE)) == JoinType.JOIN_INNER) {
                        current.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_CROSS);
                    }
                }
            } else if (current.getType() != 4) break;
            if (current.getType() != 4) continue;
            current.getGroups().removeAll(optionalNode.getGroups());
        }
        return NodeEditor.findAllNodes(optionalNode, 4);
    }

    private boolean isOptionalUsingKey(PlanNode joinNode, PlanNode optionalNode, QueryMetadataInterface metadata, boolean isRight) throws TeiidComponentException, QueryMetadataException {
        if (optionalNode.getGroups().size() != 1) {
            return false;
        }
        PlanNode left = isRight ? joinNode.getFirstChild() : joinNode.getLastChild();
        LinkedList<Expression> leftExpressions = new LinkedList<Expression>();
        LinkedList<Expression> rightExpressions = new LinkedList<Expression>();
        LinkedList<Criteria> nonEquiJoinCriteria = new LinkedList<Criteria>();
        RuleChooseJoinStrategy.separateCriteria(left.getGroups(), optionalNode.getGroups(), leftExpressions, rightExpressions, (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA), nonEquiJoinCriteria);
        if (!nonEquiJoinCriteria.isEmpty()) {
            for (Criteria crit : nonEquiJoinCriteria) {
                if (Collections.disjoint(GroupsUsedByElementsVisitor.getGroups(crit), optionalNode.getGroups())) continue;
                return false;
            }
        }
        ArrayList<Object> leftIds = new ArrayList<Object>(leftExpressions.size());
        ArrayList<Object> rightIds = new ArrayList<Object>(rightExpressions.size());
        for (Expression expr : leftExpressions) {
            if (!(expr instanceof ElementSymbol)) continue;
            leftIds.add(((ElementSymbol)expr).getMetadataID());
        }
        for (Expression expr : rightExpressions) {
            if (expr instanceof ElementSymbol) {
                rightIds.add(((ElementSymbol)expr).getMetadataID());
                continue;
            }
            return false;
        }
        for (GroupSymbol group : left.getGroups()) {
            Collection fks = metadata.getForeignKeysInGroup(group.getMetadataID());
            for (Object fk : fks) {
                List fkColumns = metadata.getElementIDsInKey(fk);
                if (!leftIds.containsAll(fkColumns)) continue;
                Object pk = metadata.getPrimaryKeyIDForForeignKeyID(fk);
                List pkColumns = metadata.getElementIDsInKey(pk);
                if (rightIds.size() != pkColumns.size() || !rightIds.containsAll(pkColumns)) continue;
                if (!isRight) {
                    JoinUtil.swapJoinChildren(joinNode);
                }
                return true;
            }
        }
        return false;
    }

    static boolean useNonDistinctRows(PlanNode parent) {
        while (parent != null) {
            if (parent.hasBooleanProperty(NodeConstants.Info.IS_DUP_REMOVAL)) {
                return false;
            }
            switch (parent.getType()) {
                case 2: {
                    return false;
                }
                case 256: {
                    if (parent.hasBooleanProperty(NodeConstants.Info.USE_ALL)) break;
                    return false;
                }
                case 128: {
                    LinkedHashSet<AggregateSymbol> aggs = RulePushAggregates.collectAggregates(parent);
                    return AggregateSymbol.areAggregatesCardinalityDependent(aggs);
                }
                case 1024: {
                    if (!FrameUtil.isOrderedOrStrictLimit(parent)) break;
                    return true;
                }
                case 8: {
                    List projectCols = (List)parent.getProperty(NodeConstants.Info.PROJECT_COLS);
                    for (Expression ex : projectCols) {
                        if (!FunctionCollectorVisitor.isNonDeterministic(ex) && ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ex).isEmpty()) continue;
                        return true;
                    }
                    break;
                }
            }
            parent = parent.getParent();
        }
        return true;
    }

    public String toString() {
        return "RemoveOptionalJoins";
    }
}

