/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.xom;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.option.xom.XOMDocumentWrapper;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyAxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.SteppingNavigator;
import net.sf.saxon.tree.util.SteppingNode;
import net.sf.saxon.tree.wrapper.AbstractNodeWrapper;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class XOMNodeWrapper
extends AbstractNodeWrapper
implements VirtualNode,
SiblingCountingNode,
SteppingNode {
    protected Node node;
    protected short nodeKind;
    private XOMNodeWrapper parent;
    protected XOMDocumentWrapper docWrapper;
    protected int index;

    protected XOMNodeWrapper(Node node, XOMNodeWrapper parent, int index) {
        int kind;
        if (node instanceof Element) {
            kind = 1;
        } else if (node instanceof Text) {
            kind = 3;
        } else if (node instanceof Attribute) {
            kind = 2;
        } else if (node instanceof Comment) {
            kind = 8;
        } else if (node instanceof ProcessingInstruction) {
            kind = 7;
        } else if (node instanceof Document) {
            kind = 9;
        } else {
            XOMNodeWrapper.throwIllegalNode(node);
            return;
        }
        this.nodeKind = (short)kind;
        this.node = node;
        this.parent = parent;
        this.index = index;
    }

    protected final XOMNodeWrapper makeWrapper(Node node, XOMDocumentWrapper docWrapper) {
        return this.makeWrapper(node, docWrapper, null, -1);
    }

    protected final XOMNodeWrapper makeWrapper(Node node, XOMDocumentWrapper docWrapper, XOMNodeWrapper parent, int index) {
        if (node == docWrapper.node) {
            return docWrapper;
        }
        XOMNodeWrapper wrapper = new XOMNodeWrapper(node, parent, index);
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    private static void throwIllegalNode(Node node) {
        String str = node == null ? "NULL" : node.getClass() + " instance " + node.toString();
        throw new IllegalArgumentException("Bad node type in XOM! " + str);
    }

    public SequenceIterator iterate() {
        return SingletonIterator.makeIterator((Item)this);
    }

    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public AtomicSequence atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        SchemaType st = this.getSchemaType();
        return st == null ? -1 : st.getFingerprint();
    }

    public SchemaType getSchemaType() {
        if (this.getNodeKind() == 2) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return Untyped.getInstance();
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return other instanceof XOMNodeWrapper && this.node == ((XOMNodeWrapper)other).node;
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String uri) {
        this.docWrapper.baseURI = uri;
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof XOMNodeWrapper) {
            return XOMNodeWrapper.compareOrderFast(this.node, ((XOMNodeWrapper)other).node);
        }
        return -other.compareOrder((NodeInfo)this);
    }

    private static int compareOrderFast(Node first, Node second) {
        if (first == second) {
            return 0;
        }
        ParentNode firstParent = first.getParent();
        ParentNode secondParent = second.getParent();
        if (firstParent == null) {
            if (secondParent != null) {
                return -1;
            }
            return first.hashCode() - second.hashCode();
        }
        if (secondParent == null) {
            return 1;
        }
        if (firstParent == secondParent) {
            int i1 = firstParent.indexOf(first);
            int i2 = firstParent.indexOf(second);
            if (i1 != -1) {
                return i2 != -1 ? i1 - i2 : 1;
            }
            if (i2 != -1) {
                return -1;
            }
            Element elem = (Element)firstParent;
            int i = elem.getAttributeCount();
            while (--i >= 0) {
                Attribute attr = elem.getAttribute(i);
                if (attr == second) {
                    return -1;
                }
                if (attr != first) continue;
                return 1;
            }
            throw new IllegalStateException("should be unreachable");
        }
        int depth1 = 0;
        int depth2 = 0;
        Node p1 = first;
        Node p2 = second;
        while (p1 != null) {
            ++depth1;
            if ((p1 = p1.getParent()) != second) continue;
            return 1;
        }
        while (p2 != null) {
            ++depth2;
            if ((p2 = p2.getParent()) != first) continue;
            return -1;
        }
        p1 = first;
        while (depth1 > depth2) {
            p1 = p1.getParent();
            --depth1;
        }
        p2 = second;
        while (depth2 > depth1) {
            p2 = p2.getParent();
            --depth2;
        }
        while (true) {
            firstParent = p1.getParent();
            secondParent = p2.getParent();
            if (firstParent == null || secondParent == null) {
                return p1.hashCode() - p2.hashCode();
            }
            if (firstParent == secondParent) {
                return firstParent.indexOf(p1) - firstParent.indexOf(p2);
            }
            p1 = firstParent;
            p2 = secondParent;
        }
    }

    public int comparePosition(NodeInfo other) {
        return Navigator.comparePosition((NodeInfo)this, (NodeInfo)other);
    }

    public String getStringValue() {
        return this.node.getValue();
    }

    public CharSequence getStringValueCS() {
        return this.node.getValue();
    }

    public int getNameCode() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                return this.docWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        int nc = this.getNameCode();
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getLocalName();
            }
            case 2: {
                return ((Attribute)this.node).getLocalName();
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
        }
        return "";
    }

    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
        }
        return "";
    }

    public SteppingNode getParent() {
        ParentNode p;
        if (this.parent == null && (p = this.node.getParent()) != null) {
            this.parent = this.makeWrapper((Node)p, this.docWrapper);
        }
        return this.parent;
    }

    public SteppingNode getNextSibling() {
        ParentNode parenti = this.node.getParent();
        if (parenti == null) {
            return null;
        }
        int count = parenti.getChildCount();
        if (this.index != -1) {
            if (this.index + 1 < count) {
                return this.makeWrapper(parenti.getChild(this.index + 1), this.docWrapper, this.parent, this.index + 1);
            }
            return null;
        }
        this.index = parenti.indexOf(this.node);
        if (this.index + 1 < count) {
            return this.makeWrapper(parenti.getChild(this.index + 1), this.docWrapper, this.parent, this.index + 1);
        }
        return null;
    }

    public SteppingNode getPreviousSibling() {
        ParentNode parenti = this.node.getParent();
        if (parenti == null) {
            return null;
        }
        if (this.index != -1) {
            if (this.index - 1 > 0) {
                return this.makeWrapper(parenti.getChild(this.index - 1), this.docWrapper, this.parent, this.index - 1);
            }
            return null;
        }
        this.index = parenti.indexOf(this.node);
        if (this.index - 1 > 0) {
            return this.makeWrapper(parenti.getChild(this.index - 1), this.docWrapper, this.parent, this.index - 1);
        }
        return null;
    }

    public SteppingNode getFirstChild() {
        if (this.node.getChildCount() > 0) {
            for (int i = 0; i < this.node.getChildCount(); ++i) {
                Node n = this.node.getChild(i);
                if (n instanceof DocType) continue;
                return this.makeWrapper(n, this.docWrapper, this, 0);
            }
        }
        return null;
    }

    public SteppingNode getSuccessorElement(SteppingNode anchor, String uri, String local) {
        Node stop = anchor == null ? null : ((XOMNodeWrapper)anchor).node;
        Node next = this.node;
        while ((next = XOMNodeWrapper.getSuccessorNode(next, stop)) != null && (!(next instanceof Element) || uri != null && !uri.equals(((Element)next).getNamespaceURI()) || local != null && !local.equals(((Element)next).getLocalName()))) {
        }
        if (next == null) {
            return null;
        }
        return this.makeWrapper(next, this.docWrapper);
    }

    private static Node getSuccessorNode(Node start, Node anchor) {
        if (start.getChildCount() > 0) {
            return start.getChild(0);
        }
        if (start == anchor) {
            return null;
        }
        Node p = start;
        ParentNode q;
        while ((q = p.getParent()) != null) {
            int i = q.indexOf(p) + 1;
            if (i < q.getChildCount()) {
                return q.getChild(i);
            }
            if (q == anchor) {
                return null;
            }
            p = q;
        }
        return null;
    }

    public int getSiblingPosition() {
        int i;
        if (this.index != -1) {
            return this.index;
        }
        switch (this.nodeKind) {
            case 2: {
                Attribute att = (Attribute)this.node;
                Element p = (Element)att.getParent();
                if (p == null) {
                    return 0;
                }
                int i2 = p.getAttributeCount();
                while (--i2 >= 0) {
                    if (p.getAttribute(i2) != att) continue;
                    this.index = i2;
                    return i2;
                }
                throw new IllegalStateException("XOM node not linked to parent node");
            }
        }
        ParentNode p = this.node.getParent();
        int n = i = p == null ? 0 : p.indexOf(this.node);
        if (i == -1) {
            throw new IllegalStateException("XOM node not linked to parent node");
        }
        this.index = i;
        return this.index;
    }

    protected AxisIterator<NodeInfo> iterateAttributes(NodeTest nodeTest) {
        return new Navigator.AxisFilter((AxisIterator)new AttributeAxisIterator(this, nodeTest), nodeTest);
    }

    protected AxisIterator<NodeInfo> iterateChildren(NodeTest nodeTest) {
        if (this.hasChildNodes()) {
            return new Navigator.AxisFilter((AxisIterator)new ChildAxisIterator(this, true, true, nodeTest), nodeTest);
        }
        return EmptyAxisIterator.emptyAxisIterator();
    }

    protected AxisIterator<NodeInfo> iterateSiblings(NodeTest nodeTest, boolean forwards) {
        return new Navigator.AxisFilter((AxisIterator)new ChildAxisIterator(this, false, forwards, nodeTest), nodeTest);
    }

    protected AxisIterator<NodeInfo> iterateDescendants(NodeTest nodeTest, boolean includeSelf) {
        if (includeSelf) {
            return new SteppingNavigator.DescendantAxisIterator((SteppingNode)this, true, nodeTest);
        }
        if (this.hasChildNodes()) {
            return new SteppingNavigator.DescendantAxisIterator((SteppingNode)this, false, nodeTest);
        }
        return EmptyAxisIterator.emptyAxisIterator();
    }

    public String getAttributeValue(String uri, String local) {
        Attribute att;
        if (this.nodeKind == 1 && (att = ((Element)this.node).getAttribute(local, uri)) != null) {
            return att.getValue();
        }
        return null;
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        if (this.docWrapper.node instanceof Document) {
            return this.docWrapper;
        }
        return null;
    }

    public boolean hasChildNodes() {
        return this.node.getChildCount() > 0;
    }

    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey((SiblingCountingNode)this, (FastStringBuffer)buffer, (boolean)true);
    }

    public long getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)out, (int)copyOptions, (int)locationId);
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        if (this.node instanceof Element) {
            Element elem = (Element)this.node;
            int size = elem.getNamespaceDeclarationCount();
            if (size == 0) {
                return NamespaceBinding.EMPTY_ARRAY;
            }
            NamespaceBinding[] result = buffer == null || size > buffer.length ? new NamespaceBinding[size] : buffer;
            for (int i = 0; i < size; ++i) {
                String prefix = elem.getNamespacePrefix(i);
                String uri = elem.getNamespaceURI(prefix);
                result[i] = new NamespaceBinding(prefix, uri);
            }
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }
        return null;
    }

    public boolean isId() {
        return this.getNodeKind() == 2 && ((Attribute)this.node).getType() == Attribute.Type.ID;
    }

    public boolean isIdref() {
        return this.getNodeKind() == 2 && (((Attribute)this.node).getType() == Attribute.Type.IDREF || ((Attribute)this.node).getType() == Attribute.Type.IDREFS);
    }

    public boolean isNilled() {
        return false;
    }

    public void delete() throws XPathException {
        if (this.parent != null) {
            if (this.nodeKind == 2) {
                ((Element)this.parent.node).removeAttribute((Attribute)this.node);
            } else {
                ((ParentNode)this.parent.node).removeChild(this.node);
            }
        }
    }

    private final class PrecedingAxisIterator
    implements AxisIterator {
        private XOMNodeWrapper start;
        private boolean includeAncestors;
        private Node currNode;
        private ParentNode nextAncestor;
        private NodeInfo current;
        private NodeTest nodeTest;
        private int position;
        private String testLocalName;
        private String testURI;

        public PrecedingAxisIterator(XOMNodeWrapper start, boolean includeAncestors, NodeTest test) {
            this.start = start;
            this.includeAncestors = includeAncestors;
            this.currNode = start.node;
            ParentNode parentNode = this.nextAncestor = includeAncestors ? null : start.node.getParent();
            if (test == AnyNodeTest.getInstance()) {
                test = null;
            } else if (test instanceof NameTest) {
                NameTest nt = (NameTest)test;
                if (nt.getPrimitiveType() == 1) {
                    NamePool pool = XOMNodeWrapper.this.getNamePool();
                    this.testLocalName = pool.getLocalName(nt.getFingerprint());
                    this.testURI = pool.getURI(nt.getFingerprint());
                }
            } else if (test instanceof NodeKindTest && test.getPrimitiveType() == 1) {
                this.testLocalName = "";
                this.testURI = null;
            }
            this.nodeTest = test;
            this.position = 0;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public NodeInfo next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(curr)) {
            }
            if (curr != null) {
                ++this.position;
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            int i;
            while (true) {
                ParentNode p;
                if ((p = this.currNode.getParent()) == null) {
                    return null;
                }
                i = this.currNode.getParent().indexOf(this.currNode) - 1;
                if (i >= 0) {
                    int j;
                    p = p.getChild(i);
                    while ((j = p.getChildCount() - 1) >= 0) {
                        p = p.getChild(j);
                        i = j;
                    }
                } else if (p == this.nextAncestor) {
                    this.nextAncestor = this.nextAncestor.getParent();
                    this.currNode = p;
                    continue;
                }
                this.currNode = p;
                if (this.conforms(this.currNode)) break;
            }
            return XOMNodeWrapper.this.makeWrapper(this.currNode, XOMNodeWrapper.this.docWrapper, null, i);
        }

        private boolean conforms(Node node) {
            if (this.testLocalName != null) {
                if (!(node instanceof Element)) {
                    return false;
                }
                if (this.testURI == null) {
                    return true;
                }
                Element elem = (Element)node;
                return this.testLocalName.equals(elem.getLocalName()) && this.testURI.equals(elem.getNamespaceURI());
            }
            return !(node instanceof DocType);
        }

        public NodeInfo current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        public Sequence atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        public AxisIterator getAnother() {
            return new PrecedingAxisIterator(this.start, this.includeAncestors, this.nodeTest);
        }

        public int getProperties() {
            return 0;
        }
    }

    private final class ChildAxisIterator
    implements AxisIterator {
        private XOMNodeWrapper start;
        private XOMNodeWrapper commonParent;
        private int ix;
        private boolean downwards;
        private boolean forwards;
        private NodeInfo current;
        private ParentNode par;
        private int cursor;
        private NodeTest nodeTest;
        private int position;

        private ChildAxisIterator(XOMNodeWrapper start, boolean downwards, boolean forwards, NodeTest test) {
            this.start = start;
            this.downwards = downwards;
            this.forwards = forwards;
            if (test == AnyNodeTest.getInstance()) {
                test = null;
            }
            this.nodeTest = test;
            this.position = 0;
            this.commonParent = downwards ? start : (XOMNodeWrapper)start.getParent();
            this.par = (ParentNode)this.commonParent.node;
            if (downwards) {
                this.ix = forwards ? 0 : this.par.getChildCount();
            } else {
                this.ix = this.par.indexOf(start.node);
                if (forwards) {
                    ++this.ix;
                }
            }
            this.cursor = this.ix--;
            if (downwards || !forwards) {
                // empty if block
            }
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public NodeInfo next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(curr)) {
            }
            if (curr != null) {
                ++this.position;
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            Node nextChild;
            do {
                if (this.forwards) {
                    if (this.cursor == this.par.getChildCount()) {
                        return null;
                    }
                    nextChild = this.par.getChild(this.cursor++);
                    continue;
                }
                if (this.cursor == 0) {
                    return null;
                }
                nextChild = this.par.getChild(--this.cursor);
            } while (nextChild instanceof DocType);
            XOMNodeWrapper curr = XOMNodeWrapper.this.makeWrapper(nextChild, XOMNodeWrapper.this.docWrapper, this.commonParent, this.ix);
            this.ix += this.forwards ? 1 : -1;
            return curr;
        }

        public NodeInfo current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        public Sequence atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        public AxisIterator getAnother() {
            return new ChildAxisIterator(this.start, this.downwards, this.forwards, this.nodeTest);
        }

        public int getProperties() {
            return 0;
        }
    }

    private final class AttributeAxisIterator
    implements AxisIterator {
        private XOMNodeWrapper start;
        private NodeInfo current;
        private int cursor;
        private NodeTest nodeTest;
        private int position;

        public AttributeAxisIterator(XOMNodeWrapper start, NodeTest test) {
            this.start = start;
            if (test == AnyNodeTest.getInstance()) {
                test = null;
            }
            this.nodeTest = test;
            this.position = 0;
            this.cursor = 0;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public NodeInfo next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(curr)) {
            }
            if (curr != null) {
                ++this.position;
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            Element elem = (Element)this.start.node;
            if (this.cursor == elem.getAttributeCount()) {
                return null;
            }
            XOMNodeWrapper curr = XOMNodeWrapper.this.makeWrapper((Node)elem.getAttribute(this.cursor), XOMNodeWrapper.this.docWrapper, this.start, this.cursor);
            ++this.cursor;
            return curr;
        }

        public NodeInfo current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        public Sequence atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        public AxisIterator getAnother() {
            return new AttributeAxisIterator(this.start, this.nodeTest);
        }

        public int getProperties() {
            return 0;
        }
    }

    private final class AncestorAxisIterator
    implements AxisIterator {
        private XOMNodeWrapper start;
        private boolean includeSelf;
        private NodeInfo current;
        private NodeTest nodeTest;
        private int position;

        public AncestorAxisIterator(XOMNodeWrapper start, boolean includeSelf, NodeTest test) {
            this.start = start;
            if (test == AnyNodeTest.getInstance()) {
                test = null;
            }
            this.nodeTest = test;
            if (!includeSelf) {
                this.current = start;
            }
            this.includeSelf = includeSelf;
            this.position = 0;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public NodeInfo next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(curr)) {
            }
            if (curr != null) {
                ++this.position;
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            this.current = this.current == null ? this.start : this.current.getParent();
            return this.current;
        }

        public NodeInfo current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        public Sequence atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        public AxisIterator getAnother() {
            return new AncestorAxisIterator(this.start, this.includeSelf, this.nodeTest);
        }

        public int getProperties() {
            return 0;
        }
    }
}

