/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminComponentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminPlugin;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.CacheStatistics;
import org.teiid.adminapi.DomainAware;
import org.teiid.adminapi.EngineStatistics;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.WorkerPoolStatistics;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.PropertyDefinitionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.adminapi.jboss.MetadataMapper;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.ObjectConverterUtil;

public class AdminFactory {
    private static final Logger LOGGER = Logger.getLogger(AdminFactory.class.getName());
    private static AdminFactory INSTANCE = new AdminFactory();

    public static AdminFactory getInstance() {
        return INSTANCE;
    }

    public Admin createAdmin(String host, int port, String userName, char[] password, String profileName) throws AdminException {
        AdminImpl admin = (AdminImpl)this.createAdmin(host, port, userName, password);
        if (admin != null) {
            admin.setProfileName(profileName);
        }
        return admin;
    }

    public Admin createAdmin(String host, int port, String userName, char[] password) throws AdminException {
        if (host == null) {
            host = "localhost";
        }
        if (port < 0) {
            port = 9999;
        }
        try {
            AuthenticationCallbackHandler cbh = new AuthenticationCallbackHandler(userName, password);
            ModelControllerClient newClient = ModelControllerClient.Factory.create((String)host, (int)port, (CallbackHandler)cbh);
            List nodeTypes = Util.getNodeTypes((ModelControllerClient)newClient, (OperationRequestAddress)new DefaultOperationRequestAddress());
            if (!nodeTypes.isEmpty()) {
                boolean domainMode = nodeTypes.contains("server-group");
                LOGGER.info("Connected to " + (domainMode ? "domain controller at " : "standalone controller at ") + host + ":" + port);
                return new AdminImpl(newClient);
            }
            LOGGER.info(AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70051, new Object[]{host, port}));
        }
        catch (UnknownHostException e) {
            throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70000, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70000, new Object[]{host, e.getLocalizedMessage()}));
        }
        return null;
    }

    public Admin createAdmin(ModelControllerClient connection) {
        return new AdminImpl(connection);
    }

    public Admin createAdmin(ModelControllerClient connection, String profileName) {
        AdminImpl admin = new AdminImpl(connection);
        admin.setProfileName(profileName);
        return admin;
    }

    public class AdminImpl
    implements Admin {
        private static final String CLASS_NAME = "class-name";
        private static final String JAVA_CONTEXT = "java:/";
        private ModelControllerClient connection;
        private boolean domainMode = false;
        private String profileName = "ha";

        public AdminImpl(ModelControllerClient connection) {
            this.connection = connection;
            List nodeTypes = Util.getNodeTypes((ModelControllerClient)connection, (OperationRequestAddress)new DefaultOperationRequestAddress());
            if (!nodeTypes.isEmpty()) {
                this.domainMode = nodeTypes.contains("server-group");
            }
        }

        public void setProfileName(String name) {
            this.profileName = name;
        }

        public void clearCache(String cacheType) throws AdminException {
            this.cliCall("clear-cache", new String[]{"subsystem", "teiid"}, new String[]{"cache-type", cacheType}, new ResultCallback());
        }

        public void clearCache(String cacheType, String vdbName, int vdbVersion) throws AdminException {
            this.cliCall("clear-cache", new String[]{"subsystem", "teiid"}, new String[]{"cache-type", cacheType, "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion)}, new ResultCallback());
        }

        public void close() {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.connection = null;
                this.domainMode = false;
            }
        }

        private void createConnectionFactory(String deploymentName, String rarName, Properties properties) throws AdminException {
            if (!this.getInstalledResourceAdaptorNames().contains(rarName)) {
                this.addArchiveResourceAdapter(rarName);
            } else {
                String moduleName = this.getResourceAdapterModuleName(rarName);
                this.addModuleResourceAdapter(deploymentName, moduleName);
                rarName = deploymentName;
            }
            BuildPropertyDefinitions bpd = new BuildPropertyDefinitions();
            this.buildResourceAdpaterProperties(rarName, bpd);
            ArrayList<PropertyDefinition> jcaSpecific = bpd.getPropertyDefinitions();
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add("jndi-name");
            parameters.add(this.addJavaContext(deploymentName));
            parameters.add("enabled");
            parameters.add("true");
            if (properties.getProperty(CLASS_NAME) != null) {
                parameters.add(CLASS_NAME);
                parameters.add(properties.getProperty(CLASS_NAME));
            }
            for (PropertyDefinition pd : jcaSpecific) {
                if (properties.getProperty(pd.getName()) == null) continue;
                parameters.add(pd.getName());
                parameters.add(properties.getProperty(pd.getName()));
            }
            this.cliCall("add", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName, "connection-definitions", deploymentName}, parameters.toArray(new String[parameters.size()]), new ResultCallback());
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                boolean add = true;
                String key = (String)keys.nextElement();
                if (key.equals(CLASS_NAME)) {
                    add = false;
                }
                for (PropertyDefinition pd : jcaSpecific) {
                    if (!key.equals(pd.getName())) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                this.addConfigProperty(rarName, deploymentName, key, properties.getProperty(key));
            }
            this.activateConnectionFactory(rarName);
        }

        private void addConfigProperty(String rarName, String deploymentName, String key, String value) throws AdminException {
            if (value == null || value.trim().isEmpty()) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70054, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70054, new Object[]{key}));
            }
            this.cliCall("add", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName, "connection-definitions", deploymentName, "config-properties", key}, new String[]{"value", value}, new ResultCallback());
        }

        private void activateConnectionFactory(String rarName) throws AdminException {
            this.cliCall("activate", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName}, null, new ResultCallback());
        }

        private void addProfileNode(DefaultOperationRequestBuilder builder) throws AdminException {
            String profile;
            if (this.domainMode && (profile = this.getProfileName()) != null) {
                builder.addNode("profile", profile);
            }
        }

        private void addArchiveResourceAdapter(String rarName) throws AdminException {
            this.cliCall("add", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName}, new String[]{"archive", rarName, "transaction-support", "NoTransaction"}, new ResultCallback());
        }

        private void addModuleResourceAdapter(String rarName, String moduleName) throws AdminException {
            this.cliCall("add", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName}, new String[]{"module", moduleName, "transaction-support", "NoTransaction"}, new ResultCallback());
        }

        private String getResourceAdapterModuleName(String rarName) throws AdminException {
            final ArrayList props = new ArrayList();
            this.cliCall("read-resource", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName}, null, new ResultCallback(){

                @Override
                void onSuccess(ModelNode outcome, ModelNode result) throws AdminException {
                    List properties = outcome.get("result").asList();
                    for (ModelNode prop : properties) {
                        Property p;
                        if (!prop.getType().equals((Object)ModelType.PROPERTY) || !(p = prop.asProperty()).getName().equals("module")) continue;
                        props.add(p.getValue().asString());
                    }
                }
            });
            return (String)props.get(0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Set<String> getInstalledJDBCDrivers() throws AdminException {
            HashSet<String> driverList = new HashSet<String>();
            driverList.addAll(this.getChildNodeNames("datasources", "jdbc-driver"));
            if (!this.domainMode) {
                ModelNode request = this.buildRequest("datasources", "installed-drivers-list", new String[0]);
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (!Util.isSuccess((ModelNode)outcome)) return driverList;
                    List<String> drivers = this.getList(outcome, new AbstractMetadatMapper(){

                        @Override
                        public String unwrap(ModelNode node) {
                            if (node.hasDefined("driver-name")) {
                                return node.get("driver-name").asString();
                            }
                            return null;
                        }
                    });
                    driverList.addAll(drivers);
                    return driverList;
                }
                catch (IOException e) {
                    throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70052, (Throwable)e);
                }
            } else {
                List<String> deployments = this.getChildNodeNames(null, "deployment");
                for (String deployment : deployments) {
                    if (deployment.contains("translator") || !deployment.endsWith(".jar")) continue;
                    driverList.add(deployment);
                }
            }
            return driverList;
        }

        public String getProfileName() throws AdminException {
            if (!this.domainMode) {
                return null;
            }
            if (this.profileName == null) {
                this.profileName = this.getChildNodeNames(null, "profile").get(0);
            }
            return this.profileName;
        }

        public void createDataSource(String deploymentName, String templateName, Properties properties) throws AdminException {
            deploymentName = this.removeJavaContext(deploymentName);
            Collection<String> dsNames = this.getDataSourceNames();
            if (dsNames.contains(deploymentName)) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70003, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70003, new Object[]{deploymentName}));
            }
            Set<String> resourceAdapters = this.getResourceAdapterNames();
            if (resourceAdapters.contains(templateName)) {
                this.createConnectionFactory(deploymentName, templateName, properties);
                return;
            }
            Set<String> drivers = this.getInstalledJDBCDrivers();
            if (!drivers.contains(templateName)) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70004, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70004, new Object[]{templateName}));
            }
            Collection<PropertyDefinition> dsProperties = this.getTemplatePropertyDefinitions(templateName);
            ArrayList<String> parameters = new ArrayList<String>();
            if (properties != null) {
                parameters.add("connection-url");
                parameters.add(properties.getProperty("connection-url"));
                for (PropertyDefinition prop : dsProperties) {
                    String value;
                    if (prop.getName().equals("connection-properties") || (value = properties.getProperty(prop.getName())) == null) continue;
                    parameters.add(prop.getName());
                    parameters.add(value);
                }
            } else {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70005, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70005, new Object[0]));
            }
            parameters.add("jndi-name");
            parameters.add(this.addJavaContext(deploymentName));
            parameters.add("driver-name");
            parameters.add(templateName);
            parameters.add("pool-name");
            parameters.add(deploymentName);
            this.cliCall("add", new String[]{"subsystem", "datasources", "data-source", deploymentName}, parameters.toArray(new String[parameters.size()]), new ResultCallback());
            String cp = properties.getProperty("connection-properties");
            if (cp != null) {
                StringTokenizer st = new StringTokenizer(cp, ",");
                while (st.hasMoreTokens()) {
                    String prop = st.nextToken();
                    String key = prop.substring(0, prop.indexOf(61));
                    String value = prop.substring(prop.indexOf(61) + 1);
                    this.addConnectionProperty(deploymentName, key, value);
                }
            }
            this.cliCall("enable", new String[]{"subsystem", "datasources", "data-source", deploymentName}, null, new ResultCallback());
        }

        private void addConnectionProperty(String deploymentName, String key, String value) throws AdminException {
            if (value == null || value.trim().isEmpty()) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70054, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70054, new Object[]{key}));
            }
            this.cliCall("add", new String[]{"subsystem", "datasources", "data-source", deploymentName, "connection-properties", key}, new String[]{"value", value}, new ResultCallback());
        }

        private void execute(ModelNode request) throws AdminException {
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70006, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70007, (Throwable)e);
            }
        }

        public Properties getDataSource(String deployedName) throws AdminException {
            deployedName = this.removeJavaContext(deployedName);
            Collection<String> dsNames = this.getDataSourceNames();
            if (!dsNames.contains(deployedName)) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70008, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70008, new Object[]{deployedName}));
            }
            Properties dsProperties = new Properties();
            this.cliCall("read-resource", new String[]{"subsystem", "datasources", "data-source", deployedName}, null, new DataSourceProperties(dsProperties));
            if (dsProperties.isEmpty()) {
                this.cliCall("read-resource", new String[]{"subsystem", "datasources", "xa-data-source", deployedName}, null, new DataSourceProperties(dsProperties));
            }
            if (dsProperties.isEmpty()) {
                Map<String, String> raDSMap = this.getConnectionFactoryNames();
                String rarName = raDSMap.get(deployedName);
                if (rarName != null) {
                    this.cliCall("read-resource", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName, "connection-definitions", deployedName}, null, new ConnectionFactoryProperties(dsProperties, rarName, deployedName, null));
                }
                if (dsProperties.getProperty("driver-name") == null) {
                    String moduleName = this.getResourceAdapterModuleName(rarName);
                    Set<String> installedRars = this.getResourceAdapterNames();
                    for (String installedRar : installedRars) {
                        if (!this.getResourceAdapterModuleName(installedRar).equals(moduleName)) continue;
                        dsProperties.setProperty("driver-name", installedRar);
                        break;
                    }
                }
            }
            return dsProperties;
        }

        public void deleteDataSource(String deployedName) throws AdminException {
            Map<String, String> raDSMap;
            String rarName;
            deployedName = this.removeJavaContext(deployedName);
            Collection<String> dsNames = this.getDataSourceNames();
            if (!dsNames.contains(deployedName)) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70008, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70008, new Object[]{deployedName}));
            }
            boolean deleted = this.deleteDS(deployedName, "datasources", "data-source");
            if (!deleted) {
                deleted = this.deleteDS(deployedName, "datasources", "xa-data-source");
            }
            if (!deleted && (rarName = (raDSMap = this.getConnectionFactoryNames()).get(deployedName)) != null) {
                this.cliCall("remove", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName, "connection-definitions", deployedName}, null, new ResultCallback());
                if (this.getInstalledResourceAdaptorNames().contains(deployedName)) {
                    this.cliCall("remove", new String[]{"subsystem", "resource-adapters", "resource-adapter", deployedName}, null, new ResultCallback());
                }
            }
            if ((dsNames = this.getDataSourceNames()).contains(deployedName)) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70008, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70008, new Object[]{deployedName}));
            }
        }

        private String removeJavaContext(String deployedName) {
            if (deployedName.startsWith(JAVA_CONTEXT)) {
                deployedName = deployedName.substring(6);
            }
            return deployedName;
        }

        private String addJavaContext(String deployedName) {
            if (!deployedName.startsWith(JAVA_CONTEXT)) {
                deployedName = JAVA_CONTEXT + deployedName;
            }
            return deployedName;
        }

        private boolean deleteDS(String deployedName, String ... subsystem) throws AdminException {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                this.addProfileNode(builder);
                builder.addNode("subsystem", subsystem[0]);
                builder.addNode(subsystem[1], deployedName);
                builder.setOperationName("remove");
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70010, (Throwable)e, "Failed to build operation");
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    return false;
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70009, (Throwable)e);
            }
            return true;
        }

        public void undeploy(String deployedName) throws AdminException {
            ModelNode request;
            try {
                request = this.buildUndeployRequest(deployedName, false);
            }
            catch (OperationFormatException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70010, (Throwable)e, "Failed to build operation");
            }
            this.execute(request);
        }

        public void undeploy(String deployedName, boolean force) throws AdminException {
            ModelNode request;
            try {
                request = this.buildUndeployRequest(deployedName, force);
            }
            catch (OperationFormatException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70010, (Throwable)e, "Failed to build operation");
            }
            this.execute(request);
        }

        public ModelNode buildUndeployRequest(String name, boolean force) throws OperationFormatException {
            DefaultOperationRequestBuilder builder;
            ModelNode composite = new ModelNode();
            composite.get("operation").set("composite");
            composite.get("address").setEmptyList();
            ModelNode steps = composite.get("steps");
            if (this.domainMode) {
                ModelNode groupStep;
                List serverGroups = Util.getServerGroups((ModelControllerClient)this.connection);
                for (String group : serverGroups) {
                    groupStep = Util.configureDeploymentOperation((String)"undeploy", (String)name, (String)group);
                    steps.add(groupStep);
                }
                for (String group : serverGroups) {
                    groupStep = Util.configureDeploymentOperation((String)"remove", (String)name, (String)group);
                    steps.add(groupStep);
                }
            } else if (Util.isDeployedAndEnabledInStandalone((String)name, (ModelControllerClient)this.connection) || force) {
                builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("undeploy");
                builder.addNode("deployment", name);
                steps.add(builder.buildRequest());
            }
            builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("remove");
            builder.addNode("deployment", name);
            steps.add(builder.buildRequest());
            return composite;
        }

        public void deploy(String deployName, InputStream vdb) throws AdminException {
            ModelNode request = this.buildDeployVDBRequest(deployName, vdb, true);
            this.execute(request);
        }

        public void deploy(String deployName, InputStream vdb, boolean persist) throws AdminException {
            ModelNode request = this.buildDeployVDBRequest(deployName, vdb, persist);
            this.execute(request);
        }

        private ModelNode buildDeployVDBRequest(String fileName, InputStream vdb, boolean persist) throws AdminException {
            try {
                if (Util.isDeploymentInRepository((String)fileName, (ModelControllerClient)this.connection)) {
                    DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                    builder = new DefaultOperationRequestBuilder();
                    builder.setOperationName("full-replace-deployment");
                    builder.addProperty("name", fileName);
                    byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)vdb);
                    builder.getModelNode().get("content").get(0).get("bytes").set(bytes);
                    return builder.buildRequest();
                }
                ModelNode composite = new ModelNode();
                composite.get("operation").set("composite");
                composite.get("address").setEmptyList();
                ModelNode steps = composite.get("steps");
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("add");
                builder.addNode("deployment", fileName);
                byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)vdb);
                builder.getModelNode().get("content").get(0).get("bytes").set(bytes);
                ModelNode request = builder.buildRequest();
                if (!persist) {
                    request.get("persistent").set(false);
                }
                request.get("enabled").set(true);
                steps.add(request);
                if (this.domainMode) {
                    List serverGroups = Util.getServerGroups((ModelControllerClient)this.connection);
                    for (String serverGroup : serverGroups) {
                        steps.add(Util.configureDeploymentOperation((String)"add", (String)fileName, (String)serverGroup));
                    }
                    for (String serverGroup : serverGroups) {
                        steps.add(Util.configureDeploymentOperation((String)"deploy", (String)fileName, (String)serverGroup));
                    }
                } else {
                    builder = new DefaultOperationRequestBuilder();
                    builder.setOperationName("deploy");
                    builder.addNode("deployment", fileName);
                    request = builder.buildRequest();
                    if (!persist) {
                        request.get("persistent").set(false);
                    }
                    request.get("enabled").set(true);
                    steps.add(request);
                }
                return composite;
            }
            catch (OperationFormatException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70010, (Throwable)e, "Failed to build operation");
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70011, (Throwable)e);
            }
        }

        public Collection<? extends CacheStatistics> getCacheStats(String cacheType) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "cache-statistics", "cache-type", cacheType);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    if (this.domainMode) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.CacheStatisticsMetadataMapper.INSTANCE);
                    }
                    if (outcome.hasDefined("result")) {
                        ModelNode result = outcome.get("result");
                        return Arrays.asList(VDBMetadataMapper.CacheStatisticsMetadataMapper.INSTANCE.unwrap(result));
                    }
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70013, (Throwable)e);
            }
            return null;
        }

        public Collection<? extends EngineStatistics> getEngineStats() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "engine-statistics", new String[0]);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    if (this.domainMode) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.EngineStatisticsMetadataMapper.INSTANCE);
                    }
                    if (outcome.hasDefined("result")) {
                        ModelNode result = outcome.get("result");
                        return Arrays.asList(VDBMetadataMapper.EngineStatisticsMetadataMapper.INSTANCE.unwrap(result));
                    }
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70013, (Throwable)e);
            }
            return null;
        }

        public Collection<String> getCacheTypes() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "cache-types", new String[0]);
            return new HashSet<String>(this.executeList(request));
        }

        private Collection<String> executeList(ModelNode request) throws AdminException {
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    return Util.getList((ModelNode)outcome);
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70014, (Throwable)e);
            }
            return Collections.emptyList();
        }

        private List<String> getChildNodeNames(String subsystem, String childNode) throws AdminException {
            ModelNode request = this.buildRequest(subsystem, "read-children-names", "child-type", childNode);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    return Util.getList((ModelNode)outcome);
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70015, (Throwable)e);
            }
            return Collections.emptyList();
        }

        public Collection<String> getDataSourceNames() throws AdminException {
            HashSet<String> datasourceNames = new HashSet<String>();
            datasourceNames.addAll(this.getChildNodeNames("datasources", "data-source"));
            datasourceNames.addAll(this.getChildNodeNames("datasources", "xa-data-source"));
            datasourceNames.addAll(this.getConnectionFactoryNames().keySet());
            HashSet<String> dsNames = new HashSet<String>();
            for (String s : datasourceNames) {
                if (s.startsWith(JAVA_CONTEXT)) {
                    dsNames.add(s.substring(6));
                    continue;
                }
                dsNames.add(s);
            }
            return dsNames;
        }

        private Map<String, String> getConnectionFactoryNames() throws AdminException {
            HashMap<String, String> datasourceNames = new HashMap<String, String>();
            Set<String> resourceAdapters = this.getInstalledResourceAdaptorNames();
            for (String resource : resourceAdapters) {
                this.getRAConnections(datasourceNames, resource);
            }
            return datasourceNames;
        }

        private void getRAConnections(final HashMap<String, String> datasourceNames, final String rarName) throws AdminException {
            this.cliCall("read-resource", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName}, null, new ResultCallback(){

                @Override
                public void onSuccess(ModelNode outcome, ModelNode result) throws AdminProcessingException {
                    if (result.hasDefined("connection-definitions")) {
                        List connDefs = result.get("connection-definitions").asList();
                        for (ModelNode conn : connDefs) {
                            Iterator it = conn.keys().iterator();
                            if (!it.hasNext()) continue;
                            datasourceNames.put(it.next(), rarName);
                        }
                    }
                }

                @Override
                public void onFailure(String msg) throws AdminProcessingException {
                }
            });
        }

        private Set<String> getInstalledResourceAdaptorNames() throws AdminException {
            HashSet<String> templates = new HashSet<String>();
            templates.addAll(this.getChildNodeNames("resource-adapters", "resource-adapter"));
            return templates;
        }

        private Set<String> getResourceAdapterNames() throws AdminException {
            Set<String> templates = this.getDeployedResourceAdaptorNames();
            templates.addAll(this.getInstalledResourceAdaptorNames());
            Map<String, String> connFactoryMap = this.getConnectionFactoryNames();
            for (String key : connFactoryMap.keySet()) {
                templates.remove(key);
            }
            return templates;
        }

        private Set<String> getDeployedResourceAdaptorNames() throws AdminException {
            HashSet<String> templates = new HashSet<String>();
            List<String> deployments = this.getChildNodeNames(null, "deployment");
            for (String deployment : deployments) {
                if (!deployment.endsWith(".rar")) continue;
                templates.add(deployment);
            }
            return templates;
        }

        public List<String> getDeployments() {
            return Util.getDeployments((ModelControllerClient)this.connection);
        }

        public Set<String> getDataSourceTemplateNames() throws AdminException {
            HashSet<String> templates = new HashSet<String>();
            templates.addAll(this.getInstalledJDBCDrivers());
            templates.addAll(this.getResourceAdapterNames());
            return templates;
        }

        public Collection<? extends WorkerPoolStatistics> getWorkerPoolStats() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "workerpool-statistics", new String[0]);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        if (this.domainMode) {
                            return this.getDomainAwareList(outcome, VDBMetadataMapper.WorkerPoolStatisticsMetadataMapper.INSTANCE);
                        }
                        if (outcome.hasDefined("result")) {
                            ModelNode result = outcome.get("result");
                            return Arrays.asList(VDBMetadataMapper.WorkerPoolStatisticsMetadataMapper.INSTANCE.unwrap(result));
                        }
                    }
                }
                catch (IOException e) {
                    throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70020, (Throwable)e);
                }
            }
            return null;
        }

        public void cancelRequest(String sessionId, long executionId) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "cancel-request", "session", sessionId, "execution-id", String.valueOf(executionId));
            if (request == null) {
                return;
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70021, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70022, (Throwable)e);
            }
        }

        public Collection<? extends Request> getRequests() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-requests", new String[0]);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.RequestMetadataMapper.INSTANCE);
                    }
                }
                catch (IOException e) {
                    throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70023, (Throwable)e);
                }
            }
            return Collections.emptyList();
        }

        public Collection<? extends Request> getRequestsForSession(String sessionId) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-requests-per-session", "session", sessionId);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.RequestMetadataMapper.INSTANCE);
                    }
                }
                catch (IOException e) {
                    throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70024, (Throwable)e);
                }
            }
            return Collections.emptyList();
        }

        public Collection<? extends Session> getSessions() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-sessions", new String[0]);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.SessionMetadataMapper.INSTANCE);
                    }
                }
                catch (IOException e) {
                    throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70025, (Throwable)e);
                }
            }
            return Collections.emptyList();
        }

        private void buildResourceAdpaterProperties(String rarName, BuildPropertyDefinitions builder) throws AdminException {
            this.cliCall("read-resource-description", new String[]{"subsystem", "resource-adapters", "resource-adapter", rarName, "connection-definitions", "any"}, null, builder);
        }

        public Collection<PropertyDefinition> getTemplatePropertyDefinitions(String templateName) throws AdminException {
            BuildPropertyDefinitions builder = new BuildPropertyDefinitions();
            Set<String> resourceAdapters = this.getResourceAdapterNames();
            if (resourceAdapters.contains(templateName)) {
                this.cliCall("read-rar-description", new String[]{"subsystem", "teiid"}, new String[]{"rar-name", templateName}, builder);
                this.buildResourceAdpaterProperties(templateName, builder);
                return builder.getPropertyDefinitions();
            }
            this.cliCall("read-resource-description", new String[]{"subsystem", "datasources", "data-source", templateName}, null, builder);
            PropertyDefinitionMetadata cp = new PropertyDefinitionMetadata();
            cp.setName("connection-properties");
            cp.setDisplayName("Addtional Driver Properties");
            cp.setDescription("The connection-properties element allows you to pass in arbitrary connection properties to the Driver.connect(url, props) method. Supply comma separated name-value pairs");
            cp.setRequired(false);
            cp.setAdvanced(true);
            ArrayList<PropertyDefinition> props = builder.getPropertyDefinitions();
            props.add((PropertyDefinition)cp);
            return props;
        }

        @Deprecated
        public Collection<? extends PropertyDefinition> getTranslatorPropertyDefinitions(String translatorName) throws AdminException {
            BuildPropertyDefinitions builder = new BuildPropertyDefinitions();
            Collection<? extends Translator> translators = this.getTranslators();
            for (Translator translator : translators) {
                if (!translator.getName().equalsIgnoreCase(translatorName)) continue;
                this.cliCall("read-translator-properties", new String[]{"subsystem", "teiid"}, new String[]{"translator-name", translatorName, "type", Admin.TranlatorPropertyType.OVERRIDE.name()}, builder);
                return builder.getPropertyDefinitions();
            }
            throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70055, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70055, new Object[]{translatorName}));
        }

        public Collection<? extends PropertyDefinition> getTranslatorPropertyDefinitions(String translatorName, Admin.TranlatorPropertyType type) throws AdminException {
            BuildPropertyDefinitions builder = new BuildPropertyDefinitions();
            Collection<? extends Translator> translators = this.getTranslators();
            for (Translator translator : translators) {
                if (!translator.getName().equalsIgnoreCase(translatorName)) continue;
                this.cliCall("read-translator-properties", new String[]{"subsystem", "teiid"}, new String[]{"translator-name", translatorName, "type", type.name()}, builder);
                return builder.getPropertyDefinitions();
            }
            throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70055, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70055, new Object[]{translatorName}));
        }

        private boolean excludeProperty(String name) {
            String[] names;
            for (String n : names = new String[]{"jndi-name", "pool-name", "driver-name", "reauth-plugin-class-name", "enabled", "valid-connection-checker-class-name", "valid-connection-checker-properties", "stale-connection-checker-class-name", "stale-connection-checker-properties", "exception-sorter-class-name", "exception-sorter-properties", "use-try-lock", "allocation-retry", "allocation-retry-wait-millis", "jta", "use-java-context", "url-selector-strategy-class-name", "driver-class", "datasource-class", "use-ccm"}) {
                if (!n.equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }

        public Collection<? extends Transaction> getTransactions() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-transactions", new String[0]);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.TransactionMetadataMapper.INSTANCE);
                    }
                }
                catch (IOException e) {
                    throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70028, (Throwable)e);
                }
            }
            return Collections.emptyList();
        }

        public void terminateSession(String sessionId) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "terminate-session", "session", sessionId);
            if (request == null) {
                return;
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70029, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70030, (Throwable)e);
            }
        }

        public void terminateTransaction(String transactionId) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "terminate-transaction", "xid", transactionId);
            if (request == null) {
                return;
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70031, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70032, (Throwable)e);
            }
        }

        public Translator getTranslator(String deployedName) throws AdminException {
            block5: {
                ModelNode request = this.buildRequest("teiid", "get-translator", "translator-name", deployedName);
                if (request == null) {
                    return null;
                }
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (!Util.isSuccess((ModelNode)outcome) || !outcome.hasDefined("result")) break block5;
                    if (this.domainMode) {
                        List<VDBTranslatorMetaData> list = this.getDomainAwareList(outcome, VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE);
                        if (list != null && !list.isEmpty()) {
                            return (Translator)list.get(0);
                        }
                        break block5;
                    }
                    ModelNode result = outcome.get("result");
                    return VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE.unwrap(result);
                }
                catch (IOException e) {
                    throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70033, (Throwable)e);
                }
            }
            return null;
        }

        public Collection<? extends Translator> getTranslators() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-translators", new String[0]);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    return this.getDomainAwareList(outcome, VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE);
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70034, (Throwable)e);
            }
            return Collections.emptyList();
        }

        private ModelNode buildRequest(String subsystem, String operationName, String ... params) throws AdminException {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                if (subsystem != null) {
                    this.addProfileNode(builder);
                    builder.addNode("subsystem", subsystem);
                }
                builder.setOperationName(operationName);
                request = builder.buildRequest();
                if (params != null && params.length % 2 == 0) {
                    for (int i = 0; i < params.length; i += 2) {
                        builder.addProperty(params[i], params[i + 1]);
                    }
                }
            }
            catch (OperationFormatException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70010, (Throwable)e, "Failed to build operation");
            }
            return request;
        }

        private void cliCall(String operationName, String[] address, String[] params, ResultCallback callback) throws AdminException {
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                int i;
                if (address.length % 2 != 0) {
                    throw new IllegalArgumentException("Failed to build operation");
                }
                this.addProfileNode(builder);
                for (i = 0; i < address.length; i += 2) {
                    builder.addNode(address[i], address[i + 1]);
                }
                builder.setOperationName(operationName);
                ModelNode request = builder.buildRequest();
                if (params != null && params.length % 2 == 0) {
                    for (i = 0; i < params.length; i += 2) {
                        builder.addProperty(params[i], params[i + 1]);
                    }
                }
                ModelNode outcome = this.connection.execute(request);
                ModelNode result = null;
                if (Util.isSuccess((ModelNode)outcome)) {
                    if (outcome.hasDefined("result")) {
                        result = outcome.get("result");
                    }
                    callback.onSuccess(outcome, result);
                } else {
                    callback.onFailure(Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (OperationFormatException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70010, (Throwable)e, "Failed to build operation");
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70007, (Throwable)e);
            }
        }

        private <T> List<T> getDomainAwareList(ModelNode operationResult, MetadataMapper<T> mapper) {
            if (this.domainMode) {
                ArrayList<T> returnList = new ArrayList<T>();
                ModelNode serverGroups = operationResult.get("server-groups");
                Set serverGroupNames = serverGroups.keys();
                for (String serverGroupName : serverGroupNames) {
                    ModelNode serverGroup = serverGroups.get(serverGroupName);
                    ModelNode hostGroups = serverGroup.get("host");
                    Set hostKeys = hostGroups.keys();
                    for (String hostName : hostKeys) {
                        ModelNode hostGroup = hostGroups.get(hostName);
                        Set serverNames = hostGroup.keys();
                        for (String serverName : serverNames) {
                            ModelNode result;
                            ModelNode server = hostGroup.get(serverName);
                            if (!server.get(new String[]{"response", "outcome"}).asString().equals("success") || !(result = server.get(new String[]{"response", "result"})).isDefined()) continue;
                            List nodeList = result.asList();
                            for (ModelNode node : nodeList) {
                                T anObj = mapper.unwrap(node);
                                if (anObj instanceof DomainAware) {
                                    ((AdminObjectImpl)anObj).setServerGroup(serverGroupName);
                                    ((AdminObjectImpl)anObj).setServerName(serverName);
                                    ((AdminObjectImpl)anObj).setHostName(hostName);
                                }
                                returnList.add(anObj);
                            }
                        }
                    }
                }
                return returnList;
            }
            return this.getList(operationResult, mapper);
        }

        private <T> List<T> getList(ModelNode operationResult, MetadataMapper<T> mapper) {
            if (!operationResult.hasDefined("result")) {
                return Collections.emptyList();
            }
            List nodeList = operationResult.get("result").asList();
            if (nodeList.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<T> list = new ArrayList<T>(nodeList.size());
            for (ModelNode node : nodeList) {
                list.add(mapper.unwrap(node));
            }
            return list;
        }

        public VDB getVDB(String vdbName, int vdbVersion) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "get-vdb", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion));
            if (request == null) {
                return null;
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    if (this.domainMode) {
                        List<VDBMetaData> list = this.getDomainAwareList(outcome, VDBMetadataMapper.INSTANCE);
                        if (list != null && !list.isEmpty()) {
                            return (VDB)list.get(0);
                        }
                    } else if (outcome.hasDefined("result")) {
                        ModelNode result = outcome.get("result");
                        return VDBMetadataMapper.INSTANCE.unwrap(result);
                    }
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70035, (Throwable)e);
            }
            return null;
        }

        public List<? extends VDB> getVDBs() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-vdbs", new String[0]);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    return this.getDomainAwareList(outcome, VDBMetadataMapper.INSTANCE);
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70036, (Throwable)e);
            }
            return Collections.emptyList();
        }

        public void addDataRoleMapping(String vdbName, int vdbVersion, String dataRole, String mappedRoleName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "add-data-role", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "data-role", dataRole, "mapped-role", mappedRoleName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70039, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70040, (Throwable)e);
            }
        }

        public void removeDataRoleMapping(String vdbName, int vdbVersion, String dataRole, String mappedRoleName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "remove-data-role", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "data-role", dataRole, "mapped-role", mappedRoleName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70041, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70042, (Throwable)e);
            }
        }

        public void setAnyAuthenticatedForDataRole(String vdbName, int vdbVersion, String dataRole, boolean anyAuthenticated) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "add-anyauthenticated-role", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "data-role", dataRole);
            if (!anyAuthenticated) {
                request = this.buildRequest("teiid", "remove-anyauthenticated-role", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "data-role", dataRole);
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70043, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70044, (Throwable)e);
            }
        }

        public void changeVDBConnectionType(String vdbName, int vdbVersion, VDB.ConnectionType type) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "change-vdb-connection-type", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "connection-type", type.name());
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70045, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70046, (Throwable)e);
            }
        }

        public void assignToModel(String vdbName, int vdbVersion, String modelName, String sourceName, String translatorName, String dsName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "assign-datasource", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "model-name", modelName, "source-name", sourceName, "translator-name", translatorName, "ds-name", dsName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70047, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70048, (Throwable)e);
            }
        }

        public void updateSource(String vdbName, int vdbVersion, String sourceName, String translatorName, String dsName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "update-source", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "source-name", sourceName, "translator-name", translatorName, "ds-name", dsName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70047, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70048, (Throwable)e);
            }
        }

        public void addSource(String vdbName, int vdbVersion, String modelName, String sourceName, String translatorName, String dsName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "add-source", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "model-name", modelName, "source-name", sourceName, "translator-name", translatorName, "ds-name", dsName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70047, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70048, (Throwable)e);
            }
        }

        public void removeSource(String vdbName, int vdbVersion, String modelName, String sourceName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "remove-source", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "model-name", modelName, "source-name", sourceName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70047, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70048, (Throwable)e);
            }
        }

        public void markDataSourceAvailable(String jndiName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "mark-datasource-available", "ds-name", jndiName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70049, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70050, (Throwable)e);
            }
        }

        public void restartVDB(String vdbName, int vdbVersion, String ... models) throws AdminException {
            ModelNode request = null;
            String modelNames = null;
            if (models != null && models.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < models.length - 1; ++i) {
                    sb.append(models[i]).append(",");
                }
                sb.append(models[models.length - 1]);
                modelNames = sb.toString();
            }
            request = modelNames != null ? this.buildRequest("teiid", "restart-vdb", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "model-names", modelNames) : this.buildRequest("teiid", "restart-vdb", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion));
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70045, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70046, (Throwable)e);
            }
        }

        public String getSchema(String vdbName, int vdbVersion, String modelName, EnumSet<Admin.SchemaObjectType> allowedTypes, String typeNamePattern) throws AdminException {
            ModelNode request = null;
            ArrayList<String> params = new ArrayList<String>();
            params.add("vdb-name");
            params.add(vdbName);
            params.add("vdb-version");
            params.add(String.valueOf(vdbVersion));
            params.add("model-name");
            params.add(modelName);
            if (allowedTypes != null) {
                params.add("entity-type");
                StringBuilder sb = new StringBuilder();
                for (Admin.SchemaObjectType type : allowedTypes) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(type.name());
                }
                params.add(sb.toString());
            }
            if (typeNamePattern != null) {
                params.add("entity-pattern");
                params.add(typeNamePattern);
            }
            request = this.buildRequest("teiid", "get-schema", params.toArray(new String[params.size()]));
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70045, Util.getFailureDescription((ModelNode)outcome));
                }
                return outcome.get("result").asString();
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70046, (Throwable)e);
            }
        }

        public String getQueryPlan(String sessionId, int executionId) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "get-plan", "session", sessionId, "execution-id", String.valueOf(executionId));
            if (request == null) {
                return null;
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70021, Util.getFailureDescription((ModelNode)outcome));
                }
                return outcome.get("result").asString();
            }
            catch (IOException e) {
                throw new AdminComponentException((BundleUtil.Event)AdminPlugin.Event.TEIID70022, (Throwable)e);
            }
        }

        public void restart() {
            try {
                this.cliCall("reload", new String[0], new String[0], new ResultCallback());
            }
            catch (AdminException adminException) {
                // empty catch block
            }
        }

        private class BuildPropertyDefinitions
        extends ResultCallback {
            private ArrayList<PropertyDefinition> propDefinitions;

            private BuildPropertyDefinitions() {
                this.propDefinitions = new ArrayList();
            }

            @Override
            public void onSuccess(ModelNode outcome, ModelNode result) throws AdminProcessingException {
                if (result.getType().equals((Object)ModelType.LIST)) {
                    this.buildPropertyDefinitions(result.asList());
                } else if (result.get("attributes").isDefined()) {
                    this.buildPropertyDefinitions(result.get("attributes").asList());
                }
            }

            @Override
            public void onFailure(String msg) throws AdminProcessingException {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70026, msg);
            }

            ArrayList<PropertyDefinition> getPropertyDefinitions() {
                return this.propDefinitions;
            }

            private void buildPropertyDefinitions(List<ModelNode> propsNodes) {
                for (ModelNode node : propsNodes) {
                    String access;
                    PropertyDefinitionMetadata def = new PropertyDefinitionMetadata();
                    Set keys = node.keys();
                    String name = (String)keys.iterator().next();
                    if (AdminImpl.this.excludeProperty(name)) continue;
                    def.setName(name);
                    node = node.get(name);
                    if (node.hasDefined("display")) {
                        def.setDisplayName(node.get("display").asString());
                    } else {
                        def.setDisplayName(name);
                    }
                    if (node.hasDefined("description")) {
                        def.setDescription(node.get("description").asString());
                    }
                    if (node.hasDefined("allowed")) {
                        List allowed = node.get("allowed").asList();
                        ArrayList<String> list = new ArrayList<String>();
                        for (ModelNode m : allowed) {
                            list.add(m.asString());
                        }
                        def.setAllowedValues(list);
                    }
                    if (node.hasDefined("required")) {
                        def.setRequired(node.get("required").asBoolean());
                    }
                    if (node.hasDefined("owner")) {
                        def.addProperty("owner", node.get("owner").asString());
                    }
                    if (node.hasDefined("read-only")) {
                        access = node.get("read-only").asString();
                        def.setModifiable(!Boolean.parseBoolean(access));
                    }
                    if (node.hasDefined("access-type")) {
                        access = node.get("access-type").asString();
                        if ("read-write".equals(access)) {
                            def.setModifiable(true);
                        } else {
                            def.setModifiable(false);
                        }
                    }
                    if (node.hasDefined("advanced")) {
                        access = node.get("advanced").asString();
                        def.setAdvanced(Boolean.parseBoolean(access));
                    }
                    if (node.hasDefined("masked")) {
                        access = node.get("masked").asString();
                        def.setAdvanced(Boolean.parseBoolean(access));
                    }
                    if (node.hasDefined("restart-required")) {
                        def.setRequiresRestart(PropertyDefinition.RestartType.NONE);
                    }
                    String type = node.get("type").asString();
                    if (ModelType.STRING.name().equals(type)) {
                        def.setPropertyTypeClassName(String.class.getName());
                    } else if (ModelType.INT.name().equals(type)) {
                        def.setPropertyTypeClassName(Integer.class.getName());
                    } else if (ModelType.LONG.name().equals(type)) {
                        def.setPropertyTypeClassName(Long.class.getName());
                    } else if (ModelType.BOOLEAN.name().equals(type)) {
                        def.setPropertyTypeClassName(Boolean.class.getName());
                    } else if (ModelType.BIG_INTEGER.name().equals(type)) {
                        def.setPropertyTypeClassName(BigInteger.class.getName());
                    } else if (ModelType.BIG_DECIMAL.name().equals(type)) {
                        def.setPropertyTypeClassName(BigDecimal.class.getName());
                    }
                    if (node.hasDefined("default")) {
                        if (ModelType.STRING.name().equals(type)) {
                            def.setDefaultValue((Serializable)((Object)node.get("default").asString()));
                        } else if (ModelType.INT.name().equals(type)) {
                            def.setDefaultValue((Serializable)Integer.valueOf(node.get("default").asInt()));
                        } else if (ModelType.LONG.name().equals(type)) {
                            def.setDefaultValue((Serializable)Long.valueOf(node.get("default").asLong()));
                        } else if (ModelType.BOOLEAN.name().equals(type)) {
                            def.setDefaultValue((Serializable)Boolean.valueOf(node.get("default").asBoolean()));
                        } else if (ModelType.BIG_INTEGER.name().equals(type)) {
                            def.setDefaultValue((Serializable)node.get("default").asBigInteger());
                        } else if (ModelType.BIG_DECIMAL.name().equals(type)) {
                            def.setDefaultValue((Serializable)node.get("default").asBigDecimal());
                        }
                    }
                    this.propDefinitions.add((PropertyDefinition)def);
                }
            }
        }

        private class ConnectionFactoryProperties
        extends ResultCallback {
            private Properties dsProperties;
            private String deployedName;
            private String rarName;
            private String configName;

            ConnectionFactoryProperties(Properties props, String rarName, String deployedName, String configName) {
                this.dsProperties = props;
                this.rarName = rarName;
                this.deployedName = deployedName;
                this.configName = configName;
            }

            @Override
            public void onSuccess(ModelNode outcome, ModelNode result) throws AdminException {
                List props = outcome.get("result").asList();
                for (ModelNode prop : props) {
                    if (!prop.getType().equals((Object)ModelType.PROPERTY)) continue;
                    Property p = prop.asProperty();
                    if (p.getName().equals("jndi-name")) {
                        this.dsProperties.setProperty("jndi-name", p.getValue().asString());
                    }
                    if (!p.getValue().isDefined() || AdminImpl.this.excludeProperty(p.getName())) continue;
                    if (p.getName().equals("archive")) {
                        this.dsProperties.setProperty("driver-name", p.getValue().asString());
                    }
                    if (p.getName().equals("value")) {
                        this.dsProperties.setProperty(this.configName, p.getValue().asString());
                        continue;
                    }
                    if (p.getName().equals("config-properties")) {
                        List configs = p.getValue().asList();
                        for (ModelNode config : configs) {
                            if (!config.getType().equals((Object)ModelType.PROPERTY)) continue;
                            Property p1 = config.asProperty();
                            AdminImpl.this.cliCall("read-resource", new String[]{"subsystem", "resource-adapters", "resource-adapter", this.rarName, "connection-definitions", this.deployedName, "config-properties", p1.getName()}, null, new ConnectionFactoryProperties(this.dsProperties, this.rarName, this.deployedName, p1.getName()));
                        }
                        continue;
                    }
                    this.dsProperties.setProperty(p.getName(), p.getValue().asString());
                }
            }

            @Override
            public void onFailure(String msg) throws AdminProcessingException {
            }
        }

        private class DataSourceProperties
        extends ResultCallback {
            private Properties dsProperties;

            DataSourceProperties(Properties props) {
                this.dsProperties = props;
            }

            @Override
            public void onSuccess(ModelNode outcome, ModelNode result) throws AdminProcessingException {
                List props = outcome.get("result").asList();
                for (ModelNode prop : props) {
                    if (!prop.getType().equals((Object)ModelType.PROPERTY)) continue;
                    Property p = prop.asProperty();
                    ModelType type = p.getValue().getType();
                    if (!p.getValue().isDefined() || type.equals((Object)ModelType.LIST) || type.equals((Object)ModelType.OBJECT) || !p.getName().equals("driver-name") && !p.getName().equals("jndi-name") && AdminImpl.this.excludeProperty(p.getName())) continue;
                    this.dsProperties.setProperty(p.getName(), p.getValue().asString());
                }
            }

            @Override
            public void onFailure(String msg) throws AdminProcessingException {
            }
        }

        class AbstractMetadatMapper
        implements MetadataMapper<String> {
            AbstractMetadatMapper() {
            }

            @Override
            public ModelNode wrap(String obj, ModelNode node) {
                return null;
            }

            @Override
            public String unwrap(ModelNode node) {
                return null;
            }

            @Override
            public ModelNode describe(ModelNode node) {
                return null;
            }
        }
    }

    private class ResultCallback {
        private ResultCallback() {
        }

        void onSuccess(ModelNode outcome, ModelNode result) throws AdminException {
        }

        void onFailure(String msg) throws AdminProcessingException {
            throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70006, msg);
        }
    }

    private class AuthenticationCallbackHandler
    implements CallbackHandler {
        private boolean realmShown = false;
        private String userName = null;
        private char[] password = null;

        public AuthenticationCallbackHandler(String user, char[] password) {
            this.userName = user;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                ((NameCallback)callbacks[0]).setName("anonymous CLI user");
                return;
            }
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    if (this.realmShown) continue;
                    this.realmShown = true;
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.userName);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

