/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.index;

import com.metamatrix.connector.metadata.index.MetadataLiteralCriteria;
import com.metamatrix.connector.metadata.index.MetadataSearchCriteria;
import com.metamatrix.core.util.ArgCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MetadataInCriteria
implements MetadataSearchCriteria {
    private final String fieldName;
    private final Collection fieldValues;
    private String fieldFunction;

    public MetadataInCriteria(String fieldName, Collection fieldValues) {
        ArgCheck.isNotNull((Object)fieldName);
        this.fieldName = fieldName;
        this.fieldValues = fieldValues;
    }

    public String getFieldFunction() {
        return this.fieldFunction;
    }

    public void setFieldFunction(String fieldFunction) {
        this.fieldFunction = fieldFunction;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Collection getFieldValues() {
        return this.fieldValues;
    }

    public boolean hasFieldWithCaseFunctions() {
        return this.fieldFunction != null && (this.fieldFunction.equalsIgnoreCase("UPPER") || this.fieldFunction.equalsIgnoreCase("UCASE") || this.fieldFunction.equalsIgnoreCase("LOWER") || this.fieldFunction.equalsIgnoreCase("LCASE"));
    }

    public Collection getLiteralCriteria() {
        ArrayList<MetadataLiteralCriteria> litCriteria = new ArrayList<MetadataLiteralCriteria>();
        Iterator iter = this.getFieldValues().iterator();
        while (iter.hasNext()) {
            MetadataLiteralCriteria literalCrit = new MetadataLiteralCriteria(this.fieldName, iter.next());
            literalCrit.setFieldFunction(this.fieldFunction);
            litCriteria.add(literalCrit);
        }
        return litCriteria;
    }
}

