/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.internal;

import com.metamatrix.connector.metadata.ResultsIterator;
import com.metamatrix.connector.metadata.internal.IObjectQuery;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.connector.metadata.internal.MetadataException;
import com.metamatrix.connector.metadata.internal.ReflectionWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ObjectQueryProcessor
implements ResultsIterator.ResultsProcessor {
    private final IObjectSource objectSource;
    private String tableDefiningMethodName = null;
    private IObjectQuery query;

    public ObjectQueryProcessor(IObjectSource objectSource) {
        this.objectSource = objectSource;
    }

    public ResultsIterator process(IObjectQuery query) throws MetadataException {
        int endMethodNameIndex;
        String tableName;
        this.tableDefiningMethodName = null;
        String tableNameForObjectSource = tableName = query.getTableNameInSource();
        int startMethodNameIndex = tableName.lastIndexOf(String.valueOf('('));
        if (startMethodNameIndex > 0 && (endMethodNameIndex = tableName.lastIndexOf(String.valueOf(')'))) > 0 && endMethodNameIndex > startMethodNameIndex) {
            this.tableDefiningMethodName = tableName.substring(startMethodNameIndex + 1, endMethodNameIndex);
            tableNameForObjectSource = tableName.substring(0, startMethodNameIndex);
        }
        this.query = query;
        Collection results = this.objectSource.getObjects(tableNameForObjectSource, query.getCriteria());
        return new ResultsIterator(this, results.iterator());
    }

    @Override
    public void createRows(Object resultObject, List rows) {
        ReflectionWrapper wrapper = new ReflectionWrapper(resultObject);
        if (this.tableDefiningMethodName == null) {
            this.addRow(wrapper, null, rows);
        } else {
            Collection<Object> subTableCollection = null;
            Object subTableResults = wrapper.get(this.tableDefiningMethodName);
            if (subTableResults.getClass().isArray()) {
                subTableCollection = Arrays.asList((Object[])subTableResults);
            } else if (subTableResults instanceof Collection) {
                subTableCollection = (Collection)subTableResults;
            }
            this.createRowsFor(wrapper, subTableCollection, rows);
        }
    }

    private void createRowsFor(ReflectionWrapper wrapperAroundResultObject, Collection subTableCollection, List rows) {
        for (Object subTableObject : subTableCollection) {
            this.addRow(wrapperAroundResultObject, subTableObject, rows);
        }
    }

    private void addRow(ReflectionWrapper wrapper, Object subTableObject, List rows) {
        ArrayList<Object> newRow = new ArrayList<Object>();
        String[] columnNames = this.query.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            Object value = null;
            if (columnNames[i].equals(this.tableDefiningMethodName)) {
                value = subTableObject;
            } else if (columnNames[i].startsWith(this.tableDefiningMethodName + '.')) {
                ReflectionWrapper subWrapper = new ReflectionWrapper(subTableObject);
                String columnMethodName = columnNames[i].substring(this.tableDefiningMethodName.length() + 1);
                value = subWrapper.get(columnMethodName);
            } else {
                value = wrapper.get(columnNames[i]);
            }
            this.query.checkType(i, value);
            if (value != null) {
                this.query.checkCaseType(i, value);
                Integer caseType = this.query.getCaseType(i);
                if (caseType.equals(IObjectQuery.UPPER_CASE)) {
                    value = value.toString().toUpperCase();
                } else if (caseType.equals(IObjectQuery.LOWER_CASE)) {
                    value = value.toString().toLowerCase();
                }
            }
            newRow.add(value);
        }
        rows.add(newRow);
    }
}

