/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

public final class CharOperation {
    public static final boolean match(char[] pattern, char[] name, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int patternEnd = pattern.length;
        int nameEnd = name.length;
        int iPattern = 0;
        int iName = 0;
        if (patternEnd < 0) {
            patternEnd = pattern.length;
        }
        if (nameEnd < 0) {
            nameEnd = name.length;
        }
        char patternChar = '\u0000';
        while (iPattern < patternEnd && (patternChar = pattern[iPattern]) != '*') {
            if (iName == nameEnd) {
                return false;
            }
            if (isCaseSensitive && patternChar != name[iName] && patternChar != '?') {
                return false;
            }
            if (!isCaseSensitive && Character.toLowerCase(patternChar) != Character.toLowerCase(name[iName]) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            char matchChar;
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern[iPattern];
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            char c = matchChar = isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName]);
            if (isCaseSensitive ? matchChar != patternChar && patternChar != '?' : matchChar != Character.toLowerCase(patternChar) && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern[iPattern] == '*';
    }

    public static final boolean prefixEquals(char[] prefix, char[] name, boolean isCaseSensitive) {
        int max = prefix.length;
        if (name.length < max) {
            return false;
        }
        int i = max;
        while (--i >= 0) {
            if (prefix[i] == name[i] || isCaseSensitive && Character.toLowerCase(prefix[i]) == Character.toLowerCase(name[i])) continue;
            return false;
        }
        return true;
    }
}

