/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.impl;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.metadata.runtime.impl.MetadataRecordDelegate;
import com.metamatrix.modeler.core.container.EObjectFinder;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMetadataRecord
implements MetadataRecord {
    private static final int DEFAULT_INDEX_VERSION = 0;
    private String pathString;
    private String modelName;
    private String resourcePath;
    private int indexVersion = 0;
    private char recordType;
    private transient Map propValues;
    protected Object eObject;
    protected MetadataRecordDelegate delegate;
    private EObjectFinder finder;

    @Override
    public String getUUID() {
        return this.delegate.getUUID();
    }

    @Override
    public String getParentUUID() {
        return this.delegate.getParentUUID();
    }

    @Override
    public String getNameInSource() {
        return this.delegate.getNameInSource();
    }

    @Override
    public String getModelName() {
        if (this.modelName == null) {
            int prntIdx;
            int n = prntIdx = this.getFullName() != null ? this.getFullName().indexOf(46) : -1;
            this.modelName = prntIdx <= 0 ? this.getFullName() : (this.getFullName() != null ? this.getFullName().substring(0, prntIdx) : null);
        }
        return this.modelName;
    }

    @Override
    public String getFullName() {
        return this.delegate.getFullName();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getPathString() {
        if (this.pathString == null) {
            this.pathString = this.getFullName() != null ? this.getFullName().replace('.', '/') : null;
        }
        return this.pathString;
    }

    @Override
    public String getPath() {
        return this.getPathString();
    }

    @Override
    public String getParentFullName() {
        int prntIdx;
        int n = prntIdx = this.getFullName() != null ? this.getFullName().lastIndexOf('.' + this.getName()) : -1;
        if (prntIdx <= 0) {
            return "";
        }
        return this.getFullName().substring(0, prntIdx);
    }

    @Override
    public String getParentPathString() {
        String parentFullName = this.getParentFullName();
        return parentFullName != null ? parentFullName.replace('.', '/') : null;
    }

    @Override
    public char getRecordType() {
        return this.recordType;
    }

    public void setNameInSource(String string) {
        this.delegate.setNameInSource(string);
    }

    public void setFullName(String fullName) {
        this.delegate.setFullName(fullName);
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void setUUID(String string) {
        this.delegate.setUUID(string);
    }

    public void setParentUUID(String string) {
        this.delegate.setParentUUID(string);
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public void setIndexVersion(int version) {
        this.indexVersion = version;
    }

    public void setEObjectFinder(EObjectFinder finder) {
        this.finder = finder;
    }

    @Override
    public Object getEObject() {
        if (this.eObject != null) {
            return this.eObject;
        }
        Assertion.isNotNull((Object)this.finder);
        try {
            String uuid = this.getUUID();
            int delimitIndex = uuid.indexOf(58);
            ObjectID objID = UUID.stringToObject((String)uuid.substring(delimitIndex + 1));
            return this.finder.find(objID);
        }
        catch (Exception e) {
            LogManager.logWarning((String)"com.metamatrix.metadata.runtime", (Throwable)e, (String)e.getMessage());
            return null;
        }
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String path) {
        this.resourcePath = path;
    }

    public void setRecordType(char c) {
        this.recordType = c;
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        ArgCheck.isNotNull((Object)propertyName);
        if (this.propValues != null) {
            return this.propValues.get(propertyName);
        }
        return null;
    }

    @Override
    public void setPropertyValue(String propertyName, Object propertyVame) {
        if (propertyName != null && propertyVame != null) {
            if (this.propValues == null) {
                this.propValues = new HashMap();
            }
            this.propValues.put(propertyName, propertyVame);
        }
    }

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractMetadataRecord other = (AbstractMetadataRecord)obj;
        if (this.getRecordType() != other.getRecordType()) {
            return false;
        }
        if (!EquivalenceUtil.areEqual((Object)this.getUUID(), (Object)other.getUUID())) {
            return false;
        }
        if (!EquivalenceUtil.areEqual((Object)this.getParentUUID(), (Object)other.getParentUUID())) {
            return false;
        }
        if (!EquivalenceUtil.areEqual((Object)this.getFullName(), (Object)other.getFullName())) {
            return false;
        }
        return EquivalenceUtil.areEqual((Object)this.getNameInSource(), (Object)other.getNameInSource());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (int)this.recordType);
        myHash = HashCodeUtil.hashCode((int)myHash, (Object)this.delegate.getFullName());
        myHash = HashCodeUtil.hashCode((int)myHash, (Object)this.delegate.getUUID());
        myHash = HashCodeUtil.hashCode((int)myHash, (Object)this.delegate.getParentUUID());
        myHash = HashCodeUtil.hashCode((int)myHash, (Object)this.delegate.getNameInSource());
        return myHash;
    }
}

