/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.api.MetadataObject;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import java.io.Serializable;
import java.util.Properties;

public abstract class BasicMetadataObject
implements MetadataObject,
Serializable {
    private MetadataID id;
    private BasicVirtualDatabaseID virtualDatabaseID = null;
    private Properties properties;

    protected BasicMetadataObject(BasicVirtualDatabaseID virtualDBID) {
        if (virtualDBID == null) {
            throw new MetaMatrixRuntimeException("ERR.008.005.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0007"));
        }
        this.id = virtualDBID;
        this.virtualDatabaseID = virtualDBID;
    }

    protected BasicMetadataObject(MetadataID metadataID, BasicVirtualDatabaseID virtualDBID) {
        if (virtualDBID == null || metadataID == null) {
            throw new MetaMatrixRuntimeException("ERR.008.005.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0007"));
        }
        this.id = metadataID;
        this.virtualDatabaseID = virtualDBID;
    }

    public VirtualDatabaseID getVirtualDatabaseID() {
        return this.virtualDatabaseID;
    }

    public String getNameInSource() {
        String alias = this.getAlias();
        if (alias != null) {
            return alias;
        }
        return this.getName();
    }

    public boolean hasNameInSource() {
        return this.getAlias() != null;
    }

    public String getAlias() {
        return null;
    }

    public String getPath() {
        return null;
    }

    public Properties getProperties() throws VirtualDatabaseException {
        return this.properties;
    }

    public Properties getCurrentProperties() {
        return this.properties;
    }

    public void setProperties(Properties definedProperties) {
        this.properties = definedProperties;
    }

    public MetadataID getID() {
        return this.id;
    }

    public String getName() {
        return this.getID().getName();
    }

    public String getFullName() {
        return this.getID().getFullName();
    }

    protected void setID(MetadataID newID) {
        this.id = newID;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicMetadataObject) {
            BasicMetadataObject that = (BasicMetadataObject)obj;
            return this.getID().equals(that.getID());
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        if (this.getClass().isInstance(obj)) {
            BasicMetadataObject that = (BasicMetadataObject)obj;
            return this.getID().compareTo((Object)that.getID());
        }
        throw new MetaMatrixRuntimeException("ERR.008.005.0008", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0008", new Object[]{obj.getClass(), this.getClass()}));
    }

    public String toString() {
        return this.id.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone this immutable object.");
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(name, value);
    }
}

