/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.model.BasicMetadataID;

public class BasicModelID
extends BasicMetadataID
implements ModelID {
    private String version;
    private String modelUuid;
    private String versionDate;

    public BasicModelID(String fullName, String version, long internalUniqueID) {
        super(fullName, internalUniqueID);
        if (this.getNameComponents().size() > 1) {
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{"Invalid ModelID \"", fullName, "\". Number of name components must be > 0."});
            throw new MetaMatrixRuntimeException("ERR.008.005.0016", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0016", new Object[]{fullName}));
        }
        this.version = version;
    }

    public BasicModelID(String fullName, String version) {
        super(fullName);
        if (this.getNameComponents().size() > 1) {
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{"Invalid ModelID \"", fullName, "\". Number of name components must be > 0."});
            throw new MetaMatrixRuntimeException("ERR.008.005.0016", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0016", new Object[]{fullName}));
        }
        this.version = version;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicModelID) {
            long thatUID;
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            BasicModelID that = (BasicModelID)obj;
            if (this.getClass() != that.getClass()) {
                return false;
            }
            if (this.getUuid() == null || that.getUuid() == null) {
                return this.getFullName().equalsIgnoreCase(that.getFullName());
            }
            if (!this.getUuid().equals(that.getUuid())) {
                return false;
            }
            if (!this.getFullName().equalsIgnoreCase(that.getFullName())) {
                return false;
            }
            long thisUID = this.getUID();
            return thisUID == (thatUID = that.getUID());
        }
        return false;
    }

    public BasicModelID(String fullName) {
        super(fullName);
        if (this.getNameComponents().size() > 1) {
            throw new MetaMatrixRuntimeException("ERR.008.005.0016", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0016", new Object[]{fullName}));
        }
        this.version = null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (this.version == null) {
            this.version = version;
        }
        if (this.version.equals(FAKE_NAME)) {
            this.version = version;
        }
    }

    public String getUuid() {
        return this.modelUuid;
    }

    public void setUuid(String uuid) {
        this.modelUuid = uuid;
    }

    public String getVersionDate() {
        return this.versionDate;
    }

    public void setVersionDate(String dateString) {
        this.versionDate = dateString;
    }
}

