/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.model.BasicMetadataID;

public class BasicVirtualDatabaseID
extends BasicMetadataID
implements VirtualDatabaseID {
    private String version;

    public BasicVirtualDatabaseID(String fullName, String versionName, long internalUniqueID) {
        super(fullName, internalUniqueID);
        this.version = versionName;
        this.updateHashCode();
    }

    public BasicVirtualDatabaseID(String fullName, String versionName) {
        super(fullName);
        this.version = versionName;
        this.updateHashCode();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.updateHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicVirtualDatabaseID) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            BasicVirtualDatabaseID that = (BasicVirtualDatabaseID)obj;
            if (this.getClass() != that.getClass()) {
                return false;
            }
            return (this.getFullName() + this.version).equalsIgnoreCase(that.getFullName() + that.getVersion());
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        BasicVirtualDatabaseID that = (BasicVirtualDatabaseID)obj;
        if (obj == null) {
            throw new MetaMatrixRuntimeException("ERR.008.000.0005", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0005"));
        }
        int diff = this.hashCode() - that.hashCode();
        if (diff != 0) {
            return diff;
        }
        if (this.getClass() != that.getClass()) {
            diff = this.getClass().hashCode() - that.getClass().hashCode();
            return diff;
        }
        return (this.getFullName() + this.version).compareToIgnoreCase(that.getFullName() + that.getVersion());
    }

    @Override
    public int compareToByName(Object obj) {
        BasicVirtualDatabaseID that = (BasicVirtualDatabaseID)obj;
        if (obj == null) {
            throw new MetaMatrixRuntimeException("ERR.008.000.0005", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0005"));
        }
        return (this.getFullName() + this.version).compareToIgnoreCase(that.getFullName() + that.getVersion());
    }

    @Override
    protected int computeHashCode() {
        return (this.getFullName() + this.version).toLowerCase().hashCode();
    }
}

