/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.metadata.runtime.api.Element;
import com.metamatrix.metadata.runtime.api.Group;
import com.metamatrix.metadata.runtime.api.GroupID;
import com.metamatrix.metadata.runtime.api.MetadataSourceAPI;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.Procedure;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseMetadata;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class BasicVirtualDatabaseMetadata
implements VirtualDatabaseMetadata {
    private MetadataSourceAPI metadataSource = null;
    private VirtualDatabaseID vdbID = null;

    public BasicVirtualDatabaseMetadata(MetadataSourceAPI metadataSource, VirtualDatabaseID id) {
        this.metadataSource = metadataSource;
        this.vdbID = id;
    }

    @Override
    public boolean isModelDetailsLoaded() {
        return this.metadataSource.isModelDetailsLoaded();
    }

    @Override
    public Collection getDisplayableModels() throws VirtualDatabaseException {
        return this.metadataSource.getDisplayableModels();
    }

    @Override
    public Collection getAllModels() throws VirtualDatabaseException {
        return this.metadataSource.getAllModels();
    }

    @Override
    public Model getModel(String name) throws VirtualDatabaseException {
        BasicModelID modelID = new BasicModelID(name);
        return this.metadataSource.getModel(modelID);
    }

    @Override
    public boolean isVisible(String resourcePath) throws VirtualDatabaseException {
        return this.metadataSource.isVisible(resourcePath);
    }

    @Override
    public VirtualDatabase getVirtualDatabase() throws VirtualDatabaseException {
        return this.metadataSource.getVirtualDatabase();
    }

    @Override
    public VirtualDatabaseID getVirtualDatabaseID() {
        return this.vdbID;
    }

    @Override
    public List getALLPaths(Collection models) throws VirtualDatabaseException {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = models.iterator();
        while (iter.hasNext()) {
            ModelID modelID = (ModelID)((Model)iter.next()).getID();
            Collection groups = this.metadataSource.getGroupsInModel(modelID);
            for (Group group : groups) {
                result.add(group.getFullName());
                List elements = this.getElementsInGroup((GroupID)group.getID());
                if (elements == null) continue;
                for (Element e : elements) {
                    result.add(e.getFullName());
                }
            }
            Collection procedures = null;
            Procedure procedure2 = null;
            procedures = this.metadataSource.getProceduresInModel(modelID);
            for (Procedure procedure2 : procedures) {
                result.add(procedure2.getFullName());
            }
        }
        return result;
    }

    @Override
    public Collection getProcedures(ModelID modelID) throws VirtualDatabaseException {
        return this.metadataSource.getProceduresInModel(modelID);
    }

    @Override
    public List getElementsInGroup(GroupID groupID) throws VirtualDatabaseException {
        return this.metadataSource.getElementsInGroup(groupID);
    }

    @Override
    public Collection getGroupsInModel(ModelID modelID) throws VirtualDatabaseException {
        return this.metadataSource.getGroupsInModel(modelID);
    }
}

