/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ModelFileUtil {
    public static final String MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi";
    public static final String DOT_PROJECT = ".project";
    public static final String FILE_COLON = "file:";
    public static final String EXTENSION_XML = "xml";
    public static final String EXTENSION_XMI = "xmi";
    public static final String EXTENSION_XSD = "xsd";
    public static final String EXTENSION_VDB = "vdb";
    public static final String EXTENSION_ECORE = "ecore";
    public static final String EXTENSION_WSDL = "wsdl";
    private static XmiHeaderCache CACHE;

    public static void setCache(XmiHeaderCache cache) {
        CACHE = cache;
    }

    public static boolean isModelFile(File resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            String extension = FileUtils.getExtension((String)resource.getAbsolutePath());
            return ModelFileUtil.isModelFileExtension(extension, true);
        }
        if (ModelFileUtil.isXsdFile(resource)) {
            return true;
        }
        if (ModelFileUtil.isVdbArchiveFile(resource)) {
            return false;
        }
        if (!EXTENSION_XMI.equals(ModelFileUtil.getFileExtension(resource))) {
            return false;
        }
        XMIHeader header = ModelFileUtil.getXmiHeader(resource);
        if (header != null) {
            if (header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
                return false;
            }
            if (header.getUUID() != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isXsdFile(File resource) {
        return EXTENSION_XSD.equals(ModelFileUtil.getFileExtension(resource));
    }

    public static boolean isVdbArchiveFile(File resource) {
        return EXTENSION_VDB.equals(ModelFileUtil.getFileExtension(resource));
    }

    public static String getFileExtension(File resource) {
        if (resource != null) {
            return FileUtils.getExtension((File)resource);
        }
        return "";
    }

    public static boolean isModelFileExtension(String extension, boolean caseSensitive) {
        String exten;
        if (extension == null) {
            return false;
        }
        String string = exten = caseSensitive ? extension : extension.toLowerCase();
        if (EXTENSION_XMI.equals(exten)) {
            return true;
        }
        if (EXTENSION_XSD.equals(exten)) {
            return true;
        }
        if (EXTENSION_VDB.equals(exten)) {
            return false;
        }
        return false;
    }

    public static XMIHeader getXmiHeader(File resource) {
        if (resource != null && resource.isFile() && resource.exists() && resource.canRead()) {
            XMIHeader header;
            if (CACHE != null && (header = CACHE.getCachedXmiHeader(resource)) != null) {
                return header;
            }
            if (ModelFileUtil.isVdbArchiveFile(resource)) {
                return ModelFileUtil.getXmiHeaderForVdbArchive(resource);
            }
            try {
                header = XMIHeaderReader.readHeader((File)resource);
                if (CACHE != null) {
                    CACHE.setXmiHeaderToCache(resource, header);
                }
                return header;
            }
            catch (MetaMatrixCoreException e) {
                LogManager.logWarning((String)"com.metamatrix.metadata.runtime", (Throwable)e, (String)e.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMIHeader getXmiHeaderForVdbArchive(File vdbArchiveJar) {
        if (ModelFileUtil.isVdbArchiveFile(vdbArchiveJar)) {
            if (vdbArchiveJar.length() == 0L) {
                return null;
            }
            ZipFile zipFile = null;
            XMIHeader header = null;
            InputStream manifestStream = null;
            try {
                zipFile = new ZipFile(vdbArchiveJar);
                manifestStream = ModelFileUtil.getManifestModelContentsFromVdbArchive(zipFile);
                header = ModelFileUtil.getXmiHeader(manifestStream);
            }
            catch (ZipException e) {
                LogManager.logWarning((String)"com.metamatrix.metadata.runtime", (Throwable)e, (String)e.getMessage());
            }
            catch (IOException e) {
                LogManager.logWarning((String)"com.metamatrix.metadata.runtime", (Throwable)e, (String)e.getMessage());
            }
            finally {
                if (manifestStream != null) {
                    try {
                        manifestStream.close();
                    }
                    catch (IOException err) {}
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {}
                }
            }
            return header;
        }
        return null;
    }

    public static InputStream getManifestModelContentsFromVdbArchive(ZipFile zipFile) {
        return ModelFileUtil.getFileContentsFromArchive(zipFile, MANIFEST_MODEL_NAME);
    }

    public static InputStream getFileContentsFromArchive(ZipFile zipFile, String zipEntryName) {
        ArgCheck.isNotNull((Object)zipFile);
        ArgCheck.isNotEmpty((String)zipEntryName);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry == null || !entry.getName().equalsIgnoreCase(zipEntryName)) continue;
                return zipFile.getInputStream(entry);
            }
        }
        catch (IOException e) {
            LogManager.logWarning((String)"com.metamatrix.metadata.runtime", (Throwable)e, (String)e.getMessage());
        }
        return null;
    }

    public static XMIHeader getXmiHeader(InputStream resourceStream) {
        if (resourceStream != null) {
            try {
                return XMIHeaderReader.readHeader((InputStream)resourceStream);
            }
            catch (MetaMatrixCoreException e) {
                LogManager.logWarning((String)"com.metamatrix.metadata.runtime", (Throwable)e, (String)e.getMessage());
            }
        }
        return null;
    }

    public static interface XmiHeaderCache {
        public XMIHeader getCachedXmiHeader(File var1);

        public void setXmiHeaderToCache(File var1, XMIHeader var2);
    }
}

