/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.plugins.context.zip.ZipEntryContext;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.index.IEntryResult;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.StringUtil;
import org.teiid.internal.core.index.Index;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.RecordFactory;
import org.teiid.metadata.index.RuntimeMetadataPlugin;
import org.teiid.metadata.index.SimpleIndexUtil;
import org.teiid.metadata.index.TransformationRecordImpl;
import org.teiid.query.metadata.TransformationMetadata;

public class IndexMetadataFactory {
    private Index[] indexes;
    private RecordFactory recordFactory = new RecordFactory();
    private Map<String, String> annotationCache = new HashMap<String, String>();
    private Map<String, LinkedHashMap<String, String>> extensionCache = new HashMap<String, LinkedHashMap<String, String>>();
    private Map<String, Datatype> datatypeCache;
    private Map<String, KeyRecord> primaryKeyCache = new HashMap<String, KeyRecord>();
    private Map<String, Table> tableCache = new HashMap<String, Table>();
    private MetadataStore store;
    private HashSet<VirtualFile> indexFiles = new HashSet();
    private LinkedHashMap<String, TransformationMetadata.Resource> vdbEntries;

    public IndexMetadataFactory() {
    }

    public IndexMetadataFactory(URL url) throws IOException, URISyntaxException {
        VFS.init();
        ZipEntryContext context = new ZipEntryContext(url);
        VirtualFileHandler vfh = context.getRoot();
        VirtualFile vdb = new VirtualFile(vfh);
        List children = vdb.getChildrenRecursively(new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.getName().endsWith(".INDEX");
            }
        });
        for (VirtualFile f : children) {
            this.addIndexFile(f);
        }
        this.addEntriesPlusVisibilities(vdb, new VDBMetaData());
    }

    public MetadataStore getMetadataStore(Collection<Datatype> systemDatatypes) throws IOException {
        if (this.store == null) {
            this.store = new MetadataStore();
            ArrayList<Index> tmp = new ArrayList<Index>();
            for (VirtualFile f : this.indexFiles) {
                Index index = new Index(f, true);
                index.setDoCache(true);
                tmp.add(index);
            }
            this.indexes = tmp.toArray(new Index[tmp.size()]);
            this.getAnnotationCache();
            this.getExtensionCache();
            Map<String, Datatype> datatypes = this.getDatatypeCache();
            if (systemDatatypes != null) {
                for (Datatype datatype : systemDatatypes) {
                    datatypes.put(datatype.getUUID(), datatype);
                }
            }
            List keys = this.findMetadataRecords('K', null, false);
            for (KeyRecord keyRecord : keys) {
                this.primaryKeyCache.put(keyRecord.getUUID(), keyRecord);
            }
            this.getModels();
            this.getTables();
            this.getProcedures();
            for (Index index : tmp) {
                index.close();
            }
        }
        return this.store;
    }

    private void getExtensionCache() {
        IEntryResult[] properties;
        for (IEntryResult iEntryResult : properties = this.queryIndex('X', null, false)) {
            String str = new String(iEntryResult.getWord());
            List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
            int tokenIndex = 2;
            String uuid = (String)tokens.get(1);
            LinkedHashMap<String, String> result = this.extensionCache.get(uuid);
            if (result == null) {
                result = new LinkedHashMap();
                this.extensionCache.put(uuid, result);
            }
            result.put((String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        }
    }

    private void getAnnotationCache() {
        IEntryResult[] results;
        for (IEntryResult iEntryResult : results = this.queryIndex('W', null, false)) {
            String str = new String(iEntryResult.getWord());
            List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
            int indexVersion = this.recordFactory.getIndexVersion(iEntryResult.getWord());
            String uuid = (String)tokens.get(2);
            int tokenIndex = 6;
            if (this.recordFactory.includeAnnotationProperties(indexVersion)) {
                // empty if block
            }
            int n = ++tokenIndex;
            ++tokenIndex;
            this.annotationCache.put(uuid, (String)tokens.get(n));
        }
    }

    public void addIndexFile(VirtualFile f) {
        this.indexFiles.add(f);
    }

    public void addEntriesPlusVisibilities(VirtualFile root, VDBMetaData vdb) throws IOException {
        LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap = new LinkedHashMap<String, TransformationMetadata.Resource>();
        for (VirtualFile f : root.getChildrenRecursively()) {
            if (!f.isLeaf()) continue;
            String path = f.getPathName().substring(root.getPathName().length());
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            visibilityMap.put(path, new TransformationMetadata.Resource(f, this.isFileVisible(f.getPathName(), vdb)));
        }
        this.vdbEntries = visibilityMap;
    }

    private boolean isFileVisible(String pathInVDB, VDBMetaData vdb) {
        String modelName;
        ModelMetaData model;
        if (pathInVDB.endsWith(".xmi") && (model = vdb.getModel(modelName = StringUtil.getFirstToken((String)StringUtil.getLastToken((String)pathInVDB, (String)"/"), (String)"."))) != null) {
            return model.isVisible();
        }
        if (pathInVDB.startsWith("META-INF/")) {
            return false;
        }
        String entry = StringUtil.getLastToken((String)pathInVDB, (String)"/");
        if (entry.endsWith(".INDEX") || entry.endsWith(".SEARCH_INDEX")) {
            return false;
        }
        return !entry.equalsIgnoreCase("vdb.xml");
    }

    public LinkedHashMap<String, TransformationMetadata.Resource> getEntriesPlusVisibilities() {
        return this.vdbEntries;
    }

    public void getModels() {
        List records = this.findMetadataRecords('A', null, false);
        for (Schema modelRecord : records) {
            this.store.addSchema(modelRecord);
        }
    }

    public void getTables() {
        for (Schema model : this.store.getSchemas().values()) {
            List records = this.findMetadataRecords('B', model.getName() + '.' + '*', true);
            Collections.sort(records, new Comparator<Table>(){

                @Override
                public int compare(Table o1, Table o2) {
                    if (!o1.isMaterialized()) {
                        return -1;
                    }
                    if (!o2.isMaterialized()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (Table tableRecord : records) {
                this.tableCache.put(tableRecord.getUUID(), tableRecord);
                ArrayList columns = new ArrayList(this.findChildRecords((AbstractMetadataRecord)tableRecord, 'G'));
                for (Column columnRecordImpl : columns) {
                    columnRecordImpl.setDatatype(this.getDatatypeCache().get(columnRecordImpl.getDatatypeUUID()));
                    columnRecordImpl.setParent((ColumnSet)tableRecord);
                    String fullName = columnRecordImpl.getName();
                    if (!fullName.startsWith(tableRecord.getName() + '.')) continue;
                    columnRecordImpl.setName(fullName.substring(tableRecord.getName().length() + 1));
                }
                Collections.sort(columns);
                tableRecord.setColumns(columns);
                tableRecord.setAccessPatterns(this.findChildRecords((AbstractMetadataRecord)tableRecord, 'H'));
                HashMap<String, Column> uuidColumnMap = new HashMap<String, Column>();
                for (Column columnRecordImpl : columns) {
                    uuidColumnMap.put(columnRecordImpl.getUUID(), columnRecordImpl);
                }
                for (KeyRecord columnSetRecordImpl : tableRecord.getAccessPatterns()) {
                    this.loadColumnSetRecords((ColumnSet<?>)columnSetRecordImpl, (Map<String, Column>)uuidColumnMap);
                    columnSetRecordImpl.setParent((AbstractMetadataRecord)tableRecord);
                }
                tableRecord.setForiegnKeys(this.findChildRecords((AbstractMetadataRecord)tableRecord, 'J'));
                for (ForeignKey foreignKeyRecord : tableRecord.getForeignKeys()) {
                    foreignKeyRecord.setPrimaryKey(this.getPrimaryKey(foreignKeyRecord.getUniqueKeyID()));
                    this.loadColumnSetRecords((ColumnSet<?>)foreignKeyRecord, (Map<String, Column>)uuidColumnMap);
                    foreignKeyRecord.setParent((AbstractMetadataRecord)tableRecord);
                }
                tableRecord.setUniqueKeys(this.findChildRecords((AbstractMetadataRecord)tableRecord, 'I'));
                for (KeyRecord columnSetRecordImpl : tableRecord.getUniqueKeys()) {
                    this.loadColumnSetRecords((ColumnSet<?>)columnSetRecordImpl, (Map<String, Column>)uuidColumnMap);
                    columnSetRecordImpl.setParent((AbstractMetadataRecord)tableRecord);
                }
                tableRecord.setIndexes(this.findChildRecords((AbstractMetadataRecord)tableRecord, 'L'));
                for (KeyRecord columnSetRecordImpl : tableRecord.getIndexes()) {
                    this.loadColumnSetRecords((ColumnSet<?>)columnSetRecordImpl, (Map<String, Column>)uuidColumnMap);
                    columnSetRecordImpl.setParent((AbstractMetadataRecord)tableRecord);
                }
                if (tableRecord.getPrimaryKey() != null) {
                    KeyRecord primaryKey = this.getPrimaryKey(tableRecord.getPrimaryKey().getUUID());
                    this.loadColumnSetRecords((ColumnSet<?>)primaryKey, (Map<String, Column>)uuidColumnMap);
                    primaryKey.setParent((AbstractMetadataRecord)tableRecord);
                    tableRecord.setPrimaryKey(primaryKey);
                }
                String groupUUID = tableRecord.getUUID();
                if (tableRecord.isVirtual()) {
                    TransformationRecordImpl select;
                    TransformationRecordImpl delete;
                    TransformationRecordImpl insert;
                    TransformationRecordImpl update = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'R', false);
                    if (update != null) {
                        tableRecord.setUpdatePlan(update.getTransformation());
                    }
                    if ((insert = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'Q', false)) != null) {
                        tableRecord.setInsertPlan(insert.getTransformation());
                    }
                    if ((delete = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'S', false)) != null) {
                        tableRecord.setDeletePlan(delete.getTransformation());
                    }
                    if ((select = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'P', false)) == null) {
                        select = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'U', false);
                    }
                    if (select != null) {
                        tableRecord.setSelectTransformation(select.getTransformation());
                        tableRecord.setBindings(select.getBindings());
                        tableRecord.setSchemaPaths(select.getSchemaPaths());
                        tableRecord.setResourcePath(select.getResourcePath());
                    }
                }
                if (tableRecord.isMaterialized()) {
                    tableRecord.setMaterializedStageTable(this.tableCache.get(tableRecord.getMaterializedStageTable().getUUID()));
                    tableRecord.setMaterializedTable(this.tableCache.get(tableRecord.getMaterializedTable().getUUID()));
                }
                model.addTable(tableRecord);
            }
        }
    }

    private KeyRecord getPrimaryKey(String uuid) {
        KeyRecord key = this.primaryKeyCache.get(uuid);
        if (key == null) {
            throw new TeiidRuntimeException(uuid + " PrimaryKey " + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        return key;
    }

    public Map<String, Datatype> getDatatypeCache() {
        if (this.datatypeCache == null) {
            this.datatypeCache = new HashMap<String, Datatype>();
            List dataTypes = this.findMetadataRecords('M', null, false);
            for (Datatype datatypeRecordImpl : dataTypes) {
                this.datatypeCache.put(datatypeRecordImpl.getUUID(), datatypeRecordImpl);
                this.store.addDatatype(datatypeRecordImpl);
            }
        }
        return this.datatypeCache;
    }

    private Column findElement(String fullName) {
        Column columnRecord = (Column)this.getRecordByType(fullName, 'G');
        columnRecord.setDatatype(this.getDatatypeCache().get(columnRecord.getDatatypeUUID()));
        return columnRecord;
    }

    private AbstractMetadataRecord getRecordByType(String entityName, char recordType) {
        return this.getRecordByType(entityName, recordType, true);
    }

    private AbstractMetadataRecord getRecordByType(String entityName, char recordType, boolean mustExist) {
        List results = this.findMetadataRecords(recordType, entityName, false);
        int resultSize = results.size();
        if (resultSize == 1) {
            return (AbstractMetadataRecord)results.iterator().next();
        }
        if (resultSize == 0) {
            if (mustExist) {
                throw new TeiidRuntimeException(entityName + TransformationMetadata.NOT_EXISTS_MESSAGE);
            }
            return null;
        }
        throw new TeiidRuntimeException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.0", new Object[]{entityName}));
    }

    public void getProcedures() {
        for (Schema model : this.store.getSchemas().values()) {
            List procedureRecordImpls = this.findMetadataRecords('E', model.getName() + '.' + '*', true);
            for (Procedure procedureRecord : procedureRecordImpls) {
                TransformationRecordImpl transformRecord;
                ColumnSet resultRecord;
                for (int i = 0; i < procedureRecord.getParameters().size(); ++i) {
                    ProcedureParameter paramRecord = (ProcedureParameter)this.getRecordByType(((ProcedureParameter)procedureRecord.getParameters().get(i)).getUUID(), 'F');
                    paramRecord.setDatatype(this.getDatatypeCache().get(paramRecord.getDatatypeUUID()));
                    procedureRecord.getParameters().set(i, paramRecord);
                    paramRecord.setProcedure(procedureRecord);
                }
                ColumnSet result = procedureRecord.getResultSet();
                if (result != null && (resultRecord = (ColumnSet)this.getRecordByType(result.getUUID(), 'C', false)) != null) {
                    resultRecord.setParent((AbstractMetadataRecord)procedureRecord);
                    resultRecord.setName(RecordFactory.getShortName(resultRecord.getName()));
                    this.loadColumnSetRecords(resultRecord, null);
                    procedureRecord.setResultSet(resultRecord);
                }
                if (procedureRecord.isVirtual() && (transformRecord = (TransformationRecordImpl)this.getRecordByType(procedureRecord.getUUID(), 'T', false)) != null) {
                    procedureRecord.setQueryPlan(transformRecord.getTransformation());
                }
                model.addProcedure(procedureRecord);
            }
        }
    }

    private List findChildRecords(AbstractMetadataRecord parentRecord, char childRecordType) {
        String patternStr = this.getUUIDMatchPattern(childRecordType, parentRecord.getUUID(), true);
        IEntryResult[] results = this.queryIndex(childRecordType, patternStr.toCharArray(), false, true, false);
        return this.loadRecords(results);
    }

    private void loadColumnSetRecords(ColumnSet<?> indexRecord, Map<String, Column> columns) {
        for (int i = 0; i < indexRecord.getColumns().size(); ++i) {
            String uuid = ((Column)indexRecord.getColumns().get(i)).getUUID();
            Column c = null;
            if (columns != null) {
                c = columns.get(uuid);
            } else {
                c = this.findElement(uuid);
                c.setName(RecordFactory.getShortName(c.getName()));
            }
            indexRecord.getColumns().set(i, c);
            if (columns != null) continue;
            c.setParent(indexRecord);
        }
    }

    private List findMetadataRecords(char recordType, String entityName, boolean isPartialName) {
        IEntryResult[] results = this.queryIndex(recordType, entityName, isPartialName);
        List<AbstractMetadataRecord> records = this.loadRecords(results);
        return records;
    }

    private List<AbstractMetadataRecord> loadRecords(IEntryResult[] results) {
        List<AbstractMetadataRecord> records = this.recordFactory.getMetadataRecord(results);
        for (AbstractMetadataRecord metadataRecord : records) {
            String uuid = metadataRecord.getUUID();
            metadataRecord.setAnnotation(this.annotationCache.get(uuid));
            metadataRecord.setProperties(this.extensionCache.get(uuid));
        }
        return records;
    }

    private String getUUIDMatchPattern(char recordType, String uuid, boolean parent) {
        ArgCheck.isNotNull((Object)uuid);
        String patternStr = String.valueOf(recordType) + '\u00a0' + '*' + '\u00a0';
        if (parent) {
            for (int i = 0; i < 3; ++i) {
                patternStr = patternStr + String.valueOf('*') + '\u00a0';
            }
        }
        patternStr = patternStr + uuid.toLowerCase() + '\u00a0' + '*';
        return patternStr;
    }

    private IEntryResult[] queryIndex(char recordType, String entityName, boolean isPartialName) {
        IEntryResult[] results = null;
        if (StringUtil.startsWithIgnoreCase((String)entityName, (String)"mmuuid")) {
            String patternString = null;
            patternString = recordType == 'M' ? this.getDatatypeUUIDMatchPattern(entityName) : this.getUUIDMatchPattern(recordType, entityName, false);
            results = this.queryIndex(recordType, patternString.toCharArray(), false, true, true);
        } else if (isPartialName) {
            String patternString = this.getMatchPattern(recordType, entityName);
            results = this.queryIndex(recordType, patternString.toCharArray(), false, true, false);
        } else {
            String prefixString = this.getPrefixPattern(recordType, entityName);
            results = this.queryIndex(recordType, prefixString.toCharArray(), true, true, entityName != null);
        }
        return results;
    }

    private String getDatatypeUUIDMatchPattern(String uuid) {
        ArgCheck.isNotNull((Object)uuid);
        String uuidString = uuid;
        if (StringUtil.startsWithIgnoreCase((String)uuid, (String)"mmuuid")) {
            uuidString = uuid.toLowerCase();
        }
        String patternStr = "M\u00a0*\u00a0*\u00a0*\u00a0" + uuidString + '\u00a0' + '*';
        return patternStr;
    }

    private String getPrefixPattern(char recordType, String name) {
        String patternStr = "" + recordType + '\u00a0';
        if (name != null) {
            patternStr = patternStr + name.trim().toUpperCase() + '\u00a0';
        }
        return patternStr;
    }

    private String getMatchPattern(char recordType, String name) {
        ArgCheck.isNotNull((Object)name);
        String patternStr = "" + recordType + '\u00a0' + '*';
        if (name != null) {
            patternStr = patternStr + name.trim().toUpperCase() + '\u00a0' + '*';
        }
        return patternStr;
    }

    private IEntryResult[] queryIndex(char recordType, char[] pattern, boolean isPrefix, boolean isCaseSensitive, boolean returnFirstMatch) {
        String indexName = SimpleIndexUtil.getIndexFileNameForRecordType(recordType);
        Index[] search = SimpleIndexUtil.getIndexes(indexName, this.indexes);
        if (search.length == 0) {
            search = this.indexes;
        }
        try {
            return SimpleIndexUtil.queryIndex(search, pattern, isPrefix, isCaseSensitive, returnFirstMatch);
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }
}

