/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.core.index.IEntryResult;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.StringUtil;
import org.teiid.internal.core.index.EntryResult;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.TransformationRecordImpl;

public class RecordFactory {
    public static final int INDEX_RECORD_BLOCK_SIZE = 8160;
    public static final int NONVERSIONED_RECORD_INDEX_VERSION = 0;
    public static final int DELIMITER_INDEX_VERSION = 1;
    public static final int TABLE_MATERIALIZATION_INDEX_VERSION = 2;
    public static final int COLUMN_NATIVE_TYPE_INDEX_VERSION = 3;
    public static final int COLUMN_INPUT_PARAMETER_FLAG_INDEX_VERSION = 4;
    public static final int ANNOTATION_TAGS_INDEX_VERSION = 5;
    public static final int TRANSFORMATION_UUID_INDEX_VERSION = 6;
    public static final int COLUMN_NULL_DISTINCT_INDEX_VERSION = 7;
    public static final int PRIMITIVE_TYPE_ID_INDEX_VERSION = 8;
    public static final int PROCEDURE_UPDATE_COUNT_VERSION = 9;
    public static final int CURRENT_INDEX_VERSION = 9;
    private int version = 0;

    public List<AbstractMetadataRecord> getMetadataRecord(IEntryResult[] queryResult) {
        ArrayList<AbstractMetadataRecord> records = new ArrayList<AbstractMetadataRecord>(queryResult.length);
        for (int i = 0; i < queryResult.length; ++i) {
            AbstractMetadataRecord record = this.getMetadataRecord(queryResult[i].getWord());
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    private AbstractMetadataRecord getMetadataRecord(char[] record) {
        if (record == null || record.length == 0) {
            return null;
        }
        switch (record[0]) {
            case 'A': {
                return this.createModelRecord(record);
            }
            case 'B': {
                return this.createTableRecord(record);
            }
            case 'D': {
                return null;
            }
            case 'E': {
                return this.createProcedureRecord(record);
            }
            case 'F': {
                return this.createProcedureParameterRecord(record);
            }
            case 'G': {
                return this.createColumnRecord(record);
            }
            case 'H': {
                return this.createColumnSetRecord(record, (ColumnSet)new KeyRecord(KeyRecord.Type.AccessPattern));
            }
            case 'L': {
                return this.createColumnSetRecord(record, (ColumnSet)new KeyRecord(KeyRecord.Type.Index));
            }
            case 'C': {
                return this.createColumnSetRecord(record, new ColumnSet());
            }
            case 'I': {
                return this.createColumnSetRecord(record, (ColumnSet)new KeyRecord(KeyRecord.Type.Unique));
            }
            case 'K': {
                return this.createColumnSetRecord(record, (ColumnSet)new KeyRecord(KeyRecord.Type.Primary));
            }
            case 'J': {
                return this.createForeignKeyRecord(record);
            }
            case 'M': {
                return this.createDatatypeRecord(record);
            }
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': {
                return this.createTransformationRecord(record);
            }
        }
        throw new IllegalArgumentException("Invalid record type for creating MetadataRecord " + record[0]);
    }

    public static IEntryResult joinEntryResults(IEntryResult result, IEntryResult[] continuationResults, int blockSize) {
        char[] baseResult = result.getWord();
        if (baseResult.length < blockSize || baseResult[blockSize - 1] != '&') {
            return result;
        }
        String baseStr = new String(baseResult);
        String objectID = RecordFactory.extractUUIDString(result);
        StringBuffer sb = new StringBuffer();
        sb.append(baseStr.substring(0, blockSize - 1));
        IEntryResult[] sortedResults = RecordFactory.sortContinuationResults(objectID, continuationResults);
        for (int i = 0; i < sortedResults.length; ++i) {
            int beginIndex;
            char[] continuation = sortedResults[i].getWord();
            int segNumber = RecordFactory.getContinuationSegmentNumber(objectID, sortedResults[i]);
            for (int j = beginIndex = objectID.length() + Integer.toString(segNumber).length() + 5; j < continuation.length; ++j) {
                if (j >= blockSize - 1) continue;
                sb.append(continuation[j]);
            }
        }
        return new EntryResult(sb.toString().toCharArray(), result.getFileReferences());
    }

    private static IEntryResult[] sortContinuationResults(String objectID, IEntryResult[] continuationResults) {
        if (continuationResults.length < 10) {
            return continuationResults;
        }
        IEntryResult[] sortedResults = new IEntryResult[continuationResults.length];
        for (int i = 0; i < continuationResults.length; ++i) {
            int segNumber = RecordFactory.getContinuationSegmentNumber(objectID, continuationResults[i]);
            sortedResults[segNumber - 1] = continuationResults[i];
        }
        return sortedResults;
    }

    public static int getContinuationSegmentNumber(String objectID, IEntryResult continuationResult) {
        char[] record = continuationResult.getWord();
        int segNumber = -1;
        int index = objectID.length() + 4;
        if (record[index + 1] == '\u00a0') {
            segNumber = Character.getNumericValue(record[index]);
        } else if (record[index + 2] == '\u00a0') {
            char[] temp = new char[]{record[index], record[index + 1]};
            String segCount = new String(temp);
            segNumber = Integer.parseInt(segCount);
        } else if (record[index + 3] == '\u00a0') {
            char[] temp = new char[]{record[index], record[index + 1], record[index + 2]};
            String segCount = new String(temp);
            segNumber = Integer.parseInt(segCount);
        }
        return segNumber;
    }

    public static String extractUUIDString(IEntryResult result) {
        char[] word = result.getWord();
        String baseStr = new String(word);
        int beginIndex = baseStr.indexOf("mmuuid");
        int endIndex = word.length;
        Assertion.assertTrue((beginIndex != -1 ? 1 : 0) != 0);
        for (int i = beginIndex; i < word.length; ++i) {
            if (word[i] != '\u00a0') continue;
            endIndex = i;
            break;
        }
        Assertion.assertTrue((beginIndex < endIndex ? 1 : 0) != 0);
        return new String(baseStr.substring(beginIndex, endIndex));
    }

    public Schema createModelRecord(char[] record) {
        String str = new String(record);
        List<String> tokens = RecordFactory.getStrings(str, '\u00a0');
        Schema model = new Schema();
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)model, tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++));
        int n = ++tokenIndex;
        ++tokenIndex;
        model.setPhysical(Integer.parseInt(tokens.get(n)) == 0);
        model.setPrimaryMetamodelUri(this.getObjectValue(tokens.get(tokenIndex++)));
        char[] supportFlags = tokens.get(tokenIndex++).toCharArray();
        model.setVisible(this.getBooleanValue(supportFlags[0]));
        this.setRecordFooterValues((AbstractMetadataRecord)model, tokens, tokenIndex);
        return model;
    }

    public TransformationRecordImpl createTransformationRecord(char[] record) {
        String str = new String(record);
        List<String> tokens = RecordFactory.getStrings(str, '\u00a0');
        TransformationRecordImpl transform = new TransformationRecordImpl();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 2;
        this.getObjectValue(tokens.get(tokenIndex++));
        if (this.includeTransformationUUID(indexVersion)) {
            transform.setUUID(this.getObjectValue(tokens.get(tokenIndex++)));
        }
        transform.setTransformation(this.getObjectValue(tokens.get(tokenIndex++)));
        List<String> bindings = RecordFactory.getStrings(tokens.get(tokenIndex++), this.getListDelimiter(indexVersion));
        transform.setBindings(bindings);
        List<String> schemaPaths = RecordFactory.getStrings(tokens.get(tokenIndex++), this.getListDelimiter(indexVersion));
        transform.setSchemaPaths(schemaPaths);
        this.setRecordFooterValues(transform, tokens, tokenIndex);
        return transform;
    }

    protected static short getKeyTypeForRecordType(char recordType) {
        switch (recordType) {
            case 'I': {
                return 2;
            }
            case 'L': {
                return 5;
            }
            case 'H': {
                return 4;
            }
            case 'K': {
                return 0;
            }
            case 'J': {
                return 1;
            }
            case 'C': {
                return -1;
            }
        }
        throw new IllegalArgumentException("Invalid record type, for key" + recordType);
    }

    public Table createTableRecord(char[] record) {
        String str = new String(record);
        List<String> tokens = RecordFactory.getStrings(str, '\u00a0');
        Table table = new Table();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)table, tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++));
        table.setCardinality(Integer.parseInt(tokens.get(tokenIndex++)));
        table.setTableType(Table.Type.values()[Integer.parseInt(tokens.get(tokenIndex++))]);
        char[] supportFlags = tokens.get(tokenIndex++).toCharArray();
        table.setVirtual(this.getBooleanValue(supportFlags[0]));
        table.setSystem(this.getBooleanValue(supportFlags[1]));
        table.setSupportsUpdate(this.getBooleanValue(supportFlags[2]));
        if (this.includeMaterializationFlag(indexVersion)) {
            table.setMaterialized(this.getBooleanValue(supportFlags[3]));
        }
        int n = ++tokenIndex;
        ++tokenIndex;
        String id = this.getObjectValue(tokens.get(n));
        if (id != null) {
            KeyRecord pk = new KeyRecord(KeyRecord.Type.Primary);
            pk.setUUID(id);
            table.setPrimaryKey(pk);
        }
        tokenIndex += 4;
        if (this.includeMaterializationFlag(indexVersion)) {
            Table matTable = new Table();
            matTable.setUUID(tokens.get(tokenIndex++));
            table.setMaterializedTable(matTable);
            matTable = new Table();
            matTable.setUUID(tokens.get(tokenIndex++));
            table.setMaterializedStageTable(matTable);
        }
        this.setRecordFooterValues((AbstractMetadataRecord)table, tokens, tokenIndex);
        return table;
    }

    private static List<Column> createColumns(List<String> uuids) {
        ArrayList<Column> columns = new ArrayList<Column>(uuids.size());
        for (String uuid : uuids) {
            Column column = new Column();
            column.setUUID(uuid);
            columns.add(column);
        }
        return columns;
    }

    public Column createColumnRecord(char[] record) {
        String str = new String(record);
        List<String> tokens = RecordFactory.getStrings(str, '\u00a0');
        Column column = new Column();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)column, tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++));
        char[] supportFlags = tokens.get(tokenIndex++).toCharArray();
        column.setSelectable(this.getBooleanValue(supportFlags[0]));
        column.setUpdatable(this.getBooleanValue(supportFlags[1]));
        column.setAutoIncremented(this.getBooleanValue(supportFlags[2]));
        column.setCaseSensitive(this.getBooleanValue(supportFlags[3]));
        column.setSigned(this.getBooleanValue(supportFlags[4]));
        column.setCurrency(this.getBooleanValue(supportFlags[5]));
        column.setFixedLength(this.getBooleanValue(supportFlags[6]));
        column.setNullType(BaseColumn.NullType.values()[Integer.parseInt(tokens.get(tokenIndex++))]);
        column.setSearchType(Column.SearchType.values()[3 - Integer.parseInt(tokens.get(tokenIndex++))]);
        column.setLength(Integer.parseInt(tokens.get(tokenIndex++)));
        column.setScale(Integer.parseInt(tokens.get(tokenIndex++)));
        column.setPrecision(Integer.parseInt(tokens.get(tokenIndex++)));
        column.setPosition(Integer.parseInt(tokens.get(tokenIndex++)));
        column.setCharOctetLength(Integer.parseInt(tokens.get(tokenIndex++)));
        column.setRadix(Integer.parseInt(tokens.get(tokenIndex++)));
        if (this.includeColumnNullDistinctValues(indexVersion)) {
            column.setDistinctValues(Integer.parseInt(tokens.get(tokenIndex++)));
            column.setNullValues(Integer.parseInt(tokens.get(tokenIndex++)));
        }
        column.setMinimumValue(this.getObjectValue(tokens.get(tokenIndex++)));
        column.setMaximumValue(this.getObjectValue(tokens.get(tokenIndex++)));
        column.setFormat(this.getObjectValue(tokens.get(tokenIndex++)));
        column.setRuntimeType(this.getObjectValue(tokens.get(tokenIndex++)));
        if (this.includeColumnNativeType(indexVersion)) {
            column.setNativeType(this.getObjectValue(tokens.get(tokenIndex++)));
        }
        column.setDatatypeUUID(this.getObjectValue(tokens.get(tokenIndex++)));
        column.setDefaultValue(this.getObjectValue(tokens.get(tokenIndex++)));
        this.setRecordFooterValues((AbstractMetadataRecord)column, tokens, tokenIndex);
        return column;
    }

    public ColumnSet createColumnSetRecord(char[] record, ColumnSet columnSet) {
        String str = new String(record);
        List<String> tokens = RecordFactory.getStrings(str, '\u00a0');
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)columnSet, tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++));
        List<String> uuids = RecordFactory.getStrings(tokens.get(tokenIndex++), this.getListDelimiter(indexVersion));
        columnSet.setColumns(RecordFactory.createColumns(uuids));
        if (record[0] == 'I' || record[0] == 'K') {
            ++tokenIndex;
        }
        this.setRecordFooterValues((AbstractMetadataRecord)columnSet, tokens, tokenIndex);
        return columnSet;
    }

    public ForeignKey createForeignKeyRecord(char[] record) {
        String str = new String(record);
        List<String> tokens = RecordFactory.getStrings(str, '\u00a0');
        ForeignKey fkRecord = new ForeignKey();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)fkRecord, tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++));
        List<String> uuids = RecordFactory.getStrings(tokens.get(tokenIndex++), this.getListDelimiter(indexVersion));
        fkRecord.setColumns(RecordFactory.createColumns(uuids));
        fkRecord.setUniqueKeyID(this.getObjectValue(tokens.get(tokenIndex++)));
        this.setRecordFooterValues((AbstractMetadataRecord)fkRecord, tokens, tokenIndex);
        return fkRecord;
    }

    public Datatype createDatatypeRecord(char[] record) {
        String str = new String(record);
        List<String> tokens = RecordFactory.getStrings(str, '\u00a0');
        Datatype dt = new Datatype();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        int n = ++tokenIndex;
        dt.setDatatypeID(this.getObjectValue(tokens.get(n)));
        int n2 = ++tokenIndex;
        dt.setBasetypeID(this.getObjectValue(tokens.get(n2)));
        int n3 = ++tokenIndex;
        ++tokenIndex;
        String fullName = tokens.get(n3);
        int indx = fullName.lastIndexOf("#");
        if (indx > -1) {
            fullName = new String(fullName.substring(indx + 1));
        } else {
            indx = fullName.lastIndexOf(46);
            if (indx > -1) {
                fullName = new String(fullName.substring(indx + 1));
            }
        }
        dt.setName(fullName);
        dt.setUUID(this.getObjectValue(tokens.get(tokenIndex++)));
        dt.setNameInSource(this.getObjectValue(tokens.get(tokenIndex++)));
        dt.setVarietyType(Datatype.Variety.values()[Short.parseShort(tokens.get(tokenIndex++))]);
        int n4 = ++tokenIndex;
        dt.setRuntimeTypeName(this.getObjectValue(tokens.get(n4)));
        int n5 = ++tokenIndex;
        dt.setJavaClassName(this.getObjectValue(tokens.get(n5)));
        int n6 = ++tokenIndex;
        dt.setType(Datatype.Type.values()[Short.parseShort(tokens.get(n6))]);
        int n7 = ++tokenIndex;
        dt.setSearchType(Column.SearchType.values()[3 - Integer.parseInt(tokens.get(n7))]);
        int n8 = ++tokenIndex;
        dt.setNullType(BaseColumn.NullType.values()[Integer.parseInt(tokens.get(n8))]);
        int n9 = ++tokenIndex;
        char[] booleanValues = tokens.get(n9).toCharArray();
        dt.setSigned(this.getBooleanValue(booleanValues[0]));
        dt.setAutoIncrement(this.getBooleanValue(booleanValues[1]));
        dt.setCaseSensitive(this.getBooleanValue(booleanValues[2]));
        int n10 = ++tokenIndex;
        dt.setLength(Integer.parseInt(tokens.get(n10)));
        int n11 = ++tokenIndex;
        dt.setPrecisionLength(Integer.parseInt(tokens.get(n11)));
        int n12 = ++tokenIndex;
        dt.setScale(Integer.parseInt(tokens.get(n12)));
        int n13 = ++tokenIndex;
        ++tokenIndex;
        dt.setRadix(Integer.parseInt(tokens.get(n13)));
        if (this.includePrimitiveTypeIdValue(indexVersion)) {
            dt.setPrimitiveTypeID(this.getObjectValue(tokens.get(tokenIndex++)));
        }
        this.setRecordFooterValues((AbstractMetadataRecord)dt, tokens, tokenIndex);
        return dt;
    }

    public Procedure createProcedureRecord(char[] record) {
        String str = new String(record);
        List<String> tokens = RecordFactory.getStrings(str, '\u00a0');
        Procedure procRd = new Procedure();
        int indexVersion = this.getIndexVersion(record);
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)procRd, tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++));
        char[] booleanValues = tokens.get(tokenIndex++).toCharArray();
        procRd.setFunction(this.getBooleanValue(booleanValues[0]));
        procRd.setVirtual(this.getBooleanValue(booleanValues[1]));
        List<String> uuids = RecordFactory.getStrings(tokens.get(tokenIndex++), this.getListDelimiter(indexVersion));
        ArrayList<ProcedureParameter> columns = new ArrayList<ProcedureParameter>(uuids.size());
        for (String uuid : uuids) {
            ProcedureParameter column = new ProcedureParameter();
            column.setUUID(uuid);
            columns.add(column);
        }
        procRd.setParameters(columns);
        String rsId = this.getObjectValue(tokens.get(tokenIndex++));
        if (rsId != null) {
            ColumnSet cs = new ColumnSet();
            cs.setUUID(rsId);
            procRd.setResultSet(cs);
        }
        if (RecordFactory.includeProcedureUpdateCount(indexVersion)) {
            procRd.setUpdateCount(Integer.parseInt(tokens.get(tokenIndex++)));
        }
        this.setRecordFooterValues((AbstractMetadataRecord)procRd, tokens, tokenIndex);
        return procRd;
    }

    public ProcedureParameter createProcedureParameterRecord(char[] record) {
        String str = new String(record);
        List<String> tokens = RecordFactory.getStrings(str, '\u00a0');
        ProcedureParameter paramRd = new ProcedureParameter();
        int tokenIndex = 0;
        this.setRecordHeaderValues((AbstractMetadataRecord)paramRd, tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++), tokens.get(tokenIndex++));
        paramRd.setDefaultValue(this.getObjectValue(tokens.get(tokenIndex++)));
        paramRd.setRuntimeType(this.getObjectValue(tokens.get(tokenIndex++)));
        paramRd.setDatatypeUUID(this.getObjectValue(tokens.get(tokenIndex++)));
        paramRd.setLength(Integer.parseInt(tokens.get(tokenIndex++)));
        paramRd.setRadix(Integer.parseInt(tokens.get(tokenIndex++)));
        paramRd.setScale(Integer.parseInt(tokens.get(tokenIndex++)));
        paramRd.setNullType(BaseColumn.NullType.values()[Integer.parseInt(tokens.get(tokenIndex++))]);
        paramRd.setPrecision(Integer.parseInt(tokens.get(tokenIndex++)));
        paramRd.setPosition(Integer.parseInt(tokens.get(tokenIndex++)));
        ProcedureParameter.Type type = null;
        switch (Short.parseShort(tokens.get(tokenIndex++))) {
            case 0: {
                type = ProcedureParameter.Type.In;
                break;
            }
            case 2: {
                type = ProcedureParameter.Type.InOut;
                break;
            }
            case 1: {
                type = ProcedureParameter.Type.Out;
                break;
            }
            case 3: {
                type = ProcedureParameter.Type.ReturnValue;
            }
        }
        paramRd.setType(type);
        char[] flags = tokens.get(tokenIndex++).toCharArray();
        paramRd.setOptional(this.getBooleanValue(flags[0]));
        this.setRecordFooterValues((AbstractMetadataRecord)paramRd, tokens, tokenIndex);
        return paramRd;
    }

    int getIndexVersion(char[] record) {
        if (this.version == 0) {
            int beginIndex;
            int endIndex;
            for (int i = beginIndex = (endIndex = record.length) - 6 > 0 ? endIndex - 6 : 1; i < endIndex; ++i) {
                if (record[i] != '\u00a1') continue;
                char versionPart1 = record[i + 1];
                char versionPart2 = record[i + 2];
                if (!Character.isDigit(versionPart1) || !Character.isDigit(versionPart2)) continue;
                this.version = Character.digit(versionPart1, 10) * 10 + Character.digit(versionPart2, 10);
            }
        }
        return this.version;
    }

    public String getObjectValue(String str) {
        if (str != null && str.length() == 1 && str.charAt(0) == ' ') {
            return null;
        }
        return str;
    }

    public boolean getBooleanValue(char b) {
        return b == '1';
    }

    public static List<String> getStrings(String values, char listDelimiter) {
        if (StringUtil.isEmpty((String)values)) {
            return Collections.emptyList();
        }
        if (values.length() == 1 && values.charAt(0) == ' ') {
            return Collections.emptyList();
        }
        List tokens = StringUtil.split((String)values, (String)String.valueOf(listDelimiter));
        ArrayList<String> result = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            if (token == null) continue;
            result.add(new String(token));
        }
        return result;
    }

    public char getListDelimiter(int indexVersionNumber) {
        if (indexVersionNumber < 1) {
            return ',';
        }
        return '\u001f';
    }

    public boolean includeMaterializationFlag(int indexVersionNumber) {
        return indexVersionNumber >= 2;
    }

    public boolean includeMaterializedTables(int indexVersionNumber) {
        return indexVersionNumber >= 2;
    }

    public boolean includeColumnNativeType(int indexVersionNumber) {
        return indexVersionNumber >= 3;
    }

    public boolean includeColumnNullDistinctValues(int indexVersionNumber) {
        return indexVersionNumber >= 7;
    }

    public boolean includePrimitiveTypeIdValue(int indexVersionNumber) {
        return indexVersionNumber >= 8;
    }

    public boolean includeInputParameterFlag(int indexVersionNumber) {
        return indexVersionNumber >= 4;
    }

    public boolean includeAnnotationProperties(int indexVersionNumber) {
        return indexVersionNumber < 5;
    }

    public boolean includeTransformationUUID(int indexVersionNumber) {
        return indexVersionNumber >= 6;
    }

    private static boolean includeProcedureUpdateCount(int indexVersionNumber) {
        return indexVersionNumber >= 9;
    }

    private void setRecordHeaderValues(AbstractMetadataRecord record, String recordType, String upperName, String objectID, String fullName, String nameInSource, String parentObjectID) {
        record.setUUID(this.getObjectValue(objectID));
        if (fullName != null) {
            String name = fullName;
            if (record instanceof ProcedureParameter || record instanceof KeyRecord) {
                name = RecordFactory.getShortName(fullName);
            } else {
                int index = fullName.indexOf(46);
                if (index > 0) {
                    name = new String(fullName.substring(index + 1));
                }
            }
            record.setName(name);
        }
        record.setNameInSource(this.getObjectValue(nameInSource));
    }

    static String getShortName(String fullName) {
        int index = fullName.lastIndexOf(46);
        if (index > 0) {
            fullName = new String(fullName.substring(index + 1));
        }
        return fullName;
    }

    private void setRecordFooterValues(AbstractMetadataRecord record, List<String> tokens, int tokenIndex) {
        if (record instanceof TransformationRecordImpl) {
            ((TransformationRecordImpl)record).setResourcePath(this.getOptionalToken(tokens, tokenIndex));
        }
        ++tokenIndex;
        if (record.getName() == null) {
            record.setName(this.getOptionalToken(tokens, tokenIndex++));
        }
        this.getOptionalToken(tokens, tokenIndex++);
    }

    public String getOptionalToken(List<String> tokens, int tokenIndex) {
        if (tokens.size() > tokenIndex) {
            return tokens.get(tokenIndex);
        }
        return null;
    }
}

