/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.index.IEntryResult;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.internal.core.index.Index;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.RecordFactory;
import org.teiid.metadata.index.RuntimeMetadataPlugin;
import org.teiid.metadata.index.SimpleIndexUtil;
import org.teiid.metadata.index.TransformationRecordImpl;
import org.teiid.query.metadata.TransformationMetadata;

public class IndexMetadataStore
extends MetadataStore {
    private static final long serialVersionUID = -7606516749442597438L;
    private Index[] indexes;
    private RecordFactory recordFactory = new RecordFactory(){

        @Override
        protected AbstractMetadataRecord getMetadataRecord(char[] record) {
            if (record == null || record.length == 0) {
                return null;
            }
            char c = record[0];
            switch (c) {
                case 'W': {
                    List<String> tokens = RecordFactory.getStrings(record, '\u00a0');
                    int indexVersion = IndexMetadataStore.this.recordFactory.getIndexVersion(record);
                    String uuid = tokens.get(2);
                    int tokenIndex = 6;
                    if (IndexMetadataStore.this.recordFactory.includeAnnotationProperties(indexVersion)) {
                        // empty if block
                    }
                    int n = ++tokenIndex;
                    ++tokenIndex;
                    IndexMetadataStore.this.annotationCache.put(uuid, tokens.get(n));
                    return null;
                }
                case 'X': {
                    List<String> tokens = RecordFactory.getStrings(record, '\u00a0');
                    String uuid = tokens.get(1);
                    LinkedHashMap<String, String> result = (LinkedHashMap<String, String>)IndexMetadataStore.this.extensionCache.get(uuid);
                    if (result == null) {
                        result = new LinkedHashMap<String, String>();
                        IndexMetadataStore.this.extensionCache.put(uuid, result);
                    }
                    int tokenIndex = 2;
                    result.put(tokens.get(tokenIndex++), tokens.get(tokenIndex++));
                    return null;
                }
            }
            AbstractMetadataRecord abstractMetadataRecord = super.getMetadataRecord(record);
            if (abstractMetadataRecord == null) {
                return null;
            }
            String parentName = null;
            if (record[0] == 'B') {
                parentName = ((Schema)((Table)abstractMetadataRecord).getParent()).getName();
            } else if (record[0] == 'E') {
                parentName = ((Procedure)abstractMetadataRecord).getParent().getName();
            }
            if (parentName != null) {
                ArrayList<AbstractMetadataRecord> typeRecords;
                HashMap<Character, ArrayList<AbstractMetadataRecord>> map = (HashMap<Character, ArrayList<AbstractMetadataRecord>>)IndexMetadataStore.this.schemaEntries.get(parentName);
                if (map == null) {
                    map = new HashMap<Character, ArrayList<AbstractMetadataRecord>>();
                    IndexMetadataStore.this.schemaEntries.put(parentName, map);
                }
                if ((typeRecords = (ArrayList<AbstractMetadataRecord>)map.get(Character.valueOf(record[0]))) == null) {
                    typeRecords = new ArrayList<AbstractMetadataRecord>();
                    map.put(Character.valueOf(record[0]), typeRecords);
                }
                typeRecords.add(abstractMetadataRecord);
            }
            Map<String, AbstractMetadataRecord> uuidMap = IndexMetadataStore.this.getByType(record[0]);
            uuidMap.put(abstractMetadataRecord.getUUID(), abstractMetadataRecord);
            if (this.parentId != null) {
                List<AbstractMetadataRecord> typeChildren = IndexMetadataStore.this.getByParent(this.parentId, record[0], AbstractMetadataRecord.class, true);
                typeChildren.add(abstractMetadataRecord);
            }
            return abstractMetadataRecord;
        }
    };
    private Map<String, String> annotationCache = new HashMap<String, String>();
    private Map<String, LinkedHashMap<String, String>> extensionCache = new HashMap<String, LinkedHashMap<String, String>>();
    private Map<String, Map<Character, List<AbstractMetadataRecord>>> schemaEntries = new HashMap<String, Map<Character, List<AbstractMetadataRecord>>>();
    private Map<String, Map<Character, List<AbstractMetadataRecord>>> childRecords = new HashMap<String, Map<Character, List<AbstractMetadataRecord>>>();
    private Map<Character, LinkedHashMap<String, AbstractMetadataRecord>> allRecords = new HashMap<Character, LinkedHashMap<String, AbstractMetadataRecord>>();
    private HashSet<VirtualFile> indexFiles = new HashSet();
    private LinkedHashMap<String, TransformationMetadata.Resource> vdbEntries;
    private boolean loaded = false;
    private Semaphore lock = new Semaphore(1);

    public IndexMetadataStore() {
    }

    public IndexMetadataStore(VirtualFile vdb) throws IOException, URISyntaxException {
        List children = vdb.getChildrenRecursively(new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.getName().endsWith(".INDEX");
            }
        });
        for (VirtualFile f : children) {
            this.addIndexFile(f);
        }
        this.addEntriesPlusVisibilities(vdb, new VDBMetaData());
    }

    Map<String, AbstractMetadataRecord> getByType(char type) {
        LinkedHashMap<String, Object> uuidMap = this.allRecords.get(Character.valueOf(type));
        if (uuidMap == null) {
            uuidMap = new LinkedHashMap();
            this.allRecords.put(Character.valueOf(type), uuidMap);
        }
        return uuidMap;
    }

    <T extends AbstractMetadataRecord> List<T> getByParent(String parentId, char type, Class<T> clazz, boolean create) {
        List<AbstractMetadataRecord> typeChildren;
        Map<Character, List<AbstractMetadataRecord>> children = this.childRecords.get(parentId);
        if (children == null) {
            children = new HashMap<Character, List<AbstractMetadataRecord>>();
            this.childRecords.put(parentId, children);
        }
        if ((typeChildren = children.get(Character.valueOf(type))) == null) {
            if (!create) {
                return Collections.emptyList();
            }
            typeChildren = new ArrayList<AbstractMetadataRecord>(2);
            children.put(Character.valueOf(type), typeChildren);
        }
        return typeChildren;
    }

    private void loadAll() {
        for (Index index : this.indexes) {
            try {
                IEntryResult[] results = SimpleIndexUtil.queryIndex(new Index[]{index}, new char[0], true, true, false);
                this.recordFactory.getMetadataRecord(results);
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)RuntimeMetadataPlugin.Event.TEIID80000, (Throwable)e);
            }
        }
        for (Map map : this.allRecords.values()) {
            for (AbstractMetadataRecord metadataRecord : map.values()) {
                String uuid = metadataRecord.getUUID();
                metadataRecord.setAnnotation(this.annotationCache.get(uuid));
                metadataRecord.setProperties((Map)this.extensionCache.get(uuid));
            }
        }
    }

    public void load(Collection<Datatype> systemDatatypes) throws IOException {
        this.load(null, systemDatatypes);
        Collection<AbstractMetadataRecord> modelRecords = this.getByType('A').values();
        for (AbstractMetadataRecord record : modelRecords) {
            Schema s = (Schema)record;
            this.load(s.getName(), systemDatatypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String modelName, Collection<Datatype> systemDatatypes) throws IOException {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!this.loaded) {
            if (systemDatatypes == null) {
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/teiid/metadata/types.dat");
                try {
                    InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
                    BufferedReader br = new BufferedReader(isr);
                    String s = br.readLine();
                    String[] props = s.split("\\|");
                    while ((s = br.readLine()) != null) {
                        Datatype dt = new Datatype();
                        String[] vals = s.split("\\|");
                        Properties p = new Properties();
                        for (int i = 0; i < props.length; ++i) {
                            if (vals[i].length() == 0) continue;
                            p.setProperty(props[i], new String(vals[i]));
                        }
                        PropertiesUtils.setBeanProperties((Object)dt, (Properties)p, null);
                        this.addDatatype(dt);
                    }
                }
                finally {
                    is.close();
                }
            }
            ArrayList<Index> tmp = new ArrayList<Index>();
            for (VirtualFile f : this.indexFiles) {
                Index index = new Index(f, true);
                index.setDoCache(true);
                tmp.add(index);
            }
            this.indexes = tmp.toArray(new Index[tmp.size()]);
            this.loadAll();
            for (Index index : tmp) {
                index.close();
            }
            Map<String, AbstractMetadataRecord> uuidToRecord = this.getByType('M');
            if (systemDatatypes != null) {
                for (Datatype datatype : systemDatatypes) {
                    uuidToRecord.put(datatype.getUUID(), (AbstractMetadataRecord)datatype);
                }
            } else {
                for (Datatype datatype : this.getDatatypes().values()) {
                    uuidToRecord.put(datatype.getUUID(), (AbstractMetadataRecord)datatype);
                }
            }
            for (AbstractMetadataRecord datatypeRecordImpl : uuidToRecord.values()) {
                this.addDatatype((Datatype)datatypeRecordImpl);
            }
            this.loaded = true;
        }
        this.lock.release();
        if (this.loaded) {
            this.getModels(modelName);
            this.getTables(modelName);
            this.getProcedures(modelName);
        }
    }

    public void addIndexFile(VirtualFile f) {
        this.indexFiles.add(f);
    }

    public void addEntriesPlusVisibilities(VirtualFile root, VDBMetaData vdb) throws IOException {
        LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap = new LinkedHashMap<String, TransformationMetadata.Resource>();
        for (VirtualFile f : root.getChildrenRecursively()) {
            if (!f.isFile()) continue;
            String path = f.getPathName().substring(root.getPathName().length());
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            visibilityMap.put(path, new TransformationMetadata.Resource(f, this.isFileVisible(f.getPathName(), vdb)));
        }
        this.vdbEntries = visibilityMap;
    }

    private boolean isFileVisible(String pathInVDB, VDBMetaData vdb) {
        String modelName;
        ModelMetaData model;
        if (pathInVDB.endsWith(".xmi") && (model = vdb.getModel(modelName = StringUtil.getFirstToken((String)StringUtil.getLastToken((String)pathInVDB, (String)"/"), (String)"."))) != null) {
            return model.isVisible();
        }
        if (pathInVDB.startsWith("META-INF/")) {
            return false;
        }
        String entry = StringUtil.getLastToken((String)pathInVDB, (String)"/");
        if (entry.endsWith(".INDEX") || entry.endsWith(".SEARCH_INDEX")) {
            return false;
        }
        return !entry.equalsIgnoreCase("vdb.xml");
    }

    public LinkedHashMap<String, TransformationMetadata.Resource> getEntriesPlusVisibilities() {
        return this.vdbEntries;
    }

    private void getModels(String modelName) {
        Collection<AbstractMetadataRecord> modelRecords = this.getByType('A').values();
        for (AbstractMetadataRecord modelRecord : modelRecords) {
            Schema s = (Schema)modelRecord;
            if (!s.getName().equalsIgnoreCase(modelName)) continue;
            this.addSchema((Schema)modelRecord);
        }
    }

    private void getTables(String modelName) {
        Schema model = (Schema)this.getSchemas().get(modelName);
        if (model == null) {
            return;
        }
        Map<Character, List<AbstractMetadataRecord>> entries = this.schemaEntries.get(modelName);
        if (entries == null) {
            return;
        }
        List<AbstractMetadataRecord> recs = entries.get(Character.valueOf('B'));
        if (recs == null) {
            return;
        }
        List<AbstractMetadataRecord> records = recs;
        for (Table table : records) {
            ArrayList<Column> columns = new ArrayList<Column>(this.getByParent(table.getUUID(), 'G', Column.class, false));
            for (Column columnRecordImpl : columns) {
                columnRecordImpl.setDatatype((Datatype)this.getByType('M').get(columnRecordImpl.getDatatypeUUID()));
                columnRecordImpl.setParent((ColumnSet)table);
                String fullName = columnRecordImpl.getName();
                if (!fullName.startsWith(table.getName() + '.')) continue;
                columnRecordImpl.setName(new String(fullName.substring(table.getName().length() + 1)));
            }
            Collections.sort(columns);
            table.setColumns(columns);
            table.setAccessPatterns(this.getByParent(table.getUUID(), 'H', KeyRecord.class, false));
            HashMap<String, Column> uuidColumnMap = new HashMap<String, Column>();
            for (Column columnRecordImpl : columns) {
                uuidColumnMap.put(columnRecordImpl.getUUID(), columnRecordImpl);
            }
            for (KeyRecord columnSetRecordImpl : table.getAccessPatterns()) {
                this.loadColumnSetRecords((ColumnSet<?>)columnSetRecordImpl, (Map<String, Column>)uuidColumnMap);
                columnSetRecordImpl.setParent((AbstractMetadataRecord)table);
            }
            table.setForiegnKeys(this.getByParent(table.getUUID(), 'J', ForeignKey.class, false));
            for (ForeignKey foreignKeyRecord : table.getForeignKeys()) {
                KeyRecord pk = (KeyRecord)this.getRecordByType(foreignKeyRecord.getUniqueKeyID(), 'K', false);
                if (pk == null) {
                    pk = (KeyRecord)this.getRecordByType(foreignKeyRecord.getUniqueKeyID(), 'I');
                }
                foreignKeyRecord.setPrimaryKey(pk);
                this.loadColumnSetRecords((ColumnSet<?>)foreignKeyRecord, (Map<String, Column>)uuidColumnMap);
                foreignKeyRecord.setParent((AbstractMetadataRecord)table);
            }
            table.setUniqueKeys(this.getByParent(table.getUUID(), 'I', KeyRecord.class, false));
            for (KeyRecord columnSetRecordImpl : table.getUniqueKeys()) {
                this.loadColumnSetRecords((ColumnSet<?>)columnSetRecordImpl, (Map<String, Column>)uuidColumnMap);
                columnSetRecordImpl.setParent((AbstractMetadataRecord)table);
            }
            List indexRecords = table.getIndexes();
            for (int i = 0; i < indexRecords.size(); ++i) {
                indexRecords.set(i, (KeyRecord)this.getRecordByType(((KeyRecord)indexRecords.get(i)).getUUID(), 'L'));
            }
            for (KeyRecord columnSetRecordImpl : indexRecords) {
                this.loadColumnSetRecords((ColumnSet<?>)columnSetRecordImpl, (Map<String, Column>)uuidColumnMap);
                columnSetRecordImpl.setParent((AbstractMetadataRecord)table);
            }
            if (table.getPrimaryKey() != null) {
                KeyRecord primaryKey = (KeyRecord)this.getRecordByType(table.getPrimaryKey().getUUID(), 'K');
                this.loadColumnSetRecords((ColumnSet<?>)primaryKey, (Map<String, Column>)uuidColumnMap);
                primaryKey.setParent((AbstractMetadataRecord)table);
                table.setPrimaryKey(primaryKey);
            }
            String groupUUID = table.getUUID();
            if (table.isVirtual()) {
                TransformationRecordImpl select;
                TransformationRecordImpl delete;
                TransformationRecordImpl insert;
                TransformationRecordImpl update = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'R', false);
                if (update != null) {
                    table.setUpdatePlan(update.getTransformation());
                }
                if ((insert = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'Q', false)) != null) {
                    table.setInsertPlan(insert.getTransformation());
                }
                if ((delete = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'S', false)) != null) {
                    table.setDeletePlan(delete.getTransformation());
                }
                if ((select = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'P', false)) == null) {
                    select = (TransformationRecordImpl)this.getRecordByType(groupUUID, 'U', false);
                }
                if (select != null) {
                    table.setSelectTransformation(select.getTransformation());
                    table.setBindings(select.getBindings());
                    table.setSchemaPaths(select.getSchemaPaths());
                    table.setResourcePath(select.getResourcePath());
                }
            }
            if (table.isMaterialized()) {
                table.setMaterializedStageTable((Table)this.getByType('B').get(table.getMaterializedStageTable().getUUID()));
                table.setMaterializedTable((Table)this.getByType('B').get(table.getMaterializedTable().getUUID()));
            }
            model.addTable(table);
        }
    }

    private Column findElement(String fullName) {
        Column columnRecord = (Column)this.getRecordByType(fullName, 'G');
        columnRecord.setDatatype((Datatype)this.getByType('M').get(columnRecord.getDatatypeUUID()));
        return columnRecord;
    }

    private AbstractMetadataRecord getRecordByType(String entityName, char recordType) {
        return this.getRecordByType(entityName, recordType, true);
    }

    private AbstractMetadataRecord getRecordByType(String entityName, char recordType, boolean mustExist) {
        AbstractMetadataRecord record = this.getByType(recordType).get(entityName);
        if (record == null) {
            if (mustExist) {
                throw new TeiidRuntimeException((BundleUtil.Event)RuntimeMetadataPlugin.Event.TEIID80002, entityName + TransformationMetadata.NOT_EXISTS_MESSAGE);
            }
            return null;
        }
        return record;
    }

    private void getProcedures(String modelName) {
        Schema model = (Schema)this.getSchemas().get(modelName);
        if (model == null) {
            return;
        }
        Map<Character, List<AbstractMetadataRecord>> entries = this.schemaEntries.get(model.getName());
        if (entries == null) {
            return;
        }
        List<AbstractMetadataRecord> recs = entries.get(Character.valueOf('E'));
        if (recs == null) {
            return;
        }
        List<AbstractMetadataRecord> records = recs;
        for (Procedure procedure : records) {
            ColumnSet resultRecord;
            for (int i = 0; i < procedure.getParameters().size(); ++i) {
                ProcedureParameter paramRecord = (ProcedureParameter)this.getRecordByType(((ProcedureParameter)procedure.getParameters().get(i)).getUUID(), 'F');
                paramRecord.setDatatype((Datatype)this.getByType('M').get(paramRecord.getDatatypeUUID()));
                procedure.getParameters().set(i, paramRecord);
                paramRecord.setProcedure(procedure);
            }
            ColumnSet result = procedure.getResultSet();
            if (result != null && (resultRecord = (ColumnSet)this.getRecordByType(result.getUUID(), 'C', false)) != null) {
                resultRecord.setParent((AbstractMetadataRecord)procedure);
                resultRecord.setName(RecordFactory.getShortName(resultRecord.getName()));
                this.loadColumnSetRecords(resultRecord, null);
                procedure.setResultSet(resultRecord);
            }
            if (procedure.isVirtual()) {
                TransformationRecordImpl transformRecord = (TransformationRecordImpl)this.getRecordByType(procedure.getUUID(), 'T', false);
                if (transformRecord != null) {
                    procedure.setQueryPlan(transformRecord.getTransformation());
                }
            } else if (procedure.isFunction()) {
                FunctionParameter outputParam = null;
                ArrayList<FunctionParameter> args = new ArrayList<FunctionParameter>(procedure.getParameters().size() - 1);
                boolean valid = true;
                block6: for (ProcedureParameter param : procedure.getParameters()) {
                    FunctionParameter fp = new FunctionParameter();
                    fp.setName(param.getName());
                    fp.setDescription(param.getAnnotation());
                    fp.setType(param.getRuntimeType());
                    switch (param.getType()) {
                        case ReturnValue: {
                            if (outputParam != null) {
                                valid = false;
                            }
                            outputParam = fp;
                            continue block6;
                        }
                        case In: {
                            args.add(fp);
                            continue block6;
                        }
                    }
                    valid = false;
                }
                if (valid && outputParam != null) {
                    FunctionMethod function = new FunctionMethod(procedure.getName(), procedure.getAnnotation(), model.getName(), FunctionMethod.PushDown.MUST_PUSHDOWN, null, null, args, outputParam, false, FunctionMethod.Determinism.DETERMINISTIC);
                    FunctionMethod.convertExtensionMetadata((Procedure)procedure, (FunctionMethod)function);
                    model.addFunction(function);
                    continue;
                }
            }
            model.addProcedure(procedure);
        }
    }

    private void loadColumnSetRecords(ColumnSet<?> indexRecord, Map<String, Column> columns) {
        for (int i = 0; i < indexRecord.getColumns().size(); ++i) {
            String uuid = ((Column)indexRecord.getColumns().get(i)).getUUID();
            Column c = null;
            if (columns != null) {
                c = columns.get(uuid);
            } else {
                c = this.findElement(uuid);
                c.setName(RecordFactory.getShortName(c.getName()));
            }
            indexRecord.getColumns().set(i, c);
            if (columns != null) continue;
            c.setParent(indexRecord);
        }
    }
}

