/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.Map;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ReturnRepresentation;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public class EntityResponse
extends ServiceResponse {
    private final ReturnRepresentation returnRepresentation;
    private final ODataSerializer serializer;
    private final EntitySerializerOptions options;
    private final ContentType responseContentType;
    private final String baseURL;

    private EntityResponse(ServiceMetadata metadata, ODataResponse response, ODataSerializer serializer, EntitySerializerOptions options, ContentType responseContentType, Map<String, String> preferences, ReturnRepresentation returnRepresentation, String baseURL) {
        super(metadata, response, preferences);
        this.serializer = serializer;
        this.options = options;
        this.responseContentType = responseContentType;
        this.returnRepresentation = returnRepresentation;
        this.baseURL = baseURL;
    }

    public static EntityResponse getInstance(ServiceRequest request, ContextURL contextURL, boolean references, ODataResponse response, ReturnRepresentation returnRepresentation) throws ContentNegotiatorException, SerializerException {
        EntitySerializerOptions options = (EntitySerializerOptions)request.getSerializerOptions(EntitySerializerOptions.class, contextURL, references);
        return new EntityResponse(request.getServiceMetaData(), response, request.getSerializer(), options, request.getResponseContentType(), request.getPreferences(), returnRepresentation, request.getODataRequest().getRawBaseUri());
    }

    public static EntityResponse getInstance(ServiceRequest request, ContextURL contextURL, boolean references, ODataResponse response) throws ContentNegotiatorException, SerializerException {
        EntitySerializerOptions options = (EntitySerializerOptions)request.getSerializerOptions(EntitySerializerOptions.class, contextURL, references);
        return new EntityResponse(request.getServiceMetaData(), response, request.getSerializer(), options, request.getResponseContentType(), request.getPreferences(), null, request.getODataRequest().getRawBaseUri());
    }

    public void writeReadEntity(EdmEntityType entityType, Entity entity) throws SerializerException {
        assert (!this.isClosed());
        if (entity == null) {
            this.writeNotFound(true);
            return;
        }
        this.response.setContent(this.serializer.entity(this.metadata, entityType, entity, this.options).getContent());
        this.writeOK(this.responseContentType);
        this.close();
    }

    public void writeCreatedEntity(EdmEntitySet entitySet, Entity entity) throws SerializerException {
        String locationHeader;
        assert (entity != null);
        try {
            locationHeader = EntityResponse.buildLocation(this.baseURL, entity, entitySet.getName(), entitySet.getEntityType());
        }
        catch (EdmPrimitiveTypeException e) {
            throw new SerializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PRIMITIVE_VALUE, new String[0]);
        }
        if (this.returnRepresentation == ReturnRepresentation.MINIMAL || this.returnRepresentation == ReturnRepresentation.NONE) {
            this.writeNoContent(false);
            this.writeHeader("Location", locationHeader);
            if (this.returnRepresentation == ReturnRepresentation.MINIMAL) {
                this.writeHeader("Preference-Applied", "return=minimal");
            }
            this.writeHeader("OData-EntityId", entity.getId().toASCIIString());
            this.close();
            return;
        }
        this.response.setContent(this.serializer.entity(this.metadata, entitySet.getEntityType(), entity, this.options).getContent());
        this.writeCreated(false);
        this.writeHeader("Location", locationHeader);
        this.writeHeader("Preference-Applied", "return=representation");
        this.writeHeader("Content-Type", this.responseContentType.toContentTypeString());
        this.close();
    }

    public void writeUpdatedEntity() {
        this.writeNoContent(true);
    }

    public void writeDeletedEntityOrReference() {
        this.writeNoContent(true);
    }

    public void accepts(ServiceResponseVisior visitor) throws ODataLibraryException, ODataApplicationException {
        visitor.visit(this);
    }

    public void writeCreated(boolean closeResponse) {
        this.response.setStatusCode(HttpStatusCode.CREATED.getStatusCode());
        if (closeResponse) {
            this.close();
        }
    }

    public void writeError(ODataServerError error) {
        try {
            this.writeContent(this.serializer.error(error).getContent(), error.getStatusCode(), true);
        }
        catch (SerializerException e) {
            this.writeServerError(true);
        }
    }

    public void writeNotModified() {
        this.response.setStatusCode(HttpStatusCode.NOT_MODIFIED.getStatusCode());
        this.close();
    }

    public static String buildLocation(String baseURL, Entity entity, String enitySetName, EdmEntityType type) throws EdmPrimitiveTypeException {
        StringBuilder location = new StringBuilder();
        location.append(baseURL).append("/").append(enitySetName);
        int i = 0;
        boolean usename = type.getKeyPredicateNames().size() > 1;
        location.append("(");
        for (String key : type.getKeyPredicateNames()) {
            if (i > 0) {
                location.append(",");
            }
            ++i;
            if (usename) {
                location.append(key).append("=");
            }
            String propertyType = entity.getProperty(key).getType();
            Object propertyValue = entity.getProperty(key).getValue();
            if (propertyType.startsWith("Edm.")) {
                propertyType = propertyType.substring(4);
            }
            EdmPrimitiveTypeKind kind = EdmPrimitiveTypeKind.valueOf((String)propertyType);
            String value = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)kind).valueToString(propertyValue, Boolean.valueOf(true), Integer.valueOf(4000), Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(true));
            if (kind == EdmPrimitiveTypeKind.String) {
                value = EdmString.getInstance().toUriLiteral(Encoder.encode((String)value));
            }
            location.append(value);
        }
        location.append(")");
        return location.toString();
    }
}

