/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmDateTimeOffset
extends SingletonPrimitiveType {
    private static final Pattern PATTERN = Pattern.compile("(-?\\p{Digit}{4,})-(\\p{Digit}{2})-(\\p{Digit}{2})T(\\p{Digit}{2}):(\\p{Digit}{2})(?::(\\p{Digit}{2})(\\.(\\p{Digit}{0,12}?)0*)?)?(Z|([-+]\\p{Digit}{2}:\\p{Digit}{2}))?");
    private static final EdmDateTimeOffset INSTANCE = new EdmDateTimeOffset();

    public static EdmDateTimeOffset getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return Timestamp.class;
    }

    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        String timeZoneOffset = matcher.group(9) == null || matcher.group(10) == null || matcher.group(10).matches("[-+]0+:0+") ? null : matcher.group(10);
        TimeZone tz = TimeZone.getTimeZone("GMT" + (timeZoneOffset == null ? "" : timeZoneOffset));
        Calendar dateTimeValue = Calendar.getInstance(tz);
        if (dateTimeValue.get(15) == 0 && timeZoneOffset != null) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        dateTimeValue.clear();
        dateTimeValue.set(Short.parseShort(matcher.group(1)), Byte.parseByte(matcher.group(2)) - 1, Byte.parseByte(matcher.group(3)), Byte.parseByte(matcher.group(4)), Byte.parseByte(matcher.group(5)), matcher.group(6) == null ? 0 : (int)Byte.parseByte(matcher.group(6)));
        int nanoSeconds = 0;
        if (matcher.group(7) != null) {
            if (matcher.group(7).length() == 1 || matcher.group(7).length() > 13) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
            }
            String decimals = matcher.group(8);
            if (decimals.length() > (precision == null ? 0 : precision)) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' does not match the facets' constraints.");
            }
            if (returnType.isAssignableFrom(Timestamp.class)) {
                if (!decimals.isEmpty()) {
                    nanoSeconds = Integer.parseInt(decimals.length() > 9 ? decimals.substring(0, 9) : decimals + "000000000".substring(decimals.length()));
                }
            } else {
                String milliSeconds = decimals.length() > 3 ? decimals.substring(0, 3) : decimals + "000".substring(decimals.length());
                dateTimeValue.set(14, Short.parseShort(milliSeconds));
            }
        }
        try {
            return EdmDateTimeOffset.convertDateTime(dateTimeValue, nanoSeconds, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", (Exception)e);
        }
    }

    protected static <T> T convertDateTime(Calendar dateTimeValue, int nanoSeconds, Class<T> returnType) throws IllegalArgumentException, ClassCastException {
        dateTimeValue.setLenient(false);
        if (returnType.isAssignableFrom(Calendar.class)) {
            dateTimeValue.get(14);
            dateTimeValue.setLenient(true);
            return returnType.cast(dateTimeValue);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(dateTimeValue.getTimeInMillis());
        }
        if (returnType.isAssignableFrom(java.util.Date.class)) {
            return returnType.cast(dateTimeValue.getTime());
        }
        if (returnType.isAssignableFrom(Timestamp.class)) {
            Timestamp timestamp = new Timestamp(dateTimeValue.getTimeInMillis());
            timestamp.setNanos(nanoSeconds);
            return returnType.cast(timestamp);
        }
        if (returnType.isAssignableFrom(Time.class)) {
            dateTimeValue.set(1, 1970);
            dateTimeValue.set(2, 0);
            dateTimeValue.set(5, 1);
            dateTimeValue.set(14, 0);
            return returnType.cast(new Time(dateTimeValue.getTimeInMillis()));
        }
        if (returnType.isAssignableFrom(Date.class)) {
            dateTimeValue.set(11, 0);
            dateTimeValue.set(12, 0);
            dateTimeValue.set(13, 0);
            dateTimeValue.set(14, 0);
            return returnType.cast(new Date(dateTimeValue.getTimeInMillis()));
        }
        throw new ClassCastException("unsupported return type " + returnType.getSimpleName());
    }

    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        Calendar dateTimeValue = EdmDateTimeOffset.createDateTime(value, false);
        StringBuilder result = new StringBuilder();
        int year = dateTimeValue.get(1);
        EdmDateTimeOffset.appendTwoDigits(result, year / 100);
        EdmDateTimeOffset.appendTwoDigits(result, year % 100);
        result.append('-');
        EdmDateTimeOffset.appendTwoDigits(result, dateTimeValue.get(2) + 1);
        result.append('-');
        EdmDateTimeOffset.appendTwoDigits(result, dateTimeValue.get(5));
        result.append('T');
        EdmDateTimeOffset.appendTwoDigits(result, dateTimeValue.get(11));
        result.append(':');
        EdmDateTimeOffset.appendTwoDigits(result, dateTimeValue.get(12));
        result.append(':');
        EdmDateTimeOffset.appendTwoDigits(result, dateTimeValue.get(13));
        int fractionalSecs = value instanceof Timestamp ? ((Timestamp)value).getNanos() : dateTimeValue.get(14);
        try {
            EdmDateTimeOffset.appendFractionalSeconds(result, fractionalSecs, value instanceof Timestamp, precision);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The value '" + value + "' does not match the facets' constraints.", (Exception)e);
        }
        int offsetInMinutes = (dateTimeValue.get(15) + dateTimeValue.get(16)) / 60 / 1000;
        int offsetHours = offsetInMinutes / 60;
        int offsetMinutes = Math.abs(offsetInMinutes % 60);
        String offsetString = offsetInMinutes == 0 ? "Z" : String.format("%+03d:%02d", offsetHours, offsetMinutes);
        result.append(offsetString);
        return result.toString();
    }

    protected static <T> Calendar createDateTime(T value, boolean isLocal) throws EdmPrimitiveTypeException {
        Calendar dateTimeValue;
        if (value instanceof java.util.Date) {
            TimeZone tz = isLocal ? EdmDateTimeOffset.getDefaultTimeZone() : TimeZone.getTimeZone("GMT");
            dateTimeValue = Calendar.getInstance(tz);
            dateTimeValue.setTime((java.util.Date)value);
        } else if (value instanceof Calendar) {
            dateTimeValue = (Calendar)((Calendar)value).clone();
        } else if (value instanceof Long) {
            TimeZone tz = isLocal ? EdmDateTimeOffset.getDefaultTimeZone() : TimeZone.getTimeZone("GMT");
            dateTimeValue = Calendar.getInstance(tz);
            dateTimeValue.setTimeInMillis((Long)value);
        } else {
            throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
        }
        return dateTimeValue;
    }

    protected static void appendTwoDigits(StringBuilder result, int number) {
        result.append((char)(48 + number / 10));
        result.append((char)(48 + number % 10));
    }

    protected static void appendFractionalSeconds(StringBuilder result, int fractionalSeconds, boolean isNano, Integer precision) throws IllegalArgumentException {
        if (fractionalSeconds > 0) {
            int nonSignificant = 0;
            int output = fractionalSeconds;
            while (output % 10 == 0) {
                output /= 10;
                ++nonSignificant;
            }
            if (precision == null || precision < (isNano ? 9 : 3) - nonSignificant) {
                throw new IllegalArgumentException();
            }
            result.append('.');
            for (int d = 100 * (isNano ? 1000000 : 1); d > 0; d /= 10) {
                byte digit = (byte)(fractionalSeconds % (d * 10) / d);
                if (digit <= 0 && fractionalSeconds % d <= 0) continue;
                result.append((char)(48 + digit));
            }
        }
    }

    protected static TimeZone getDefaultTimeZone() {
        String tz = System.getProperty("defaultTimeZoneForEdmDateTypes");
        return tz != null ? TimeZone.getTimeZone(tz) : TimeZone.getDefault();
    }
}

