/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.UDFMetaData;
import org.teiid.metadata.CompositeMetadataStore;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.TransformationMetadata;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.vdb.runtime.VDBKey;

public class CompositeVDB {
    private VDBMetaData vdb;
    private MetadataStoreGroup stores;
    private LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap;
    private UDFMetaData udf;
    private LinkedHashMap<VDBKey, CompositeVDB> children;
    private MetadataStore systemStore;
    private VDBMetaData mergedVDB;

    public CompositeVDB(VDBMetaData vdb, MetadataStoreGroup stores, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, UDFMetaData udf, MetadataStore systemStore) {
        this.vdb = vdb;
        this.stores = stores;
        this.visibilityMap = visibilityMap;
        this.udf = udf;
        this.systemStore = systemStore;
        this.update(this.vdb);
    }

    public void addChild(CompositeVDB child) {
        if (this.children == null) {
            this.children = new LinkedHashMap();
        }
        VDBMetaData childVDB = child.getVDB();
        this.children.put(new VDBKey(childVDB.getName(), childVDB.getVersion()), child);
        this.mergedVDB = null;
    }

    public void removeChild(VDBKey child) {
        if (this.children != null) {
            this.children.remove(child);
        }
        this.mergedVDB = null;
    }

    private void update(VDBMetaData vdbMetadata) {
        TransformationMetadata metadata = this.buildTransformationMetaData(vdbMetadata, this.getVisibilityMap(), this.getMetadataStores(), this.getUDF());
        vdbMetadata.addAttchment(QueryMetadataInterface.class, (Object)metadata);
        vdbMetadata.addAttchment(TransformationMetadata.class, (Object)metadata);
    }

    private TransformationMetadata buildTransformationMetaData(VDBMetaData vdb, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, MetadataStoreGroup stores, UDFMetaData udf) {
        Collection<FunctionMethod> methods = null;
        if (udf != null) {
            methods = udf.getFunctions();
        }
        CompositeMetadataStore compositeStore = new CompositeMetadataStore(stores.getStores());
        compositeStore.addMetadataStore(this.systemStore);
        TransformationMetadata metadata = new TransformationMetadata(vdb, compositeStore, visibilityMap, methods);
        return metadata;
    }

    public VDBMetaData getVDB() {
        if (this.children == null || this.children.isEmpty()) {
            return this.vdb;
        }
        if (this.mergedVDB == null) {
            this.mergedVDB = this.buildVDB();
            this.update(this.mergedVDB);
        }
        return this.mergedVDB;
    }

    private VDBMetaData buildVDB() {
        VDBMetaData mergedVDB = new VDBMetaData();
        mergedVDB.setName(this.vdb.getName());
        mergedVDB.setVersion(this.vdb.getVersion());
        mergedVDB.setModels(this.vdb.getModels());
        mergedVDB.setDataPolicies(this.vdb.getDataPolicies());
        mergedVDB.setDescription(this.vdb.getDescription());
        mergedVDB.setStatus(this.vdb.getStatus());
        mergedVDB.setJAXBProperties(this.vdb.getJAXBProperties());
        for (CompositeVDB child : this.children.values()) {
            for (Model m : child.getVDB().getModels()) {
                mergedVDB.addModel((ModelMetaData)m);
            }
            for (DataPolicy p : child.getVDB().getDataPolicies()) {
                mergedVDB.addDataPolicy((DataPolicyMetadata)p);
            }
        }
        return mergedVDB;
    }

    private UDFMetaData getUDF() {
        if (this.children == null || this.children.isEmpty()) {
            return this.udf;
        }
        UDFMetaData mergedUDF = new UDFMetaData();
        if (this.udf != null) {
            mergedUDF.addFunctions(this.udf.getFunctions());
        }
        for (CompositeVDB child : this.children.values()) {
            UDFMetaData funcs = child.getUDF();
            if (funcs == null) continue;
            mergedUDF.addFunctions(funcs.getFunctions());
        }
        return mergedUDF;
    }

    private LinkedHashMap<String, TransformationMetadata.Resource> getVisibilityMap() {
        if (this.children == null || this.children.isEmpty()) {
            return this.visibilityMap;
        }
        LinkedHashMap<String, TransformationMetadata.Resource> mergedvisibilityMap = new LinkedHashMap<String, TransformationMetadata.Resource>();
        if (this.visibilityMap != null) {
            mergedvisibilityMap.putAll(this.visibilityMap);
        }
        for (CompositeVDB child : this.children.values()) {
            LinkedHashMap<String, TransformationMetadata.Resource> vm = child.getVisibilityMap();
            if (vm == null) continue;
            mergedvisibilityMap.putAll(vm);
        }
        return mergedvisibilityMap;
    }

    private MetadataStoreGroup getMetadataStores() {
        if (this.children == null || this.children.isEmpty()) {
            return this.stores;
        }
        MetadataStoreGroup mergedStores = new MetadataStoreGroup();
        if (this.stores != null) {
            mergedStores.addStores(this.stores.getStores());
        }
        for (CompositeVDB child : this.children.values()) {
            MetadataStoreGroup stores = child.getMetadataStores();
            if (stores == null) continue;
            mergedStores.addStores(stores.getStores());
        }
        return mergedStores;
    }
}

