/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.deployers.VDBRepository;
import org.teiid.metadata.index.IndexMetadataFactory;
import org.teiid.metadata.index.RuntimeMetadataPlugin;
import org.teiid.runtime.RuntimePlugin;

public class SystemVDBDeployer {
    private VDBRepository vdbRepository;

    public void start() {
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("System.vdb");
            if (url == null) {
                throw new TeiidRuntimeException(RuntimeMetadataPlugin.Util.getString("system_vdb_not_found"));
            }
            this.vdbRepository.setSystemStore(new IndexMetadataFactory(url).getMetadataStore());
        }
        catch (URISyntaxException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("failed_to_deployed", new Object[]{"System.vdb"}));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("failed_to_deployed", new Object[]{"System.vdb"}));
        }
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }
}

