/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.impl.TranslatorMetaData;
import org.teiid.deployers.TranslatorMetaDataGroup;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.impl.TranslatorRepository;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;

public class TranslatorDeployer
extends AbstractSimpleRealDeployer<TranslatorMetaDataGroup> {
    private TranslatorRepository translatorRepository;
    private VDBStatusChecker vdbChecker;

    public TranslatorDeployer() {
        super(TranslatorMetaDataGroup.class);
    }

    public void deploy(DeploymentUnit unit, TranslatorMetaDataGroup group) throws DeploymentException {
        for (TranslatorMetaData data : group.getTranslators()) {
            String translatorName = data.getName();
            if (translatorName == null) {
                throw new DeploymentException(RuntimePlugin.Util.getString("name_not_found", new Object[]{unit.getName()}));
            }
            String type = data.getType();
            Translator parent = this.translatorRepository.getTranslatorMetaData(null, type);
            if (parent == null) {
                throw new DeploymentException(RuntimePlugin.Util.getString("translator_type_not_found", new Object[]{unit.getName()}));
            }
            Set<String> keys = parent.getProperties().stringPropertyNames();
            for (String key : keys) {
                if (data.getPropertyValue(key) != null || parent.getPropertyValue(key) == null) continue;
                data.addProperty(key, parent.getPropertyValue(key));
            }
            this.translatorRepository.addTranslatorMetadata(translatorName, data);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("translator_added", new Object[]{translatorName}));
            this.vdbChecker.translatorAdded(translatorName);
        }
    }

    public void undeploy(DeploymentUnit unit, TranslatorMetaDataGroup group) {
        super.undeploy(unit, (Object)group);
        for (TranslatorMetaData data : group.getTranslators()) {
            String translatorName = data.getName();
            if (this.translatorRepository == null) continue;
            this.translatorRepository.removeTranslatorMetadata(translatorName);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("translator_removed", new Object[]{translatorName}));
            this.vdbChecker.translatorRemoved(translatorName);
        }
    }

    public void setTranslatorRepository(TranslatorRepository repo) {
        this.translatorRepository = repo;
    }

    public void setVDBStatusChecker(VDBStatusChecker checker) {
        this.vdbChecker = checker;
    }
}

